/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.source;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.ISourceViewerExtension2;
import org.eclipse.jface.text.source.JFaceTextMessages;
import org.eclipse.jface.text.source.projection.AnnotationBag;

public class DefaultAnnotationHover
implements IAnnotationHover {
    private boolean fShowLineNumber;

    public DefaultAnnotationHover() {
        this(false);
    }

    public DefaultAnnotationHover(boolean bl) {
        this.fShowLineNumber = bl;
    }

    @Override
    public String getHoverInfo(ISourceViewer iSourceViewer, int n) {
        List list = this.getAnnotationsForLine(iSourceViewer, n);
        if (list != null) {
            if (list.size() == 1) {
                Annotation annotation = (Annotation)list.get(0);
                String string = annotation.getText();
                if (string != null && string.trim().length() > 0) {
                    return this.formatSingleMessage(string);
                }
            } else {
                ArrayList<String> arrayList = new ArrayList<String>();
                for (Annotation annotation : list) {
                    String string = annotation.getText();
                    if (string == null || string.trim().length() <= 0) continue;
                    arrayList.add(string.trim());
                }
                if (arrayList.size() == 1) {
                    return this.formatSingleMessage((String)arrayList.get(0));
                }
                if (arrayList.size() > 1) {
                    return this.formatMultipleMessages(arrayList);
                }
            }
        }
        if (this.fShowLineNumber && n > -1) {
            return JFaceTextMessages.getFormattedString("DefaultAnnotationHover.lineNumber", new String[]{Integer.toString(n + 1)});
        }
        return null;
    }

    protected boolean isIncluded(Annotation annotation) {
        return true;
    }

    protected String formatSingleMessage(String string) {
        return string;
    }

    protected String formatMultipleMessages(List list) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(JFaceTextMessages.getString("DefaultAnnotationHover.multipleMarkers"));
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append('\n');
            String string = (String)iterator.next();
            stringBuffer.append(JFaceTextMessages.getFormattedString("DefaultAnnotationHover.listItem", new String[]{string}));
        }
        return stringBuffer.toString();
    }

    private boolean isRulerLine(Position position, IDocument iDocument, int n) {
        if (position.getOffset() > -1 && position.getLength() > -1) {
            try {
                return n == iDocument.getLineOfOffset(position.getOffset());
            }
            catch (BadLocationException badLocationException) {}
        }
        return false;
    }

    private IAnnotationModel getAnnotationModel(ISourceViewer iSourceViewer) {
        if (iSourceViewer instanceof ISourceViewerExtension2) {
            ISourceViewerExtension2 iSourceViewerExtension2 = (ISourceViewerExtension2)((Object)iSourceViewer);
            return iSourceViewerExtension2.getVisualAnnotationModel();
        }
        return iSourceViewer.getAnnotationModel();
    }

    private boolean isDuplicateAnnotation(Map map, Position position, String string) {
        if (map.containsKey(position)) {
            Object v = map.get(position);
            if (string.equals(v)) {
                return true;
            }
            if (v instanceof List) {
                List list = (List)v;
                if (list.contains(string)) {
                    return true;
                }
                list.add(string);
            } else {
                ArrayList<Object> arrayList = new ArrayList<Object>();
                arrayList.add(v);
                arrayList.add(string);
                map.put(position, arrayList);
            }
        } else {
            map.put(position, string);
        }
        return false;
    }

    private boolean includeAnnotation(Annotation annotation, Position position, HashMap hashMap) {
        if (!this.isIncluded(annotation)) {
            return false;
        }
        String string = annotation.getText();
        return string != null && !this.isDuplicateAnnotation(hashMap, position, string);
    }

    private List getAnnotationsForLine(ISourceViewer iSourceViewer, int n) {
        IAnnotationModel iAnnotationModel = this.getAnnotationModel(iSourceViewer);
        if (iAnnotationModel == null) {
            return null;
        }
        IDocument iDocument = iSourceViewer.getDocument();
        ArrayList<Annotation> arrayList = new ArrayList<Annotation>();
        HashMap hashMap = new HashMap();
        Iterator iterator = iAnnotationModel.getAnnotationIterator();
        while (iterator.hasNext()) {
            Annotation annotation = (Annotation)iterator.next();
            Position position = iAnnotationModel.getPosition(annotation);
            if (position == null || !this.isRulerLine(position, iDocument, n)) continue;
            if (annotation instanceof AnnotationBag) {
                AnnotationBag annotationBag = (AnnotationBag)annotation;
                Iterator iterator2 = annotationBag.iterator();
                while (iterator2.hasNext()) {
                    annotation = (Annotation)iterator2.next();
                    position = iAnnotationModel.getPosition(annotation);
                    if (position == null || !this.includeAnnotation(annotation, position, hashMap)) continue;
                    arrayList.add(annotation);
                }
                continue;
            }
            if (!this.includeAnnotation(annotation, position, hashMap)) continue;
            arrayList.add(annotation);
        }
        return arrayList;
    }
}

