/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.source;

import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.IVerticalRulerExtension;
import org.eclipse.jface.text.source.IVerticalRulerInfoExtension;
import org.eclipse.jface.text.source.IVerticalRulerListener;
import org.eclipse.jface.text.source.VerticalRulerEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;

public class CompositeRuler
implements IVerticalRuler,
IVerticalRulerExtension,
IVerticalRulerInfoExtension {
    private ITextViewer fTextViewer;
    private CompositeRulerCanvas fComposite;
    private IAnnotationModel fModel;
    private List fDecorators = new ArrayList(2);
    private Point fLocation = new Point(-1, -1);
    private int fLastMouseButtonActivityLine = -1;
    private int fGap;
    private Set fAnnotationListeners = new HashSet();

    public CompositeRuler() {
        this(0);
    }

    public CompositeRuler(int n) {
        this.fGap = n;
    }

    public void addDecorator(int n, IVerticalRulerColumn iVerticalRulerColumn) {
        iVerticalRulerColumn.setModel(this.getModel());
        if (n > this.fDecorators.size()) {
            this.fDecorators.add(iVerticalRulerColumn);
        } else {
            this.fDecorators.add(n, iVerticalRulerColumn);
        }
        if (this.fComposite != null && !this.fComposite.isDisposed()) {
            iVerticalRulerColumn.createControl(this, (Composite)this.fComposite);
            this.fComposite.childAdded(iVerticalRulerColumn.getControl());
            this.layoutTextViewer();
        }
    }

    public void removeDecorator(int n) {
        IVerticalRulerColumn iVerticalRulerColumn = (IVerticalRulerColumn)this.fDecorators.get(n);
        this.removeDecorator(iVerticalRulerColumn);
    }

    public void removeDecorator(IVerticalRulerColumn iVerticalRulerColumn) {
        Control control;
        this.fDecorators.remove(iVerticalRulerColumn);
        if (iVerticalRulerColumn != null && (control = iVerticalRulerColumn.getControl()) != null && !control.isDisposed()) {
            this.fComposite.childRemoved(control);
            control.dispose();
        }
        this.layoutTextViewer();
    }

    private void layoutTextViewer() {
        StyledText styledText = this.fTextViewer.getTextWidget();
        if (this.fTextViewer instanceof ITextViewerExtension) {
            ITextViewerExtension iTextViewerExtension = (ITextViewerExtension)((Object)this.fTextViewer);
            styledText = iTextViewerExtension.getControl();
        }
        if (styledText instanceof Composite && !styledText.isDisposed()) {
            ((Composite)styledText).layout(true);
        }
    }

    @Override
    public Control getControl() {
        return this.fComposite;
    }

    @Override
    public Control createControl(Composite composite, ITextViewer iTextViewer) {
        this.fTextViewer = iTextViewer;
        this.fComposite = new CompositeRulerCanvas(composite, 0);
        this.fComposite.setLayout(new RulerLayout());
        for (IVerticalRulerColumn iVerticalRulerColumn : this.fDecorators) {
            iVerticalRulerColumn.createControl(this, (Composite)this.fComposite);
            this.fComposite.childAdded(iVerticalRulerColumn.getControl());
        }
        return this.fComposite;
    }

    @Override
    public void setModel(IAnnotationModel iAnnotationModel) {
        this.fModel = iAnnotationModel;
        for (IVerticalRulerColumn iVerticalRulerColumn : this.fDecorators) {
            iVerticalRulerColumn.setModel(iAnnotationModel);
        }
    }

    @Override
    public IAnnotationModel getModel() {
        return this.fModel;
    }

    @Override
    public void update() {
        Display display;
        if (this.fComposite != null && !this.fComposite.isDisposed() && (display = this.fComposite.getDisplay()) != null) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    CompositeRuler.this.immediateUpdate();
                }
            });
        }
    }

    public void immediateUpdate() {
        for (IVerticalRulerColumn iVerticalRulerColumn : this.fDecorators) {
            iVerticalRulerColumn.redraw();
        }
    }

    @Override
    public void setFont(Font font) {
        for (IVerticalRulerColumn iVerticalRulerColumn : this.fDecorators) {
            iVerticalRulerColumn.setFont(font);
        }
    }

    @Override
    public int getWidth() {
        int n = 0;
        for (IVerticalRulerColumn iVerticalRulerColumn : this.fDecorators) {
            n += iVerticalRulerColumn.getWidth() + this.fGap;
        }
        return Math.max(0, n - this.fGap);
    }

    @Override
    public int getLineOfLastMouseButtonActivity() {
        if (this.fLastMouseButtonActivityLine == -1) {
            this.fLastMouseButtonActivityLine = this.toDocumentLineNumber(this.fLocation.y);
        } else if (this.fTextViewer.getDocument() == null || this.fLastMouseButtonActivityLine >= this.fTextViewer.getDocument().getNumberOfLines()) {
            this.fLastMouseButtonActivityLine = -1;
        }
        return this.fLastMouseButtonActivityLine;
    }

    @Override
    public int toDocumentLineNumber(int n) {
        if (this.fTextViewer == null || n == -1) {
            return -1;
        }
        StyledText styledText = this.fTextViewer.getTextWidget();
        int n2 = styledText.getLineIndex(n);
        if (n2 == styledText.getLineCount() - 1 && n > styledText.getLinePixel(n2 + 1)) {
            return -1;
        }
        return CompositeRuler.widgetLine2ModelLine(this.fTextViewer, n2);
    }

    protected static final int widgetLine2ModelLine(ITextViewer iTextViewer, int n) {
        if (iTextViewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 iTextViewerExtension5 = (ITextViewerExtension5)((Object)iTextViewer);
            return iTextViewerExtension5.widgetLine2ModelLine(n);
        }
        try {
            IRegion iRegion = iTextViewer.getVisibleRegion();
            IDocument iDocument = iTextViewer.getDocument();
            return n += iDocument.getLineOfOffset(iRegion.getOffset());
        }
        catch (BadLocationException badLocationException) {
            return n;
        }
    }

    public ITextViewer getTextViewer() {
        return this.fTextViewer;
    }

    @Override
    public void setLocationOfLastMouseButtonActivity(int n, int n2) {
        this.fLocation.x = n;
        this.fLocation.y = n2;
        this.fLastMouseButtonActivityLine = -1;
    }

    public Iterator getDecoratorIterator() {
        Assert.isNotNull((Object)this.fDecorators, (String)"fDecorators must be initialized");
        return this.fDecorators.iterator();
    }

    @Override
    public IAnnotationHover getHover() {
        return null;
    }

    @Override
    public void addVerticalRulerListener(IVerticalRulerListener iVerticalRulerListener) {
        this.fAnnotationListeners.add(iVerticalRulerListener);
    }

    @Override
    public void removeVerticalRulerListener(IVerticalRulerListener iVerticalRulerListener) {
        this.fAnnotationListeners.remove(iVerticalRulerListener);
    }

    public void fireAnnotationSelected(VerticalRulerEvent verticalRulerEvent) {
        for (IVerticalRulerListener iVerticalRulerListener : this.fAnnotationListeners) {
            iVerticalRulerListener.annotationSelected(verticalRulerEvent);
        }
    }

    public void fireAnnotationDefaultSelected(VerticalRulerEvent verticalRulerEvent) {
        for (IVerticalRulerListener iVerticalRulerListener : this.fAnnotationListeners) {
            iVerticalRulerListener.annotationDefaultSelected(verticalRulerEvent);
        }
    }

    public void fireAnnotationContextMenuAboutToShow(VerticalRulerEvent verticalRulerEvent, Menu menu) {
        for (IVerticalRulerListener iVerticalRulerListener : this.fAnnotationListeners) {
            iVerticalRulerListener.annotationContextMenuAboutToShow(verticalRulerEvent, menu);
        }
    }

    public void relayout() {
        this.layoutTextViewer();
    }

    static class CompositeRulerCanvas
    extends Canvas {
        private List fCachedListeners = new ArrayList();
        private Listener fMenuDetectListener = new Listener(){

            public void handleEvent(Event event) {
                Menu menu;
                if (event.type == 35 && (menu = CompositeRulerCanvas.this.getMenu()) != null) {
                    menu.setLocation(event.x, event.y);
                    menu.setVisible(true);
                }
            }
        };

        public CompositeRulerCanvas(Composite composite, int n) {
            super(composite, n);
            super.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent disposeEvent) {
                    if (CompositeRulerCanvas.this.fCachedListeners != null) {
                        CompositeRulerCanvas.this.fCachedListeners.clear();
                        CompositeRulerCanvas.this.fCachedListeners = null;
                    }
                }
            });
        }

        private void addListener(Class clazz, Control control, EventListener eventListener) {
            if (ControlListener.class.equals((Object)clazz)) {
                control.addControlListener((ControlListener)eventListener);
                return;
            }
            if (FocusListener.class.equals((Object)clazz)) {
                control.addFocusListener((FocusListener)eventListener);
                return;
            }
            if (HelpListener.class.equals((Object)clazz)) {
                control.addHelpListener((HelpListener)eventListener);
                return;
            }
            if (KeyListener.class.equals((Object)clazz)) {
                control.addKeyListener((KeyListener)eventListener);
                return;
            }
            if (MouseListener.class.equals((Object)clazz)) {
                control.addMouseListener((MouseListener)eventListener);
                return;
            }
            if (MouseMoveListener.class.equals((Object)clazz)) {
                control.addMouseMoveListener((MouseMoveListener)eventListener);
                return;
            }
            if (MouseTrackListener.class.equals((Object)clazz)) {
                control.addMouseTrackListener((MouseTrackListener)eventListener);
                return;
            }
            if (PaintListener.class.equals((Object)clazz)) {
                control.addPaintListener((PaintListener)eventListener);
                return;
            }
            if (TraverseListener.class.equals((Object)clazz)) {
                control.addTraverseListener((TraverseListener)eventListener);
                return;
            }
            if (DisposeListener.class.equals((Object)clazz)) {
                control.addDisposeListener((DisposeListener)eventListener);
                return;
            }
        }

        private void removeListener(Class clazz, Control control, EventListener eventListener) {
            if (ControlListener.class.equals((Object)clazz)) {
                control.removeControlListener((ControlListener)eventListener);
                return;
            }
            if (FocusListener.class.equals((Object)clazz)) {
                control.removeFocusListener((FocusListener)eventListener);
                return;
            }
            if (HelpListener.class.equals((Object)clazz)) {
                control.removeHelpListener((HelpListener)eventListener);
                return;
            }
            if (KeyListener.class.equals((Object)clazz)) {
                control.removeKeyListener((KeyListener)eventListener);
                return;
            }
            if (MouseListener.class.equals((Object)clazz)) {
                control.removeMouseListener((MouseListener)eventListener);
                return;
            }
            if (MouseMoveListener.class.equals((Object)clazz)) {
                control.removeMouseMoveListener((MouseMoveListener)eventListener);
                return;
            }
            if (MouseTrackListener.class.equals((Object)clazz)) {
                control.removeMouseTrackListener((MouseTrackListener)eventListener);
                return;
            }
            if (PaintListener.class.equals((Object)clazz)) {
                control.removePaintListener((PaintListener)eventListener);
                return;
            }
            if (TraverseListener.class.equals((Object)clazz)) {
                control.removeTraverseListener((TraverseListener)eventListener);
                return;
            }
            if (DisposeListener.class.equals((Object)clazz)) {
                control.removeDisposeListener((DisposeListener)eventListener);
                return;
            }
        }

        private void addListener(Class clazz, EventListener eventListener) {
            Control[] controlArray = this.getChildren();
            int n = 0;
            while (n < controlArray.length) {
                if (controlArray[n] != null && !controlArray[n].isDisposed()) {
                    this.addListener(clazz, controlArray[n], eventListener);
                }
                ++n;
            }
            ListenerInfo listenerInfo = new ListenerInfo();
            listenerInfo.fClass = clazz;
            listenerInfo.fListener = eventListener;
            this.fCachedListeners.add(listenerInfo);
        }

        private void removeListener(Class clazz, EventListener eventListener) {
            Control[] controlArray = this.getChildren();
            int n = this.fCachedListeners.size();
            int n2 = 0;
            while (n2 < n) {
                ListenerInfo listenerInfo = (ListenerInfo)this.fCachedListeners.get(n2);
                if (eventListener == listenerInfo.fListener && clazz.equals(listenerInfo.fClass)) {
                    this.fCachedListeners.remove(n2);
                    break;
                }
                ++n2;
            }
            n2 = 0;
            while (n2 < controlArray.length) {
                if (controlArray[n2] != null && !controlArray[n2].isDisposed()) {
                    this.removeListener(clazz, controlArray[n2], eventListener);
                }
                ++n2;
            }
        }

        public void childAdded(Control control) {
            if (control != null && !control.isDisposed()) {
                int n = this.fCachedListeners.size();
                int n2 = 0;
                while (n2 < n) {
                    ListenerInfo listenerInfo = (ListenerInfo)this.fCachedListeners.get(n2);
                    this.addListener(listenerInfo.fClass, control, listenerInfo.fListener);
                    ++n2;
                }
                control.addListener(35, this.fMenuDetectListener);
            }
        }

        public void childRemoved(Control control) {
            if (control != null && !control.isDisposed()) {
                int n = this.fCachedListeners.size();
                int n2 = 0;
                while (n2 < n) {
                    ListenerInfo listenerInfo = (ListenerInfo)this.fCachedListeners.get(n2);
                    this.removeListener(listenerInfo.fClass, control, listenerInfo.fListener);
                    ++n2;
                }
                control.removeListener(35, this.fMenuDetectListener);
            }
        }

        public void removeControlListener(ControlListener controlListener) {
            this.removeListener(ControlListener.class, (EventListener)controlListener);
            super.removeControlListener(controlListener);
        }

        public void removeFocusListener(FocusListener focusListener) {
            this.removeListener(FocusListener.class, (EventListener)focusListener);
            super.removeFocusListener(focusListener);
        }

        public void removeHelpListener(HelpListener helpListener) {
            this.removeListener(HelpListener.class, (EventListener)helpListener);
            super.removeHelpListener(helpListener);
        }

        public void removeKeyListener(KeyListener keyListener) {
            this.removeListener(KeyListener.class, (EventListener)keyListener);
            super.removeKeyListener(keyListener);
        }

        public void removeMouseListener(MouseListener mouseListener) {
            this.removeListener(MouseListener.class, (EventListener)mouseListener);
            super.removeMouseListener(mouseListener);
        }

        public void removeMouseMoveListener(MouseMoveListener mouseMoveListener) {
            this.removeListener(MouseMoveListener.class, (EventListener)mouseMoveListener);
            super.removeMouseMoveListener(mouseMoveListener);
        }

        public void removeMouseTrackListener(MouseTrackListener mouseTrackListener) {
            this.removeListener(MouseTrackListener.class, (EventListener)mouseTrackListener);
            super.removeMouseTrackListener(mouseTrackListener);
        }

        public void removePaintListener(PaintListener paintListener) {
            this.removeListener(PaintListener.class, (EventListener)paintListener);
            super.removePaintListener(paintListener);
        }

        public void removeTraverseListener(TraverseListener traverseListener) {
            this.removeListener(TraverseListener.class, (EventListener)traverseListener);
            super.removeTraverseListener(traverseListener);
        }

        public void removeDisposeListener(DisposeListener disposeListener) {
            this.removeListener(DisposeListener.class, (EventListener)disposeListener);
            super.removeDisposeListener(disposeListener);
        }

        public void addControlListener(ControlListener controlListener) {
            super.addControlListener(controlListener);
            this.addListener(ControlListener.class, (EventListener)controlListener);
        }

        public void addFocusListener(FocusListener focusListener) {
            super.addFocusListener(focusListener);
            this.addListener(FocusListener.class, (EventListener)focusListener);
        }

        public void addHelpListener(HelpListener helpListener) {
            super.addHelpListener(helpListener);
            this.addListener(HelpListener.class, (EventListener)helpListener);
        }

        public void addKeyListener(KeyListener keyListener) {
            super.addKeyListener(keyListener);
            this.addListener(KeyListener.class, (EventListener)keyListener);
        }

        public void addMouseListener(MouseListener mouseListener) {
            super.addMouseListener(mouseListener);
            this.addListener(MouseListener.class, (EventListener)mouseListener);
        }

        public void addMouseMoveListener(MouseMoveListener mouseMoveListener) {
            super.addMouseMoveListener(mouseMoveListener);
            this.addListener(MouseMoveListener.class, (EventListener)mouseMoveListener);
        }

        public void addMouseTrackListener(MouseTrackListener mouseTrackListener) {
            super.addMouseTrackListener(mouseTrackListener);
            this.addListener(MouseTrackListener.class, (EventListener)mouseTrackListener);
        }

        public void addPaintListener(PaintListener paintListener) {
            super.addPaintListener(paintListener);
            this.addListener(PaintListener.class, (EventListener)paintListener);
        }

        public void addTraverseListener(TraverseListener traverseListener) {
            super.addTraverseListener(traverseListener);
            this.addListener(TraverseListener.class, (EventListener)traverseListener);
        }

        public void addDisposeListener(DisposeListener disposeListener) {
            super.addDisposeListener(disposeListener);
            this.addListener(DisposeListener.class, (EventListener)disposeListener);
        }

        static class ListenerInfo {
            Class fClass;
            EventListener fListener;

            ListenerInfo() {
            }
        }
    }

    class RulerLayout
    extends Layout {
        protected RulerLayout() {
        }

        protected Point computeSize(Composite composite, int n, int n2, boolean bl) {
            Control[] controlArray = composite.getChildren();
            Point point = new Point(0, 0);
            int n3 = 0;
            while (n3 < controlArray.length) {
                Point point2 = controlArray[n3].computeSize(-1, -1, bl);
                point.x += point2.x;
                point.y = Math.max(point.y, point2.y);
                ++n3;
            }
            point.x += Math.max(0, controlArray.length - 1) * CompositeRuler.this.fGap;
            return point;
        }

        protected void layout(Composite composite, boolean bl) {
            Rectangle rectangle = composite.getClientArea();
            int n = rectangle.height;
            int n2 = 0;
            for (IVerticalRulerColumn iVerticalRulerColumn : CompositeRuler.this.fDecorators) {
                int n3 = iVerticalRulerColumn.getWidth();
                iVerticalRulerColumn.getControl().setBounds(n2, 0, n3, n);
                n2 += n3 + CompositeRuler.this.fGap;
            }
        }
    }
}

