/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.source;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.internal.text.revisions.RevisionPainter;
import org.eclipse.jface.internal.text.source.DiffPainter;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.IViewportListener;
import org.eclipse.jface.text.JFaceTextUtil;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.revisions.IRevisionRulerColumn;
import org.eclipse.jface.text.revisions.RevisionInformation;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IChangeRulerColumn;
import org.eclipse.jface.text.source.ILineRange;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.jface.text.source.IVerticalRulerListener;
import org.eclipse.jface.text.source.LineNumberRulerColumn;
import org.eclipse.jface.text.source.LineRange;
import org.eclipse.jface.util.Util;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public final class ChangeRulerColumn
implements IChangeRulerColumn,
IRevisionRulerColumn {
    private static final boolean IS_MAC = Util.isMac();
    private final InternalListener fInternalListener = new InternalListener();
    private final MouseHandler fMouseHandler = new MouseHandler();
    private final RevisionPainter fRevisionPainter;
    private final DiffPainter fDiffPainter;
    private CompositeRuler fParentRuler;
    private ITextViewer fCachedTextViewer;
    private StyledText fCachedTextWidget;
    private Canvas fCanvas;
    private Color fBackground;
    private IAnnotationModel fAnnotationModel;
    private final int fWidth = 5;
    private int fScrollPos;
    private Image fBuffer;
    private boolean fSensitiveToTextChanges = false;

    public ChangeRulerColumn() {
        this.fRevisionPainter = null;
        this.fDiffPainter = new DiffPainter(this, null);
    }

    public ChangeRulerColumn(ISharedTextColors iSharedTextColors) {
        Assert.isNotNull((Object)iSharedTextColors);
        this.fRevisionPainter = new RevisionPainter(this, iSharedTextColors);
        this.fDiffPainter = new DiffPainter(this, null);
    }

    private Color getBackground() {
        if (this.fBackground == null) {
            return this.fCachedTextWidget.getDisplay().getSystemColor(25);
        }
        return this.fBackground;
    }

    @Override
    public Control createControl(CompositeRuler compositeRuler, Composite composite) {
        this.fParentRuler = compositeRuler;
        this.fCachedTextViewer = compositeRuler.getTextViewer();
        this.fCachedTextWidget = this.fCachedTextViewer.getTextWidget();
        this.fCanvas = new Canvas(composite, 0);
        this.fCanvas.setBackground(this.getBackground());
        this.fCanvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                if (ChangeRulerColumn.this.fCachedTextViewer != null) {
                    ChangeRulerColumn.this.doubleBufferPaint(paintEvent.gc);
                }
            }
        });
        this.fCanvas.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                ChangeRulerColumn.this.handleDispose();
                ChangeRulerColumn.this.fCachedTextViewer = null;
                ChangeRulerColumn.this.fCachedTextWidget = null;
            }
        });
        this.fCanvas.addMouseListener((MouseListener)this.fMouseHandler);
        this.fCanvas.addMouseMoveListener((MouseMoveListener)this.fMouseHandler);
        if (this.fCachedTextViewer != null) {
            this.fCachedTextViewer.addViewportListener(this.fInternalListener);
            this.fCachedTextViewer.addTextListener(this.fInternalListener);
        }
        this.fRevisionPainter.setParentRuler(compositeRuler);
        this.fDiffPainter.setParentRuler(compositeRuler);
        return this.fCanvas;
    }

    protected void handleDispose() {
        if (this.fCachedTextViewer != null) {
            this.fCachedTextViewer.removeViewportListener(this.fInternalListener);
            this.fCachedTextViewer.removeTextListener(this.fInternalListener);
        }
        if (this.fBuffer != null) {
            this.fBuffer.dispose();
            this.fBuffer = null;
        }
    }

    private void doubleBufferPaint(GC gC) {
        Rectangle rectangle;
        Point point = this.fCanvas.getSize();
        if (point.x <= 0 || point.y <= 0) {
            return;
        }
        if (this.fBuffer != null) {
            rectangle = this.fBuffer.getBounds();
            if (rectangle.width != point.x || rectangle.height != point.y) {
                this.fBuffer.dispose();
                this.fBuffer = null;
            }
        }
        if (this.fBuffer == null) {
            this.fBuffer = new Image((Device)this.fCanvas.getDisplay(), point.x, point.y);
        }
        rectangle = new GC((Drawable)this.fBuffer);
        rectangle.setFont(this.fCanvas.getFont());
        try {
            rectangle.setBackground(this.getBackground());
            rectangle.fillRectangle(0, 0, point.x, point.y);
            this.doPaint((GC)rectangle);
        }
        finally {
            rectangle.dispose();
        }
        gC.drawImage(this.fBuffer, 0, 0);
    }

    protected int getVisibleLinesInViewport() {
        return LineNumberRulerColumn.getVisibleLinesInViewport(this.fCachedTextWidget);
    }

    protected final boolean isViewerCompletelyShown() {
        return JFaceTextUtil.isShowingEntireContents(this.fCachedTextWidget);
    }

    private void doPaint(GC gC) {
        ILineRange iLineRange = this.computeVisibleModelLines();
        if (iLineRange == null) {
            return;
        }
        this.fSensitiveToTextChanges = this.isViewerCompletelyShown();
        this.fScrollPos = this.fCachedTextWidget.getTopPixel();
        this.fRevisionPainter.paint(gC, iLineRange);
        if (!this.fRevisionPainter.hasInformation()) {
            this.fDiffPainter.paint(gC, iLineRange);
        }
    }

    @Override
    public void redraw() {
        if (this.fCachedTextViewer != null && this.fCanvas != null && !this.fCanvas.isDisposed()) {
            if (IS_MAC) {
                this.fCanvas.redraw();
                this.fCanvas.update();
            } else {
                GC gC = new GC((Drawable)this.fCanvas);
                this.doubleBufferPaint(gC);
                gC.dispose();
            }
        }
    }

    @Override
    public void setFont(Font font) {
    }

    private CompositeRuler getParentRuler() {
        return this.fParentRuler;
    }

    @Override
    public int getLineOfLastMouseButtonActivity() {
        return this.getParentRuler().getLineOfLastMouseButtonActivity();
    }

    @Override
    public int toDocumentLineNumber(int n) {
        return this.getParentRuler().toDocumentLineNumber(n);
    }

    @Override
    public IAnnotationHover getHover() {
        int n = this.getParentRuler().getLineOfLastMouseButtonActivity();
        if (this.fRevisionPainter.hasHover(n)) {
            return this.fRevisionPainter.getHover();
        }
        if (this.fDiffPainter.hasHover(n)) {
            return this.fDiffPainter.getHover();
        }
        return null;
    }

    @Override
    public void setHover(IAnnotationHover iAnnotationHover) {
        this.fRevisionPainter.setHover(iAnnotationHover);
        this.fDiffPainter.setHover(iAnnotationHover);
    }

    @Override
    public void setModel(IAnnotationModel iAnnotationModel) {
        this.setAnnotationModel(iAnnotationModel);
        this.fRevisionPainter.setModel(iAnnotationModel);
        this.fDiffPainter.setModel(iAnnotationModel);
    }

    private void setAnnotationModel(IAnnotationModel iAnnotationModel) {
        if (this.fAnnotationModel != iAnnotationModel) {
            this.fAnnotationModel = iAnnotationModel;
        }
    }

    @Override
    public void setBackground(Color color) {
        this.fBackground = color;
        if (this.fCanvas != null && !this.fCanvas.isDisposed()) {
            this.fCanvas.setBackground(this.getBackground());
        }
        this.fRevisionPainter.setBackground(color);
        this.fDiffPainter.setBackground(color);
    }

    @Override
    public void setAddedColor(Color color) {
        this.fDiffPainter.setAddedColor(color);
    }

    @Override
    public void setChangedColor(Color color) {
        this.fDiffPainter.setChangedColor(color);
    }

    @Override
    public void setDeletedColor(Color color) {
        this.fDiffPainter.setDeletedColor(color);
    }

    @Override
    public IAnnotationModel getModel() {
        return this.fAnnotationModel;
    }

    @Override
    public Control getControl() {
        return this.fCanvas;
    }

    @Override
    public int getWidth() {
        return 5;
    }

    protected final void postRedraw() {
        Display display;
        if (this.fCanvas != null && !this.fCanvas.isDisposed() && (display = this.fCanvas.getDisplay()) != null) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    ChangeRulerColumn.this.redraw();
                }
            });
        }
    }

    @Override
    public void addVerticalRulerListener(IVerticalRulerListener iVerticalRulerListener) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeVerticalRulerListener(IVerticalRulerListener iVerticalRulerListener) {
        throw new UnsupportedOperationException();
    }

    private final ILineRange computeVisibleModelLines() {
        IRegion iRegion;
        int n;
        int n2;
        IDocument iDocument = this.fCachedTextViewer.getDocument();
        if (iDocument == null) {
            return null;
        }
        if (this.fCachedTextViewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 iTextViewerExtension5 = (ITextViewerExtension5)((Object)this.fCachedTextViewer);
            n2 = JFaceTextUtil.getPartialTopIndex(this.fCachedTextWidget);
            n = iTextViewerExtension5.widgetLine2ModelLine(n2);
            iRegion = iTextViewerExtension5.getModelCoverage();
        } else {
            n = JFaceTextUtil.getPartialTopIndex(this.fCachedTextViewer);
            iRegion = this.fCachedTextViewer.getVisibleRegion();
        }
        int n3 = this.fCachedTextViewer.getBottomIndex();
        if (n3 != -1) {
            ++n3;
        }
        try {
            int n4;
            n2 = iDocument.getLineOfOffset(iRegion.getOffset());
            if (n2 > n) {
                n = n2;
            }
            if ((n4 = iDocument.getLineOfOffset(iRegion.getOffset() + iRegion.getLength())) < n3 || n3 == -1) {
                n3 = n4;
            }
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
            return null;
        }
        LineRange lineRange = new LineRange(n, n3 - n + 1);
        return lineRange;
    }

    @Override
    public void setRevisionInformation(RevisionInformation revisionInformation) {
        this.fRevisionPainter.setRevisionInformation(revisionInformation);
        this.fRevisionPainter.setBackground(this.getBackground());
    }

    public ISelectionProvider getRevisionSelectionProvider() {
        return this.fRevisionPainter.getRevisionSelectionProvider();
    }

    private class InternalListener
    implements IViewportListener,
    ITextListener {
        private InternalListener() {
        }

        @Override
        public void viewportChanged(int n) {
            if (n != ChangeRulerColumn.this.fScrollPos) {
                ChangeRulerColumn.this.redraw();
            }
        }

        @Override
        public void textChanged(TextEvent textEvent) {
            if (!textEvent.getViewerRedrawState()) {
                return;
            }
            if (ChangeRulerColumn.this.fSensitiveToTextChanges || textEvent.getDocumentEvent() == null) {
                ChangeRulerColumn.this.postRedraw();
            }
        }
    }

    private class MouseHandler
    implements MouseListener,
    MouseMoveListener {
        private MouseHandler() {
        }

        public void mouseUp(MouseEvent mouseEvent) {
        }

        public void mouseDown(MouseEvent mouseEvent) {
            ChangeRulerColumn.this.fParentRuler.setLocationOfLastMouseButtonActivity(mouseEvent.x, mouseEvent.y);
        }

        public void mouseDoubleClick(MouseEvent mouseEvent) {
            ChangeRulerColumn.this.fParentRuler.setLocationOfLastMouseButtonActivity(mouseEvent.x, mouseEvent.y);
        }

        public void mouseMove(MouseEvent mouseEvent) {
            ChangeRulerColumn.this.fParentRuler.setLocationOfLastMouseButtonActivity(mouseEvent.x, mouseEvent.y);
        }
    }
}

