/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.source;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.IViewportListener;
import org.eclipse.jface.text.JFaceTextUtil;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IAnnotationAccessExtension;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.jface.text.source.IAnnotationModelExtension2;
import org.eclipse.jface.text.source.IAnnotationModelListener;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.jface.text.source.IVerticalRulerInfoExtension;
import org.eclipse.jface.text.source.IVerticalRulerListener;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.util.Util;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class AnnotationRulerColumn
implements IVerticalRulerColumn,
IVerticalRulerInfo,
IVerticalRulerInfoExtension {
    private static final boolean IS_MAC = Util.isMac();
    private CompositeRuler fParentRuler;
    private ITextViewer fCachedTextViewer;
    private StyledText fCachedTextWidget;
    private Canvas fCanvas;
    private IAnnotationModel fModel;
    private int fScrollPos;
    private Image fBuffer;
    private InternalListener fInternalListener = new InternalListener();
    private int fWidth;
    private boolean fAllowSetModel = true;
    private Set fConfiguredAnnotationTypes = new HashSet();
    private Map fAllowedAnnotationTypes = new HashMap();
    private IAnnotationAccessExtension fAnnotationAccessExtension;
    private IAnnotationHover fHover;
    private List fCachedAnnotations = new ArrayList();
    private Comparator fTupleComparator = new TupleComparator();
    private Cursor fHitDetectionCursor;
    private Cursor fLastCursor;
    private MouseListener fMouseListener;

    public AnnotationRulerColumn(IAnnotationModel iAnnotationModel, int n, IAnnotationAccess iAnnotationAccess) {
        this(n, iAnnotationAccess);
        this.fAllowSetModel = false;
        this.fModel = iAnnotationModel;
        this.fModel.addAnnotationModelListener((IAnnotationModelListener)this.fInternalListener);
    }

    public AnnotationRulerColumn(int n, IAnnotationAccess iAnnotationAccess) {
        this.fWidth = n;
        if (iAnnotationAccess instanceof IAnnotationAccessExtension) {
            this.fAnnotationAccessExtension = (IAnnotationAccessExtension)((Object)iAnnotationAccess);
        }
    }

    public AnnotationRulerColumn(IAnnotationModel iAnnotationModel, int n) {
        this.fWidth = n;
        this.fAllowSetModel = false;
        this.fModel = iAnnotationModel;
        this.fModel.addAnnotationModelListener((IAnnotationModelListener)this.fInternalListener);
    }

    public AnnotationRulerColumn(int n) {
        this.fWidth = n;
    }

    @Override
    public Control getControl() {
        return this.fCanvas;
    }

    @Override
    public int getWidth() {
        return this.fWidth;
    }

    @Override
    public Control createControl(CompositeRuler compositeRuler, Composite composite) {
        this.fParentRuler = compositeRuler;
        this.fCachedTextViewer = compositeRuler.getTextViewer();
        this.fCachedTextWidget = this.fCachedTextViewer.getTextWidget();
        this.fHitDetectionCursor = composite.getDisplay().getSystemCursor(21);
        this.fCanvas = this.createCanvas(composite);
        this.fCanvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                if (AnnotationRulerColumn.this.fCachedTextViewer != null) {
                    AnnotationRulerColumn.this.doubleBufferPaint(paintEvent.gc);
                }
            }
        });
        this.fCanvas.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                AnnotationRulerColumn.this.handleDispose();
                AnnotationRulerColumn.this.fCachedTextViewer = null;
                AnnotationRulerColumn.this.fCachedTextWidget = null;
            }
        });
        this.fMouseListener = new MouseListener(){

            public void mouseUp(MouseEvent mouseEvent) {
                int n;
                if (AnnotationRulerColumn.this.isPropagatingMouseListener()) {
                    AnnotationRulerColumn.this.fParentRuler.setLocationOfLastMouseButtonActivity(mouseEvent.x, mouseEvent.y);
                    n = AnnotationRulerColumn.this.fParentRuler.getLineOfLastMouseButtonActivity();
                } else {
                    n = AnnotationRulerColumn.this.fParentRuler.toDocumentLineNumber(mouseEvent.y);
                }
                if (1 == mouseEvent.button) {
                    AnnotationRulerColumn.this.mouseClicked(n);
                }
            }

            public void mouseDown(MouseEvent mouseEvent) {
                int n;
                if (AnnotationRulerColumn.this.isPropagatingMouseListener()) {
                    AnnotationRulerColumn.this.fParentRuler.setLocationOfLastMouseButtonActivity(mouseEvent.x, mouseEvent.y);
                    n = AnnotationRulerColumn.this.fParentRuler.getLineOfLastMouseButtonActivity();
                } else {
                    n = AnnotationRulerColumn.this.fParentRuler.toDocumentLineNumber(mouseEvent.y);
                }
                if (1 == mouseEvent.button) {
                    AnnotationRulerColumn.this.mouseDown(n);
                }
            }

            public void mouseDoubleClick(MouseEvent mouseEvent) {
                int n;
                if (AnnotationRulerColumn.this.isPropagatingMouseListener()) {
                    AnnotationRulerColumn.this.fParentRuler.setLocationOfLastMouseButtonActivity(mouseEvent.x, mouseEvent.y);
                    n = AnnotationRulerColumn.this.fParentRuler.getLineOfLastMouseButtonActivity();
                } else {
                    n = AnnotationRulerColumn.this.fParentRuler.toDocumentLineNumber(mouseEvent.y);
                }
                if (1 == mouseEvent.button) {
                    AnnotationRulerColumn.this.mouseDoubleClicked(n);
                }
            }
        };
        this.fCanvas.addMouseListener(this.fMouseListener);
        this.fCanvas.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent mouseEvent) {
                AnnotationRulerColumn.this.handleMouseMove(mouseEvent);
            }
        });
        if (this.fCachedTextViewer != null) {
            this.fCachedTextViewer.addViewportListener(this.fInternalListener);
            this.fCachedTextViewer.addTextListener(this.fInternalListener);
        }
        return this.fCanvas;
    }

    private Canvas createCanvas(Composite composite) {
        return new Canvas(composite, 786432){

            public void addMouseListener(MouseListener mouseListener) {
                if (AnnotationRulerColumn.this.isPropagatingMouseListener() || mouseListener == AnnotationRulerColumn.this.fMouseListener) {
                    super.addMouseListener(mouseListener);
                }
            }
        };
    }

    protected boolean isPropagatingMouseListener() {
        return true;
    }

    protected void mouseDown(int n) {
    }

    protected void mouseDoubleClicked(int n) {
    }

    protected void mouseClicked(int n) {
    }

    private void handleMouseMove(MouseEvent mouseEvent) {
        this.fParentRuler.setLocationOfLastMouseButtonActivity(mouseEvent.x, mouseEvent.y);
        if (this.fCachedTextViewer != null) {
            Cursor cursor;
            int n = this.toDocumentLineNumber(mouseEvent.y);
            Cursor cursor2 = cursor = this.hasAnnotation(n) ? this.fHitDetectionCursor : null;
            if (cursor != this.fLastCursor) {
                this.fCanvas.setCursor(cursor);
                this.fLastCursor = cursor;
            }
        }
    }

    protected boolean hasAnnotation(int n) {
        IDocument iDocument;
        IAnnotationModel iAnnotationModel;
        block6: {
            iAnnotationModel = this.fModel;
            if (this.fModel instanceof IAnnotationModelExtension) {
                iAnnotationModel = ((IAnnotationModelExtension)this.fModel).getAnnotationModel(SourceViewer.MODEL_ANNOTATION_MODEL);
            }
            if (iAnnotationModel == null) {
                return false;
            }
            try {
                iDocument = this.fCachedTextViewer.getDocument();
                if (iDocument != null) break block6;
                return false;
            }
            catch (BadLocationException badLocationException) {
                return false;
            }
        }
        IRegion iRegion = iDocument.getLineInformation(n);
        int n2 = iRegion.getOffset();
        int n3 = iRegion.getLength();
        Iterator iterator = this.fModel instanceof IAnnotationModelExtension2 ? ((IAnnotationModelExtension2)this.fModel).getAnnotationIterator(n2, n3 + 1, true, true) : iAnnotationModel.getAnnotationIterator();
        while (iterator.hasNext()) {
            Position position;
            Annotation annotation = (Annotation)iterator.next();
            if (annotation.isMarkedDeleted() || this.skip(annotation) || (position = iAnnotationModel.getPosition(annotation)) == null || position.isDeleted() || !position.overlapsWith(n2, n3) && (position.length != 0 || position.offset != n2 + n3)) continue;
            return true;
        }
        return false;
    }

    private void handleDispose() {
        if (this.fCachedTextViewer != null) {
            this.fCachedTextViewer.removeViewportListener(this.fInternalListener);
            this.fCachedTextViewer.removeTextListener(this.fInternalListener);
        }
        if (this.fModel != null) {
            this.fModel.removeAnnotationModelListener((IAnnotationModelListener)this.fInternalListener);
        }
        if (this.fBuffer != null) {
            this.fBuffer.dispose();
            this.fBuffer = null;
        }
        this.fConfiguredAnnotationTypes.clear();
        this.fAllowedAnnotationTypes.clear();
        this.fAnnotationAccessExtension = null;
    }

    private void doubleBufferPaint(GC gC) {
        Rectangle rectangle;
        Point point = this.fCanvas.getSize();
        if (point.x <= 0 || point.y <= 0) {
            return;
        }
        if (this.fBuffer != null) {
            rectangle = this.fBuffer.getBounds();
            if (rectangle.width != point.x || rectangle.height != point.y) {
                this.fBuffer.dispose();
                this.fBuffer = null;
            }
        }
        if (this.fBuffer == null) {
            this.fBuffer = new Image((Device)this.fCanvas.getDisplay(), point.x, point.y);
        }
        rectangle = new GC((Drawable)this.fBuffer);
        rectangle.setFont(this.fCachedTextWidget.getFont());
        try {
            rectangle.setBackground(this.fCanvas.getBackground());
            rectangle.fillRectangle(0, 0, point.x, point.y);
            if (this.fCachedTextViewer instanceof ITextViewerExtension5) {
                this.doPaint1((GC)rectangle);
            } else {
                this.doPaint((GC)rectangle);
            }
        }
        finally {
            rectangle.dispose();
        }
        gC.drawImage(this.fBuffer, 0, 0);
    }

    protected int getInclusiveTopIndexStartOffset() {
        if (this.fCachedTextWidget == null || this.fCachedTextWidget.isDisposed()) {
            return -1;
        }
        IDocument iDocument = this.fCachedTextViewer.getDocument();
        if (iDocument == null) {
            return -1;
        }
        int n = JFaceTextUtil.getPartialTopIndex(this.fCachedTextViewer);
        try {
            return iDocument.getLineOffset(n);
        }
        catch (BadLocationException badLocationException) {
            return -1;
        }
    }

    private int getExclusiveBottomIndexEndOffset() {
        if (this.fCachedTextWidget == null || this.fCachedTextWidget.isDisposed()) {
            return -1;
        }
        IDocument iDocument = this.fCachedTextViewer.getDocument();
        if (iDocument == null) {
            return -1;
        }
        int n = JFaceTextUtil.getPartialBottomIndex(this.fCachedTextViewer);
        try {
            if (n >= iDocument.getNumberOfLines()) {
                n = iDocument.getNumberOfLines() - 1;
            }
            return iDocument.getLineOffset(n) + iDocument.getLineLength(n);
        }
        catch (BadLocationException badLocationException) {
            return -1;
        }
    }

    protected void doPaint(GC gC) {
        IRegion iRegion;
        if (this.fModel == null || this.fCachedTextViewer == null) {
            return;
        }
        int n = this.getInclusiveTopIndexStartOffset();
        int n2 = this.getExclusiveBottomIndexEndOffset();
        int n3 = n2 - n;
        this.fScrollPos = this.fCachedTextWidget.getTopPixel();
        Point point = this.fCanvas.getSize();
        IDocument iDocument = this.fCachedTextViewer.getDocument();
        if (iDocument == null) {
            return;
        }
        int n4 = -1;
        int n5 = -1;
        try {
            iRegion = this.fCachedTextViewer.getVisibleRegion();
            n4 = iDocument.getLineOfOffset(iRegion.getOffset());
            n5 = iDocument.getLineOfOffset(iRegion.getOffset() + iRegion.getLength());
        }
        catch (BadLocationException badLocationException) {
            return;
        }
        iRegion = new Rectangle(0, 0, 0, 0);
        int n6 = 1;
        int n7 = 0;
        while (n7 < n6) {
            Iterator iterator = this.fModel instanceof IAnnotationModelExtension2 ? ((IAnnotationModelExtension2)this.fModel).getAnnotationIterator(n, n3 + 1, true, true) : this.fModel.getAnnotationIterator();
            while (iterator.hasNext()) {
                int n8;
                Position position;
                Annotation annotation = (Annotation)iterator.next();
                int n9 = 0;
                if (this.fAnnotationAccessExtension != null) {
                    n9 = this.fAnnotationAccessExtension.getLayer(annotation);
                }
                n6 = Math.max(n6, n9 + 1);
                if (n9 != n7 || this.skip(annotation) || (position = this.fModel.getPosition(annotation)) == null) continue;
                int n10 = n8 = position.getLength() == 0 ? n3 + 1 : n3;
                if (!position.overlapsWith(n, n8)) continue;
                try {
                    int n11 = position.getOffset();
                    int n12 = position.getLength();
                    int n13 = iDocument.getLineOfOffset(n11);
                    if (n13 < n4) {
                        n13 = n4;
                    }
                    int n14 = n13;
                    if (n12 > 0) {
                        n14 = iDocument.getLineOfOffset(n11 + n12 - 1);
                    }
                    if (n14 > n5) {
                        n14 = n5;
                    }
                    iRegion.x = 0;
                    iRegion.y = JFaceTextUtil.computeLineHeight(this.fCachedTextWidget, 0, n13 -= n4, n13) - this.fScrollPos;
                    iRegion.width = point.x;
                    int n15 = (n14 -= n4) - n13;
                    iRegion.height = JFaceTextUtil.computeLineHeight(this.fCachedTextWidget, n13, n14 + 1, n15 + 1);
                    if (iRegion.y >= point.y || this.fAnnotationAccessExtension == null) continue;
                    this.fAnnotationAccessExtension.paint(annotation, gC, this.fCanvas, (Rectangle)iRegion);
                }
                catch (BadLocationException badLocationException) {}
            }
            ++n7;
        }
    }

    protected void doPaint1(GC gC) {
        int n;
        if (this.fModel == null || this.fCachedTextViewer == null) {
            return;
        }
        ITextViewerExtension5 iTextViewerExtension5 = (ITextViewerExtension5)((Object)this.fCachedTextViewer);
        this.fScrollPos = this.fCachedTextWidget.getTopPixel();
        Point point = this.fCanvas.getSize();
        int n2 = this.getInclusiveTopIndexStartOffset();
        int n3 = this.getExclusiveBottomIndexEndOffset() - n2;
        Rectangle rectangle = new Rectangle(0, 0, 0, 0);
        ReusableRegion reusableRegion = new ReusableRegion();
        int n4 = Integer.MAX_VALUE;
        int n5 = Integer.MIN_VALUE;
        this.fCachedAnnotations.clear();
        Iterator iterator = this.fModel instanceof IAnnotationModelExtension2 ? ((IAnnotationModelExtension2)this.fModel).getAnnotationIterator(n2, n3 + 1, true, true) : this.fModel.getAnnotationIterator();
        while (iterator.hasNext()) {
            Position position;
            Annotation annotation = (Annotation)iterator.next();
            if (this.skip(annotation) || (position = this.fModel.getPosition(annotation)) == null) continue;
            int n6 = n = position.getLength() == 0 ? n3 + 1 : n3;
            if (!position.overlapsWith(n2, n)) continue;
            int n7 = 0;
            if (this.fAnnotationAccessExtension != null) {
                n7 = this.fAnnotationAccessExtension.getLayer(annotation);
            }
            n4 = Math.min(n4, n7);
            n5 = Math.max(n5, n7);
            this.fCachedAnnotations.add(new Tuple(annotation, position));
        }
        Collections.sort(this.fCachedAnnotations, this.fTupleComparator);
        int n8 = n4;
        while (n8 <= n5) {
            int n9 = 0;
            n = this.fCachedAnnotations.size();
            while (n9 < n) {
                Tuple tuple = (Tuple)this.fCachedAnnotations.get(n9);
                Annotation annotation = tuple.annotation;
                Position position = tuple.position;
                int n10 = 0;
                if (this.fAnnotationAccessExtension != null) {
                    n10 = this.fAnnotationAccessExtension.getLayer(annotation);
                }
                if (n10 == n8) {
                    int n11;
                    int n12;
                    reusableRegion.setOffset(position.getOffset());
                    reusableRegion.setLength(position.getLength());
                    IRegion iRegion = iTextViewerExtension5.modelRange2WidgetRange(reusableRegion);
                    if (iRegion != null && (n12 = iTextViewerExtension5.widgetLineOfWidgetOffset(iRegion.getOffset())) != -1 && (n11 = iTextViewerExtension5.widgetLineOfWidgetOffset(iRegion.getOffset() + Math.max(iRegion.getLength() - 1, 0))) != -1) {
                        rectangle.x = 0;
                        rectangle.y = JFaceTextUtil.computeLineHeight(this.fCachedTextWidget, 0, n12, n12) - this.fScrollPos;
                        rectangle.width = point.x;
                        int n13 = n11 - n12;
                        rectangle.height = JFaceTextUtil.computeLineHeight(this.fCachedTextWidget, n12, n11 + 1, n13 + 1);
                        if (rectangle.y < point.y && this.fAnnotationAccessExtension != null) {
                            this.fAnnotationAccessExtension.paint(annotation, gC, this.fCanvas, rectangle);
                        }
                    }
                }
                ++n9;
            }
            ++n8;
        }
        this.fCachedAnnotations.clear();
    }

    private void postRedraw() {
        Display display;
        if (this.fCanvas != null && !this.fCanvas.isDisposed() && (display = this.fCanvas.getDisplay()) != null) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    AnnotationRulerColumn.this.redraw();
                }
            });
        }
    }

    @Override
    public void redraw() {
        if (this.fCanvas != null && !this.fCanvas.isDisposed()) {
            if (IS_MAC) {
                this.fCanvas.redraw();
                this.fCanvas.update();
            } else {
                GC gC = new GC((Drawable)this.fCanvas);
                this.doubleBufferPaint(gC);
                gC.dispose();
            }
        }
    }

    @Override
    public void setModel(IAnnotationModel iAnnotationModel) {
        if (this.fAllowSetModel && iAnnotationModel != this.fModel) {
            if (this.fModel != null) {
                this.fModel.removeAnnotationModelListener((IAnnotationModelListener)this.fInternalListener);
            }
            this.fModel = iAnnotationModel;
            if (this.fModel != null) {
                this.fModel.addAnnotationModelListener((IAnnotationModelListener)this.fInternalListener);
            }
            this.postRedraw();
        }
    }

    @Override
    public void setFont(Font font) {
    }

    protected ITextViewer getCachedTextViewer() {
        return this.fCachedTextViewer;
    }

    @Override
    public IAnnotationModel getModel() {
        return this.fModel;
    }

    public void addAnnotationType(Object object) {
        this.fConfiguredAnnotationTypes.add(object);
        this.fAllowedAnnotationTypes.clear();
    }

    @Override
    public int getLineOfLastMouseButtonActivity() {
        return this.fParentRuler.getLineOfLastMouseButtonActivity();
    }

    @Override
    public int toDocumentLineNumber(int n) {
        return this.fParentRuler.toDocumentLineNumber(n);
    }

    public void removeAnnotationType(Object object) {
        this.fConfiguredAnnotationTypes.remove(object);
        this.fAllowedAnnotationTypes.clear();
    }

    private boolean skip(Annotation annotation) {
        String string = annotation.getType();
        Boolean bl = (Boolean)this.fAllowedAnnotationTypes.get(string);
        if (bl != null) {
            return bl == false;
        }
        boolean bl2 = this.skip(string);
        this.fAllowedAnnotationTypes.put(string, !bl2 ? Boolean.TRUE : Boolean.FALSE);
        return bl2;
    }

    private boolean skip(Object object) {
        if (this.fAnnotationAccessExtension != null) {
            Iterator iterator = this.fConfiguredAnnotationTypes.iterator();
            while (iterator.hasNext()) {
                if (!this.fAnnotationAccessExtension.isSubtype(object, iterator.next())) continue;
                return false;
            }
            return true;
        }
        return !this.fConfiguredAnnotationTypes.contains(object);
    }

    @Override
    public IAnnotationHover getHover() {
        return this.fHover;
    }

    public void setHover(IAnnotationHover iAnnotationHover) {
        this.fHover = iAnnotationHover;
    }

    @Override
    public void addVerticalRulerListener(IVerticalRulerListener iVerticalRulerListener) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeVerticalRulerListener(IVerticalRulerListener iVerticalRulerListener) {
        throw new UnsupportedOperationException();
    }

    class InternalListener
    implements IViewportListener,
    IAnnotationModelListener,
    ITextListener {
        InternalListener() {
        }

        @Override
        public void viewportChanged(int n) {
            if (n != AnnotationRulerColumn.this.fScrollPos) {
                AnnotationRulerColumn.this.redraw();
            }
        }

        public void modelChanged(IAnnotationModel iAnnotationModel) {
            AnnotationRulerColumn.this.postRedraw();
        }

        @Override
        public void textChanged(TextEvent textEvent) {
            if (textEvent.getViewerRedrawState()) {
                AnnotationRulerColumn.this.postRedraw();
            }
        }
    }

    private static class ReusableRegion
    extends Position
    implements IRegion {
        private ReusableRegion() {
        }
    }

    private static class Tuple {
        Annotation annotation;
        Position position;

        Tuple(Annotation annotation, Position position) {
            this.annotation = annotation;
            this.position = position;
        }
    }

    private static class TupleComparator
    implements Comparator {
        private TupleComparator() {
        }

        public int compare(Object object, Object object2) {
            Position position = ((Tuple)object).position;
            Position position2 = ((Tuple)object2).position;
            return position.getOffset() - position2.getOffset();
        }
    }
}

