/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.source;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPaintPositionManager;
import org.eclipse.jface.text.IPainter;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.ITextPresentationListener;
import org.eclipse.jface.text.ITextViewerExtension2;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.JFaceTextUtil;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModelEvent;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IAnnotationAccessExtension;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelListener;
import org.eclipse.jface.text.source.IAnnotationModelListenerExtension;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;

public class AnnotationPainter
implements IPainter,
PaintListener,
IAnnotationModelListener,
IAnnotationModelListenerExtension,
ITextPresentationListener {
    private static boolean DEBUG = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.jface.text/debug/AnnotationPainter"));
    private static final IDrawingStrategy SQUIGGLES_STRATEGY = new SquigglesStrategy();
    private static final IDrawingStrategy NULL_STRATEGY = new NullStrategy();
    private static final Object SQUIGGLES = new Object();
    private static final ITextStyleStrategy HIGHLIGHTING_STRATEGY = new HighlightingStrategy();
    private static final Object HIGHLIGHTING = new Object();
    private boolean fIsActive = false;
    private boolean fIsPainting = false;
    private volatile boolean fIsSettingModel = false;
    private ISourceViewer fSourceViewer;
    private StyledText fTextWidget;
    private IAnnotationModel fModel;
    private IAnnotationAccess fAnnotationAccess;
    private Map fDecorationsMap = new HashMap();
    private Map fHighlightedDecorationsMap = new HashMap();
    private Object fDecorationMapLock = new Object();
    private Object fHighlightedDecorationsMapLock = new Object();
    private Map fAnnotationType2Color = new HashMap();
    private Map fCachedAnnotationType2Color = new HashMap();
    private Position fCurrentHighlightAnnotationRange = null;
    private Position fTotalHighlightAnnotationRange = null;
    private Position fCurrentDrawRange = null;
    private Position fTotalDrawRange = null;
    private ITextInputListener fTextInputListener;
    private boolean fInputDocumentAboutToBeChanged;
    private Map fAnnotationType2PaintingStrategyId = new HashMap();
    private Map fCachedAnnotationType2PaintingStrategy = new HashMap();
    private Map fPaintingStrategyId2PaintingStrategy = new HashMap();
    private ReusableRegion fReusableRegion = new ReusableRegion();

    public AnnotationPainter(ISourceViewer iSourceViewer, IAnnotationAccess iAnnotationAccess) {
        this.fSourceViewer = iSourceViewer;
        this.fAnnotationAccess = iAnnotationAccess;
        this.fTextWidget = iSourceViewer.getTextWidget();
        this.fPaintingStrategyId2PaintingStrategy.put(SQUIGGLES, SQUIGGLES_STRATEGY);
        this.fPaintingStrategyId2PaintingStrategy.put(HIGHLIGHTING, HIGHLIGHTING_STRATEGY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasDecorations() {
        Object object = this.fDecorationMapLock;
        synchronized (object) {
            return !this.fDecorationsMap.isEmpty();
        }
    }

    private void enablePainting() {
        if (!this.fIsPainting && this.hasDecorations()) {
            this.fIsPainting = true;
            this.fTextWidget.addPaintListener((PaintListener)this);
            this.handleDrawRequest(null);
        }
    }

    private void disablePainting(boolean bl) {
        if (this.fIsPainting) {
            this.fIsPainting = false;
            this.fTextWidget.removePaintListener((PaintListener)this);
            if (bl && this.hasDecorations()) {
                this.handleDrawRequest(null);
            }
        }
    }

    private void setModel(IAnnotationModel iAnnotationModel) {
        if (this.fModel != iAnnotationModel) {
            if (this.fModel != null) {
                this.fModel.removeAnnotationModelListener((IAnnotationModelListener)this);
            }
            this.fModel = iAnnotationModel;
            if (this.fModel != null) {
                try {
                    this.fIsSettingModel = true;
                    this.fModel.addAnnotationModelListener((IAnnotationModelListener)this);
                }
                finally {
                    this.fIsSettingModel = false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void catchupWithModel(AnnotationModelEvent annotationModelEvent) {
        Object object;
        Iterator<Annotation> iterator;
        HashMap<Object, Decoration> hashMap;
        HashMap<Object, Decoration> hashMap2;
        Object object3 = this.fDecorationMapLock;
        synchronized (object3) {
            if (this.fDecorationsMap == null) {
                return;
            }
        }
        if (this.fModel == null) {
            object3 = this.fDecorationMapLock;
            synchronized (object3) {
                this.fDecorationsMap.clear();
            }
            object3 = this.fHighlightedDecorationsMapLock;
            synchronized (object3) {
                this.fHighlightedDecorationsMap.clear();
            }
            return;
        }
        object3 = this.computeClippingRegion(null, true);
        IDocument iDocument = this.fSourceViewer.getDocument();
        int n = Integer.MAX_VALUE;
        int n2 = -1;
        int n3 = Integer.MAX_VALUE;
        int n4 = -1;
        Object object4 = this.fDecorationMapLock;
        synchronized (object4) {
            hashMap2 = new HashMap<Object, Decoration>(this.fDecorationsMap);
        }
        object4 = this.fHighlightedDecorationsMapLock;
        synchronized (object4) {
            hashMap = new HashMap<Object, Decoration>(this.fHighlightedDecorationsMap);
        }
        boolean bl = false;
        if (annotationModelEvent == null || annotationModelEvent.isWorldChange()) {
            bl = true;
            if (DEBUG && annotationModelEvent == null) {
                System.out.println("AP: INTERNAL CHANGE");
            }
            for (Map.Entry object22 : hashMap2.entrySet()) {
                Annotation annotation = (Annotation)object22.getKey();
                Decoration decoration = (Decoration)object22.getValue();
                this.drawDecoration(decoration, null, annotation, (IRegion)object3, iDocument);
            }
            hashMap2.clear();
            hashMap.clear();
            iterator = this.fModel.getAnnotationIterator();
        } else {
            Decoration decoration;
            void var13_15;
            object = annotationModelEvent.getRemovedAnnotations();
            boolean n5 = false;
            int n6 = ((Annotation[])object).length;
            while (var13_15 < n6) {
                Position position;
                Object object2 = object[var13_15];
                decoration = (Decoration)hashMap.remove(object2);
                if (decoration != null && (position = decoration.fPosition) != null) {
                    n = Math.min(n, position.offset);
                    n2 = Math.max(n2, position.offset + position.length);
                }
                if ((decoration = (Decoration)hashMap2.remove(object2)) != null) {
                    this.drawDecoration(decoration, null, (Annotation)object2, (IRegion)object3, iDocument);
                    position = decoration.fPosition;
                    if (position != null) {
                        n3 = Math.min(n3, position.offset);
                        n4 = Math.max(n4, position.offset + position.length);
                    }
                }
                ++var13_15;
            }
            Annotation[] annotationArray = annotationModelEvent.getChangedAnnotations();
            n6 = 0;
            int n7 = annotationArray.length;
            while (n6 < n7) {
                Decoration decoration2;
                decoration = annotationArray[n6];
                boolean bl2 = false;
                Decoration decoration3 = (Decoration)hashMap.get(decoration);
                if (decoration3 != null) {
                    bl2 = true;
                    if ((decoration3 = this.getDecoration((Annotation)decoration, decoration3)) == null) {
                        hashMap.remove(decoration);
                    }
                } else if ((decoration3 = this.getDecoration((Annotation)decoration, decoration3)) != null && decoration3.fPaintingStrategy instanceof ITextStyleStrategy) {
                    hashMap.put(decoration, decoration3);
                    bl2 = true;
                }
                boolean bl3 = !bl2 && decoration3 != null;
                Position position = null;
                position = decoration3 == null ? this.fModel.getPosition((Annotation)decoration) : decoration3.fPosition;
                if (position != null && !position.isDeleted()) {
                    if (bl2) {
                        n = Math.min(n, position.offset);
                        n2 = Math.max(n2, position.offset + position.length);
                    }
                    if (bl3) {
                        n3 = Math.min(n3, position.offset);
                        n4 = Math.max(n4, position.offset + position.length);
                    }
                } else {
                    hashMap.remove(decoration);
                }
                if (bl3 && (decoration2 = (Decoration)hashMap2.get(decoration)) != null) {
                    this.drawDecoration(decoration2, null, (Annotation)decoration, (IRegion)object3, iDocument);
                    if (decoration3 != null) {
                        hashMap2.put(decoration, decoration3);
                    } else {
                        hashMap2.remove(decoration);
                    }
                }
                ++n6;
            }
            iterator = Arrays.asList(annotationModelEvent.getAddedAnnotations()).iterator();
        }
        while (iterator.hasNext()) {
            object = (Annotation)iterator.next();
            Decoration decoration = this.getDecoration((Annotation)object, null);
            if (decoration == null) continue;
            if (decoration.fPaintingStrategy instanceof IDrawingStrategy) {
                hashMap2.put(object, decoration);
                n3 = Math.min(n3, ((Decoration)decoration).fPosition.offset);
                n4 = Math.max(n4, ((Decoration)decoration).fPosition.offset + ((Decoration)decoration).fPosition.length);
                continue;
            }
            if (!(decoration.fPaintingStrategy instanceof ITextStyleStrategy)) continue;
            hashMap.put(object, decoration);
            n = Math.min(n, ((Decoration)decoration).fPosition.offset);
            n2 = Math.max(n2, ((Decoration)decoration).fPosition.offset + ((Decoration)decoration).fPosition.length);
        }
        object = this.fDecorationMapLock;
        synchronized (object) {
            this.fDecorationsMap = hashMap2;
            this.updateDrawRanges(n3, n4, bl);
        }
        object = this.fHighlightedDecorationsMapLock;
        synchronized (object) {
            this.fHighlightedDecorationsMap = hashMap;
            this.updateHighlightRanges(n, n2, bl);
        }
    }

    private void updateHighlightRanges(int n, int n2, boolean bl) {
        if (n != Integer.MAX_VALUE) {
            int n3 = n;
            int n4 = n2;
            if (this.fTotalHighlightAnnotationRange != null) {
                n3 = Math.min(n3, this.fTotalHighlightAnnotationRange.offset);
                n4 = Math.max(n4, this.fTotalHighlightAnnotationRange.offset + this.fTotalHighlightAnnotationRange.length);
            }
            if (this.fTotalHighlightAnnotationRange == null) {
                this.fTotalHighlightAnnotationRange = new Position(0);
            }
            if (this.fCurrentHighlightAnnotationRange == null) {
                this.fCurrentHighlightAnnotationRange = new Position(0);
            }
            if (bl) {
                this.fTotalHighlightAnnotationRange.offset = n;
                this.fTotalHighlightAnnotationRange.length = n2 - n;
                this.fCurrentHighlightAnnotationRange.offset = n3;
                this.fCurrentHighlightAnnotationRange.length = n4 - n3;
            } else {
                this.fTotalHighlightAnnotationRange.offset = n3;
                this.fTotalHighlightAnnotationRange.length = n4 - n3;
                this.fCurrentHighlightAnnotationRange.offset = n;
                this.fCurrentHighlightAnnotationRange.length = n2 - n;
            }
        } else if (bl) {
            this.fCurrentHighlightAnnotationRange = this.fTotalHighlightAnnotationRange;
            this.fTotalHighlightAnnotationRange = null;
        } else {
            this.fCurrentHighlightAnnotationRange = null;
        }
        this.adaptToDocumentLength(this.fCurrentHighlightAnnotationRange);
        this.adaptToDocumentLength(this.fTotalHighlightAnnotationRange);
    }

    private void updateDrawRanges(int n, int n2, boolean bl) {
        if (n != Integer.MAX_VALUE) {
            int n3 = n;
            int n4 = n2;
            if (this.fTotalDrawRange != null) {
                n3 = Math.min(n3, this.fTotalDrawRange.offset);
                n4 = Math.max(n4, this.fTotalDrawRange.offset + this.fTotalDrawRange.length);
            }
            if (this.fTotalDrawRange == null) {
                this.fTotalDrawRange = new Position(0);
            }
            if (this.fCurrentDrawRange == null) {
                this.fCurrentDrawRange = new Position(0);
            }
            if (bl) {
                this.fTotalDrawRange.offset = n;
                this.fTotalDrawRange.length = n2 - n;
                this.fCurrentDrawRange.offset = n3;
                this.fCurrentDrawRange.length = n4 - n3;
            } else {
                this.fTotalDrawRange.offset = n3;
                this.fTotalDrawRange.length = n4 - n3;
                this.fCurrentDrawRange.offset = n;
                this.fCurrentDrawRange.length = n2 - n;
            }
        } else if (bl) {
            this.fCurrentDrawRange = this.fTotalDrawRange;
            this.fTotalDrawRange = null;
        } else {
            this.fCurrentDrawRange = null;
        }
        this.adaptToDocumentLength(this.fCurrentDrawRange);
        this.adaptToDocumentLength(this.fTotalDrawRange);
    }

    private void adaptToDocumentLength(Position position) {
        if (position == null) {
            return;
        }
        int n = this.fSourceViewer.getDocument().getLength();
        position.offset = Math.min(position.offset, n);
        position.length = Math.min(position.length, n - position.offset);
    }

    private Decoration getDecoration(Annotation annotation, Decoration decoration) {
        if (annotation.isMarkedDeleted()) {
            return null;
        }
        String string = annotation.getType();
        Object object = this.getPaintingStrategy(string);
        if (object == null || object instanceof NullStrategy) {
            return null;
        }
        Color color = this.getColor(string);
        if (color == null) {
            return null;
        }
        Position position = this.fModel.getPosition(annotation);
        if (position == null || position.isDeleted()) {
            return null;
        }
        if (decoration == null) {
            decoration = new Decoration();
        }
        decoration.fPosition = position;
        decoration.fColor = color;
        if (this.fAnnotationAccess instanceof IAnnotationAccessExtension) {
            IAnnotationAccessExtension iAnnotationAccessExtension = (IAnnotationAccessExtension)((Object)this.fAnnotationAccess);
            decoration.fLayer = iAnnotationAccessExtension.getLayer(annotation);
        } else {
            decoration.fLayer = 0;
        }
        decoration.fPaintingStrategy = object;
        return decoration;
    }

    private Object getPaintingStrategy(String string) {
        Object v = this.fCachedAnnotationType2PaintingStrategy.get(string);
        if (v != null) {
            return v;
        }
        v = this.fPaintingStrategyId2PaintingStrategy.get(this.fAnnotationType2PaintingStrategyId.get(string));
        if (v != null) {
            this.fCachedAnnotationType2PaintingStrategy.put(string, v);
            return v;
        }
        if (this.fAnnotationAccess instanceof IAnnotationAccessExtension) {
            IAnnotationAccessExtension iAnnotationAccessExtension = (IAnnotationAccessExtension)((Object)this.fAnnotationAccess);
            Object[] objectArray = iAnnotationAccessExtension.getSupertypes(string);
            int n = 0;
            while (n < objectArray.length) {
                v = this.fPaintingStrategyId2PaintingStrategy.get(this.fAnnotationType2PaintingStrategyId.get(objectArray[n]));
                if (v != null) {
                    this.fCachedAnnotationType2PaintingStrategy.put(string, v);
                    return v;
                }
                ++n;
            }
        }
        this.fCachedAnnotationType2PaintingStrategy.put(string, NULL_STRATEGY);
        return null;
    }

    private Color getColor(Object object) {
        IAnnotationAccessExtension iAnnotationAccessExtension;
        Object[] objectArray;
        Color color = (Color)this.fCachedAnnotationType2Color.get(object);
        if (color != null) {
            return color;
        }
        color = (Color)this.fAnnotationType2Color.get(object);
        if (color != null) {
            this.fCachedAnnotationType2Color.put(object, color);
            return color;
        }
        if (this.fAnnotationAccess instanceof IAnnotationAccessExtension && (objectArray = (iAnnotationAccessExtension = (IAnnotationAccessExtension)((Object)this.fAnnotationAccess)).getSupertypes(object)) != null) {
            int n = 0;
            while (n < objectArray.length) {
                color = (Color)this.fAnnotationType2Color.get(objectArray[n]);
                if (color != null) {
                    this.fCachedAnnotationType2Color.put(object, color);
                    return color;
                }
                ++n;
            }
        }
        return null;
    }

    private void updatePainting(AnnotationModelEvent annotationModelEvent) {
        this.disablePainting(annotationModelEvent == null);
        this.catchupWithModel(annotationModelEvent);
        if (!this.fInputDocumentAboutToBeChanged) {
            this.invalidateTextPresentation();
        }
        this.enablePainting();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invalidateTextPresentation() {
        Region region = null;
        Object object = this.fHighlightedDecorationsMapLock;
        synchronized (object) {
            if (this.fCurrentHighlightAnnotationRange != null) {
                region = new Region(this.fCurrentHighlightAnnotationRange.getOffset(), this.fCurrentHighlightAnnotationRange.getLength());
            }
        }
        if (region == null) {
            return;
        }
        if (this.fSourceViewer instanceof ITextViewerExtension2) {
            if (DEBUG) {
                System.out.println("AP: invalidating offset: " + region.getOffset() + ", length= " + region.getLength());
            }
            ((ITextViewerExtension2)((Object)this.fSourceViewer)).invalidateTextPresentation(region.getOffset(), region.getLength());
        } else {
            this.fSourceViewer.invalidateTextPresentation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void applyTextPresentation(TextPresentation textPresentation) {
        HashSet hashSet;
        Object object = this.fHighlightedDecorationsMapLock;
        synchronized (object) {
            if (this.fHighlightedDecorationsMap == null || this.fHighlightedDecorationsMap.isEmpty()) {
                return;
            }
            hashSet = new HashSet(this.fHighlightedDecorationsMap.entrySet());
        }
        object = textPresentation.getExtent();
        if (DEBUG) {
            System.out.println("AP: applying text presentation offset: " + object.getOffset() + ", length= " + object.getLength());
        }
        int n = 0;
        int n2 = 1;
        while (n < n2) {
            for (Map.Entry entry : hashSet) {
                ITextViewerExtension5 iTextViewerExtension5;
                Annotation annotation = (Annotation)entry.getKey();
                if (annotation.isMarkedDeleted()) continue;
                Decoration decoration = (Decoration)entry.getValue();
                n2 = Math.max(n2, decoration.fLayer + 1);
                if (decoration.fLayer != n) continue;
                Position position = decoration.fPosition;
                if (this.fSourceViewer instanceof ITextViewerExtension5 ? (iTextViewerExtension5 = (ITextViewerExtension5)((Object)this.fSourceViewer)).modelRange2WidgetRange((IRegion)new Region(position.getOffset(), position.getLength())) == null : !this.fSourceViewer.overlapsWithVisibleRegion(position.offset, position.length)) continue;
                int n3 = object.getOffset() + object.getLength();
                int n4 = position.getOffset() + position.getLength();
                if (n4 < object.getOffset() || n3 <= position.getOffset()) continue;
                int n5 = Math.max(position.getOffset(), object.getOffset());
                int n6 = Math.min(n3, n4);
                int n7 = Math.max(n6 - n5, 0);
                StyleRange styleRange = new StyleRange(n5, n7, null, null);
                ((ITextStyleStrategy)decoration.fPaintingStrategy).applyTextStyle(styleRange, decoration.fColor);
                textPresentation.mergeStyleRange(styleRange);
            }
            ++n;
        }
    }

    public synchronized void modelChanged(IAnnotationModel iAnnotationModel) {
        if (DEBUG) {
            System.err.println("AP: OLD API of AnnotationModelListener called");
        }
        this.modelChanged(new AnnotationModelEvent(iAnnotationModel));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void modelChanged(final AnnotationModelEvent annotationModelEvent) {
        Display display;
        try {
            StyledText styledText = this.fTextWidget;
            if (styledText == null || styledText.isDisposed()) {
                return;
            }
            display = styledText.getDisplay();
        }
        catch (SWTException sWTException) {
            if (sWTException.code != 24) throw sWTException;
            return;
        }
        if (this.fIsSettingModel) {
            if (display != Display.getCurrent()) return;
            this.updatePainting(annotationModelEvent);
            return;
        } else {
            if (DEBUG && annotationModelEvent != null && annotationModelEvent.isWorldChange()) {
                System.out.println("AP: WORLD CHANGED, stack trace follows:");
                new Throwable().printStackTrace(System.out);
            }
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (AnnotationPainter.this.fTextWidget != null && !AnnotationPainter.this.fTextWidget.isDisposed()) {
                        AnnotationPainter.this.updatePainting(annotationModelEvent);
                    }
                }
            });
        }
    }

    public void setAnnotationTypeColor(Object object, Color color) {
        if (color != null) {
            this.fAnnotationType2Color.put(object, color);
        } else {
            this.fAnnotationType2Color.remove(object);
        }
        this.fCachedAnnotationType2Color.clear();
    }

    public void addAnnotationType(Object object) {
        this.addAnnotationType(object, SQUIGGLES);
    }

    public void addAnnotationType(Object object, Object object2) {
        this.fAnnotationType2PaintingStrategyId.put(object, object2);
        this.fCachedAnnotationType2PaintingStrategy.clear();
        if (this.fTextInputListener == null) {
            this.fTextInputListener = new ITextInputListener(){

                @Override
                public void inputDocumentAboutToBeChanged(IDocument iDocument, IDocument iDocument2) {
                    AnnotationPainter.this.fInputDocumentAboutToBeChanged = true;
                }

                @Override
                public void inputDocumentChanged(IDocument iDocument, IDocument iDocument2) {
                    AnnotationPainter.this.fInputDocumentAboutToBeChanged = false;
                }
            };
            this.fSourceViewer.addTextInputListener(this.fTextInputListener);
        }
    }

    public void addDrawingStrategy(Object object, IDrawingStrategy iDrawingStrategy) {
        if (object == null) {
            throw new IllegalArgumentException();
        }
        this.fPaintingStrategyId2PaintingStrategy.put(object, iDrawingStrategy);
        this.fCachedAnnotationType2PaintingStrategy.clear();
    }

    public void addTextStyleStrategy(Object object, ITextStyleStrategy iTextStyleStrategy) {
        if (object == null) {
            throw new IllegalArgumentException();
        }
        this.fPaintingStrategyId2PaintingStrategy.put(object, iTextStyleStrategy);
        this.fCachedAnnotationType2PaintingStrategy.clear();
    }

    public void addHighlightAnnotationType(Object object) {
        this.addAnnotationType(object, HIGHLIGHTING);
    }

    public void removeAnnotationType(Object object) {
        this.fCachedAnnotationType2PaintingStrategy.clear();
        this.fAnnotationType2PaintingStrategyId.remove(object);
        if (this.fAnnotationType2PaintingStrategyId.isEmpty() && this.fTextInputListener != null) {
            this.fSourceViewer.removeTextInputListener(this.fTextInputListener);
            this.fTextInputListener = null;
            this.fInputDocumentAboutToBeChanged = false;
        }
    }

    public void removeHighlightAnnotationType(Object object) {
        this.removeAnnotationType(object);
    }

    public void removeAllAnnotationTypes() {
        this.fCachedAnnotationType2PaintingStrategy.clear();
        this.fAnnotationType2PaintingStrategyId.clear();
        if (this.fTextInputListener != null) {
            this.fSourceViewer.removeTextInputListener(this.fTextInputListener);
            this.fTextInputListener = null;
        }
    }

    public boolean isPaintingAnnotations() {
        return !this.fAnnotationType2PaintingStrategyId.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        if (this.fAnnotationType2Color != null) {
            this.fAnnotationType2Color.clear();
            this.fAnnotationType2Color = null;
        }
        if (this.fCachedAnnotationType2Color != null) {
            this.fCachedAnnotationType2Color.clear();
            this.fCachedAnnotationType2Color = null;
        }
        if (this.fCachedAnnotationType2PaintingStrategy != null) {
            this.fCachedAnnotationType2PaintingStrategy.clear();
            this.fCachedAnnotationType2PaintingStrategy = null;
        }
        if (this.fAnnotationType2PaintingStrategyId != null) {
            this.fAnnotationType2PaintingStrategyId.clear();
            this.fAnnotationType2PaintingStrategyId = null;
        }
        this.fTextWidget = null;
        this.fSourceViewer = null;
        this.fAnnotationAccess = null;
        this.fModel = null;
        Object object = this.fDecorationMapLock;
        synchronized (object) {
            this.fDecorationsMap = null;
        }
        object = this.fHighlightedDecorationsMapLock;
        synchronized (object) {
            this.fHighlightedDecorationsMap = null;
        }
    }

    private int getInclusiveTopIndexStartOffset() {
        if (this.fTextWidget != null && !this.fTextWidget.isDisposed()) {
            int n = JFaceTextUtil.getPartialTopIndex(this.fSourceViewer);
            try {
                IDocument iDocument = this.fSourceViewer.getDocument();
                return iDocument.getLineOffset(n);
            }
            catch (BadLocationException badLocationException) {}
        }
        return -1;
    }

    private int getExclusiveBottomIndexEndOffset() {
        if (this.fTextWidget != null && !this.fTextWidget.isDisposed()) {
            int n = JFaceTextUtil.getPartialBottomIndex(this.fSourceViewer);
            try {
                IDocument iDocument = this.fSourceViewer.getDocument();
                if (n >= iDocument.getNumberOfLines()) {
                    n = iDocument.getNumberOfLines() - 1;
                }
                return iDocument.getLineOffset(n) + iDocument.getLineLength(n);
            }
            catch (BadLocationException badLocationException) {}
        }
        return -1;
    }

    public void paintControl(PaintEvent paintEvent) {
        if (this.fTextWidget != null) {
            this.handleDrawRequest(paintEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleDrawRequest(PaintEvent paintEvent) {
        ArrayList arrayList;
        if (this.fTextWidget == null) {
            return;
        }
        IRegion iRegion = this.computeClippingRegion(paintEvent, false);
        if (iRegion == null) {
            return;
        }
        int n = iRegion.getOffset();
        int n2 = iRegion.getLength();
        GC gC = paintEvent != null ? paintEvent.gc : null;
        ArrayList arrayList2 = this.fDecorationMapLock;
        synchronized (arrayList2) {
            arrayList = new ArrayList(this.fDecorationsMap.size());
            arrayList.addAll(this.fDecorationsMap.entrySet());
        }
        arrayList2 = new ArrayList(10);
        for (Map.Entry object2 : arrayList) {
            Annotation annotation = (Annotation)object2.getKey();
            Decoration decoration = (Decoration)object2.getValue();
            if (annotation.isMarkedDeleted() || this.skip(annotation) || !this.regionsTouchOrOverlap(decoration.fPosition.getOffset(), decoration.fPosition.getLength(), n, n2)) continue;
            int n3 = arrayList2.size();
            while (n3 <= decoration.fLayer) {
                arrayList2.add(new LinkedList());
                ++n3;
            }
            ((List)arrayList2.get(decoration.fLayer)).add(object2);
        }
        IDocument iDocument = this.fSourceViewer.getDocument();
        for (List list : arrayList2) {
            for (Map.Entry entry : list) {
                Annotation annotation = (Annotation)entry.getKey();
                Decoration decoration = (Decoration)entry.getValue();
                this.drawDecoration(decoration, gC, annotation, iRegion, iDocument);
            }
        }
    }

    private void drawDecoration(Decoration decoration, GC gC, Annotation annotation, IRegion iRegion, IDocument iDocument) {
        if (iRegion == null) {
            return;
        }
        if (!(decoration.fPaintingStrategy instanceof IDrawingStrategy)) {
            return;
        }
        IDrawingStrategy iDrawingStrategy = (IDrawingStrategy)decoration.fPaintingStrategy;
        int n = iRegion.getOffset();
        int n2 = iRegion.getLength();
        Position position = decoration.fPosition;
        try {
            int n3 = iDocument.getLineOfOffset(position.getOffset());
            int n4 = Math.max(position.getOffset(), position.getOffset() + position.getLength() - 1);
            int n5 = iDocument.getLineOfOffset(n4);
            int n6 = n3;
            while (n6 <= n5) {
                IRegion iRegion2;
                int n7 = iDocument.getLineOffset(n6);
                int n8 = Math.max(n7, position.getOffset());
                String string = iDocument.getLineDelimiter(n6);
                int n9 = string != null ? string.length() : 0;
                int n10 = Math.min(n7 + iDocument.getLineLength(n6) - n9, position.getOffset() + position.getLength()) - n8;
                if (n10 >= 0 && this.regionsTouchOrOverlap(n8, n10, n, n2) && (iRegion2 = this.getWidgetRange(n8, n10)) != null) {
                    iDrawingStrategy.draw(annotation, gC, this.fTextWidget, iRegion2.getOffset(), iRegion2.getLength(), decoration.fColor);
                }
                ++n6;
            }
        }
        catch (BadLocationException badLocationException) {}
    }

    private IRegion computeClippingRegion(PaintEvent paintEvent, boolean bl) {
        int n;
        int n2;
        int n3;
        if (paintEvent == null) {
            if (!bl && this.fCurrentDrawRange != null) {
                return new Region(this.fCurrentDrawRange.offset, this.fCurrentDrawRange.length);
            }
            int n4 = this.getInclusiveTopIndexStartOffset();
            if (n4 == -1) {
                return null;
            }
            int n5 = this.getExclusiveBottomIndexEndOffset() - n4;
            return new Region(n4, n5);
        }
        try {
            n3 = this.fTextWidget.getOffsetAtLocation(new Point(0, paintEvent.y));
            n2 = this.fTextWidget.getLineAtOffset(n3);
            n = this.fTextWidget.getOffsetAtLine(n2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            try {
                n3 = JFaceTextUtil.getPartialTopIndex(this.fTextWidget);
                n = this.fTextWidget.getOffsetAtLine(n3);
            }
            catch (IllegalArgumentException illegalArgumentException2) {
                n = 0;
            }
        }
        try {
            n2 = this.fTextWidget.getOffsetAtLocation(new Point(0, paintEvent.y + paintEvent.height));
            int n6 = this.fTextWidget.getLineAtOffset(n2);
            n3 = this.fTextWidget.getOffsetAtLine(n6 + 1);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            try {
                n2 = JFaceTextUtil.getPartialBottomIndex(this.fTextWidget);
                n3 = n2 == this.fTextWidget.getLineCount() - 1 ? this.fTextWidget.getCharCount() : this.fTextWidget.getOffsetAtLine(n2 + 1) - 1;
            }
            catch (IllegalArgumentException illegalArgumentException3) {
                n3 = this.fTextWidget.getCharCount();
            }
        }
        IRegion iRegion = this.getModelRange(n, n3 - n);
        return iRegion;
    }

    protected boolean skip(Annotation annotation) {
        return false;
    }

    private IRegion getWidgetRange(int n, int n2) {
        int n3;
        if (n == Integer.MAX_VALUE) {
            return null;
        }
        if (this.fSourceViewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 iTextViewerExtension5 = (ITextViewerExtension5)((Object)this.fSourceViewer);
            this.fReusableRegion.setOffset(n);
            this.fReusableRegion.setLength(n2);
            return iTextViewerExtension5.modelRange2WidgetRange(this.fReusableRegion);
        }
        IRegion iRegion = this.fSourceViewer.getVisibleRegion();
        int n4 = iRegion.getOffset();
        if (this.regionsTouchOrOverlap(n, n2, n4, n3 = iRegion.getLength())) {
            int n5 = Math.max(n4, n);
            int n6 = Math.min(n4 + n3, n + n2);
            this.fReusableRegion.setOffset(n5 - n4);
            this.fReusableRegion.setLength(n6 - n5);
            return this.fReusableRegion;
        }
        return null;
    }

    private IRegion getModelRange(int n, int n2) {
        if (n == Integer.MAX_VALUE) {
            return null;
        }
        if (this.fSourceViewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 iTextViewerExtension5 = (ITextViewerExtension5)((Object)this.fSourceViewer);
            return iTextViewerExtension5.widgetRange2ModelRange((IRegion)new Region(n, n2));
        }
        IRegion iRegion = this.fSourceViewer.getVisibleRegion();
        return new Region(iRegion.getOffset() + n, n2);
    }

    private boolean regionsTouchOrOverlap(int n, int n2, int n3, int n4) {
        return n <= n3 + n4 && n3 <= n + n2;
    }

    @Override
    public void deactivate(boolean bl) {
        if (this.fIsActive) {
            this.fIsActive = false;
            this.disablePainting(bl);
            this.setModel(null);
            this.catchupWithModel(null);
        }
    }

    protected boolean isRepaintReason(int n) {
        return 16 == n || 8 == n;
    }

    protected IAnnotationModel findAnnotationModel(ISourceViewer iSourceViewer) {
        if (iSourceViewer != null) {
            return iSourceViewer.getAnnotationModel();
        }
        return null;
    }

    @Override
    public void paint(int n) {
        if (this.fSourceViewer.getDocument() == null) {
            this.deactivate(false);
            return;
        }
        if (!this.fIsActive) {
            IAnnotationModel iAnnotationModel = this.findAnnotationModel(this.fSourceViewer);
            if (iAnnotationModel != null) {
                this.fIsActive = true;
                this.setModel(iAnnotationModel);
            }
        } else if (this.isRepaintReason(n)) {
            this.updatePainting(null);
        }
    }

    @Override
    public void setPositionManager(IPaintPositionManager iPaintPositionManager) {
    }

    public static final class BoxStrategy
    implements ITextStyleStrategy {
        int fBorderStyle;

        public BoxStrategy(int n) {
            Assert.isLegal((n == 2 || n == 4 || n == 1 ? 1 : 0) != 0);
            this.fBorderStyle = n;
        }

        @Override
        public void applyTextStyle(StyleRange styleRange, Color color) {
            styleRange.borderStyle = this.fBorderStyle;
            styleRange.borderColor = color;
        }
    }

    private static class Decoration {
        private Position fPosition;
        private Color fColor;
        private int fLayer;
        private Object fPaintingStrategy;

        private Decoration() {
        }
    }

    public static final class HighlightingStrategy
    implements ITextStyleStrategy {
        @Override
        public void applyTextStyle(StyleRange styleRange, Color color) {
            styleRange.background = color;
        }
    }

    public static interface IDrawingStrategy {
        public void draw(Annotation var1, GC var2, StyledText var3, int var4, int var5, Color var6);
    }

    public static interface ITextStyleStrategy {
        public void applyTextStyle(StyleRange var1, Color var2);
    }

    public static final class NullStrategy
    implements IDrawingStrategy {
        @Override
        public void draw(Annotation annotation, GC gC, StyledText styledText, int n, int n2, Color color) {
        }
    }

    private static class ReusableRegion
    extends Position
    implements IRegion {
        private ReusableRegion() {
        }
    }

    public static class SquigglesStrategy
    implements IDrawingStrategy {
        @Override
        public void draw(Annotation annotation, GC gC, StyledText styledText, int n, int n2, Color color) {
            if (gC != null) {
                if (n2 < 1) {
                    return;
                }
                Point point = styledText.getLocationAtOffset(n);
                Point point2 = styledText.getLocationAtOffset(n + n2);
                Rectangle rectangle = styledText.getTextBounds(n, n + n2 - 1);
                point.x = rectangle.x;
                point2.x = rectangle.x + rectangle.width;
                int[] nArray = this.computePolyline(point, point2, styledText.getBaseline(n), styledText.getLineHeight(n));
                gC.setLineWidth(0);
                gC.setLineStyle(1);
                gC.setForeground(color);
                gC.drawPolyline(nArray);
            } else {
                styledText.redrawRange(n, n2, true);
            }
        }

        private int[] computePolyline(Point point, Point point2, int n, int n2) {
            int n3 = (point2.x - point.x) / 4;
            if (n3 == 0 && point2.x - point.x > 2) {
                n3 = 1;
            }
            int n4 = point.x;
            int n5 = (2 * n3 + 1) * 2;
            if (n5 < 0) {
                return new int[0];
            }
            int[] nArray = new int[n5];
            int n6 = point.y + Math.min(n + 1, n2 - 2 - 1);
            int n7 = n6 + 2;
            int n8 = 0;
            while (n8 < n3) {
                int n9 = 4 * n8;
                nArray[n9] = n4 + 4 * n8;
                nArray[n9 + 1] = n7;
                nArray[n9 + 2] = nArray[n9] + 2;
                nArray[n9 + 3] = n6;
                ++n8;
            }
            nArray[n5 - 2] = Math.min(Math.max(0, point2.x - 1), point.x + 4 * n3);
            nArray[n5 - 1] = n7;
            return nArray;
        }
    }

    public static final class UnderlineStrategy
    implements ITextStyleStrategy {
        int fUnderlineStyle;

        public UnderlineStrategy(int n) {
            Assert.isLegal((n == 0 || n == 1 || n == 2 || n == 3 ? 1 : 0) != 0);
            this.fUnderlineStyle = n;
        }

        @Override
        public void applyTextStyle(StyleRange styleRange, Color color) {
            styleRange.underline = true;
            styleRange.underlineStyle = this.fUnderlineStyle;
            styleRange.underlineColor = color;
        }
    }
}

