/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.source;

import java.util.Iterator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.internal.text.InformationControlReplacer;
import org.eclipse.jface.internal.text.InternalAccessor;
import org.eclipse.jface.text.AbstractHoverInformationControlManager;
import org.eclipse.jface.text.AbstractInformationControlManager;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.ITextViewerExtension8;
import org.eclipse.jface.text.JFaceTextUtil;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationHoverExtension;
import org.eclipse.jface.text.source.IAnnotationHoverExtension2;
import org.eclipse.jface.text.source.ILineRange;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.jface.text.source.IVerticalRulerInfoExtension;
import org.eclipse.jface.text.source.LineRange;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class AnnotationBarHoverManager
extends AbstractHoverInformationControlManager {
    private ISourceViewer fSourceViewer;
    private IVerticalRulerInfo fVerticalRulerInfo;
    private IAnnotationHover fAnnotationHover;
    protected boolean fAllowMouseExit = false;
    private boolean fHideOnMouseWheel = true;
    private IAnnotationHover fCurrentHover;

    public AnnotationBarHoverManager(ISourceViewer iSourceViewer, IVerticalRuler iVerticalRuler, IAnnotationHover iAnnotationHover, IInformationControlCreator iInformationControlCreator) {
        this(iVerticalRuler, iSourceViewer, iAnnotationHover, iInformationControlCreator);
    }

    public AnnotationBarHoverManager(IVerticalRulerInfo iVerticalRulerInfo, ISourceViewer iSourceViewer, IAnnotationHover iAnnotationHover, IInformationControlCreator iInformationControlCreator) {
        super(iInformationControlCreator);
        Assert.isNotNull((Object)iSourceViewer);
        this.fSourceViewer = iSourceViewer;
        this.fVerticalRulerInfo = iVerticalRulerInfo;
        this.fAnnotationHover = iAnnotationHover;
        this.setAnchor(ANCHOR_RIGHT);
        this.setMargins(5, 0);
    }

    @Override
    protected void computeInformation() {
        this.fAllowMouseExit = false;
        MouseEvent mouseEvent = this.getHoverEvent();
        if ((mouseEvent.stateMask & SWT.BUTTON_MASK) != 0) {
            this.setInformation(null, null);
            return;
        }
        IAnnotationHover iAnnotationHover = this.getHover(mouseEvent);
        if (iAnnotationHover == null) {
            this.setInformation(null, null);
            return;
        }
        int n = this.getHoverLine(mouseEvent);
        if (iAnnotationHover instanceof IAnnotationHoverExtension) {
            IAnnotationHoverExtension iAnnotationHoverExtension = (IAnnotationHoverExtension)((Object)iAnnotationHover);
            ILineRange iLineRange = iAnnotationHoverExtension.getHoverLineRange(this.fSourceViewer, n);
            this.setCustomInformationControlCreator(iAnnotationHoverExtension.getHoverControlCreator());
            iLineRange = this.adaptLineRange(iLineRange, n);
            if (iLineRange != null) {
                this.setInformation(iAnnotationHoverExtension.getHoverInfo(this.fSourceViewer, iLineRange, this.computeNumberOfVisibleLines()), this.computeArea(iLineRange));
            } else {
                this.setInformation(null, null);
            }
        } else {
            this.setCustomInformationControlCreator(null);
            this.setInformation(iAnnotationHover.getHoverInfo(this.fSourceViewer, n), this.computeArea(n));
        }
    }

    @Override
    protected void showInformationControl(Rectangle rectangle) {
        super.showInformationControl(rectangle);
        this.fCurrentHover = this.getHover(this.getHoverEvent());
    }

    @Override
    protected void hideInformationControl() {
        this.fCurrentHover = null;
        super.hideInformationControl();
    }

    private ILineRange adaptLineRange(ILineRange iLineRange, int n) {
        if (iLineRange != null && (iLineRange = this.adaptLineRangeToFolding(iLineRange, n)) != null) {
            return this.adaptLineRangeToViewport(iLineRange);
        }
        return null;
    }

    private ILineRange adaptLineRangeToFolding(ILineRange iLineRange, int n) {
        if (this.fSourceViewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 iTextViewerExtension5 = (ITextViewerExtension5)((Object)this.fSourceViewer);
            try {
                IRegion iRegion;
                IRegion iRegion2 = this.convertToRegion(iLineRange);
                IRegion[] iRegionArray = iTextViewerExtension5.getCoveredModelRanges(iRegion2);
                if (iRegionArray != null && iRegionArray.length > 0 && (iRegion = this.findRegionContainingLine(iRegionArray, n)) != null) {
                    return this.convertToLineRange(iRegion);
                }
            }
            catch (BadLocationException badLocationException) {}
            return null;
        }
        return iLineRange;
    }

    private ILineRange adaptLineRangeToViewport(ILineRange iLineRange) {
        try {
            StyledText styledText = this.fSourceViewer.getTextWidget();
            int n = styledText.getTopIndex();
            int n2 = this.getWidgetLineNumber(iLineRange.getStartLine());
            int n3 = Math.max(n - n2, 0);
            Rectangle rectangle = styledText.getClientArea();
            Rectangle rectangle2 = styledText.computeTrim(0, 0, 0, 0);
            int n4 = rectangle.height - rectangle2.height;
            int n5 = JFaceTextUtil.getLineIndex(styledText, n4) - styledText.getTopIndex();
            int n6 = n + n5;
            int n7 = this.getWidgetLineNumber(iLineRange.getStartLine() + iLineRange.getNumberOfLines() - 1);
            int n8 = Math.max(n7 - n6, 0);
            return new LineRange(iLineRange.getStartLine() + n3, iLineRange.getNumberOfLines() - n8 - n3);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    private IRegion convertToRegion(ILineRange iLineRange) throws BadLocationException {
        IDocument iDocument = this.fSourceViewer.getDocument();
        int n = iDocument.getLineOffset(iLineRange.getStartLine());
        int n2 = iLineRange.getStartLine() + Math.max(0, iLineRange.getNumberOfLines() - 1);
        IRegion iRegion = iDocument.getLineInformation(n2);
        int n3 = iRegion.getOffset() + iRegion.getLength();
        return new Region(n, n3 - n);
    }

    private IRegion findRegionContainingLine(IRegion[] iRegionArray, int n) throws BadLocationException {
        IDocument iDocument = this.fSourceViewer.getDocument();
        IRegion iRegion = iDocument.getLineInformation(n);
        int n2 = 0;
        while (n2 < iRegionArray.length) {
            if (TextUtilities.overlaps((IRegion)iRegionArray[n2], (IRegion)iRegion)) {
                return iRegionArray[n2];
            }
            ++n2;
        }
        return null;
    }

    private ILineRange convertToLineRange(IRegion iRegion) throws BadLocationException {
        IDocument iDocument = this.fSourceViewer.getDocument();
        int n = iDocument.getLineOfOffset(iRegion.getOffset());
        int n2 = iDocument.getLineOfOffset(iRegion.getOffset() + iRegion.getLength());
        return new LineRange(n, n2 - n + 1);
    }

    private Rectangle computeArea(ILineRange iLineRange) {
        try {
            StyledText styledText = this.fSourceViewer.getTextWidget();
            int n = this.getWidgetLineNumber(iLineRange.getStartLine());
            int n2 = JFaceTextUtil.computeLineHeight(styledText, 0, n, n) - styledText.getTopPixel();
            int n3 = JFaceTextUtil.computeLineHeight(styledText, n, n + iLineRange.getNumberOfLines(), iLineRange.getNumberOfLines());
            Point point = this.fVerticalRulerInfo.getControl().getSize();
            return new Rectangle(0, n2, point.x, n3);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    private int computeNumberOfVisibleLines() {
        StyledText styledText = this.fSourceViewer.getTextWidget();
        int n = styledText.getLineHeight();
        int n2 = styledText.getClientArea().height;
        return n2 / n;
    }

    private IAnnotationHover getHover(MouseEvent mouseEvent) {
        if (mouseEvent == null || mouseEvent.getSource() == null) {
            return this.fAnnotationHover;
        }
        if (this.fVerticalRulerInfo instanceof CompositeRuler) {
            CompositeRuler compositeRuler = (CompositeRuler)this.fVerticalRulerInfo;
            Iterator iterator = compositeRuler.getDecoratorIterator();
            while (iterator.hasNext()) {
                IAnnotationHover iAnnotationHover;
                Object e = iterator.next();
                if (!(e instanceof IVerticalRulerInfoExtension) || !(e instanceof IVerticalRulerInfo) || ((IVerticalRulerInfo)e).getControl() != mouseEvent.getSource() || (iAnnotationHover = ((IVerticalRulerInfoExtension)e).getHover()) == null) continue;
                return iAnnotationHover;
            }
        }
        return this.fAnnotationHover;
    }

    private int getHoverLine(MouseEvent mouseEvent) {
        return mouseEvent == null ? -1 : this.fVerticalRulerInfo.toDocumentLineNumber(mouseEvent.y);
    }

    private int getWidgetLineNumber(int n) throws BadLocationException {
        if (this.fSourceViewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 iTextViewerExtension5 = (ITextViewerExtension5)((Object)this.fSourceViewer);
            return iTextViewerExtension5.modelLine2WidgetLine(n);
        }
        IRegion iRegion = this.fSourceViewer.getVisibleRegion();
        int n2 = this.fSourceViewer.getDocument().getLineOfOffset(iRegion.getOffset());
        return n - n2;
    }

    private Rectangle computeArea(int n) {
        try {
            StyledText styledText = this.fSourceViewer.getTextWidget();
            int n2 = this.getWidgetLineNumber(n);
            int n3 = JFaceTextUtil.computeLineHeight(styledText, 0, n2, n2) - styledText.getTopPixel();
            Point point = this.fVerticalRulerInfo.getControl().getSize();
            return new Rectangle(0, n3, point.x, styledText.getLineHeight(styledText.getOffsetAtLine(n2)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (BadLocationException badLocationException) {}
        return null;
    }

    protected IAnnotationHover getAnnotationHover() {
        return this.fAnnotationHover;
    }

    protected ISourceViewer getSourceViewer() {
        return this.fSourceViewer;
    }

    protected IVerticalRulerInfo getVerticalRulerInfo() {
        return this.fVerticalRulerInfo;
    }

    @Override
    protected Point computeSizeConstraints(Control control, Rectangle rectangle, IInformationControl iInformationControl) {
        Rectangle rectangle2;
        Point point = super.computeSizeConstraints(control, rectangle, iInformationControl);
        StyledText styledText = this.fSourceViewer.getTextWidget();
        if (styledText != null && (rectangle2 = styledText.getClientArea()) != null) {
            point.x = rectangle2.width;
            point.y = rectangle2.height;
        }
        return point;
    }

    @Override
    protected Point computeInformationControlLocation(Rectangle rectangle, Point point) {
        IAnnotationHoverExtension iAnnotationHoverExtension;
        boolean bl;
        MouseEvent mouseEvent = this.getHoverEvent();
        IAnnotationHover iAnnotationHover = this.getHover(mouseEvent);
        if (iAnnotationHover instanceof IAnnotationHoverExtension && (bl = (iAnnotationHoverExtension = (IAnnotationHoverExtension)((Object)iAnnotationHover)).canHandleMouseCursor())) {
            return this.computeLocation(rectangle, point, ANCHOR_RIGHT);
        }
        return super.computeInformationControlLocation(rectangle, point);
    }

    @Override
    protected Point computeLocation(Rectangle rectangle, Point point, AbstractInformationControlManager.Anchor anchor) {
        IAnnotationHoverExtension2 iAnnotationHoverExtension2;
        MouseEvent mouseEvent = this.getHoverEvent();
        IAnnotationHover iAnnotationHover = this.getHover(mouseEvent);
        boolean bl = false;
        if (iAnnotationHover instanceof IAnnotationHoverExtension) {
            IAnnotationHoverExtension iAnnotationHoverExtension = (IAnnotationHoverExtension)((Object)iAnnotationHover);
            bl = iAnnotationHoverExtension.canHandleMouseCursor();
        }
        boolean bl2 = true;
        if (iAnnotationHover instanceof IAnnotationHoverExtension2) {
            iAnnotationHoverExtension2 = (IAnnotationHoverExtension2)((Object)iAnnotationHover);
            bl2 = !iAnnotationHoverExtension2.canHandleMouseWheel();
        }
        this.fHideOnMouseWheel = bl2;
        if (bl) {
            this.fAllowMouseExit = true;
            iAnnotationHoverExtension2 = this.getSubjectControl();
            if (anchor == AbstractInformationControlManager.ANCHOR_RIGHT) {
                return iAnnotationHoverExtension2.toDisplay(rectangle.x - 4, rectangle.y - 2);
            }
            if (anchor == AbstractInformationControlManager.ANCHOR_LEFT) {
                return iAnnotationHoverExtension2.toDisplay(rectangle.x + rectangle.width - point.x + 4, rectangle.y - 2);
            }
        }
        this.fAllowMouseExit = false;
        return super.computeLocation(rectangle, point, anchor);
    }

    public IAnnotationHover getCurrentAnnotationHover() {
        return this.fCurrentHover;
    }

    @Override
    public InternalAccessor getInternalAccessor() {
        return new InternalAccessor(){

            @Override
            public IInformationControl getCurrentInformationControl() {
                return AnnotationBarHoverManager.super.getInternalAccessor().getCurrentInformationControl();
            }

            @Override
            public void setInformationControlReplacer(InformationControlReplacer informationControlReplacer) {
                AnnotationBarHoverManager.super.getInternalAccessor().setInformationControlReplacer(informationControlReplacer);
            }

            @Override
            public InformationControlReplacer getInformationControlReplacer() {
                return AnnotationBarHoverManager.super.getInternalAccessor().getInformationControlReplacer();
            }

            @Override
            public boolean canReplace(IInformationControl iInformationControl) {
                return AnnotationBarHoverManager.super.getInternalAccessor().canReplace(iInformationControl);
            }

            @Override
            public boolean isReplaceInProgress() {
                return AnnotationBarHoverManager.super.getInternalAccessor().isReplaceInProgress();
            }

            @Override
            public void replaceInformationControl(boolean bl) {
                AnnotationBarHoverManager.super.getInternalAccessor().replaceInformationControl(bl);
            }

            @Override
            public void cropToClosestMonitor(Rectangle rectangle) {
                AnnotationBarHoverManager.super.getInternalAccessor().cropToClosestMonitor(rectangle);
            }

            @Override
            public void setHoverEnrichMode(ITextViewerExtension8.EnrichMode enrichMode) {
                AnnotationBarHoverManager.super.getInternalAccessor().setHoverEnrichMode(enrichMode);
            }

            @Override
            public boolean getAllowMouseExit() {
                return AnnotationBarHoverManager.this.fAllowMouseExit;
            }
        };
    }

    protected class Closer
    extends MouseTrackAdapter
    implements AbstractInformationControlManager.IInformationControlCloser,
    MouseListener,
    MouseMoveListener,
    ControlListener,
    KeyListener,
    DisposeListener,
    ShellListener,
    Listener {
        private Control fSubjectControl;
        private Rectangle fSubjectArea;
        private boolean fIsActive = false;
        private IInformationControl fInformationControlToClose;
        private boolean fHasWheelFilter = false;
        private Display fDisplay;

        @Override
        public void setSubjectControl(Control control) {
            this.fSubjectControl = control;
        }

        @Override
        public void setInformationControl(IInformationControl iInformationControl) {
            this.fInformationControlToClose = iInformationControl;
        }

        @Override
        public void start(Rectangle rectangle) {
            if (this.fIsActive) {
                return;
            }
            this.fIsActive = true;
            this.fSubjectArea = rectangle;
            this.fInformationControlToClose.addDisposeListener(this);
            if (this.fSubjectControl != null && !this.fSubjectControl.isDisposed()) {
                this.fSubjectControl.addMouseListener((MouseListener)this);
                this.fSubjectControl.addMouseMoveListener((MouseMoveListener)this);
                this.fSubjectControl.addMouseTrackListener((MouseTrackListener)this);
                this.fSubjectControl.getShell().addShellListener((ShellListener)this);
                this.fSubjectControl.addControlListener((ControlListener)this);
                this.fSubjectControl.addKeyListener((KeyListener)this);
                this.fDisplay = this.fSubjectControl.getDisplay();
                if (!this.fDisplay.isDisposed() && AnnotationBarHoverManager.this.fHideOnMouseWheel) {
                    this.fHasWheelFilter = true;
                    this.fDisplay.addFilter(38, (Listener)this);
                    this.fDisplay.addFilter(37, (Listener)this);
                }
            }
        }

        @Override
        public void stop() {
            if (!this.fIsActive) {
                return;
            }
            this.fIsActive = false;
            if (this.fSubjectControl != null && !this.fSubjectControl.isDisposed()) {
                this.fSubjectControl.removeMouseListener((MouseListener)this);
                this.fSubjectControl.removeMouseMoveListener((MouseMoveListener)this);
                this.fSubjectControl.removeMouseTrackListener((MouseTrackListener)this);
                this.fSubjectControl.getShell().removeShellListener((ShellListener)this);
                this.fSubjectControl.removeControlListener((ControlListener)this);
                this.fSubjectControl.removeKeyListener((KeyListener)this);
            }
            if (this.fDisplay != null && !this.fDisplay.isDisposed() && this.fHasWheelFilter) {
                this.fDisplay.removeFilter(38, (Listener)this);
                this.fDisplay.removeFilter(37, (Listener)this);
            }
            this.fHasWheelFilter = false;
            this.fDisplay = null;
        }

        protected void stop(boolean bl) {
            this.stop();
        }

        public void mouseMove(MouseEvent mouseEvent) {
            if (!this.fSubjectArea.contains(mouseEvent.x, mouseEvent.y)) {
                AnnotationBarHoverManager.this.hideInformationControl();
            }
        }

        public void mouseUp(MouseEvent mouseEvent) {
        }

        public void mouseDown(MouseEvent mouseEvent) {
            AnnotationBarHoverManager.this.hideInformationControl();
        }

        public void mouseDoubleClick(MouseEvent mouseEvent) {
            AnnotationBarHoverManager.this.hideInformationControl();
        }

        public void handleEvent(Event event) {
            if (event.type == 38 || event.type == 37) {
                AnnotationBarHoverManager.this.hideInformationControl();
            }
        }

        public void mouseExit(MouseEvent mouseEvent) {
            if (!AnnotationBarHoverManager.this.fAllowMouseExit) {
                AnnotationBarHoverManager.this.hideInformationControl();
            }
        }

        public void controlResized(ControlEvent controlEvent) {
            AnnotationBarHoverManager.this.hideInformationControl();
        }

        public void controlMoved(ControlEvent controlEvent) {
            AnnotationBarHoverManager.this.hideInformationControl();
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void keyPressed(KeyEvent keyEvent) {
            AnnotationBarHoverManager.this.hideInformationControl();
        }

        public void shellActivated(ShellEvent shellEvent) {
        }

        public void shellClosed(ShellEvent shellEvent) {
        }

        public void shellDeactivated(ShellEvent shellEvent) {
            AnnotationBarHoverManager.this.hideInformationControl();
        }

        public void shellDeiconified(ShellEvent shellEvent) {
        }

        public void shellIconified(ShellEvent shellEvent) {
        }

        public void widgetDisposed(DisposeEvent disposeEvent) {
            AnnotationBarHoverManager.this.hideInformationControl();
        }
    }
}

