/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.source;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.IViewportListener;
import org.eclipse.jface.text.JFaceTextUtil;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ILineRange;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.jface.text.source.IVerticalRulerInfoExtension;
import org.eclipse.jface.text.source.IVerticalRulerListener;
import org.eclipse.jface.text.source.LineRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public abstract class AbstractRulerColumn
implements IVerticalRulerColumn,
IVerticalRulerInfo,
IVerticalRulerInfoExtension {
    private static final int DEFAULT_WIDTH = 12;
    private static final int DEFAULT_TEXT_INSET = 2;
    private final InternalListener fInternalListener = new InternalListener();
    private final MouseHandler fMouseHandler = new MouseHandler();
    private CompositeRuler fParentRuler;
    private Canvas fCanvas;
    private ITextViewer fTextViewer;
    private StyledText fStyledText;
    private int fLastTopPixel = -1;
    private boolean fWasShowingEntireContents = false;
    private int fWidth = 12;
    private int fTextInset = 2;
    private Color fBackground;
    private Font fFont;
    private IAnnotationModel fModel;
    private IAnnotationHover fHover;

    protected AbstractRulerColumn() {
    }

    @Override
    public Control createControl(CompositeRuler compositeRuler, Composite composite) {
        Assert.isLegal((composite != null ? 1 : 0) != 0);
        Assert.isLegal((compositeRuler != null ? 1 : 0) != 0);
        Assert.isLegal((this.fParentRuler == null ? 1 : 0) != 0);
        this.fParentRuler = compositeRuler;
        this.fTextViewer = this.getParentRuler().getTextViewer();
        this.fTextViewer.addViewportListener(this.fInternalListener);
        this.fTextViewer.addTextListener(this.fInternalListener);
        this.fStyledText = this.fTextViewer.getTextWidget();
        this.fCanvas = new Canvas(composite, this.getCanvasStyle());
        this.fCanvas.setBackground(this.getDefaultBackground());
        this.fCanvas.setFont(this.getFont());
        this.fCanvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                AbstractRulerColumn.this.paintControl(paintEvent);
            }
        });
        this.fCanvas.addMouseListener((MouseListener)this.fMouseHandler);
        this.fCanvas.addMouseMoveListener((MouseMoveListener)this.fMouseHandler);
        return this.fCanvas;
    }

    protected int getCanvasStyle() {
        return 262144;
    }

    @Override
    public final Control getControl() {
        return this.fCanvas;
    }

    protected final void setWidth(int n) {
        Assert.isLegal((n >= 0 ? 1 : 0) != 0);
        if (this.fWidth != n) {
            this.fWidth = n;
            CompositeRuler compositeRuler = this.getParentRuler();
            if (compositeRuler != null) {
                compositeRuler.relayout();
            }
        }
    }

    @Override
    public final int getWidth() {
        return this.fWidth;
    }

    protected final CompositeRuler getParentRuler() {
        return this.fParentRuler;
    }

    @Override
    public final void setFont(Font font) {
        if (this.fFont != font) {
            this.fFont = font;
            this.redraw();
        }
    }

    protected final Font getFont() {
        if (this.fFont != null) {
            return this.fFont;
        }
        if (this.fStyledText != null && !this.fStyledText.isDisposed()) {
            return this.fStyledText.getFont();
        }
        return JFaceResources.getTextFont();
    }

    protected final void setTextInset(int n) {
        if (n != this.fTextInset) {
            this.fTextInset = n;
            this.redraw();
        }
    }

    protected final int getTextInset() {
        return this.fTextInset;
    }

    @Override
    public void setModel(IAnnotationModel iAnnotationModel) {
        if (this.fModel != iAnnotationModel) {
            this.fModel = iAnnotationModel;
            this.redraw();
        }
    }

    @Override
    public final IAnnotationModel getModel() {
        return this.fModel;
    }

    protected final void setDefaultBackground(Color color) {
        if (this.fBackground != color) {
            this.fBackground = color;
            if (this.fCanvas != null && !this.fCanvas.isDisposed()) {
                this.fCanvas.setBackground(this.getDefaultBackground());
            }
            this.redraw();
        }
    }

    protected final Color getDefaultBackground() {
        if (this.fBackground != null) {
            return this.fBackground;
        }
        if (this.fStyledText != null && !this.fStyledText.isDisposed()) {
            return this.fStyledText.getBackground();
        }
        Display display = this.fCanvas != null && !this.fCanvas.isDisposed() ? this.fCanvas.getDisplay() : Display.getCurrent();
        if (display != null) {
            return display.getSystemColor(25);
        }
        return null;
    }

    protected final void setHover(IAnnotationHover iAnnotationHover) {
        if (this.fHover != iAnnotationHover) {
            this.fHover = iAnnotationHover;
        }
    }

    @Override
    public IAnnotationHover getHover() {
        return this.fHover;
    }

    public void dispose() {
        if (this.fTextViewer != null) {
            this.fTextViewer.removeViewportListener(this.fInternalListener);
            this.fTextViewer.removeTextListener(this.fInternalListener);
            this.fTextViewer = null;
        }
        if (this.fStyledText != null) {
            this.fStyledText = null;
        }
        if (this.fCanvas != null) {
            this.fCanvas.dispose();
            this.fCanvas = null;
        }
    }

    @Override
    public final void redraw() {
        if (this.fCanvas != null && !this.fCanvas.isDisposed()) {
            this.fCanvas.redraw();
        }
    }

    protected final void redraw(ILineRange iLineRange) {
        if (this.fCanvas == null || this.fCanvas.isDisposed()) {
            return;
        }
        int n = iLineRange.getStartLine();
        int n2 = n + iLineRange.getNumberOfLines();
        int n3 = JFaceTextUtil.modelLineToWidgetLine(this.fTextViewer, n);
        int n4 = JFaceTextUtil.modelLineToWidgetLine(this.fTextViewer, n2);
        int n5 = Math.max(0, this.fStyledText.getLinePixel(n3));
        int n6 = Math.min(this.fCanvas.getSize().y, this.fStyledText.getLinePixel(n4 + 1));
        this.fCanvas.redraw(0, n5, this.fWidth, n6 - n5, false);
    }

    private void paintControl(PaintEvent paintEvent) {
        int n;
        int n2;
        if (this.fTextViewer == null) {
            return;
        }
        this.fWasShowingEntireContents = JFaceTextUtil.isShowingEntireContents(this.fStyledText);
        this.fLastTopPixel = this.fStyledText.getTopPixel();
        ILineRange iLineRange = this.computeDirtyWidgetLines(paintEvent);
        GC gC = paintEvent.gc;
        this.paint(gC, iLineRange);
        if ((this.fCanvas.getStyle() & 0x40000) != 0 && (n2 = paintEvent.y + paintEvent.height) > (n = Math.max(paintEvent.y, this.fStyledText.getLinePixel(this.fStyledText.getLineCount())))) {
            gC.setBackground(this.getDefaultBackground());
            gC.fillRectangle(0, n, this.getWidth(), n2 - n);
        }
    }

    private ILineRange computeDirtyWidgetLines(PaintEvent paintEvent) {
        int n = this.fStyledText.getLineIndex(paintEvent.y);
        int n2 = this.fStyledText.getLineIndex(paintEvent.y + paintEvent.height - 1);
        return new LineRange(n, n2 - n + 1);
    }

    protected void paint(GC gC, ILineRange iLineRange) {
        int n = iLineRange.getStartLine();
        int n2 = n + iLineRange.getNumberOfLines();
        int n3 = n;
        while (n3 < n2) {
            int n4 = JFaceTextUtil.widgetLine2ModelLine(this.fTextViewer, n3);
            if (n4 != -1) {
                int n5 = this.fStyledText.getLinePixel(n3);
                int n6 = this.fStyledText.getLineHeight(this.fStyledText.getOffsetAtLine(n3));
                this.paintLine(gC, n4, n3, n5, n6);
            }
            ++n3;
        }
    }

    protected void paintLine(GC gC, int n, int n2, int n3, int n4) {
        gC.setBackground(this.computeBackground(n));
        gC.fillRectangle(0, n3, this.getWidth(), n4);
        String string = this.computeText(n);
        if (string != null) {
            gC.setForeground(this.computeForeground(n));
            gC.drawString(string, this.getTextInset(), n3, true);
        }
    }

    protected String computeText(int n) {
        return null;
    }

    protected Color computeBackground(int n) {
        return this.getDefaultBackground();
    }

    protected Color computeForeground(int n) {
        return this.fStyledText.getDisplay().getSystemColor(16);
    }

    @Override
    public final int getLineOfLastMouseButtonActivity() {
        return this.getParentRuler().getLineOfLastMouseButtonActivity();
    }

    @Override
    public final int toDocumentLineNumber(int n) {
        return this.getParentRuler().toDocumentLineNumber(n);
    }

    @Override
    public void addVerticalRulerListener(IVerticalRulerListener iVerticalRulerListener) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeVerticalRulerListener(IVerticalRulerListener iVerticalRulerListener) {
        throw new UnsupportedOperationException();
    }

    private boolean scrollVertical(int n) {
        if (n == 0 || this.fCanvas == null || this.fCanvas.isDisposed()) {
            return false;
        }
        int n2 = this.getWidth();
        int n3 = this.fStyledText.getClientArea().height;
        if (n > 0) {
            int n4 = 0 + n;
            int n5 = n3 - n4 - 0;
            if (n5 > 0) {
                this.fCanvas.scroll(0, 0, 0, n4, n2, n5, true);
            }
            if (n4 > n5) {
                int n6 = Math.max(0, 0 + n5);
                int n7 = Math.min(n3, n - n5);
                this.fCanvas.redraw(0, n6, n2, n7, true);
            }
        } else {
            int n8 = 0 - n;
            int n9 = n3 - n8 - 0;
            if (n9 > 0) {
                this.fCanvas.scroll(0, n8, 0, 0, n2, n9, true);
            }
            if (n8 > n9) {
                int n10 = Math.max(0, 0 + n9);
                int n11 = Math.min(n3, -n - n9);
                this.fCanvas.redraw(0, n10, n2, n11, true);
            }
        }
        return true;
    }

    private final class InternalListener
    implements IViewportListener,
    ITextListener {
        private InternalListener() {
        }

        @Override
        public void viewportChanged(int n) {
            int n2 = n - AbstractRulerColumn.this.fLastTopPixel;
            if (AbstractRulerColumn.this.scrollVertical(n2)) {
                AbstractRulerColumn.this.fCanvas.update();
            }
        }

        @Override
        public void textChanged(TextEvent textEvent) {
            if (!textEvent.getViewerRedrawState()) {
                return;
            }
            if (AbstractRulerColumn.this.fWasShowingEntireContents || textEvent.getDocumentEvent() == null || JFaceTextUtil.isShowingEntireContents(AbstractRulerColumn.this.fStyledText)) {
                AbstractRulerColumn.this.redraw();
            }
        }
    }

    private final class MouseHandler
    implements MouseListener,
    MouseMoveListener {
        private MouseHandler() {
        }

        public void mouseUp(MouseEvent mouseEvent) {
        }

        public void mouseDown(MouseEvent mouseEvent) {
            AbstractRulerColumn.this.fParentRuler.setLocationOfLastMouseButtonActivity(mouseEvent.x, mouseEvent.y);
        }

        public void mouseDoubleClick(MouseEvent mouseEvent) {
            AbstractRulerColumn.this.fParentRuler.setLocationOfLastMouseButtonActivity(mouseEvent.x, mouseEvent.y);
        }

        public void mouseMove(MouseEvent mouseEvent) {
            AbstractRulerColumn.this.fParentRuler.setLocationOfLastMouseButtonActivity(mouseEvent.x, mouseEvent.y);
        }
    }
}

