/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.rules;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.Token;

public class WordRule
implements IRule {
    protected static final int UNDEFINED = -1;
    protected IWordDetector fDetector;
    protected IToken fDefaultToken;
    protected int fColumn = -1;
    protected Map fWords = new HashMap();
    private StringBuffer fBuffer = new StringBuffer();
    private boolean fIgnoreCase = false;

    public WordRule(IWordDetector iWordDetector) {
        this(iWordDetector, Token.UNDEFINED, false);
    }

    public WordRule(IWordDetector iWordDetector, IToken iToken) {
        this(iWordDetector, iToken, false);
    }

    public WordRule(IWordDetector iWordDetector, IToken iToken, boolean bl) {
        Assert.isNotNull((Object)iWordDetector);
        Assert.isNotNull((Object)iToken);
        this.fDetector = iWordDetector;
        this.fDefaultToken = iToken;
        this.fIgnoreCase = bl;
    }

    public void addWord(String string, IToken iToken) {
        Assert.isNotNull((Object)string);
        Assert.isNotNull((Object)iToken);
        if (this.fIgnoreCase) {
            string = string.toLowerCase();
        }
        this.fWords.put(string, iToken);
    }

    public void setColumnConstraint(int n) {
        if (n < 0) {
            n = -1;
        }
        this.fColumn = n;
    }

    @Override
    public IToken evaluate(ICharacterScanner iCharacterScanner) {
        int n = iCharacterScanner.read();
        if (n != -1 && this.fDetector.isWordStart((char)n) && (this.fColumn == -1 || this.fColumn == iCharacterScanner.getColumn() - 1)) {
            IToken iToken;
            this.fBuffer.setLength(0);
            do {
                this.fBuffer.append((char)n);
            } while ((n = iCharacterScanner.read()) != -1 && this.fDetector.isWordPart((char)n));
            iCharacterScanner.unread();
            String string = this.fBuffer.toString();
            if (this.fIgnoreCase) {
                string = string.toLowerCase();
            }
            if ((iToken = (IToken)this.fWords.get(string)) != null) {
                return iToken;
            }
            if (this.fDefaultToken.isUndefined()) {
                this.unreadBuffer(iCharacterScanner);
            }
            return this.fDefaultToken;
        }
        iCharacterScanner.unread();
        return Token.UNDEFINED;
    }

    protected void unreadBuffer(ICharacterScanner iCharacterScanner) {
        int n = this.fBuffer.length() - 1;
        while (n >= 0) {
            iCharacterScanner.unread();
            --n;
        }
    }
}

