/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.rules;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.SingleLineRule;

public class WordPatternRule
extends SingleLineRule {
    protected IWordDetector fDetector;
    private StringBuffer fBuffer = new StringBuffer();

    public WordPatternRule(IWordDetector iWordDetector, String string, String string2, IToken iToken) {
        this(iWordDetector, string, string2, iToken, '\u0000');
    }

    public WordPatternRule(IWordDetector iWordDetector, String string, String string2, IToken iToken, char c) {
        super(string, string2, iToken, c);
        Assert.isNotNull((Object)iWordDetector);
        this.fDetector = iWordDetector;
    }

    @Override
    protected boolean endSequenceDetected(ICharacterScanner iCharacterScanner) {
        this.fBuffer.setLength(0);
        int n = iCharacterScanner.read();
        while (this.fDetector.isWordPart((char)n)) {
            this.fBuffer.append((char)n);
            n = iCharacterScanner.read();
        }
        iCharacterScanner.unread();
        if (this.fBuffer.length() >= this.fEndSequence.length) {
            int n2 = this.fEndSequence.length - 1;
            int n3 = this.fBuffer.length() - 1;
            while (n2 >= 0) {
                if (this.fEndSequence[n2] != this.fBuffer.charAt(n3)) {
                    this.unreadBuffer(iCharacterScanner);
                    return false;
                }
                --n2;
                --n3;
            }
            return true;
        }
        this.unreadBuffer(iCharacterScanner);
        return false;
    }

    protected void unreadBuffer(ICharacterScanner iCharacterScanner) {
        this.fBuffer.insert(0, this.fStartSequence);
        int n = this.fBuffer.length() - 1;
        while (n > 0) {
            iCharacterScanner.unread();
            --n;
        }
    }
}

