/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.rules;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.Token;

public class WhitespaceRule
implements IRule {
    protected IWhitespaceDetector fDetector;
    protected final IToken fWhitespaceToken;

    public WhitespaceRule(IWhitespaceDetector iWhitespaceDetector) {
        this(iWhitespaceDetector, Token.WHITESPACE);
    }

    public WhitespaceRule(IWhitespaceDetector iWhitespaceDetector, IToken iToken) {
        Assert.isNotNull((Object)iWhitespaceDetector);
        Assert.isNotNull((Object)iToken);
        this.fDetector = iWhitespaceDetector;
        this.fWhitespaceToken = iToken;
    }

    @Override
    public IToken evaluate(ICharacterScanner iCharacterScanner) {
        int n = iCharacterScanner.read();
        if (this.fDetector.isWhitespace((char)n)) {
            while (this.fDetector.isWhitespace((char)(n = iCharacterScanner.read()))) {
            }
            iCharacterScanner.unread();
            return this.fWhitespaceToken;
        }
        iCharacterScanner.unread();
        return Token.UNDEFINED;
    }
}

