/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.rules;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.Token;

public class RuleBasedScanner
implements ICharacterScanner,
ITokenScanner {
    protected IRule[] fRules;
    protected IToken fDefaultReturnToken;
    protected IDocument fDocument;
    protected char[][] fDelimiters;
    protected int fOffset;
    protected int fRangeEnd;
    protected int fTokenOffset;
    protected int fColumn;
    protected static final int UNDEFINED = -1;

    public void setRules(IRule[] iRuleArray) {
        if (iRuleArray != null) {
            this.fRules = new IRule[iRuleArray.length];
            System.arraycopy(iRuleArray, 0, this.fRules, 0, iRuleArray.length);
        } else {
            this.fRules = null;
        }
    }

    public void setDefaultReturnToken(IToken iToken) {
        Assert.isNotNull((Object)iToken.getData());
        this.fDefaultReturnToken = iToken;
    }

    @Override
    public void setRange(IDocument iDocument, int n, int n2) {
        Assert.isLegal((iDocument != null ? 1 : 0) != 0);
        int n3 = iDocument.getLength();
        this.checkRange(n, n2, n3);
        this.fDocument = iDocument;
        this.fOffset = n;
        this.fColumn = -1;
        this.fRangeEnd = n + n2;
        String[] stringArray = this.fDocument.getLegalLineDelimiters();
        this.fDelimiters = new char[stringArray.length][];
        int n4 = 0;
        while (n4 < stringArray.length) {
            this.fDelimiters[n4] = stringArray[n4].toCharArray();
            ++n4;
        }
        if (this.fDefaultReturnToken == null) {
            this.fDefaultReturnToken = new Token(null);
        }
    }

    private void checkRange(int n, int n2, int n3) {
        Assert.isLegal((n > -1 ? 1 : 0) != 0);
        Assert.isLegal((n2 > -1 ? 1 : 0) != 0);
        Assert.isLegal((n + n2 <= n3 ? 1 : 0) != 0);
    }

    @Override
    public int getTokenOffset() {
        return this.fTokenOffset;
    }

    @Override
    public int getTokenLength() {
        if (this.fOffset < this.fRangeEnd) {
            return this.fOffset - this.getTokenOffset();
        }
        return this.fRangeEnd - this.getTokenOffset();
    }

    @Override
    public int getColumn() {
        if (this.fColumn == -1) {
            try {
                int n = this.fDocument.getLineOfOffset(this.fOffset);
                int n2 = this.fDocument.getLineOffset(n);
                this.fColumn = this.fOffset - n2;
            }
            catch (BadLocationException badLocationException) {}
        }
        return this.fColumn;
    }

    @Override
    public char[][] getLegalLineDelimiters() {
        return this.fDelimiters;
    }

    @Override
    public IToken nextToken() {
        this.fTokenOffset = this.fOffset;
        this.fColumn = -1;
        if (this.fRules != null) {
            int n = 0;
            while (n < this.fRules.length) {
                IToken iToken = this.fRules[n].evaluate(this);
                if (!iToken.isUndefined()) {
                    return iToken;
                }
                ++n;
            }
        }
        if (this.read() == -1) {
            return Token.EOF;
        }
        return this.fDefaultReturnToken;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public int read() {
        try {
            if (this.fOffset < this.fRangeEnd) {
                try {
                    var2_1 = this.fDocument.getChar(this.fOffset);
                    return var2_1;
                }
                catch (BadLocationException v0) {
                    ** try [egrp 2[TRYBLOCK] [2 : 42->43)] { 
                }
            }
lbl8:
            // 3 sources

            return -1;
lbl-1000:
            // 1 sources

            {
                catch (Throwable var1_2) {
                    throw var1_2;
                }
            }
        }
        finally {
            ++this.fOffset;
            this.fColumn = -1;
        }
    }

    @Override
    public void unread() {
        --this.fOffset;
        this.fColumn = -1;
    }
}

