/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.rules;

import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DefaultPositionUpdater;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IDocumentPartitionerExtension;
import org.eclipse.jface.text.IDocumentPartitionerExtension2;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.TypedPosition;
import org.eclipse.jface.text.TypedRegion;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.RuleBasedScanner;

public class RuleBasedPartitioner
implements IDocumentPartitioner,
IDocumentPartitionerExtension,
IDocumentPartitionerExtension2 {
    public static final String CONTENT_TYPES_CATEGORY = "__content_types_category";
    protected RuleBasedScanner fScanner;
    protected String[] fLegalContentTypes;
    protected IDocument fDocument;
    protected int fPreviousDocumentLength;
    protected DefaultPositionUpdater fPositionUpdater;
    protected int fStartOffset;
    protected int fEndOffset;
    protected int fDeleteOffset;
    private String fPositionCategory;

    public RuleBasedPartitioner(RuleBasedScanner ruleBasedScanner, String[] stringArray) {
        this.fScanner = ruleBasedScanner;
        this.fLegalContentTypes = TextUtilities.copy((String[])stringArray);
        this.fPositionCategory = CONTENT_TYPES_CATEGORY + this.hashCode();
        this.fPositionUpdater = new DefaultPositionUpdater(this.fPositionCategory);
    }

    public String[] getManagingPositionCategories() {
        return new String[]{this.fPositionCategory};
    }

    public void connect(IDocument iDocument) {
        Assert.isNotNull((Object)iDocument);
        Assert.isTrue((!iDocument.containsPositionCategory(this.fPositionCategory) ? 1 : 0) != 0);
        this.fDocument = iDocument;
        this.fDocument.addPositionCategory(this.fPositionCategory);
        this.initialize();
    }

    protected void initialize() {
        this.fScanner.setRange(this.fDocument, 0, this.fDocument.getLength());
        try {
            IToken iToken = this.fScanner.nextToken();
            while (!iToken.isEOF()) {
                String string = this.getTokenContentType(iToken);
                if (this.isSupportedContentType(string)) {
                    TypedPosition typedPosition = new TypedPosition(this.fScanner.getTokenOffset(), this.fScanner.getTokenLength(), string);
                    this.fDocument.addPosition(this.fPositionCategory, (Position)typedPosition);
                }
                iToken = this.fScanner.nextToken();
            }
        }
        catch (BadLocationException badLocationException) {
        }
        catch (BadPositionCategoryException badPositionCategoryException) {}
    }

    public void disconnect() {
        Assert.isTrue((boolean)this.fDocument.containsPositionCategory(this.fPositionCategory));
        try {
            this.fDocument.removePositionCategory(this.fPositionCategory);
        }
        catch (BadPositionCategoryException badPositionCategoryException) {}
    }

    public void documentAboutToBeChanged(DocumentEvent documentEvent) {
        Assert.isTrue((documentEvent.getDocument() == this.fDocument ? 1 : 0) != 0);
        this.fPreviousDocumentLength = documentEvent.getDocument().getLength();
        this.fStartOffset = -1;
        this.fEndOffset = -1;
        this.fDeleteOffset = -1;
    }

    public boolean documentChanged(DocumentEvent documentEvent) {
        IRegion iRegion = this.documentChanged2(documentEvent);
        return iRegion != null;
    }

    private void rememberRegion(int n, int n2) {
        if (this.fStartOffset == -1) {
            this.fStartOffset = n;
        } else if (n < this.fStartOffset) {
            this.fStartOffset = n;
        }
        int n3 = n + n2;
        if (this.fEndOffset == -1) {
            this.fEndOffset = n3;
        } else if (n3 > this.fEndOffset) {
            this.fEndOffset = n3;
        }
    }

    private void rememberDeletedOffset(int n) {
        this.fDeleteOffset = n;
    }

    private IRegion createRegion() {
        if (this.fDeleteOffset == -1) {
            if (this.fStartOffset == -1 || this.fEndOffset == -1) {
                return null;
            }
            return new Region(this.fStartOffset, this.fEndOffset - this.fStartOffset);
        }
        if (this.fStartOffset == -1 || this.fEndOffset == -1) {
            return new Region(this.fDeleteOffset, 0);
        }
        int n = Math.min(this.fDeleteOffset, this.fStartOffset);
        int n2 = Math.max(this.fDeleteOffset, this.fEndOffset);
        return new Region(n, n2 - n);
    }

    public IRegion documentChanged2(DocumentEvent documentEvent) {
        try {
            String string;
            IDocument iDocument = documentEvent.getDocument();
            Position[] positionArray = iDocument.getPositions(this.fPositionCategory);
            int n = 0;
            int n2 = 0;
            int n3 = positionArray.length;
            if (n3 > 0) {
                n = iDocument.computeIndexInCategory(this.fPositionCategory, documentEvent.getOffset());
                Position position = null;
                while (--n >= 0 && ((position = positionArray[n]).overlapsWith(documentEvent.getOffset(), documentEvent.getLength()) || documentEvent.getOffset() == this.fPreviousDocumentLength && position.getOffset() + position.getLength() == this.fPreviousDocumentLength)) {
                }
                this.fPositionUpdater.update(documentEvent);
                int n4 = 0;
                while (n4 < positionArray.length) {
                    position = positionArray[n4];
                    if (position.isDeleted) {
                        this.rememberDeletedOffset(documentEvent.getOffset());
                        break;
                    }
                    ++n4;
                }
                positionArray = iDocument.getPositions(this.fPositionCategory);
                if (n >= 0) {
                    position = positionArray[n];
                    n2 = position.getOffset() + position.getLength();
                }
                ++n;
            }
            this.fScanner.setRange(iDocument, n2, iDocument.getLength() - n2);
            int n5 = n2;
            IToken iToken = this.fScanner.nextToken();
            while (!iToken.isEOF()) {
                string = this.getTokenContentType(iToken);
                if (!this.isSupportedContentType(string)) {
                    iToken = this.fScanner.nextToken();
                    continue;
                }
                int n6 = this.fScanner.getTokenOffset();
                int n7 = this.fScanner.getTokenLength();
                n5 = n6 + n7 - 1;
                while (n < positionArray.length) {
                    TypedPosition typedPosition = (TypedPosition)positionArray[n];
                    if (n5 < typedPosition.offset + typedPosition.length && (!typedPosition.overlapsWith(n6, n7) || iDocument.containsPosition(this.fPositionCategory, n6, n7) && string.equals(typedPosition.getType()))) break;
                    this.rememberRegion(typedPosition.offset, typedPosition.length);
                    iDocument.removePosition(this.fPositionCategory, (Position)typedPosition);
                    ++n;
                }
                if (iDocument.containsPosition(this.fPositionCategory, n6, n7)) {
                    return this.createRegion();
                }
                try {
                    iDocument.addPosition(this.fPositionCategory, (Position)new TypedPosition(n6, n7, string));
                    this.rememberRegion(n6, n7);
                }
                catch (BadPositionCategoryException badPositionCategoryException) {
                }
                catch (BadLocationException badLocationException) {}
                iToken = this.fScanner.nextToken();
            }
            if (n5 != n2) {
                ++n5;
            }
            n = iDocument.computeIndexInCategory(this.fPositionCategory, n5);
            while (n < positionArray.length) {
                string = (TypedPosition)positionArray[n++];
                iDocument.removePosition(this.fPositionCategory, (Position)string);
                this.rememberRegion(((TypedPosition)string).offset, ((TypedPosition)string).length);
            }
        }
        catch (BadPositionCategoryException badPositionCategoryException) {
        }
        catch (BadLocationException badLocationException) {}
        return this.createRegion();
    }

    protected TypedPosition findClosestPosition(int n) {
        Position[] positionArray;
        int n2;
        block6: {
            n2 = this.fDocument.computeIndexInCategory(this.fPositionCategory, n);
            positionArray = this.fDocument.getPositions(this.fPositionCategory);
            if (positionArray.length != 0) break block6;
            return null;
        }
        try {
            if (n2 < positionArray.length && n == positionArray[n2].offset) {
                return (TypedPosition)positionArray[n2];
            }
            if (n2 > 0) {
                --n2;
            }
            return (TypedPosition)positionArray[n2];
        }
        catch (BadPositionCategoryException badPositionCategoryException) {
        }
        catch (BadLocationException badLocationException) {}
        return null;
    }

    public String getContentType(int n) {
        TypedPosition typedPosition = this.findClosestPosition(n);
        if (typedPosition != null && typedPosition.includes(n)) {
            return typedPosition.getType();
        }
        return "__dftl_partition_content_type";
    }

    public ITypedRegion getPartition(int n) {
        try {
            Position[] positionArray = this.fDocument.getPositions(this.fPositionCategory);
            if (positionArray == null || positionArray.length == 0) {
                return new TypedRegion(0, this.fDocument.getLength(), "__dftl_partition_content_type");
            }
            int n2 = this.fDocument.computeIndexInCategory(this.fPositionCategory, n);
            if (n2 < positionArray.length) {
                TypedPosition typedPosition = (TypedPosition)positionArray[n2];
                if (n == typedPosition.offset) {
                    return new TypedRegion(typedPosition.getOffset(), typedPosition.getLength(), typedPosition.getType());
                }
                if (n2 == 0) {
                    return new TypedRegion(0, typedPosition.offset, "__dftl_partition_content_type");
                }
                TypedPosition typedPosition2 = (TypedPosition)positionArray[n2 - 1];
                if (typedPosition2.includes(n)) {
                    return new TypedRegion(typedPosition2.getOffset(), typedPosition2.getLength(), typedPosition2.getType());
                }
                int n3 = typedPosition2.getOffset() + typedPosition2.getLength();
                return new TypedRegion(n3, typedPosition.getOffset() - n3, "__dftl_partition_content_type");
            }
            TypedPosition typedPosition = (TypedPosition)positionArray[positionArray.length - 1];
            if (typedPosition.includes(n)) {
                return new TypedRegion(typedPosition.getOffset(), typedPosition.getLength(), typedPosition.getType());
            }
            int n4 = typedPosition.getOffset() + typedPosition.getLength();
            return new TypedRegion(n4, this.fDocument.getLength() - n4, "__dftl_partition_content_type");
        }
        catch (BadPositionCategoryException badPositionCategoryException) {
        }
        catch (BadLocationException badLocationException) {}
        return new TypedRegion(0, this.fDocument.getLength(), "__dftl_partition_content_type");
    }

    public ITypedRegion[] computePartitioning(int n, int n2) {
        return this.computePartitioning(n, n2, false);
    }

    public String[] getLegalContentTypes() {
        return TextUtilities.copy((String[])this.fLegalContentTypes);
    }

    protected boolean isSupportedContentType(String string) {
        if (string != null) {
            int n = 0;
            while (n < this.fLegalContentTypes.length) {
                if (this.fLegalContentTypes[n].equals(string)) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    protected String getTokenContentType(IToken iToken) {
        Object object = iToken.getData();
        if (object instanceof String) {
            return (String)object;
        }
        return null;
    }

    public String getContentType(int n, boolean bl) {
        return this.getPartition(n, bl).getType();
    }

    public ITypedRegion getPartition(int n, boolean bl) {
        ITypedRegion iTypedRegion = this.getPartition(n);
        if (bl && iTypedRegion.getOffset() == n && !iTypedRegion.getType().equals("__dftl_partition_content_type")) {
            if (n > 0 && (iTypedRegion = this.getPartition(n - 1)).getType().equals("__dftl_partition_content_type")) {
                return iTypedRegion;
            }
            return new TypedRegion(n, 0, "__dftl_partition_content_type");
        }
        return iTypedRegion;
    }

    public ITypedRegion[] computePartitioning(int n, int n2, boolean bl) {
        ArrayList<TypedRegion> arrayList = new ArrayList<TypedRegion>();
        try {
            int n3;
            int n4;
            int n5;
            int n6 = n + n2;
            Position[] positionArray = this.fDocument.getPositions(this.fPositionCategory);
            TypedPosition typedPosition = null;
            TypedPosition typedPosition2 = null;
            Position position = null;
            int n7 = 0;
            while (n7 < positionArray.length) {
                typedPosition2 = (TypedPosition)positionArray[n7];
                n5 = typedPosition != null ? typedPosition.getOffset() + typedPosition.getLength() : 0;
                position = new Position(n5, typedPosition2.getOffset() - n5);
                if ((bl || position.getLength() > 0) && position.overlapsWith(n, n2)) {
                    n4 = Math.max(n, n5);
                    n3 = Math.min(n6, position.getOffset() + position.getLength());
                    arrayList.add(new TypedRegion(n4, n3 - n4, "__dftl_partition_content_type"));
                }
                if (typedPosition2.overlapsWith(n, n2)) {
                    n4 = Math.max(n, typedPosition2.getOffset());
                    n3 = Math.min(n6, typedPosition2.getOffset() + typedPosition2.getLength());
                    arrayList.add(new TypedRegion(n4, n3 - n4, typedPosition2.getType()));
                }
                typedPosition = typedPosition2;
                ++n7;
            }
            if (typedPosition != null) {
                n5 = typedPosition.getOffset() + typedPosition.getLength();
                position = new Position(n5, this.fDocument.getLength() - n5);
                if ((bl || position.getLength() > 0) && (bl && n + n2 == n5 && position.length == 0 || position.overlapsWith(n, n2))) {
                    n4 = Math.max(n, n5);
                    n3 = Math.min(n6, this.fDocument.getLength());
                    arrayList.add(new TypedRegion(n4, n3 - n4, "__dftl_partition_content_type"));
                }
            }
            if (arrayList.isEmpty()) {
                arrayList.add(new TypedRegion(n, n2, "__dftl_partition_content_type"));
            }
        }
        catch (BadPositionCategoryException badPositionCategoryException) {}
        TypedRegion[] typedRegionArray = new TypedRegion[arrayList.size()];
        arrayList.toArray(typedRegionArray);
        return typedRegionArray;
    }
}

