/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.rules;

import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.rules.BufferedRuleBasedScanner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;

public class RuleBasedPartitionScanner
extends BufferedRuleBasedScanner
implements IPartitionTokenScanner {
    protected String fContentType;
    protected int fPartitionOffset;

    @Override
    public void setRules(IRule[] iRuleArray) {
        throw new UnsupportedOperationException();
    }

    public void setPredicateRules(IPredicateRule[] iPredicateRuleArray) {
        super.setRules(iPredicateRuleArray);
    }

    @Override
    public void setRange(IDocument iDocument, int n, int n2) {
        this.setPartialRange(iDocument, n, n2, null, -1);
    }

    @Override
    public void setPartialRange(IDocument iDocument, int n, int n2, String string, int n3) {
        int n4;
        this.fContentType = string;
        this.fPartitionOffset = n3;
        if (n3 > -1 && (n4 = n - n3) > 0) {
            super.setRange(iDocument, n3, n2 + n4);
            this.fOffset = n;
            return;
        }
        super.setRange(iDocument, n, n2);
    }

    @Override
    public IToken nextToken() {
        if (this.fContentType == null || this.fRules == null) {
            return super.nextToken();
        }
        this.fColumn = -1;
        boolean bl = this.fPartitionOffset > -1 && this.fPartitionOffset < this.fOffset;
        this.fTokenOffset = bl ? this.fPartitionOffset : this.fOffset;
        int n = 0;
        while (n < this.fRules.length) {
            IPredicateRule iPredicateRule = (IPredicateRule)this.fRules[n];
            IToken iToken = iPredicateRule.getSuccessToken();
            if (this.fContentType.equals(iToken.getData()) && !(iToken = iPredicateRule.evaluate(this, bl)).isUndefined()) {
                this.fContentType = null;
                return iToken;
            }
            ++n;
        }
        this.fContentType = null;
        if (bl) {
            this.fOffset = this.fPartitionOffset;
        }
        return super.nextToken();
    }
}

