/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.rules;

import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public class PatternRule
implements IPredicateRule {
    protected static final int UNDEFINED = -1;
    protected IToken fToken;
    protected char[] fStartSequence;
    protected char[] fEndSequence;
    protected int fColumn = -1;
    protected char fEscapeCharacter;
    protected boolean fEscapeContinuesLine;
    protected boolean fBreaksOnEOL;
    protected boolean fBreaksOnEOF;
    private Comparator fLineDelimiterComparator = new DecreasingCharArrayLengthComparator();
    private char[][] fLineDelimiters;
    private char[][] fSortedLineDelimiters;

    public PatternRule(String string, String string2, IToken iToken, char c, boolean bl) {
        Assert.isTrue((string != null && string.length() > 0 ? 1 : 0) != 0);
        Assert.isTrue((string2 != null || bl ? 1 : 0) != 0);
        Assert.isNotNull((Object)iToken);
        this.fStartSequence = string.toCharArray();
        this.fEndSequence = string2 == null ? new char[]{} : string2.toCharArray();
        this.fToken = iToken;
        this.fEscapeCharacter = c;
        this.fBreaksOnEOL = bl;
    }

    public PatternRule(String string, String string2, IToken iToken, char c, boolean bl, boolean bl2) {
        this(string, string2, iToken, c, bl);
        this.fBreaksOnEOF = bl2;
    }

    public PatternRule(String string, String string2, IToken iToken, char c, boolean bl, boolean bl2, boolean bl3) {
        this(string, string2, iToken, c, bl, bl2);
        this.fEscapeContinuesLine = bl3;
    }

    public void setColumnConstraint(int n) {
        if (n < 0) {
            n = -1;
        }
        this.fColumn = n;
    }

    protected IToken doEvaluate(ICharacterScanner iCharacterScanner) {
        return this.doEvaluate(iCharacterScanner, false);
    }

    protected IToken doEvaluate(ICharacterScanner iCharacterScanner, boolean bl) {
        int n;
        if (bl ? this.endSequenceDetected(iCharacterScanner) : (n = iCharacterScanner.read()) == this.fStartSequence[0] && this.sequenceDetected(iCharacterScanner, this.fStartSequence, this.fBreaksOnEOF) && this.endSequenceDetected(iCharacterScanner)) {
            return this.fToken;
        }
        iCharacterScanner.unread();
        return Token.UNDEFINED;
    }

    @Override
    public IToken evaluate(ICharacterScanner iCharacterScanner) {
        return this.evaluate(iCharacterScanner, false);
    }

    /*
     * Unable to fully structure code
     */
    protected boolean endSequenceDetected(ICharacterScanner var1_1) {
        block17: {
            var2_2 = var1_1.getLegalLineDelimiters();
            var3_3 = var2_2.length;
            if (this.fLineDelimiters != null && this.fLineDelimiters.length == var3_3) ** GOTO lbl7
            this.fSortedLineDelimiters = new char[var3_3][];
            break block17;
lbl-1000:
            // 1 sources

            {
                --var3_3;
lbl7:
                // 2 sources

                ** while (var3_3 > 0 && Arrays.equals((char[])this.fLineDelimiters[var3_3 - 1], (char[])var2_2[var3_3 - 1]))
            }
        }
        if (var3_3 != 0) {
            this.fLineDelimiters = var2_2;
            System.arraycopy(this.fLineDelimiters, 0, this.fSortedLineDelimiters, 0, this.fLineDelimiters.length);
            Arrays.sort(this.fSortedLineDelimiters, this.fLineDelimiterComparator);
        }
        var4_4 = 1;
        while ((var5_5 = var1_1.read()) != -1) {
            if (var5_5 == this.fEscapeCharacter) {
                if (this.fEscapeContinuesLine) {
                    var5_5 = var1_1.read();
                    var6_6 = 0;
                    while (var6_6 < this.fSortedLineDelimiters.length) {
                        if (var5_5 != this.fSortedLineDelimiters[var6_6][0] || !this.sequenceDetected(var1_1, this.fSortedLineDelimiters[var6_6], this.fBreaksOnEOF)) {
                            ++var6_6;
                            continue;
                        }
                        break;
                    }
                } else {
                    var1_1.read();
                }
            } else if (this.fEndSequence.length > 0 && var5_5 == this.fEndSequence[0]) {
                if (this.sequenceDetected(var1_1, this.fEndSequence, this.fBreaksOnEOF)) {
                    return true;
                }
            } else if (this.fBreaksOnEOL) {
                var6_6 = 0;
                while (var6_6 < this.fSortedLineDelimiters.length) {
                    if (var5_5 == this.fSortedLineDelimiters[var6_6][0] && this.sequenceDetected(var1_1, this.fSortedLineDelimiters[var6_6], this.fBreaksOnEOF)) {
                        return true;
                    }
                    ++var6_6;
                }
            }
            ++var4_4;
        }
        if (!this.fBreaksOnEOF) ** GOTO lbl46
        return true;
lbl-1000:
        // 1 sources

        {
            var1_1.unread();
            --var4_4;
lbl46:
            // 2 sources

            ** while (var4_4 > 0)
        }
lbl47:
        // 1 sources

        return false;
    }

    protected boolean sequenceDetected(ICharacterScanner iCharacterScanner, char[] cArray, boolean bl) {
        int n = 1;
        while (n < cArray.length) {
            int n2 = iCharacterScanner.read();
            if (n2 == -1 && bl) {
                return true;
            }
            if (n2 != cArray[n]) {
                iCharacterScanner.unread();
                int n3 = n - 1;
                while (n3 > 0) {
                    iCharacterScanner.unread();
                    --n3;
                }
                return false;
            }
            ++n;
        }
        return true;
    }

    @Override
    public IToken evaluate(ICharacterScanner iCharacterScanner, boolean bl) {
        if (this.fColumn == -1) {
            return this.doEvaluate(iCharacterScanner, bl);
        }
        int n = iCharacterScanner.read();
        iCharacterScanner.unread();
        if (n == this.fStartSequence[0]) {
            return this.fColumn == iCharacterScanner.getColumn() ? this.doEvaluate(iCharacterScanner, bl) : Token.UNDEFINED;
        }
        return Token.UNDEFINED;
    }

    @Override
    public IToken getSuccessToken() {
        return this.fToken;
    }

    private static class DecreasingCharArrayLengthComparator
    implements Comparator {
        private DecreasingCharArrayLengthComparator() {
        }

        public int compare(Object object, Object object2) {
            return ((char[])object2).length - ((char[])object).length;
        }
    }
}

