/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.rules;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public class NumberRule
implements IRule {
    protected static final int UNDEFINED = -1;
    protected IToken fToken;
    protected int fColumn = -1;

    public NumberRule(IToken iToken) {
        Assert.isNotNull((Object)iToken);
        this.fToken = iToken;
    }

    public void setColumnConstraint(int n) {
        if (n < 0) {
            n = -1;
        }
        this.fColumn = n;
    }

    @Override
    public IToken evaluate(ICharacterScanner iCharacterScanner) {
        int n = iCharacterScanner.read();
        if (Character.isDigit((char)n) && (this.fColumn == -1 || this.fColumn == iCharacterScanner.getColumn() - 1)) {
            while (Character.isDigit((char)(n = iCharacterScanner.read()))) {
            }
            iCharacterScanner.unread();
            return this.fToken;
        }
        iCharacterScanner.unread();
        return Token.UNDEFINED;
    }
}

