/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.rules;

import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DefaultPositionUpdater;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.DocumentRewriteSession;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IDocumentPartitionerExtension;
import org.eclipse.jface.text.IDocumentPartitionerExtension2;
import org.eclipse.jface.text.IDocumentPartitionerExtension3;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.TypedPosition;
import org.eclipse.jface.text.TypedRegion;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.rules.IToken;

public class FastPartitioner
implements IDocumentPartitioner,
IDocumentPartitionerExtension,
IDocumentPartitionerExtension2,
IDocumentPartitionerExtension3 {
    private static final String CONTENT_TYPES_CATEGORY = "__content_types_category";
    protected final IPartitionTokenScanner fScanner;
    protected final String[] fLegalContentTypes;
    protected IDocument fDocument;
    protected int fPreviousDocumentLength;
    protected final DefaultPositionUpdater fPositionUpdater;
    protected int fStartOffset;
    protected int fEndOffset;
    protected int fDeleteOffset;
    private final String fPositionCategory;
    private DocumentRewriteSession fActiveRewriteSession;
    private boolean fIsInitialized = false;
    private Position[] fCachedPositions = null;
    private static final boolean CHECK_CACHE_CONSISTENCY = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.jface.text/debug/FastPartitioner/PositionCache"));

    public FastPartitioner(IPartitionTokenScanner iPartitionTokenScanner, String[] stringArray) {
        this.fScanner = iPartitionTokenScanner;
        this.fLegalContentTypes = TextUtilities.copy((String[])stringArray);
        this.fPositionCategory = CONTENT_TYPES_CATEGORY + this.hashCode();
        this.fPositionUpdater = new DefaultPositionUpdater(this.fPositionCategory);
    }

    public String[] getManagingPositionCategories() {
        return new String[]{this.fPositionCategory};
    }

    public final void connect(IDocument iDocument) {
        this.connect(iDocument, false);
    }

    public void connect(IDocument iDocument, boolean bl) {
        Assert.isNotNull((Object)iDocument);
        Assert.isTrue((!iDocument.containsPositionCategory(this.fPositionCategory) ? 1 : 0) != 0);
        this.fDocument = iDocument;
        this.fDocument.addPositionCategory(this.fPositionCategory);
        this.fIsInitialized = false;
        if (!bl) {
            this.checkInitialization();
        }
    }

    protected final void checkInitialization() {
        if (!this.fIsInitialized) {
            this.initialize();
        }
    }

    protected void initialize() {
        this.fIsInitialized = true;
        this.clearPositionCache();
        this.fScanner.setRange(this.fDocument, 0, this.fDocument.getLength());
        try {
            IToken iToken = this.fScanner.nextToken();
            while (!iToken.isEOF()) {
                String string = this.getTokenContentType(iToken);
                if (this.isSupportedContentType(string)) {
                    TypedPosition typedPosition = new TypedPosition(this.fScanner.getTokenOffset(), this.fScanner.getTokenLength(), string);
                    this.fDocument.addPosition(this.fPositionCategory, (Position)typedPosition);
                }
                iToken = this.fScanner.nextToken();
            }
        }
        catch (BadLocationException badLocationException) {
        }
        catch (BadPositionCategoryException badPositionCategoryException) {}
    }

    public void disconnect() {
        Assert.isTrue((boolean)this.fDocument.containsPositionCategory(this.fPositionCategory));
        try {
            this.fDocument.removePositionCategory(this.fPositionCategory);
        }
        catch (BadPositionCategoryException badPositionCategoryException) {}
    }

    public void documentAboutToBeChanged(DocumentEvent documentEvent) {
        if (this.fIsInitialized) {
            Assert.isTrue((documentEvent.getDocument() == this.fDocument ? 1 : 0) != 0);
            this.fPreviousDocumentLength = documentEvent.getDocument().getLength();
            this.fStartOffset = -1;
            this.fEndOffset = -1;
            this.fDeleteOffset = -1;
        }
    }

    public final boolean documentChanged(DocumentEvent documentEvent) {
        if (this.fIsInitialized) {
            IRegion iRegion = this.documentChanged2(documentEvent);
            return iRegion != null;
        }
        return false;
    }

    private void rememberRegion(int n, int n2) {
        if (this.fStartOffset == -1) {
            this.fStartOffset = n;
        } else if (n < this.fStartOffset) {
            this.fStartOffset = n;
        }
        int n3 = n + n2;
        if (this.fEndOffset == -1) {
            this.fEndOffset = n3;
        } else if (n3 > this.fEndOffset) {
            this.fEndOffset = n3;
        }
    }

    private void rememberDeletedOffset(int n) {
        this.fDeleteOffset = n;
    }

    private IRegion createRegion() {
        if (this.fDeleteOffset == -1) {
            if (this.fStartOffset == -1 || this.fEndOffset == -1) {
                return null;
            }
            return new Region(this.fStartOffset, this.fEndOffset - this.fStartOffset);
        }
        if (this.fStartOffset == -1 || this.fEndOffset == -1) {
            return new Region(this.fDeleteOffset, 0);
        }
        int n = Math.min(this.fDeleteOffset, this.fStartOffset);
        int n2 = Math.max(this.fDeleteOffset, this.fEndOffset);
        return new Region(n, n2 - n);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IRegion documentChanged2(DocumentEvent var1_1) {
        if (!this.fIsInitialized) {
            return null;
        }
        try {
            Assert.isTrue((boolean)(var1_1.getDocument() == this.fDocument));
            var2_2 = this.getPositions();
            var3_3 = this.fDocument.getLineInformationOfOffset(var1_1.getOffset());
            var4_4 = var3_3.getOffset();
            var5_5 = -1;
            var6_6 = null;
            var7_7 = var1_1.getText() == null ? 0 : var1_1.getText().length();
            var8_8 = this.fDocument.computeIndexInCategory(this.fPositionCategory, var4_4);
            if (var8_8 > 0) {
                var9_9 = (TypedPosition)var2_2[var8_8 - 1];
                if (var9_9.includes(var4_4)) {
                    var5_5 = var9_9.getOffset();
                    var6_6 = var9_9.getType();
                    if (var1_1.getOffset() == var9_9.getOffset() + var9_9.getLength()) {
                        var4_4 = var5_5;
                    }
                    --var8_8;
                } else if (var4_4 == var1_1.getOffset() && var4_4 == var9_9.getOffset() + var9_9.getLength()) {
                    var5_5 = var9_9.getOffset();
                    var6_6 = var9_9.getType();
                    var4_4 = var5_5;
                    --var8_8;
                } else {
                    var5_5 = var9_9.getOffset() + var9_9.getLength();
                    var6_6 = "__dftl_partition_content_type";
                }
            }
            this.fPositionUpdater.update(var1_1);
            var9_10 = var8_8;
            while (var9_10 < var2_2.length) {
                var10_11 = var2_2[var9_10];
                if (var10_11.isDeleted) {
                    this.rememberDeletedOffset(var1_1.getOffset());
                    break;
                }
                ++var9_10;
            }
            this.clearPositionCache();
            var2_2 = this.getPositions();
            this.fScanner.setPartialRange(this.fDocument, var4_4, this.fDocument.getLength() - var4_4, var6_6, var5_5);
            var9_10 = var4_4;
            var10_11 = this.fScanner.nextToken();
            if (true) ** GOTO lbl69
        }
        catch (BadPositionCategoryException v0) {
            this.clearPositionCache();
            return this.createRegion();
        }
        catch (BadLocationException v1) {
            try {
                return this.createRegion();
            }
            catch (Throwable var15_18) {
                throw var15_18;
            }
            finally {
                this.clearPositionCache();
            }
        }
        {
            do {
                ++var8_8;
                if (true) ** GOTO lbl67
                block13: do {
                    try {
                        this.fDocument.addPosition(this.fPositionCategory, (Position)new TypedPosition(var11_12, var12_14, var6_6));
                        this.rememberRegion(var11_12, var12_14);
                    }
                    catch (BadPositionCategoryException v2) {
                    }
                    catch (BadLocationException v3) {}
                    var10_11 = this.fScanner.nextToken();
lbl69:
                    // 2 sources

                    while (true) {
                        block26: {
                            if (!var10_11.isEOF()) break block26;
                            var8_8 = this.fDocument.computeIndexInCategory(this.fPositionCategory, var9_10);
                            this.clearPositionCache();
                            var2_2 = this.getPositions();
                            if (true) ** GOTO lbl100
                        }
                        var6_6 = this.getTokenContentType((IToken)var10_11);
                        if (this.isSupportedContentType(var6_6)) break;
                        var10_11 = this.fScanner.nextToken();
                    }
                    var11_12 = this.fScanner.getTokenOffset();
                    var12_14 = this.fScanner.getTokenLength();
                    var9_10 = var11_12 + var12_14;
                    var13_15 = var9_10 - 1;
                    while (var8_8 < var2_2.length) {
                        var14_16 = (TypedPosition)var2_2[var8_8];
                        if (var13_15 < var14_16.offset + var14_16.length && (!var14_16.overlapsWith(var11_12, var12_14) || this.fDocument.containsPosition(this.fPositionCategory, var11_12, var12_14) && var6_6.equals(var14_16.getType()))) continue block13;
                        this.rememberRegion(var14_16.offset, var14_16.length);
                        this.fDocument.removePosition(this.fPositionCategory, (Position)var14_16);
                        ++var8_8;
                    }
                } while (!this.fDocument.containsPosition(this.fPositionCategory, var11_12, var12_14));
            } while (var13_15 < var1_1.getOffset() + var7_7);
            var16_17 = this.createRegion();
            this.clearPositionCache();
            return var16_17;
            do {
                var11_13 = (TypedPosition)var2_2[var8_8++];
                this.fDocument.removePosition(this.fPositionCategory, (Position)var11_13);
                this.rememberRegion(var11_13.offset, var11_13.length);
lbl100:
                // 2 sources

            } while (var8_8 < var2_2.length);
        }
        this.clearPositionCache();
        return this.createRegion();
    }

    protected TypedPosition findClosestPosition(int n) {
        Position[] positionArray;
        int n2;
        block6: {
            n2 = this.fDocument.computeIndexInCategory(this.fPositionCategory, n);
            positionArray = this.getPositions();
            if (positionArray.length != 0) break block6;
            return null;
        }
        try {
            if (n2 < positionArray.length && n == positionArray[n2].offset) {
                return (TypedPosition)positionArray[n2];
            }
            if (n2 > 0) {
                --n2;
            }
            return (TypedPosition)positionArray[n2];
        }
        catch (BadPositionCategoryException badPositionCategoryException) {
        }
        catch (BadLocationException badLocationException) {}
        return null;
    }

    public String getContentType(int n) {
        this.checkInitialization();
        TypedPosition typedPosition = this.findClosestPosition(n);
        if (typedPosition != null && typedPosition.includes(n)) {
            return typedPosition.getType();
        }
        return "__dftl_partition_content_type";
    }

    public ITypedRegion getPartition(int n) {
        this.checkInitialization();
        try {
            Position[] positionArray = this.getPositions();
            if (positionArray == null || positionArray.length == 0) {
                return new TypedRegion(0, this.fDocument.getLength(), "__dftl_partition_content_type");
            }
            int n2 = this.fDocument.computeIndexInCategory(this.fPositionCategory, n);
            if (n2 < positionArray.length) {
                TypedPosition typedPosition = (TypedPosition)positionArray[n2];
                if (n == typedPosition.offset) {
                    return new TypedRegion(typedPosition.getOffset(), typedPosition.getLength(), typedPosition.getType());
                }
                if (n2 == 0) {
                    return new TypedRegion(0, typedPosition.offset, "__dftl_partition_content_type");
                }
                TypedPosition typedPosition2 = (TypedPosition)positionArray[n2 - 1];
                if (typedPosition2.includes(n)) {
                    return new TypedRegion(typedPosition2.getOffset(), typedPosition2.getLength(), typedPosition2.getType());
                }
                int n3 = typedPosition2.getOffset() + typedPosition2.getLength();
                return new TypedRegion(n3, typedPosition.getOffset() - n3, "__dftl_partition_content_type");
            }
            TypedPosition typedPosition = (TypedPosition)positionArray[positionArray.length - 1];
            if (typedPosition.includes(n)) {
                return new TypedRegion(typedPosition.getOffset(), typedPosition.getLength(), typedPosition.getType());
            }
            int n4 = typedPosition.getOffset() + typedPosition.getLength();
            return new TypedRegion(n4, this.fDocument.getLength() - n4, "__dftl_partition_content_type");
        }
        catch (BadPositionCategoryException badPositionCategoryException) {
        }
        catch (BadLocationException badLocationException) {}
        return new TypedRegion(0, this.fDocument.getLength(), "__dftl_partition_content_type");
    }

    public final ITypedRegion[] computePartitioning(int n, int n2) {
        return this.computePartitioning(n, n2, false);
    }

    public String[] getLegalContentTypes() {
        return TextUtilities.copy((String[])this.fLegalContentTypes);
    }

    protected boolean isSupportedContentType(String string) {
        if (string != null) {
            int n = 0;
            while (n < this.fLegalContentTypes.length) {
                if (this.fLegalContentTypes[n].equals(string)) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    protected String getTokenContentType(IToken iToken) {
        Object object = iToken.getData();
        if (object instanceof String) {
            return (String)object;
        }
        return null;
    }

    public String getContentType(int n, boolean bl) {
        return this.getPartition(n, bl).getType();
    }

    public ITypedRegion getPartition(int n, boolean bl) {
        ITypedRegion iTypedRegion = this.getPartition(n);
        if (bl && iTypedRegion.getOffset() == n && !iTypedRegion.getType().equals("__dftl_partition_content_type")) {
            if (n > 0 && (iTypedRegion = this.getPartition(n - 1)).getType().equals("__dftl_partition_content_type")) {
                return iTypedRegion;
            }
            return new TypedRegion(n, 0, "__dftl_partition_content_type");
        }
        return iTypedRegion;
    }

    public ITypedRegion[] computePartitioning(int n, int n2, boolean bl) {
        this.checkInitialization();
        ArrayList<TypedRegion> arrayList = new ArrayList<TypedRegion>();
        try {
            int n3;
            int n4;
            int n5;
            int n6 = n + n2;
            Position[] positionArray = this.getPositions();
            TypedPosition typedPosition = null;
            TypedPosition typedPosition2 = null;
            Position position = new Position(0);
            int n7 = this.getFirstIndexEndingAfterOffset(positionArray, n);
            int n8 = this.getFirstIndexStartingAfterOffset(positionArray, n6);
            int n9 = n7;
            while (n9 < n8) {
                typedPosition2 = (TypedPosition)positionArray[n9];
                n5 = typedPosition != null ? typedPosition.getOffset() + typedPosition.getLength() : 0;
                position.setOffset(n5);
                position.setLength(typedPosition2.getOffset() - n5);
                if (bl && this.overlapsOrTouches(position, n, n2) || position.getLength() > 0 && position.overlapsWith(n, n2)) {
                    n4 = Math.max(n, n5);
                    n3 = Math.min(n6, position.getOffset() + position.getLength());
                    arrayList.add(new TypedRegion(n4, n3 - n4, "__dftl_partition_content_type"));
                }
                if (typedPosition2.overlapsWith(n, n2)) {
                    n4 = Math.max(n, typedPosition2.getOffset());
                    n3 = Math.min(n6, typedPosition2.getOffset() + typedPosition2.getLength());
                    arrayList.add(new TypedRegion(n4, n3 - n4, typedPosition2.getType()));
                }
                typedPosition = typedPosition2;
                ++n9;
            }
            if (typedPosition != null) {
                n5 = typedPosition.getOffset() + typedPosition.getLength();
                position.setOffset(n5);
                position.setLength(this.fDocument.getLength() - n5);
                if (bl && this.overlapsOrTouches(position, n, n2) || position.getLength() > 0 && position.overlapsWith(n, n2)) {
                    n4 = Math.max(n, n5);
                    n3 = Math.min(n6, this.fDocument.getLength());
                    arrayList.add(new TypedRegion(n4, n3 - n4, "__dftl_partition_content_type"));
                }
            }
            if (arrayList.isEmpty()) {
                arrayList.add(new TypedRegion(n, n2, "__dftl_partition_content_type"));
            }
        }
        catch (BadPositionCategoryException badPositionCategoryException) {
            this.clearPositionCache();
        }
        catch (RuntimeException runtimeException) {
            this.clearPositionCache();
            throw runtimeException;
        }
        TypedRegion[] typedRegionArray = new TypedRegion[arrayList.size()];
        arrayList.toArray(typedRegionArray);
        return typedRegionArray;
    }

    private boolean overlapsOrTouches(Position position, int n, int n2) {
        return position.getOffset() <= n + n2 && n <= position.getOffset() + position.getLength();
    }

    private int getFirstIndexEndingAfterOffset(Position[] positionArray, int n) {
        int n2 = -1;
        int n3 = positionArray.length;
        while (n3 - n2 > 1) {
            int n4 = n2 + n3 >> 1;
            Position position = positionArray[n4];
            if (position.getOffset() + position.getLength() > n) {
                n3 = n4;
                continue;
            }
            n2 = n4;
        }
        return n3;
    }

    private int getFirstIndexStartingAfterOffset(Position[] positionArray, int n) {
        int n2 = -1;
        int n3 = positionArray.length;
        while (n3 - n2 > 1) {
            int n4 = n2 + n3 >> 1;
            Position position = positionArray[n4];
            if (position.getOffset() >= n) {
                n3 = n4;
                continue;
            }
            n2 = n4;
        }
        return n3;
    }

    public void startRewriteSession(DocumentRewriteSession documentRewriteSession) throws IllegalStateException {
        if (this.fActiveRewriteSession != null) {
            throw new IllegalStateException();
        }
        this.fActiveRewriteSession = documentRewriteSession;
    }

    public void stopRewriteSession(DocumentRewriteSession documentRewriteSession) {
        if (this.fActiveRewriteSession == documentRewriteSession) {
            this.flushRewriteSession();
        }
    }

    public DocumentRewriteSession getActiveRewriteSession() {
        return this.fActiveRewriteSession;
    }

    protected final void flushRewriteSession() {
        this.fActiveRewriteSession = null;
        try {
            this.fDocument.removePositionCategory(this.fPositionCategory);
        }
        catch (BadPositionCategoryException badPositionCategoryException) {}
        this.fDocument.addPositionCategory(this.fPositionCategory);
        this.fIsInitialized = false;
    }

    protected final void clearPositionCache() {
        if (this.fCachedPositions != null) {
            this.fCachedPositions = null;
        }
    }

    protected final Position[] getPositions() throws BadPositionCategoryException {
        if (this.fCachedPositions == null) {
            this.fCachedPositions = this.fDocument.getPositions(this.fPositionCategory);
        } else if (CHECK_CACHE_CONSISTENCY) {
            Position[] positionArray = this.fDocument.getPositions(this.fPositionCategory);
            int n = Math.min(positionArray.length, this.fCachedPositions.length);
            int n2 = 0;
            while (n2 < n) {
                if (!positionArray[n2].equals((Object)this.fCachedPositions[n2])) {
                    System.err.println("FastPartitioner.getPositions(): cached position is not up to date: from document: " + this.toString(positionArray[n2]) + " in cache: " + this.toString(this.fCachedPositions[n2]));
                }
                ++n2;
            }
            n2 = n;
            while (n2 < positionArray.length) {
                System.err.println("FastPartitioner.getPositions(): new position in document: " + this.toString(positionArray[n2]));
                ++n2;
            }
            n2 = n;
            while (n2 < this.fCachedPositions.length) {
                System.err.println("FastPartitioner.getPositions(): stale position in cache: " + this.toString(this.fCachedPositions[n2]));
                ++n2;
            }
        }
        return this.fCachedPositions;
    }

    private String toString(Position position) {
        return "P[" + position.getOffset() + "+" + position.getLength() + "]";
    }
}

