/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.rules;

import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DefaultPositionUpdater;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.DocumentRewriteSession;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IDocumentPartitionerExtension;
import org.eclipse.jface.text.IDocumentPartitionerExtension2;
import org.eclipse.jface.text.IDocumentPartitionerExtension3;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.TypedPosition;
import org.eclipse.jface.text.TypedRegion;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.rules.IToken;

public class DefaultPartitioner
implements IDocumentPartitioner,
IDocumentPartitionerExtension,
IDocumentPartitionerExtension2,
IDocumentPartitionerExtension3 {
    public static final String CONTENT_TYPES_CATEGORY = "__content_types_category";
    protected IPartitionTokenScanner fScanner;
    protected String[] fLegalContentTypes;
    protected IDocument fDocument;
    protected int fPreviousDocumentLength;
    protected DefaultPositionUpdater fPositionUpdater;
    protected int fStartOffset;
    protected int fEndOffset;
    protected int fDeleteOffset;
    private String fPositionCategory;
    private DocumentRewriteSession fActiveRewriteSession;
    private boolean fIsInitialized = false;

    public DefaultPartitioner(IPartitionTokenScanner iPartitionTokenScanner, String[] stringArray) {
        this.fScanner = iPartitionTokenScanner;
        this.fLegalContentTypes = TextUtilities.copy((String[])stringArray);
        this.fPositionCategory = CONTENT_TYPES_CATEGORY + this.hashCode();
        this.fPositionUpdater = new DefaultPositionUpdater(this.fPositionCategory);
    }

    public String[] getManagingPositionCategories() {
        return new String[]{this.fPositionCategory};
    }

    public void connect(IDocument iDocument) {
        this.connect(iDocument, false);
    }

    public void connect(IDocument iDocument, boolean bl) {
        Assert.isNotNull((Object)iDocument);
        Assert.isTrue((!iDocument.containsPositionCategory(this.fPositionCategory) ? 1 : 0) != 0);
        this.fDocument = iDocument;
        this.fDocument.addPositionCategory(this.fPositionCategory);
        this.fIsInitialized = false;
        if (!bl) {
            this.checkInitialization();
        }
    }

    protected final void checkInitialization() {
        if (!this.fIsInitialized) {
            this.initialize();
        }
    }

    protected void initialize() {
        this.fIsInitialized = true;
        this.fScanner.setRange(this.fDocument, 0, this.fDocument.getLength());
        try {
            IToken iToken = this.fScanner.nextToken();
            while (!iToken.isEOF()) {
                String string = this.getTokenContentType(iToken);
                if (this.isSupportedContentType(string)) {
                    TypedPosition typedPosition = new TypedPosition(this.fScanner.getTokenOffset(), this.fScanner.getTokenLength(), string);
                    this.fDocument.addPosition(this.fPositionCategory, (Position)typedPosition);
                }
                iToken = this.fScanner.nextToken();
            }
        }
        catch (BadLocationException badLocationException) {
        }
        catch (BadPositionCategoryException badPositionCategoryException) {}
    }

    public void disconnect() {
        Assert.isTrue((boolean)this.fDocument.containsPositionCategory(this.fPositionCategory));
        try {
            this.fDocument.removePositionCategory(this.fPositionCategory);
        }
        catch (BadPositionCategoryException badPositionCategoryException) {}
    }

    public void documentAboutToBeChanged(DocumentEvent documentEvent) {
        if (this.fIsInitialized) {
            Assert.isTrue((documentEvent.getDocument() == this.fDocument ? 1 : 0) != 0);
            this.fPreviousDocumentLength = documentEvent.getDocument().getLength();
            this.fStartOffset = -1;
            this.fEndOffset = -1;
            this.fDeleteOffset = -1;
        }
    }

    public boolean documentChanged(DocumentEvent documentEvent) {
        if (this.fIsInitialized) {
            IRegion iRegion = this.documentChanged2(documentEvent);
            return iRegion != null;
        }
        return false;
    }

    private void rememberRegion(int n, int n2) {
        if (this.fStartOffset == -1) {
            this.fStartOffset = n;
        } else if (n < this.fStartOffset) {
            this.fStartOffset = n;
        }
        int n3 = n + n2;
        if (this.fEndOffset == -1) {
            this.fEndOffset = n3;
        } else if (n3 > this.fEndOffset) {
            this.fEndOffset = n3;
        }
    }

    private void rememberDeletedOffset(int n) {
        this.fDeleteOffset = n;
    }

    private IRegion createRegion() {
        if (this.fDeleteOffset == -1) {
            if (this.fStartOffset == -1 || this.fEndOffset == -1) {
                return null;
            }
            return new Region(this.fStartOffset, this.fEndOffset - this.fStartOffset);
        }
        if (this.fStartOffset == -1 || this.fEndOffset == -1) {
            return new Region(this.fDeleteOffset, 0);
        }
        int n = Math.min(this.fDeleteOffset, this.fStartOffset);
        int n2 = Math.max(this.fDeleteOffset, this.fEndOffset);
        return new Region(n, n2 - n);
    }

    public IRegion documentChanged2(DocumentEvent documentEvent) {
        if (!this.fIsInitialized) {
            return null;
        }
        try {
            Object object;
            IDocument iDocument = documentEvent.getDocument();
            Position[] positionArray = iDocument.getPositions(this.fPositionCategory);
            IRegion iRegion = iDocument.getLineInformationOfOffset(documentEvent.getOffset());
            int n = iRegion.getOffset();
            int n2 = -1;
            String string = null;
            int n3 = documentEvent.getText() == null ? 0 : documentEvent.getText().length();
            int n4 = iDocument.computeIndexInCategory(this.fPositionCategory, n);
            if (n4 > 0) {
                TypedPosition typedPosition = (TypedPosition)positionArray[n4 - 1];
                if (typedPosition.includes(n)) {
                    n2 = typedPosition.getOffset();
                    string = typedPosition.getType();
                    if (documentEvent.getOffset() == typedPosition.getOffset() + typedPosition.getLength()) {
                        n = n2;
                    }
                    --n4;
                } else if (n == documentEvent.getOffset() && n == typedPosition.getOffset() + typedPosition.getLength()) {
                    n2 = typedPosition.getOffset();
                    string = typedPosition.getType();
                    n = n2;
                    --n4;
                } else {
                    n2 = typedPosition.getOffset() + typedPosition.getLength();
                    string = "__dftl_partition_content_type";
                }
            }
            this.fPositionUpdater.update(documentEvent);
            int n5 = n4;
            while (n5 < positionArray.length) {
                object = positionArray[n5];
                if (((Position)object).isDeleted) {
                    this.rememberDeletedOffset(documentEvent.getOffset());
                    break;
                }
                ++n5;
            }
            positionArray = iDocument.getPositions(this.fPositionCategory);
            this.fScanner.setPartialRange(iDocument, n, iDocument.getLength() - n, string, n2);
            n5 = n;
            object = this.fScanner.nextToken();
            while (!object.isEOF()) {
                string = this.getTokenContentType((IToken)object);
                if (!this.isSupportedContentType(string)) {
                    object = this.fScanner.nextToken();
                    continue;
                }
                int n6 = this.fScanner.getTokenOffset();
                int n7 = this.fScanner.getTokenLength();
                n5 = n6 + n7 - 1;
                while (n4 < positionArray.length) {
                    TypedPosition typedPosition = (TypedPosition)positionArray[n4];
                    if (n5 < typedPosition.offset + typedPosition.length && (!typedPosition.overlapsWith(n6, n7) || iDocument.containsPosition(this.fPositionCategory, n6, n7) && string.equals(typedPosition.getType()))) break;
                    this.rememberRegion(typedPosition.offset, typedPosition.length);
                    iDocument.removePosition(this.fPositionCategory, (Position)typedPosition);
                    ++n4;
                }
                if (iDocument.containsPosition(this.fPositionCategory, n6, n7)) {
                    if (n5 >= documentEvent.getOffset() + n3) {
                        return this.createRegion();
                    }
                    ++n4;
                } else {
                    try {
                        iDocument.addPosition(this.fPositionCategory, (Position)new TypedPosition(n6, n7, string));
                        this.rememberRegion(n6, n7);
                    }
                    catch (BadPositionCategoryException badPositionCategoryException) {
                    }
                    catch (BadLocationException badLocationException) {}
                }
                object = this.fScanner.nextToken();
            }
            if (n5 != n) {
                ++n5;
            }
            n4 = iDocument.computeIndexInCategory(this.fPositionCategory, n5);
            positionArray = iDocument.getPositions(this.fPositionCategory);
            while (n4 < positionArray.length) {
                TypedPosition typedPosition = (TypedPosition)positionArray[n4++];
                iDocument.removePosition(this.fPositionCategory, (Position)typedPosition);
                this.rememberRegion(typedPosition.offset, typedPosition.length);
            }
        }
        catch (BadPositionCategoryException badPositionCategoryException) {
        }
        catch (BadLocationException badLocationException) {}
        return this.createRegion();
    }

    protected TypedPosition findClosestPosition(int n) {
        Position[] positionArray;
        int n2;
        block6: {
            n2 = this.fDocument.computeIndexInCategory(this.fPositionCategory, n);
            positionArray = this.fDocument.getPositions(this.fPositionCategory);
            if (positionArray.length != 0) break block6;
            return null;
        }
        try {
            if (n2 < positionArray.length && n == positionArray[n2].offset) {
                return (TypedPosition)positionArray[n2];
            }
            if (n2 > 0) {
                --n2;
            }
            return (TypedPosition)positionArray[n2];
        }
        catch (BadPositionCategoryException badPositionCategoryException) {
        }
        catch (BadLocationException badLocationException) {}
        return null;
    }

    public String getContentType(int n) {
        this.checkInitialization();
        TypedPosition typedPosition = this.findClosestPosition(n);
        if (typedPosition != null && typedPosition.includes(n)) {
            return typedPosition.getType();
        }
        return "__dftl_partition_content_type";
    }

    public ITypedRegion getPartition(int n) {
        this.checkInitialization();
        try {
            Position[] positionArray = this.fDocument.getPositions(this.fPositionCategory);
            if (positionArray == null || positionArray.length == 0) {
                return new TypedRegion(0, this.fDocument.getLength(), "__dftl_partition_content_type");
            }
            int n2 = this.fDocument.computeIndexInCategory(this.fPositionCategory, n);
            if (n2 < positionArray.length) {
                TypedPosition typedPosition = (TypedPosition)positionArray[n2];
                if (n == typedPosition.offset) {
                    return new TypedRegion(typedPosition.getOffset(), typedPosition.getLength(), typedPosition.getType());
                }
                if (n2 == 0) {
                    return new TypedRegion(0, typedPosition.offset, "__dftl_partition_content_type");
                }
                TypedPosition typedPosition2 = (TypedPosition)positionArray[n2 - 1];
                if (typedPosition2.includes(n)) {
                    return new TypedRegion(typedPosition2.getOffset(), typedPosition2.getLength(), typedPosition2.getType());
                }
                int n3 = typedPosition2.getOffset() + typedPosition2.getLength();
                return new TypedRegion(n3, typedPosition.getOffset() - n3, "__dftl_partition_content_type");
            }
            TypedPosition typedPosition = (TypedPosition)positionArray[positionArray.length - 1];
            if (typedPosition.includes(n)) {
                return new TypedRegion(typedPosition.getOffset(), typedPosition.getLength(), typedPosition.getType());
            }
            int n4 = typedPosition.getOffset() + typedPosition.getLength();
            return new TypedRegion(n4, this.fDocument.getLength() - n4, "__dftl_partition_content_type");
        }
        catch (BadPositionCategoryException badPositionCategoryException) {
        }
        catch (BadLocationException badLocationException) {}
        return new TypedRegion(0, this.fDocument.getLength(), "__dftl_partition_content_type");
    }

    public ITypedRegion[] computePartitioning(int n, int n2) {
        return this.computePartitioning(n, n2, false);
    }

    public String[] getLegalContentTypes() {
        return TextUtilities.copy((String[])this.fLegalContentTypes);
    }

    protected boolean isSupportedContentType(String string) {
        if (string != null) {
            int n = 0;
            while (n < this.fLegalContentTypes.length) {
                if (this.fLegalContentTypes[n].equals(string)) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    protected String getTokenContentType(IToken iToken) {
        Object object = iToken.getData();
        if (object instanceof String) {
            return (String)object;
        }
        return null;
    }

    public String getContentType(int n, boolean bl) {
        return this.getPartition(n, bl).getType();
    }

    public ITypedRegion getPartition(int n, boolean bl) {
        ITypedRegion iTypedRegion = this.getPartition(n);
        if (bl && iTypedRegion.getOffset() == n && !iTypedRegion.getType().equals("__dftl_partition_content_type")) {
            if (n > 0 && (iTypedRegion = this.getPartition(n - 1)).getType().equals("__dftl_partition_content_type")) {
                return iTypedRegion;
            }
            return new TypedRegion(n, 0, "__dftl_partition_content_type");
        }
        return iTypedRegion;
    }

    public ITypedRegion[] computePartitioning(int n, int n2, boolean bl) {
        this.checkInitialization();
        ArrayList<TypedRegion> arrayList = new ArrayList<TypedRegion>();
        try {
            int n3;
            int n4;
            int n5;
            int n6 = n + n2;
            Position[] positionArray = this.fDocument.getPositions(this.fPositionCategory);
            TypedPosition typedPosition = null;
            TypedPosition typedPosition2 = null;
            Position position = new Position(0);
            int n7 = this.getFirstIndexEndingAfterOffset(positionArray, n);
            int n8 = this.getFirstIndexStartingAfterOffset(positionArray, n6);
            int n9 = n7;
            while (n9 < n8) {
                typedPosition2 = (TypedPosition)positionArray[n9];
                n5 = typedPosition != null ? typedPosition.getOffset() + typedPosition.getLength() : 0;
                position.setOffset(n5);
                position.setLength(typedPosition2.getOffset() - n5);
                if (bl && this.overlapsOrTouches(position, n, n2) || position.getLength() > 0 && position.overlapsWith(n, n2)) {
                    n4 = Math.max(n, n5);
                    n3 = Math.min(n6, position.getOffset() + position.getLength());
                    arrayList.add(new TypedRegion(n4, n3 - n4, "__dftl_partition_content_type"));
                }
                if (typedPosition2.overlapsWith(n, n2)) {
                    n4 = Math.max(n, typedPosition2.getOffset());
                    n3 = Math.min(n6, typedPosition2.getOffset() + typedPosition2.getLength());
                    arrayList.add(new TypedRegion(n4, n3 - n4, typedPosition2.getType()));
                }
                typedPosition = typedPosition2;
                ++n9;
            }
            if (typedPosition != null) {
                n5 = typedPosition.getOffset() + typedPosition.getLength();
                position.setOffset(n5);
                position.setLength(this.fDocument.getLength() - n5);
                if (bl && this.overlapsOrTouches(position, n, n2) || position.getLength() > 0 && position.overlapsWith(n, n2)) {
                    n4 = Math.max(n, n5);
                    n3 = Math.min(n6, this.fDocument.getLength());
                    arrayList.add(new TypedRegion(n4, n3 - n4, "__dftl_partition_content_type"));
                }
            }
            if (arrayList.isEmpty()) {
                arrayList.add(new TypedRegion(n, n2, "__dftl_partition_content_type"));
            }
        }
        catch (BadPositionCategoryException badPositionCategoryException) {}
        TypedRegion[] typedRegionArray = new TypedRegion[arrayList.size()];
        arrayList.toArray(typedRegionArray);
        return typedRegionArray;
    }

    private boolean overlapsOrTouches(Position position, int n, int n2) {
        return position.getOffset() <= n + n2 && n <= position.getOffset() + position.getLength();
    }

    private int getFirstIndexEndingAfterOffset(Position[] positionArray, int n) {
        int n2 = -1;
        int n3 = positionArray.length;
        while (n3 - n2 > 1) {
            int n4 = n2 + n3 >> 1;
            Position position = positionArray[n4];
            if (position.getOffset() + position.getLength() > n) {
                n3 = n4;
                continue;
            }
            n2 = n4;
        }
        return n3;
    }

    private int getFirstIndexStartingAfterOffset(Position[] positionArray, int n) {
        int n2 = -1;
        int n3 = positionArray.length;
        while (n3 - n2 > 1) {
            int n4 = n2 + n3 >> 1;
            Position position = positionArray[n4];
            if (position.getOffset() >= n) {
                n3 = n4;
                continue;
            }
            n2 = n4;
        }
        return n3;
    }

    public void startRewriteSession(DocumentRewriteSession documentRewriteSession) throws IllegalStateException {
        if (this.fActiveRewriteSession != null) {
            throw new IllegalStateException();
        }
        this.fActiveRewriteSession = documentRewriteSession;
    }

    public void stopRewriteSession(DocumentRewriteSession documentRewriteSession) {
        if (this.fActiveRewriteSession == documentRewriteSession) {
            this.flushRewriteSession();
        }
    }

    public DocumentRewriteSession getActiveRewriteSession() {
        return this.fActiveRewriteSession;
    }

    protected final void flushRewriteSession() {
        this.fActiveRewriteSession = null;
        try {
            this.fDocument.removePositionCategory(this.fPositionCategory);
        }
        catch (BadPositionCategoryException badPositionCategoryException) {}
        this.fDocument.addPositionCategory(this.fPositionCategory);
        this.fIsInitialized = false;
    }
}

