/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.rules;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.swt.custom.StyleRange;

public class DefaultDamagerRepairer
implements IPresentationDamager,
IPresentationRepairer {
    protected IDocument fDocument;
    protected ITokenScanner fScanner;
    protected TextAttribute fDefaultTextAttribute;
    private String contentType;

    public DefaultDamagerRepairer(ITokenScanner iTokenScanner, TextAttribute textAttribute) {
        Assert.isNotNull((Object)textAttribute);
        this.fScanner = iTokenScanner;
        this.fDefaultTextAttribute = textAttribute;
    }

    public DefaultDamagerRepairer(ITokenScanner iTokenScanner) {
        Assert.isNotNull((Object)iTokenScanner);
        this.fScanner = iTokenScanner;
        this.fDefaultTextAttribute = new TextAttribute(null);
    }

    public DefaultDamagerRepairer(ITokenScanner iTokenScanner, String string) {
        this(iTokenScanner);
        this.contentType = string;
    }

    public String getContentType() {
        return this.contentType;
    }

    @Override
    public void setDocument(IDocument iDocument) {
        this.fDocument = iDocument;
    }

    protected int endOfLineOf(int n) throws BadLocationException {
        IRegion iRegion = this.fDocument.getLineInformationOfOffset(n);
        if (n <= iRegion.getOffset() + iRegion.getLength()) {
            return iRegion.getOffset() + iRegion.getLength();
        }
        int n2 = this.fDocument.getLineOfOffset(n);
        try {
            iRegion = this.fDocument.getLineInformation(n2 + 1);
            return iRegion.getOffset() + iRegion.getLength();
        }
        catch (BadLocationException badLocationException) {
            return this.fDocument.getLength();
        }
    }

    @Override
    public IRegion getDamageRegion(ITypedRegion iTypedRegion, DocumentEvent documentEvent, boolean bl) {
        if (!bl) {
            try {
                IRegion iRegion = this.fDocument.getLineInformationOfOffset(documentEvent.getOffset());
                int n = Math.max(iTypedRegion.getOffset(), iRegion.getOffset());
                int n2 = documentEvent.getOffset() + (documentEvent.getText() == null ? documentEvent.getLength() : documentEvent.getText().length());
                n2 = iRegion.getOffset() <= n2 && n2 <= iRegion.getOffset() + iRegion.getLength() ? iRegion.getOffset() + iRegion.getLength() : this.endOfLineOf(n2);
                n2 = Math.min(iTypedRegion.getOffset() + iTypedRegion.getLength(), n2);
                return new Region(n, n2 - n);
            }
            catch (BadLocationException badLocationException) {}
        }
        return iTypedRegion;
    }

    @Override
    public void createPresentation(TextPresentation textPresentation, ITypedRegion iTypedRegion) {
        IToken iToken;
        if (this.fScanner == null) {
            this.addRange(textPresentation, iTypedRegion.getOffset(), iTypedRegion.getLength(), this.fDefaultTextAttribute);
            return;
        }
        int n = iTypedRegion.getOffset();
        int n2 = 0;
        boolean bl = true;
        IToken iToken2 = Token.UNDEFINED;
        TextAttribute textAttribute = this.getTokenTextAttribute(iToken2);
        this.fScanner.setRange(this.fDocument, n, iTypedRegion.getLength());
        while (!(iToken = this.fScanner.nextToken()).isEOF()) {
            TextAttribute textAttribute2 = this.getTokenTextAttribute(iToken);
            if (textAttribute != null && textAttribute.equals(textAttribute2)) {
                n2 += this.fScanner.getTokenLength();
                bl = false;
                continue;
            }
            if (!bl) {
                this.addRange(textPresentation, n, n2, textAttribute);
            }
            bl = false;
            iToken2 = iToken;
            textAttribute = textAttribute2;
            n = this.fScanner.getTokenOffset();
            n2 = this.fScanner.getTokenLength();
        }
        this.addRange(textPresentation, n, n2, textAttribute);
    }

    protected TextAttribute getTokenTextAttribute(IToken iToken) {
        Object object = iToken.getData();
        if (object instanceof TextAttribute) {
            return (TextAttribute)object;
        }
        return this.fDefaultTextAttribute;
    }

    protected void addRange(TextPresentation textPresentation, int n, int n2, TextAttribute textAttribute) {
        if (textAttribute != null) {
            int n3 = textAttribute.getStyle();
            int n4 = n3 & 3;
            StyleRange styleRange = new StyleRange(n, n2, textAttribute.getForeground(), textAttribute.getBackground(), n4);
            styleRange.strikeout = (n3 & 0x20000000) != 0;
            styleRange.underline = (n3 & 0x40000000) != 0;
            styleRange.font = textAttribute.getFont();
            textPresentation.addStyleRange(styleRange);
        }
    }
}

