/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.revisions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.internal.text.revisions.Hunk;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.information.IInformationProviderExtension2;
import org.eclipse.jface.text.revisions.Revision;
import org.eclipse.jface.text.revisions.RevisionRange;

public final class RevisionInformation
implements ITextHoverExtension,
IInformationProviderExtension2 {
    private final List fRevisions = new ArrayList();
    private final List fRORevisions = Collections.unmodifiableList(this.fRevisions);
    private List fRanges = null;
    private IInformationControlCreator fHoverControlCreator;
    private IInformationControlCreator fInformationPresenterControlCreator;

    public void addRevision(Revision revision) {
        Assert.isLegal((revision != null ? 1 : 0) != 0);
        this.fRevisions.add(revision);
    }

    public List getRevisions() {
        return this.fRORevisions;
    }

    public List getRanges() {
        if (this.fRanges == null) {
            ArrayList arrayList = new ArrayList(this.fRevisions.size() * 2);
            for (Revision revision : this.fRevisions) {
                arrayList.addAll(revision.getRegions());
            }
            Collections.sort(arrayList, new Comparator(){

                public int compare(Object object, Object object2) {
                    RevisionRange revisionRange = (RevisionRange)object;
                    RevisionRange revisionRange2 = (RevisionRange)object2;
                    return revisionRange.getStartLine() - revisionRange2.getStartLine();
                }
            });
            this.fRanges = Collections.unmodifiableList(arrayList);
        }
        return this.fRanges;
    }

    public void applyDiff(Hunk[] hunkArray) {
        this.fRanges = null;
        Iterator iterator = this.getRevisions().iterator();
        while (iterator.hasNext()) {
            ((Revision)iterator.next()).applyDiff(hunkArray);
        }
    }

    @Override
    public IInformationControlCreator getHoverControlCreator() {
        return this.fHoverControlCreator;
    }

    @Override
    public IInformationControlCreator getInformationPresenterControlCreator() {
        return this.fInformationPresenterControlCreator;
    }

    public void setHoverControlCreator(IInformationControlCreator iInformationControlCreator) {
        this.fHoverControlCreator = iInformationControlCreator;
    }

    public void setInformationPresenterControlCreator(IInformationControlCreator iInformationControlCreator) {
        this.fInformationPresenterControlCreator = iInformationControlCreator;
    }
}

