/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.revisions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.eclipse.jface.internal.text.revisions.ChangeRegion;
import org.eclipse.jface.internal.text.revisions.Hunk;
import org.eclipse.jface.text.revisions.RevisionRange;
import org.eclipse.jface.text.source.ILineRange;
import org.eclipse.swt.graphics.RGB;

public abstract class Revision {
    private final List fChangeRegions = new ArrayList();
    private List fRanges = null;

    protected Revision() {
    }

    public final void addRange(ILineRange iLineRange) throws IndexOutOfBoundsException {
        this.fChangeRegions.add(new ChangeRegion(this, iLineRange));
    }

    public final List getRegions() {
        if (this.fRanges == null) {
            ArrayList<RevisionRange> arrayList = new ArrayList<RevisionRange>(this.fChangeRegions.size());
            for (ChangeRegion changeRegion : this.fChangeRegions) {
                for (ILineRange iLineRange : changeRegion.getAdjustedRanges()) {
                    arrayList.add(new RevisionRange(this, iLineRange));
                }
            }
            this.fRanges = Collections.unmodifiableList(arrayList);
        }
        return this.fRanges;
    }

    final void applyDiff(Hunk[] hunkArray) {
        this.fRanges = null;
        for (ChangeRegion changeRegion : this.fChangeRegions) {
            changeRegion.clearDiff();
            int n = 0;
            while (n < hunkArray.length) {
                Hunk hunk = hunkArray[n];
                changeRegion.adjustTo(hunk);
                ++n;
            }
        }
    }

    public abstract Object getHoverInfo();

    public abstract RGB getColor();

    public abstract String getId();

    public abstract Date getDate();

    public String toString() {
        return "Revision " + this.getId();
    }

    public String getAuthor() {
        return "";
    }
}

