/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.reconciler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.TypedRegion;
import org.eclipse.jface.text.reconciler.AbstractReconciler;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilerExtension;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.IReconcilingStrategyExtension;

public class Reconciler
extends AbstractReconciler
implements IReconcilerExtension {
    private Map fStrategies;
    private String fPartitioning = "__dftl_partitioning";

    public void setDocumentPartitioning(String string) {
        Assert.isNotNull((Object)string);
        this.fPartitioning = string;
    }

    @Override
    public String getDocumentPartitioning() {
        return this.fPartitioning;
    }

    public void setReconcilingStrategy(IReconcilingStrategy iReconcilingStrategy, String string) {
        Assert.isNotNull((Object)string);
        if (this.fStrategies == null) {
            this.fStrategies = new HashMap();
        }
        if (iReconcilingStrategy == null) {
            this.fStrategies.remove(string);
        } else {
            this.fStrategies.put(string, iReconcilingStrategy);
            if (iReconcilingStrategy instanceof IReconcilingStrategyExtension && this.getProgressMonitor() != null) {
                IReconcilingStrategyExtension iReconcilingStrategyExtension = (IReconcilingStrategyExtension)((Object)iReconcilingStrategy);
                iReconcilingStrategyExtension.setProgressMonitor(this.getProgressMonitor());
            }
        }
    }

    @Override
    public IReconcilingStrategy getReconcilingStrategy(String string) {
        Assert.isNotNull((Object)string);
        if (this.fStrategies == null) {
            return null;
        }
        return (IReconcilingStrategy)this.fStrategies.get(string);
    }

    @Override
    protected void process(DirtyRegion dirtyRegion) {
        DirtyRegion dirtyRegion2 = dirtyRegion;
        if (dirtyRegion2 == null) {
            dirtyRegion2 = new Region(0, this.getDocument().getLength());
        }
        ITypedRegion[] iTypedRegionArray = this.computePartitioning(dirtyRegion2.getOffset(), dirtyRegion2.getLength());
        int n = 0;
        while (n < iTypedRegionArray.length) {
            ITypedRegion iTypedRegion = iTypedRegionArray[n];
            IReconcilingStrategy iReconcilingStrategy = this.getReconcilingStrategy(iTypedRegion.getType());
            if (iReconcilingStrategy != null) {
                if (dirtyRegion != null) {
                    iReconcilingStrategy.reconcile(dirtyRegion, (IRegion)iTypedRegion);
                } else {
                    iReconcilingStrategy.reconcile((IRegion)iTypedRegion);
                }
            }
            ++n;
        }
    }

    @Override
    protected void reconcilerDocumentChanged(IDocument iDocument) {
        if (this.fStrategies != null) {
            for (IReconcilingStrategy iReconcilingStrategy : this.fStrategies.values()) {
                iReconcilingStrategy.setDocument(iDocument);
            }
        }
    }

    @Override
    public void setProgressMonitor(IProgressMonitor iProgressMonitor) {
        super.setProgressMonitor(iProgressMonitor);
        if (this.fStrategies != null) {
            for (IReconcilingStrategy iReconcilingStrategy : this.fStrategies.values()) {
                if (!(iReconcilingStrategy instanceof IReconcilingStrategyExtension)) continue;
                IReconcilingStrategyExtension iReconcilingStrategyExtension = (IReconcilingStrategyExtension)((Object)iReconcilingStrategy);
                iReconcilingStrategyExtension.setProgressMonitor(iProgressMonitor);
            }
        }
    }

    @Override
    protected void initialProcess() {
        ITypedRegion[] iTypedRegionArray = this.computePartitioning(0, this.getDocument().getLength());
        ArrayList<String> arrayList = new ArrayList<String>(iTypedRegionArray.length);
        int n = 0;
        while (n < iTypedRegionArray.length) {
            String string = iTypedRegionArray[n].getType();
            if (!arrayList.contains(string)) {
                arrayList.add(string);
                IReconcilingStrategy iReconcilingStrategy = this.getReconcilingStrategy(string);
                if (iReconcilingStrategy instanceof IReconcilingStrategyExtension) {
                    IReconcilingStrategyExtension iReconcilingStrategyExtension = (IReconcilingStrategyExtension)((Object)iReconcilingStrategy);
                    iReconcilingStrategyExtension.initialReconcile();
                }
            }
            ++n;
        }
    }

    private ITypedRegion[] computePartitioning(int n, int n2) {
        TypedRegion[] typedRegionArray = null;
        try {
            typedRegionArray = TextUtilities.computePartitioning((IDocument)this.getDocument(), (String)this.getDocumentPartitioning(), (int)n, (int)n2, (boolean)false);
        }
        catch (BadLocationException badLocationException) {
            typedRegionArray = new TypedRegion[]{};
        }
        return typedRegionArray;
    }
}

