/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.reconciler;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.reconciler.AbstractReconciler;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.IReconcilingStrategyExtension;

public class MonoReconciler
extends AbstractReconciler {
    private IReconcilingStrategy fStrategy;

    public MonoReconciler(IReconcilingStrategy iReconcilingStrategy, boolean bl) {
        Assert.isNotNull((Object)iReconcilingStrategy);
        this.fStrategy = iReconcilingStrategy;
        if (this.fStrategy instanceof IReconcilingStrategyExtension) {
            IReconcilingStrategyExtension iReconcilingStrategyExtension = (IReconcilingStrategyExtension)((Object)this.fStrategy);
            iReconcilingStrategyExtension.setProgressMonitor(this.getProgressMonitor());
        }
        this.setIsIncrementalReconciler(bl);
    }

    @Override
    public IReconcilingStrategy getReconcilingStrategy(String string) {
        Assert.isNotNull((Object)string);
        return this.fStrategy;
    }

    @Override
    protected void process(DirtyRegion dirtyRegion) {
        if (dirtyRegion != null) {
            this.fStrategy.reconcile(dirtyRegion, (IRegion)dirtyRegion);
        } else {
            IDocument iDocument = this.getDocument();
            if (iDocument != null) {
                this.fStrategy.reconcile((IRegion)new Region(0, iDocument.getLength()));
            }
        }
    }

    @Override
    protected void reconcilerDocumentChanged(IDocument iDocument) {
        this.fStrategy.setDocument(iDocument);
    }

    @Override
    public void setProgressMonitor(IProgressMonitor iProgressMonitor) {
        super.setProgressMonitor(iProgressMonitor);
        if (this.fStrategy instanceof IReconcilingStrategyExtension) {
            IReconcilingStrategyExtension iReconcilingStrategyExtension = (IReconcilingStrategyExtension)((Object)this.fStrategy);
            iReconcilingStrategyExtension.setProgressMonitor(iProgressMonitor);
        }
    }

    @Override
    protected void initialProcess() {
        if (this.fStrategy instanceof IReconcilingStrategyExtension) {
            IReconcilingStrategyExtension iReconcilingStrategyExtension = (IReconcilingStrategyExtension)((Object)this.fStrategy);
            iReconcilingStrategyExtension.initialReconcile();
        }
    }
}

