/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.reconciler;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilableModel;
import org.eclipse.jface.text.reconciler.IReconcileResult;
import org.eclipse.jface.text.reconciler.IReconcileStep;

public abstract class AbstractReconcileStep
implements IReconcileStep {
    private IReconcileStep fNextStep;
    private IReconcileStep fPreviousStep;
    private IProgressMonitor fProgressMonitor;
    protected IReconcilableModel fInputModel;

    public AbstractReconcileStep(IReconcileStep iReconcileStep) {
        Assert.isNotNull((Object)iReconcileStep);
        this.fNextStep = iReconcileStep;
        this.fNextStep.setPreviousStep(this);
    }

    public AbstractReconcileStep() {
    }

    @Override
    public boolean isLastStep() {
        return this.fNextStep == null;
    }

    @Override
    public boolean isFirstStep() {
        return this.fPreviousStep == null;
    }

    @Override
    public void setProgressMonitor(IProgressMonitor iProgressMonitor) {
        this.fProgressMonitor = iProgressMonitor;
        if (!this.isLastStep()) {
            this.fNextStep.setProgressMonitor(iProgressMonitor);
        }
    }

    @Override
    public IProgressMonitor getProgressMonitor() {
        return this.fProgressMonitor;
    }

    @Override
    public final IReconcileResult[] reconcile(IRegion iRegion) {
        IReconcileResult[] iReconcileResultArray = this.reconcileModel(null, iRegion);
        if (!this.isLastStep()) {
            this.fNextStep.setInputModel(this.getModel());
            IReconcileResult[] iReconcileResultArray2 = this.fNextStep.reconcile(iRegion);
            return this.merge(iReconcileResultArray, this.convertToInputModel(iReconcileResultArray2));
        }
        return iReconcileResultArray;
    }

    @Override
    public final IReconcileResult[] reconcile(DirtyRegion dirtyRegion, IRegion iRegion) {
        IReconcileResult[] iReconcileResultArray = this.reconcileModel(dirtyRegion, iRegion);
        if (!this.isLastStep()) {
            this.fNextStep.setInputModel(this.getModel());
            IReconcileResult[] iReconcileResultArray2 = this.fNextStep.reconcile(dirtyRegion, iRegion);
            return this.merge(iReconcileResultArray, this.convertToInputModel(iReconcileResultArray2));
        }
        return iReconcileResultArray;
    }

    protected abstract IReconcileResult[] reconcileModel(DirtyRegion var1, IRegion var2);

    protected IReconcileResult[] convertToInputModel(IReconcileResult[] iReconcileResultArray) {
        return iReconcileResultArray;
    }

    private IReconcileResult[] merge(IReconcileResult[] iReconcileResultArray, IReconcileResult[] iReconcileResultArray2) {
        if (iReconcileResultArray == null) {
            return iReconcileResultArray2;
        }
        if (iReconcileResultArray2 == null) {
            return iReconcileResultArray;
        }
        ArrayList<IReconcileResult> arrayList = new ArrayList<IReconcileResult>(Arrays.asList(iReconcileResultArray));
        arrayList.addAll(Arrays.asList(iReconcileResultArray2));
        return arrayList.toArray(new IReconcileResult[arrayList.size()]);
    }

    protected final boolean isCanceled() {
        return this.fProgressMonitor != null && this.fProgressMonitor.isCanceled();
    }

    @Override
    public void setPreviousStep(IReconcileStep iReconcileStep) {
        Assert.isNotNull((Object)iReconcileStep);
        Assert.isTrue((this.fPreviousStep == null ? 1 : 0) != 0);
        this.fPreviousStep = iReconcileStep;
    }

    @Override
    public void setInputModel(IReconcilableModel iReconcilableModel) {
        this.fInputModel = iReconcilableModel;
        if (!this.isLastStep()) {
            this.fNextStep.setInputModel(this.getModel());
        }
    }

    public IReconcilableModel getInputModel() {
        return this.fInputModel;
    }

    public abstract IReconcilableModel getModel();
}

