/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.presentation;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DefaultPositionUpdater;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.DocumentPartitioningChangedEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IDocumentPartitioningListener;
import org.eclipse.jface.text.IDocumentPartitioningListenerExtension;
import org.eclipse.jface.text.IDocumentPartitioningListenerExtension2;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.TypedPosition;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationReconcilerExtension;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.swt.custom.StyleRange;

public class PresentationReconciler
implements IPresentationReconciler,
IPresentationReconcilerExtension {
    protected static final String TRACKED_PARTITION = "__reconciler_tracked_partition";
    private Map fDamagers;
    private Map fRepairers;
    private ITextViewer fViewer;
    private InternalListener fInternalListener = new InternalListener();
    private String fPositionCategory = "__reconciler_tracked_partition" + this.hashCode();
    private IPositionUpdater fPositionUpdater = new DefaultPositionUpdater(this.fPositionCategory);
    private TypedPosition fRememberedPosition;
    private boolean fDocumentPartitioningChanged = false;
    private IRegion fChangedDocumentPartitions = null;
    private String fPartitioning = "__dftl_partitioning";

    public void setDocumentPartitioning(String string) {
        Assert.isNotNull((Object)string);
        this.fPartitioning = string;
    }

    @Override
    public String getDocumentPartitioning() {
        return this.fPartitioning;
    }

    public void setDamager(IPresentationDamager iPresentationDamager, String string) {
        Assert.isNotNull((Object)string);
        if (this.fDamagers == null) {
            this.fDamagers = new HashMap();
        }
        if (iPresentationDamager == null) {
            this.fDamagers.remove(string);
        } else {
            this.fDamagers.put(string, iPresentationDamager);
        }
    }

    public void setRepairer(IPresentationRepairer iPresentationRepairer, String string) {
        Assert.isNotNull((Object)string);
        if (this.fRepairers == null) {
            this.fRepairers = new HashMap();
        }
        if (iPresentationRepairer == null) {
            this.fRepairers.remove(string);
        } else {
            this.fRepairers.put(string, iPresentationRepairer);
        }
    }

    @Override
    public void install(ITextViewer iTextViewer) {
        Assert.isNotNull((Object)iTextViewer);
        this.fViewer = iTextViewer;
        this.fViewer.addTextInputListener(this.fInternalListener);
        IDocument iDocument = iTextViewer.getDocument();
        if (iDocument != null) {
            this.fInternalListener.inputDocumentChanged(null, iDocument);
        }
    }

    @Override
    public void uninstall() {
        this.fViewer.removeTextInputListener(this.fInternalListener);
        this.fInternalListener.inputDocumentAboutToBeChanged(this.fViewer.getDocument(), null);
    }

    @Override
    public IPresentationDamager getDamager(String string) {
        if (this.fDamagers == null) {
            return null;
        }
        return (IPresentationDamager)this.fDamagers.get(string);
    }

    @Override
    public IPresentationRepairer getRepairer(String string) {
        if (this.fRepairers == null) {
            return null;
        }
        return (IPresentationRepairer)this.fRepairers.get(string);
    }

    protected void setDocumentToDamagers(IDocument iDocument) {
        if (this.fDamagers != null) {
            for (IPresentationDamager iPresentationDamager : this.fDamagers.values()) {
                iPresentationDamager.setDocument(iDocument);
            }
        }
    }

    protected void setDocumentToRepairers(IDocument iDocument) {
        if (this.fRepairers != null) {
            for (IPresentationRepairer iPresentationRepairer : this.fRepairers.values()) {
                iPresentationRepairer.setDocument(iDocument);
            }
        }
    }

    protected TextPresentation createPresentation(IRegion iRegion, IDocument iDocument) {
        try {
            if (this.fRepairers == null || this.fRepairers.isEmpty()) {
                TextPresentation textPresentation = new TextPresentation(iRegion, 100);
                textPresentation.setDefaultStyleRange(new StyleRange(iRegion.getOffset(), iRegion.getLength(), null, null));
                return textPresentation;
            }
            TextPresentation textPresentation = new TextPresentation(iRegion, 1000);
            ITypedRegion[] iTypedRegionArray = TextUtilities.computePartitioning((IDocument)iDocument, (String)this.getDocumentPartitioning(), (int)iRegion.getOffset(), (int)iRegion.getLength(), (boolean)false);
            int n = 0;
            while (n < iTypedRegionArray.length) {
                ITypedRegion iTypedRegion = iTypedRegionArray[n];
                IPresentationRepairer iPresentationRepairer = this.getRepairer(iTypedRegion.getType());
                if (iPresentationRepairer != null) {
                    iPresentationRepairer.createPresentation(textPresentation, iTypedRegion);
                }
                ++n;
            }
            return textPresentation;
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    private IRegion getDamage(DocumentEvent documentEvent, boolean bl) {
        ITypedRegion iTypedRegion;
        IPresentationDamager iPresentationDamager;
        IRegion iRegion;
        boolean bl2;
        block8: {
            int n;
            int n2 = n = documentEvent.getText() == null ? 0 : documentEvent.getText().length();
            if (this.fDamagers == null || this.fDamagers.isEmpty()) {
                n = Math.max(documentEvent.getLength(), n);
                n = Math.min(documentEvent.getDocument().getLength() - documentEvent.getOffset(), n);
                return new Region(documentEvent.getOffset(), n);
            }
            bl2 = n == 0;
            iRegion = null;
            try {
                int n3 = documentEvent.getOffset();
                if (bl2) {
                    n3 = Math.max(0, n3 - 1);
                }
                if ((iPresentationDamager = this.getDamager((iTypedRegion = this.getPartition(documentEvent.getDocument(), n3)).getType())) != null) break block8;
                return null;
            }
            catch (BadLocationException badLocationException) {}
        }
        IRegion iRegion2 = iPresentationDamager.getDamageRegion(iTypedRegion, documentEvent, this.fDocumentPartitioningChanged);
        if (!this.fDocumentPartitioningChanged && bl && !bl2) {
            iRegion = iRegion2;
        } else {
            int n = iRegion2.getOffset();
            int n4 = this.getDamageEndOffset(documentEvent);
            if (this.fChangedDocumentPartitions != null) {
                n = Math.min(n, this.fChangedDocumentPartitions.getOffset());
                n4 = Math.max(n4, this.fChangedDocumentPartitions.getOffset() + this.fChangedDocumentPartitions.getLength());
            }
            iRegion = n4 == -1 ? iRegion2 : new Region(n, n4 - n);
        }
        return iRegion;
    }

    private int getDamageEndOffset(DocumentEvent documentEvent) throws BadLocationException {
        IPresentationDamager iPresentationDamager;
        int n;
        ITypedRegion iTypedRegion;
        int n2;
        IDocument iDocument = documentEvent.getDocument();
        int n3 = 0;
        if (documentEvent.getText() != null && (n3 = documentEvent.getText().length()) > 0) {
            --n3;
        }
        if ((n2 = (iTypedRegion = this.getPartition(iDocument, documentEvent.getOffset() + n3)).getOffset() + iTypedRegion.getLength()) == documentEvent.getOffset()) {
            return -1;
        }
        int n4 = n = this.fRememberedPosition == null ? -1 : this.fRememberedPosition.getOffset() + this.fRememberedPosition.getLength();
        if (n2 < n && n < iDocument.getLength()) {
            iTypedRegion = this.getPartition(iDocument, n);
        }
        if ((iPresentationDamager = this.getDamager(iTypedRegion.getType())) == null) {
            return -1;
        }
        IRegion iRegion = iPresentationDamager.getDamageRegion(iTypedRegion, documentEvent, this.fDocumentPartitioningChanged);
        return iRegion.getOffset() + iRegion.getLength();
    }

    private void processDamage(IRegion iRegion, IDocument iDocument) {
        TextPresentation textPresentation;
        if (iRegion != null && iRegion.getLength() > 0 && (textPresentation = this.createPresentation(iRegion, iDocument)) != null) {
            this.applyTextRegionCollection(textPresentation);
        }
    }

    private void applyTextRegionCollection(TextPresentation textPresentation) {
        this.fViewer.changeTextPresentation(textPresentation, false);
    }

    private ITypedRegion getPartition(IDocument iDocument, int n) throws BadLocationException {
        return TextUtilities.getPartition((IDocument)iDocument, (String)this.getDocumentPartitioning(), (int)n, (boolean)false);
    }

    class InternalListener
    implements ITextInputListener,
    IDocumentListener,
    ITextListener,
    IDocumentPartitioningListener,
    IDocumentPartitioningListenerExtension,
    IDocumentPartitioningListenerExtension2 {
        private boolean fDocumentChanging = false;
        private boolean fCachedRedrawState = true;

        InternalListener() {
        }

        @Override
        public void inputDocumentAboutToBeChanged(IDocument iDocument, IDocument iDocument2) {
            if (iDocument != null) {
                try {
                    PresentationReconciler.this.fViewer.removeTextListener(this);
                    iDocument.removeDocumentListener((IDocumentListener)this);
                    iDocument.removeDocumentPartitioningListener((IDocumentPartitioningListener)this);
                    iDocument.removePositionUpdater(PresentationReconciler.this.fPositionUpdater);
                    iDocument.removePositionCategory(PresentationReconciler.this.fPositionCategory);
                }
                catch (BadPositionCategoryException badPositionCategoryException) {}
            }
        }

        @Override
        public void inputDocumentChanged(IDocument iDocument, IDocument iDocument2) {
            this.fDocumentChanging = false;
            this.fCachedRedrawState = true;
            if (iDocument2 != null) {
                iDocument2.addPositionCategory(PresentationReconciler.this.fPositionCategory);
                iDocument2.addPositionUpdater(PresentationReconciler.this.fPositionUpdater);
                iDocument2.addDocumentPartitioningListener((IDocumentPartitioningListener)this);
                iDocument2.addDocumentListener((IDocumentListener)this);
                PresentationReconciler.this.fViewer.addTextListener(this);
                PresentationReconciler.this.setDocumentToDamagers(iDocument2);
                PresentationReconciler.this.setDocumentToRepairers(iDocument2);
                PresentationReconciler.this.processDamage((IRegion)new Region(0, iDocument2.getLength()), iDocument2);
            }
        }

        public void documentPartitioningChanged(IDocument iDocument) {
            if (!this.fDocumentChanging && this.fCachedRedrawState) {
                PresentationReconciler.this.processDamage((IRegion)new Region(0, iDocument.getLength()), iDocument);
            } else {
                PresentationReconciler.this.fDocumentPartitioningChanged = true;
            }
        }

        public void documentPartitioningChanged(IDocument iDocument, IRegion iRegion) {
            if (!this.fDocumentChanging && this.fCachedRedrawState) {
                PresentationReconciler.this.processDamage((IRegion)new Region(iRegion.getOffset(), iRegion.getLength()), iDocument);
            } else {
                PresentationReconciler.this.fDocumentPartitioningChanged = true;
                PresentationReconciler.this.fChangedDocumentPartitions = iRegion;
            }
        }

        public void documentPartitioningChanged(DocumentPartitioningChangedEvent documentPartitioningChangedEvent) {
            IRegion iRegion = documentPartitioningChangedEvent.getChangedRegion(PresentationReconciler.this.getDocumentPartitioning());
            if (iRegion != null) {
                this.documentPartitioningChanged(documentPartitioningChangedEvent.getDocument(), iRegion);
            }
        }

        public void documentAboutToBeChanged(DocumentEvent documentEvent) {
            this.fDocumentChanging = true;
            if (this.fCachedRedrawState) {
                try {
                    int n = documentEvent.getOffset() + documentEvent.getLength();
                    ITypedRegion iTypedRegion = PresentationReconciler.this.getPartition(documentEvent.getDocument(), n);
                    PresentationReconciler.this.fRememberedPosition = new TypedPosition(iTypedRegion);
                    documentEvent.getDocument().addPosition(PresentationReconciler.this.fPositionCategory, (Position)PresentationReconciler.this.fRememberedPosition);
                }
                catch (BadLocationException badLocationException) {
                }
                catch (BadPositionCategoryException badPositionCategoryException) {}
            }
        }

        public void documentChanged(DocumentEvent documentEvent) {
            if (this.fCachedRedrawState) {
                try {
                    documentEvent.getDocument().removePosition(PresentationReconciler.this.fPositionCategory, (Position)PresentationReconciler.this.fRememberedPosition);
                }
                catch (BadPositionCategoryException badPositionCategoryException) {}
            }
            this.fDocumentChanging = false;
        }

        @Override
        public void textChanged(TextEvent textEvent) {
            this.fCachedRedrawState = textEvent.getViewerRedrawState();
            if (!this.fCachedRedrawState) {
                return;
            }
            IRegion iRegion = null;
            IDocument iDocument = null;
            if (textEvent.getDocumentEvent() == null) {
                iDocument = PresentationReconciler.this.fViewer.getDocument();
                if (iDocument != null) {
                    if (textEvent.getOffset() == 0 && textEvent.getLength() == 0 && textEvent.getText() == null) {
                        iRegion = new Region(0, iDocument.getLength());
                    } else {
                        IRegion iRegion2 = this.widgetRegion2ModelRegion(textEvent);
                        if (iRegion2 != null) {
                            try {
                                String string = iDocument.get(iRegion2.getOffset(), iRegion2.getLength());
                                DocumentEvent documentEvent = new DocumentEvent(iDocument, iRegion2.getOffset(), iRegion2.getLength(), string);
                                iRegion = PresentationReconciler.this.getDamage(documentEvent, false);
                            }
                            catch (BadLocationException badLocationException) {}
                        }
                    }
                }
            } else {
                DocumentEvent documentEvent = textEvent.getDocumentEvent();
                iDocument = documentEvent.getDocument();
                iRegion = PresentationReconciler.this.getDamage(documentEvent, true);
            }
            if (iRegion != null && iDocument != null) {
                PresentationReconciler.this.processDamage(iRegion, iDocument);
            }
            PresentationReconciler.this.fDocumentPartitioningChanged = false;
            PresentationReconciler.this.fChangedDocumentPartitions = null;
        }

        protected IRegion widgetRegion2ModelRegion(TextEvent textEvent) {
            int n;
            String string = textEvent.getText();
            int n2 = n = string == null ? 0 : string.length();
            if (PresentationReconciler.this.fViewer instanceof ITextViewerExtension5) {
                ITextViewerExtension5 iTextViewerExtension5 = (ITextViewerExtension5)((Object)PresentationReconciler.this.fViewer);
                return iTextViewerExtension5.widgetRange2ModelRange((IRegion)new Region(textEvent.getOffset(), n));
            }
            IRegion iRegion = PresentationReconciler.this.fViewer.getVisibleRegion();
            Region region = new Region(textEvent.getOffset() + iRegion.getOffset(), n);
            return region;
        }
    }
}

