/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.link;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.NoSuchElementException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.link.LinkedPosition;

class TabStopIterator {
    private static final Comparator fComparator = new SequenceComparator();
    private final ArrayList fList;
    private int fSize;
    private int fIndex;
    private boolean fIsCycling = false;

    TabStopIterator(List list) {
        Assert.isNotNull((Object)list);
        this.fList = new ArrayList(list);
        Collections.sort(this.fList, fComparator);
        this.fSize = this.fList.size();
        this.fIndex = -1;
        Assert.isTrue((this.fSize > 0 ? 1 : 0) != 0);
    }

    boolean hasNext(LinkedPosition linkedPosition) {
        return this.getNextIndex(linkedPosition) != this.fSize;
    }

    private int getNextIndex(LinkedPosition linkedPosition) {
        if (linkedPosition != null && this.fList.get(this.fIndex) != linkedPosition) {
            return this.findNext(linkedPosition);
        }
        if (this.fIsCycling && this.fIndex == this.fSize - 1) {
            return 0;
        }
        return this.fIndex + 1;
    }

    private int findNext(LinkedPosition linkedPosition) {
        Assert.isNotNull((Object)linkedPosition);
        int n = this.fList.indexOf(linkedPosition);
        if (n != -1) {
            if (this.fIsCycling && n == this.fSize - 1) {
                return 0;
            }
            return n + 1;
        }
        LinkedPosition linkedPosition2 = null;
        for (LinkedPosition linkedPosition3 : this.fList) {
            if (linkedPosition3.offset <= linkedPosition.offset || linkedPosition2 != null && linkedPosition2.offset <= linkedPosition3.offset) continue;
            linkedPosition2 = linkedPosition3;
        }
        if (linkedPosition2 != null) {
            return this.fList.indexOf(linkedPosition2);
        }
        if (this.fIsCycling) {
            return 0;
        }
        return this.fSize;
    }

    boolean hasPrevious(LinkedPosition linkedPosition) {
        return this.getPreviousIndex(linkedPosition) != -1;
    }

    private int getPreviousIndex(LinkedPosition linkedPosition) {
        if (linkedPosition != null && this.fList.get(this.fIndex) != linkedPosition) {
            return this.findPrevious(linkedPosition);
        }
        if (this.fIsCycling && this.fIndex == 0) {
            return this.fSize - 1;
        }
        return this.fIndex - 1;
    }

    private int findPrevious(LinkedPosition linkedPosition) {
        Assert.isNotNull((Object)linkedPosition);
        int n = this.fList.indexOf(linkedPosition);
        if (n != -1) {
            if (this.fIsCycling && n == 0) {
                return this.fSize - 1;
            }
            return n - 1;
        }
        LinkedPosition linkedPosition2 = null;
        for (LinkedPosition linkedPosition3 : this.fList) {
            if (linkedPosition3.offset >= linkedPosition.offset || linkedPosition2 != null && linkedPosition2.offset >= linkedPosition3.offset) continue;
            linkedPosition2 = linkedPosition3;
        }
        if (linkedPosition2 != null) {
            return this.fList.indexOf(linkedPosition2);
        }
        if (this.fIsCycling) {
            return this.fSize - 1;
        }
        return -1;
    }

    LinkedPosition next(LinkedPosition linkedPosition) {
        if (!this.hasNext(linkedPosition)) {
            throw new NoSuchElementException();
        }
        this.fIndex = this.getNextIndex(linkedPosition);
        return (LinkedPosition)this.fList.get(this.fIndex);
    }

    LinkedPosition previous(LinkedPosition linkedPosition) {
        if (!this.hasPrevious(linkedPosition)) {
            throw new NoSuchElementException();
        }
        this.fIndex = this.getPreviousIndex(linkedPosition);
        return (LinkedPosition)this.fList.get(this.fIndex);
    }

    void setCycling(boolean bl) {
        this.fIsCycling = bl;
    }

    void addPosition(Position position) {
        this.fList.add(this.fSize++, position);
        Collections.sort(this.fList, fComparator);
    }

    void removePosition(Position position) {
        if (this.fList.remove(position)) {
            --this.fSize;
        }
    }

    boolean isCycling() {
        return this.fIsCycling;
    }

    LinkedPosition[] getPositions() {
        return this.fList.toArray(new LinkedPosition[this.fSize]);
    }

    private static class SequenceComparator
    implements Comparator {
        private SequenceComparator() {
        }

        public int compare(Object object, Object object2) {
            LinkedPosition linkedPosition = (LinkedPosition)object;
            LinkedPosition linkedPosition2 = (LinkedPosition)object2;
            int n = linkedPosition.getSequenceNumber() - linkedPosition2.getSequenceNumber();
            if (n != 0) {
                return n;
            }
            return linkedPosition.getOffset() - linkedPosition2.getOffset();
        }
    }
}

