/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.link;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModel;

final class LinkedPositionAnnotations
extends AnnotationModel {
    private static final String TARGET_ANNOTATION_TYPE = "org.eclipse.ui.internal.workbench.texteditor.link.target";
    private static final String SLAVE_ANNOTATION_TYPE = "org.eclipse.ui.internal.workbench.texteditor.link.slave";
    private static final String FOCUS_ANNOTATION_TYPE = "org.eclipse.ui.internal.workbench.texteditor.link.master";
    private static final String EXIT_ANNOTATION_TYPE = "org.eclipse.ui.internal.workbench.texteditor.link.exit";
    private boolean fMarkTargets = true;
    private boolean fMarkSlaves = true;
    private boolean fMarkFocus = true;
    private boolean fMarkExitTarget = true;
    private Annotation fFocusAnnotation = null;
    private Annotation fExitAnnotation = null;
    private final Map fGroupAnnotations = new HashMap();
    private final Map fTargetAnnotations = new HashMap();
    private Position[] fTargets = new Position[0];
    private LinkedPosition fExitPosition = null;

    LinkedPositionAnnotations() {
    }

    private void setFocusPosition(Position position) throws BadLocationException {
        if (this.fMarkFocus && this.getPosition(this.fFocusAnnotation) != position) {
            this.removeAnnotation(this.fFocusAnnotation, false);
            if (position != null) {
                this.fFocusAnnotation = new Annotation(FOCUS_ANNOTATION_TYPE, false, "");
                this.addAnnotation(this.fFocusAnnotation, position, false);
            } else {
                this.fFocusAnnotation = null;
            }
        }
    }

    private void setExitPosition(Position position) throws BadLocationException {
        if (this.fMarkExitTarget && this.getPosition(this.fExitAnnotation) != position) {
            this.removeAnnotation(this.fExitAnnotation, false);
            if (position != null) {
                this.fExitAnnotation = new Annotation(EXIT_ANNOTATION_TYPE, false, "");
                this.addAnnotation(this.fExitAnnotation, position, false);
            } else {
                this.fExitAnnotation = null;
            }
        }
    }

    private void setGroupPositions(List list) throws BadLocationException {
        if (!this.fMarkSlaves) {
            return;
        }
        ArrayList arrayList = new ArrayList(this.fGroupAnnotations.values());
        HashMap<Annotation, Position> hashMap = new HashMap<Annotation, Position>();
        if (list != null) {
            for (Position position : list) {
                if (this.fGroupAnnotations.containsKey(position)) {
                    arrayList.remove(this.fGroupAnnotations.get(position));
                    continue;
                }
                Annotation annotation = new Annotation(SLAVE_ANNOTATION_TYPE, false, "");
                hashMap.put(annotation, position);
                this.fGroupAnnotations.put(position, annotation);
            }
        }
        this.fGroupAnnotations.values().removeAll(arrayList);
        this.replaceAnnotations(arrayList.toArray(new Annotation[0]), hashMap, false);
    }

    private void setTargetPositions(List list) throws BadLocationException {
        if (!this.fMarkTargets) {
            return;
        }
        ArrayList arrayList = new ArrayList(this.fTargetAnnotations.values());
        HashMap<Annotation, Position> hashMap = new HashMap<Annotation, Position>();
        if (list != null) {
            for (Position position : list) {
                if (this.fTargetAnnotations.containsKey(position)) {
                    arrayList.remove(this.fTargetAnnotations.get(position));
                    continue;
                }
                Annotation annotation = new Annotation(TARGET_ANNOTATION_TYPE, false, "");
                hashMap.put(annotation, position);
                this.fTargetAnnotations.put(position, annotation);
            }
        }
        this.fTargetAnnotations.values().removeAll(arrayList);
        this.replaceAnnotations(arrayList.toArray(new Annotation[0]), hashMap, false);
    }

    public void switchToPosition(LinkedModeModel linkedModeModel, LinkedPosition linkedPosition) {
        LinkedPosition linkedPosition2;
        if (this.fDocument == null || linkedPosition != null && this.getPosition(this.fFocusAnnotation) == linkedPosition || linkedPosition == null && this.fFocusAnnotation == null) {
            return;
        }
        LinkedPositionGroup linkedPositionGroup = null;
        if (linkedPosition != null) {
            linkedPositionGroup = linkedModeModel.getGroupForPosition((Position)linkedPosition);
        }
        ArrayList<Position> arrayList = new ArrayList<Position>();
        arrayList.addAll(Arrays.asList(this.fTargets));
        ArrayList<Object> arrayList2 = linkedPositionGroup != null ? new ArrayList<LinkedPosition>(Arrays.asList(linkedPositionGroup.getPositions())) : new ArrayList();
        if (linkedPosition == null || !this.fDocument.equals(linkedPosition.getDocument())) {
            linkedPosition = null;
        }
        if ((linkedPosition2 = this.fExitPosition) == null || !this.fDocument.equals(linkedPosition2.getDocument())) {
            linkedPosition2 = null;
        }
        if (linkedPosition2 != null) {
            arrayList2.remove(linkedPosition2);
            arrayList.remove(linkedPosition2);
        }
        arrayList2.removeAll(arrayList);
        arrayList.remove(linkedPosition);
        arrayList2.remove(linkedPosition);
        this.prune(arrayList);
        this.prune(arrayList2);
        try {
            this.setFocusPosition((Position)linkedPosition);
            this.setExitPosition((Position)linkedPosition2);
            this.setGroupPositions(arrayList2);
            this.setTargetPositions(arrayList);
        }
        catch (BadLocationException badLocationException) {
            Assert.isTrue((boolean)false);
        }
        this.fireModelChanged();
    }

    private void prune(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            LinkedPosition linkedPosition = (LinkedPosition)iterator.next();
            if (linkedPosition.getDocument().equals(this.fDocument)) continue;
            iterator.remove();
        }
    }

    public void setTargets(Position[] positionArray) {
        this.fTargets = positionArray;
    }

    public void setExitTarget(LinkedPosition linkedPosition) {
        this.fExitPosition = linkedPosition;
    }

    protected void addPosition(IDocument iDocument, Position position) {
    }

    protected void removePosition(IDocument iDocument, Position position) {
    }

    public void fireModelChanged() {
        super.fireModelChanged();
    }

    public void markExitTarget(boolean bl) {
        this.fMarkExitTarget = bl;
    }

    public void markFocus(boolean bl) {
        this.fMarkFocus = bl;
    }

    public void markSlaves(boolean bl) {
        this.fMarkSlaves = bl;
    }

    public void markTargets(boolean bl) {
        this.fMarkTargets = bl;
    }
}

