/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.link;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.internal.text.link.contentassist.ContentAssistant2;
import org.eclipse.jface.internal.text.link.contentassist.IProposalListener;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DefaultPositionUpdater;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IEditingSupport;
import org.eclipse.jface.text.IEditingSupportRegistry;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.IRewriteTarget;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.jface.text.ITextViewerExtension2;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.link.ILinkedModeListener;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionAnnotations;
import org.eclipse.jface.text.link.ProposalPosition;
import org.eclipse.jface.text.link.TabStopIterator;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class LinkedModeUI {
    public static final Object CYCLE_NEVER = new Object();
    public static final Object CYCLE_ALWAYS = new Object();
    public static final Object CYCLE_WHEN_NO_PARENT = new Object();
    private LinkedModeUITarget fCurrentTarget;
    private LinkedModeModel fModel;
    private LinkedModeUITarget[] fTargets;
    private TabStopIterator fIterator;
    private Closer fCloser = new Closer();
    private ILinkedModeListener fLinkedListener = new ExitListener();
    private MySelectionListener fSelectionListener = new MySelectionListener();
    private ProposalListener fProposalListener = new ProposalListener();
    private IDocumentListener fDocumentListener = new DocumentListener();
    private final Position fCaretPosition = new Position(0, 0);
    private IExitPolicy fExitPolicy = new NullExitPolicy();
    private LinkedPosition fFramePosition;
    private LinkedPosition fPreviousPosition;
    private ContentAssistant2 fAssistant;
    private LinkedPosition fExitPosition;
    private boolean fIsActive = false;
    private IPositionUpdater fPositionUpdater = new DefaultPositionUpdater(this.getCategory());
    private boolean fDoContextInfo = false;
    private boolean fHasOpenCompoundChange = false;
    private ILinkedModeUIFocusListener fPositionListener = new EmtpyFocusListener();
    private IAutoEditStrategy fAutoEditVetoer = new IAutoEditStrategy(){

        @Override
        public void customizeDocumentCommand(IDocument iDocument, DocumentCommand documentCommand) {
            if (LinkedModeUI.this.fModel.anyPositionContains(documentCommand.offset)) {
                documentCommand.doit = false;
                documentCommand.caretOffset = documentCommand.offset + documentCommand.length;
            }
        }
    };
    private boolean fSimple;

    public LinkedModeUI(LinkedModeModel linkedModeModel, LinkedModeUITarget[] linkedModeUITargetArray) {
        this.constructor(linkedModeModel, linkedModeUITargetArray);
    }

    public LinkedModeUI(LinkedModeModel linkedModeModel, ITextViewer iTextViewer) {
        this.constructor(linkedModeModel, new LinkedModeUITarget[]{new EmptyTarget(iTextViewer)});
    }

    public LinkedModeUI(LinkedModeModel linkedModeModel, ITextViewer[] iTextViewerArray) {
        LinkedModeUITarget[] linkedModeUITargetArray = new LinkedModeUITarget[iTextViewerArray.length];
        int n = 0;
        while (n < linkedModeUITargetArray.length) {
            linkedModeUITargetArray[n] = new EmptyTarget(iTextViewerArray[n]);
            ++n;
        }
        this.constructor(linkedModeModel, linkedModeUITargetArray);
    }

    public LinkedModeUI(LinkedModeModel linkedModeModel, LinkedModeUITarget linkedModeUITarget) {
        this.constructor(linkedModeModel, new LinkedModeUITarget[]{linkedModeUITarget});
    }

    private void constructor(LinkedModeModel linkedModeModel, LinkedModeUITarget[] linkedModeUITargetArray) {
        Assert.isNotNull((Object)linkedModeModel);
        Assert.isNotNull((Object)linkedModeUITargetArray);
        Assert.isTrue((linkedModeUITargetArray.length > 0 ? 1 : 0) != 0);
        Assert.isTrue((linkedModeModel.getTabStopSequence().size() > 0 ? 1 : 0) != 0);
        this.fModel = linkedModeModel;
        this.fTargets = linkedModeUITargetArray;
        this.fCurrentTarget = linkedModeUITargetArray[0];
        this.fIterator = new TabStopIterator(this.fModel.getTabStopSequence());
        this.fIterator.setCycling(!this.fModel.isNested());
        this.fModel.addLinkingListener(this.fLinkedListener);
        this.fAssistant = new ContentAssistant2();
        this.fAssistant.addProposalListener(this.fProposalListener);
        this.fCaretPosition.delete();
    }

    public void enter() {
        this.fIsActive = true;
        this.connect();
        this.next();
    }

    public void setExitPolicy(IExitPolicy iExitPolicy) {
        this.fExitPolicy = iExitPolicy;
    }

    public void setExitPosition(LinkedModeUITarget linkedModeUITarget, int n, int n2, int n3) throws BadLocationException {
        IDocument iDocument;
        if (this.fExitPosition != null) {
            this.fExitPosition.getDocument().removePosition((Position)this.fExitPosition);
            this.fIterator.removePosition((Position)this.fExitPosition);
            this.fExitPosition = null;
        }
        if ((iDocument = linkedModeUITarget.getViewer().getDocument()) == null) {
            return;
        }
        this.fExitPosition = new LinkedPosition(iDocument, n, n2, n3);
        iDocument.addPosition((Position)this.fExitPosition);
        if (n3 != -1) {
            this.fIterator.addPosition((Position)this.fExitPosition);
        }
    }

    public void setExitPosition(ITextViewer iTextViewer, int n, int n2, int n3) throws BadLocationException {
        this.setExitPosition(new EmptyTarget(iTextViewer), n, n2, n3);
    }

    public void setCyclingMode(Object object) {
        if (object != CYCLE_ALWAYS && object != CYCLE_NEVER && object != CYCLE_WHEN_NO_PARENT) {
            throw new IllegalArgumentException();
        }
        if (object == CYCLE_ALWAYS || object == CYCLE_WHEN_NO_PARENT && !this.fModel.isNested()) {
            this.fIterator.setCycling(true);
        } else {
            this.fIterator.setCycling(false);
        }
    }

    void next() {
        if (this.fIterator.hasNext(this.fFramePosition)) {
            this.switchPosition(this.fIterator.next(this.fFramePosition), true, true);
            return;
        }
        this.leave(2);
    }

    void previous() {
        if (this.fIterator.hasPrevious(this.fFramePosition)) {
            this.switchPosition(this.fIterator.previous(this.fFramePosition), true, true);
        } else {
            this.leave(4);
        }
    }

    private void triggerContextInfo() {
        this.fAssistant.showContextInformation();
    }

    private void triggerContentAssist() {
        ProposalPosition proposalPosition;
        ICompletionProposal[] iCompletionProposalArray;
        if (this.fFramePosition instanceof ProposalPosition && (iCompletionProposalArray = (proposalPosition = (ProposalPosition)this.fFramePosition).getChoices()) != null && iCompletionProposalArray.length > 0) {
            this.fAssistant.setCompletions(iCompletionProposalArray);
            this.fAssistant.showPossibleCompletions();
            return;
        }
        this.fAssistant.setCompletions(new ICompletionProposal[0]);
        this.fAssistant.hidePossibleCompletions();
    }

    private void switchPosition(LinkedPosition linkedPosition, boolean bl, boolean bl2) {
        Assert.isNotNull((Object)linkedPosition);
        if (linkedPosition.equals((Object)this.fFramePosition)) {
            return;
        }
        if (this.fFramePosition != null && this.fCurrentTarget != null) {
            this.fPositionListener.linkingFocusLost(this.fFramePosition, this.fCurrentTarget);
        }
        this.endCompoundChangeIfNeeded();
        this.redraw();
        IDocument iDocument = this.fFramePosition == null ? null : this.fFramePosition.getDocument();
        IDocument iDocument2 = linkedPosition.getDocument();
        this.switchViewer(iDocument, iDocument2, linkedPosition);
        this.fFramePosition = linkedPosition;
        if (bl) {
            this.select();
        }
        if (this.fFramePosition == this.fExitPosition && !this.fIterator.isCycling()) {
            this.leave(0);
        } else {
            this.redraw();
            this.ensureAnnotationModelInstalled();
        }
        if (bl2) {
            this.triggerContentAssist();
        }
        if (this.fFramePosition != this.fExitPosition && this.fDoContextInfo) {
            this.triggerContextInfo();
        }
        if (this.fFramePosition != null && this.fCurrentTarget != null) {
            this.fPositionListener.linkingFocusGained(this.fFramePosition, this.fCurrentTarget);
        }
    }

    private void ensureAnnotationModelInstalled() {
        IAnnotationModelExtension iAnnotationModelExtension;
        IAnnotationModel iAnnotationModel;
        ISourceViewer iSourceViewer;
        IAnnotationModel iAnnotationModel2;
        ITextViewer iTextViewer;
        LinkedPositionAnnotations linkedPositionAnnotations = this.fCurrentTarget.fAnnotationModel;
        if (linkedPositionAnnotations != null && (iTextViewer = this.fCurrentTarget.getViewer()) instanceof ISourceViewer && (iAnnotationModel2 = (iSourceViewer = (ISourceViewer)iTextViewer).getAnnotationModel()) instanceof IAnnotationModelExtension && (iAnnotationModel = (iAnnotationModelExtension = (IAnnotationModelExtension)iAnnotationModel2).getAnnotationModel((Object)this.getUniqueKey())) == null) {
            iAnnotationModelExtension.addAnnotationModel((Object)this.getUniqueKey(), (IAnnotationModel)linkedPositionAnnotations);
        }
    }

    private void uninstallAnnotationModel(LinkedModeUITarget linkedModeUITarget) {
        ISourceViewer iSourceViewer;
        IAnnotationModel iAnnotationModel;
        ITextViewer iTextViewer = linkedModeUITarget.getViewer();
        if (iTextViewer instanceof ISourceViewer && (iAnnotationModel = (iSourceViewer = (ISourceViewer)iTextViewer).getAnnotationModel()) instanceof IAnnotationModelExtension) {
            IAnnotationModelExtension iAnnotationModelExtension = (IAnnotationModelExtension)iAnnotationModel;
            iAnnotationModelExtension.removeAnnotationModel((Object)this.getUniqueKey());
        }
    }

    private void switchViewer(IDocument iDocument, IDocument iDocument2, LinkedPosition linkedPosition) {
        if (iDocument != iDocument2) {
            if (this.fCurrentTarget.fAnnotationModel != null) {
                this.fCurrentTarget.fAnnotationModel.switchToPosition(this.fModel, linkedPosition);
            }
            LinkedModeUITarget linkedModeUITarget = null;
            int n = 0;
            while (n < this.fTargets.length) {
                if (this.fTargets[n].getViewer().getDocument() == iDocument2) {
                    linkedModeUITarget = this.fTargets[n];
                    break;
                }
                ++n;
            }
            if (linkedModeUITarget != this.fCurrentTarget) {
                this.disconnect();
                this.fCurrentTarget = linkedModeUITarget;
                linkedModeUITarget.linkingFocusLost(this.fFramePosition, linkedModeUITarget);
                this.connect();
                this.ensureAnnotationModelInstalled();
                if (this.fCurrentTarget != null) {
                    this.fCurrentTarget.linkingFocusGained(linkedPosition, this.fCurrentTarget);
                }
            }
        }
    }

    private void select() {
        ITextViewer iTextViewer = this.fCurrentTarget.getViewer();
        if (iTextViewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 iTextViewerExtension5 = (ITextViewerExtension5)((Object)iTextViewer);
            iTextViewerExtension5.exposeModelRange((IRegion)new Region(this.fFramePosition.offset, this.fFramePosition.length));
        } else if (!iTextViewer.overlapsWithVisibleRegion(this.fFramePosition.offset, this.fFramePosition.length)) {
            iTextViewer.resetVisibleRegion();
        }
        iTextViewer.revealRange(this.fFramePosition.offset, this.fFramePosition.length);
        iTextViewer.setSelectedRange(this.fFramePosition.offset, this.fFramePosition.length);
    }

    private void redraw() {
        if (this.fCurrentTarget.fAnnotationModel != null) {
            this.fCurrentTarget.fAnnotationModel.switchToPosition(this.fModel, this.fFramePosition);
        }
    }

    private void connect() {
        Assert.isNotNull((Object)this.fCurrentTarget);
        ITextViewer iTextViewer = this.fCurrentTarget.getViewer();
        Assert.isNotNull((Object)iTextViewer);
        this.fCurrentTarget.fWidget = iTextViewer.getTextWidget();
        if (this.fCurrentTarget.fWidget == null) {
            this.leave(1);
        }
        if (this.fCurrentTarget.fKeyListener == null) {
            this.fCurrentTarget.fKeyListener = new KeyListener();
            ((ITextViewerExtension)((Object)iTextViewer)).prependVerifyKeyListener(this.fCurrentTarget.fKeyListener);
        } else {
            this.fCurrentTarget.fKeyListener.setEnabled(true);
        }
        this.registerAutoEditVetoer(iTextViewer);
        ((IPostSelectionProvider)iTextViewer).addPostSelectionChangedListener((ISelectionChangedListener)this.fSelectionListener);
        this.createAnnotationModel();
        this.showSelection();
        this.fCurrentTarget.fShell = this.fCurrentTarget.fWidget.getShell();
        if (this.fCurrentTarget.fShell == null) {
            this.leave(1);
        }
        this.fCurrentTarget.fShell.addShellListener((ShellListener)this.fCloser);
        this.fAssistant.install(iTextViewer);
        iTextViewer.addTextInputListener(this.fCloser);
        iTextViewer.getDocument().addDocumentListener(this.fDocumentListener);
    }

    private void showSelection() {
        final StyledText styledText = this.fCurrentTarget.fWidget;
        if (styledText == null || styledText.isDisposed()) {
            return;
        }
        styledText.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!styledText.isDisposed()) {
                    try {
                        styledText.showSelection();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                }
            }
        });
    }

    private void registerAutoEditVetoer(ITextViewer iTextViewer) {
        try {
            String[] stringArray = this.getContentTypes(iTextViewer.getDocument());
            if (iTextViewer instanceof ITextViewerExtension2) {
                ITextViewerExtension2 iTextViewerExtension2 = (ITextViewerExtension2)((Object)iTextViewer);
                int n = 0;
                while (n < stringArray.length) {
                    iTextViewerExtension2.prependAutoEditStrategy(this.fAutoEditVetoer, stringArray[n]);
                    ++n;
                }
            } else {
                Assert.isTrue((boolean)false);
            }
        }
        catch (BadPartitioningException badPartitioningException) {
            this.leave(1);
        }
    }

    private void unregisterAutoEditVetoer(ITextViewer iTextViewer) {
        try {
            String[] stringArray = this.getContentTypes(iTextViewer.getDocument());
            if (iTextViewer instanceof ITextViewerExtension2) {
                ITextViewerExtension2 iTextViewerExtension2 = (ITextViewerExtension2)((Object)iTextViewer);
                int n = 0;
                while (n < stringArray.length) {
                    iTextViewerExtension2.removeAutoEditStrategy(this.fAutoEditVetoer, stringArray[n]);
                    ++n;
                }
            } else {
                Assert.isTrue((boolean)false);
            }
        }
        catch (BadPartitioningException badPartitioningException) {
            this.leave(1);
        }
    }

    private String[] getContentTypes(IDocument iDocument) throws BadPartitioningException {
        if (iDocument instanceof IDocumentExtension3) {
            IDocumentExtension3 iDocumentExtension3 = (IDocumentExtension3)iDocument;
            String[] stringArray = iDocumentExtension3.getPartitionings();
            HashSet<String> hashSet = new HashSet<String>(20);
            int n = 0;
            while (n < stringArray.length) {
                hashSet.addAll(Arrays.asList(iDocumentExtension3.getLegalContentTypes(stringArray[n])));
                ++n;
            }
            hashSet.add("__dftl_partition_content_type");
            return hashSet.toArray(new String[hashSet.size()]);
        }
        return iDocument.getLegalContentTypes();
    }

    private void createAnnotationModel() {
        if (this.fCurrentTarget.fAnnotationModel == null) {
            LinkedPositionAnnotations linkedPositionAnnotations = new LinkedPositionAnnotations();
            if (this.fSimple) {
                linkedPositionAnnotations.markExitTarget(true);
                linkedPositionAnnotations.markFocus(false);
                linkedPositionAnnotations.markSlaves(false);
                linkedPositionAnnotations.markTargets(false);
            }
            linkedPositionAnnotations.setTargets((Position[])this.fIterator.getPositions());
            linkedPositionAnnotations.setExitTarget(this.fExitPosition);
            linkedPositionAnnotations.connect(this.fCurrentTarget.getViewer().getDocument());
            this.fCurrentTarget.fAnnotationModel = linkedPositionAnnotations;
        }
    }

    private String getUniqueKey() {
        return "linked.annotationmodelkey." + this.toString();
    }

    private void disconnect() {
        Assert.isNotNull((Object)this.fCurrentTarget);
        ITextViewer iTextViewer = this.fCurrentTarget.getViewer();
        Assert.isNotNull((Object)iTextViewer);
        iTextViewer.getDocument().removeDocumentListener(this.fDocumentListener);
        this.fAssistant.uninstall();
        this.fAssistant.removeProposalListener(this.fProposalListener);
        this.fCurrentTarget.fWidget = null;
        Shell shell = this.fCurrentTarget.fShell;
        this.fCurrentTarget.fShell = null;
        if (shell != null && !shell.isDisposed()) {
            shell.removeShellListener((ShellListener)this.fCloser);
        }
        this.uninstallAnnotationModel(this.fCurrentTarget);
        this.unregisterAutoEditVetoer(iTextViewer);
        if (this.fCurrentTarget.fKeyListener != null) {
            this.fCurrentTarget.fKeyListener.setEnabled(false);
        }
        ((IPostSelectionProvider)iTextViewer).removePostSelectionChangedListener((ISelectionChangedListener)this.fSelectionListener);
        this.redraw();
    }

    void leave(final int n) {
        ITextViewer iTextViewer;
        if (!this.fIsActive) {
            return;
        }
        this.fIsActive = false;
        this.endCompoundChangeIfNeeded();
        Display display = null;
        if (this.fCurrentTarget.fWidget != null && !this.fCurrentTarget.fWidget.isDisposed()) {
            display = this.fCurrentTarget.fWidget.getDisplay();
        }
        if (this.fCurrentTarget.fAnnotationModel != null) {
            this.fCurrentTarget.fAnnotationModel.removeAllAnnotations();
        }
        this.disconnect();
        int n2 = 0;
        while (n2 < this.fTargets.length) {
            LinkedModeUITarget linkedModeUITarget = this.fTargets[n2];
            iTextViewer = linkedModeUITarget.getViewer();
            if (linkedModeUITarget.fKeyListener != null) {
                ((ITextViewerExtension)((Object)iTextViewer)).removeVerifyKeyListener(linkedModeUITarget.fKeyListener);
                linkedModeUITarget.fKeyListener = null;
            }
            iTextViewer.removeTextInputListener(this.fCloser);
            ++n2;
        }
        n2 = 0;
        while (n2 < this.fTargets.length) {
            if (this.fTargets[n2].fAnnotationModel != null) {
                this.fTargets[n2].fAnnotationModel.removeAllAnnotations();
                this.fTargets[n2].fAnnotationModel.disconnect(this.fTargets[n2].getViewer().getDocument());
                this.fTargets[n2].fAnnotationModel = null;
            }
            this.uninstallAnnotationModel(this.fTargets[n2]);
            ++n2;
        }
        if ((n & 2) != 0 && this.fExitPosition != null && this.fFramePosition != this.fExitPosition && !this.fExitPosition.isDeleted()) {
            this.switchPosition(this.fExitPosition, true, false);
        }
        final ArrayList<ITextViewer> arrayList = new ArrayList<ITextViewer>();
        int n3 = 0;
        while (n3 < this.fTargets.length) {
            iTextViewer = this.fTargets[n3].getViewer().getDocument();
            if (iTextViewer != null) {
                arrayList.add(iTextViewer);
            }
            ++n3;
        }
        this.fModel.stopForwarding(n);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (LinkedModeUI.this.fExitPosition != null) {
                    LinkedModeUI.this.fExitPosition.getDocument().removePosition((Position)LinkedModeUI.this.fExitPosition);
                }
                for (IDocument iDocument : arrayList) {
                    iDocument.removePositionUpdater(LinkedModeUI.this.fPositionUpdater);
                    boolean bl = false;
                    String[] stringArray = iDocument.getPositionCategories();
                    int n2 = 0;
                    while (n2 < stringArray.length) {
                        if (LinkedModeUI.this.getCategory().equals(stringArray[n2])) {
                            bl = true;
                            break;
                        }
                        ++n2;
                    }
                    if (!bl) continue;
                    try {
                        iDocument.removePositionCategory(LinkedModeUI.this.getCategory());
                    }
                    catch (BadPositionCategoryException badPositionCategoryException) {}
                }
                LinkedModeUI.this.fModel.exit(n);
            }
        };
        if (display != null) {
            display.asyncExec(runnable);
        } else {
            runnable.run();
        }
    }

    private void endCompoundChangeIfNeeded() {
        if (this.fHasOpenCompoundChange) {
            ITextViewerExtension iTextViewerExtension = (ITextViewerExtension)((Object)this.fCurrentTarget.getViewer());
            IRewriteTarget iRewriteTarget = iTextViewerExtension.getRewriteTarget();
            iRewriteTarget.endCompoundChange();
            this.fHasOpenCompoundChange = false;
        }
    }

    private void beginCompoundChangeIfNeeded() {
        if (!this.fHasOpenCompoundChange) {
            ITextViewerExtension iTextViewerExtension = (ITextViewerExtension)((Object)this.fCurrentTarget.getViewer());
            IRewriteTarget iRewriteTarget = iTextViewerExtension.getRewriteTarget();
            iRewriteTarget.beginCompoundChange();
            this.fHasOpenCompoundChange = true;
        }
    }

    public IRegion getSelectedRegion() {
        if (this.fFramePosition != null) {
            return new Region(this.fFramePosition.getOffset(), this.fFramePosition.getLength());
        }
        if (this.fExitPosition != null) {
            return new Region(this.fExitPosition.getOffset(), this.fExitPosition.getLength());
        }
        return null;
    }

    private String getCategory() {
        return this.toString();
    }

    public void setDoContextInfo(boolean bl) {
        this.fDoContextInfo = bl;
    }

    protected void setPositionListener(ILinkedModeUIFocusListener iLinkedModeUIFocusListener) {
        Assert.isNotNull((Object)iLinkedModeUIFocusListener);
        this.fPositionListener = iLinkedModeUIFocusListener;
    }

    public void setSimpleMode(boolean bl) {
        this.fSimple = bl;
    }

    public void enableColoredLabels(boolean bl) {
        this.fAssistant.enableColoredLabels(bl);
    }

    private class Closer
    implements ShellListener,
    ITextInputListener {
        private Closer() {
        }

        public void shellActivated(ShellEvent shellEvent) {
        }

        public void shellClosed(ShellEvent shellEvent) {
            LinkedModeUI.this.leave(1);
        }

        public void shellDeactivated(ShellEvent shellEvent) {
            ITextViewer iTextViewer;
            Display display;
            StyledText styledText;
            if (LinkedModeUI.this.fCurrentTarget == null || (styledText = ((LinkedModeUI)LinkedModeUI.this).fCurrentTarget.fWidget) == null || styledText.isDisposed() || (display = styledText.getDisplay()) == null || display.isDisposed() || (iTextViewer = LinkedModeUI.this.fCurrentTarget.getViewer()) == null) {
                LinkedModeUI.this.leave(1);
            } else {
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (LinkedModeUI.this.fIsActive && iTextViewer instanceof IEditingSupportRegistry) {
                            IEditingSupport[] iEditingSupportArray = ((IEditingSupportRegistry)((Object)iTextViewer)).getRegisteredSupports();
                            int n = 0;
                            while (n < iEditingSupportArray.length) {
                                if (iEditingSupportArray[n].ownsFocusShell()) {
                                    return;
                                }
                                ++n;
                            }
                        }
                        LinkedModeUI.this.leave(1);
                    }
                });
            }
        }

        public void shellDeiconified(ShellEvent shellEvent) {
        }

        public void shellIconified(ShellEvent shellEvent) {
            LinkedModeUI.this.leave(1);
        }

        @Override
        public void inputDocumentAboutToBeChanged(IDocument iDocument, IDocument iDocument2) {
            LinkedModeUI.this.leave(1);
        }

        @Override
        public void inputDocumentChanged(IDocument iDocument, IDocument iDocument2) {
        }
    }

    private class DocumentListener
    implements IDocumentListener {
        private DocumentListener() {
        }

        public void documentAboutToBeChanged(DocumentEvent documentEvent) {
            int n = documentEvent.getOffset() + documentEvent.getLength();
            int n2 = documentEvent.getOffset();
            while (n2 <= n) {
                if (!LinkedModeUI.this.fModel.anyPositionContains(n2)) {
                    ITextViewer iTextViewer = LinkedModeUI.this.fCurrentTarget.getViewer();
                    if (LinkedModeUI.this.fFramePosition != null && iTextViewer instanceof IEditingSupportRegistry) {
                        IEditingSupport[] iEditingSupportArray = ((IEditingSupportRegistry)((Object)iTextViewer)).getRegisteredSupports();
                        int n3 = 0;
                        while (n3 < iEditingSupportArray.length) {
                            if (iEditingSupportArray[n3].isOriginator(null, (IRegion)new Region(LinkedModeUI.this.fFramePosition.getOffset(), LinkedModeUI.this.fFramePosition.getLength()))) {
                                return;
                            }
                            ++n3;
                        }
                    }
                    LinkedModeUI.this.leave(8);
                    return;
                }
                ++n2;
            }
            LinkedModeUI.this.beginCompoundChangeIfNeeded();
        }

        public void documentChanged(DocumentEvent documentEvent) {
        }
    }

    private static final class EmptyTarget
    extends LinkedModeUITarget {
        private ITextViewer fTextViewer;

        public EmptyTarget(ITextViewer iTextViewer) {
            Assert.isNotNull((Object)iTextViewer);
            this.fTextViewer = iTextViewer;
        }

        @Override
        public ITextViewer getViewer() {
            return this.fTextViewer;
        }

        @Override
        public void linkingFocusLost(LinkedPosition linkedPosition, LinkedModeUITarget linkedModeUITarget) {
        }

        @Override
        public void linkingFocusGained(LinkedPosition linkedPosition, LinkedModeUITarget linkedModeUITarget) {
        }
    }

    private static final class EmtpyFocusListener
    implements ILinkedModeUIFocusListener {
        private EmtpyFocusListener() {
        }

        @Override
        public void linkingFocusGained(LinkedPosition linkedPosition, LinkedModeUITarget linkedModeUITarget) {
        }

        @Override
        public void linkingFocusLost(LinkedPosition linkedPosition, LinkedModeUITarget linkedModeUITarget) {
        }
    }

    public static class ExitFlags {
        public int flags;
        public boolean doit;

        public ExitFlags(int n, boolean bl) {
            this.flags = n;
            this.doit = bl;
        }
    }

    private final class ExitListener
    implements ILinkedModeListener {
        private ExitListener() {
        }

        public void left(LinkedModeModel linkedModeModel, int n) {
            LinkedModeUI.this.leave(1 | n);
        }

        public void suspend(LinkedModeModel linkedModeModel) {
            LinkedModeUI.this.disconnect();
            LinkedModeUI.this.redraw();
        }

        public void resume(LinkedModeModel linkedModeModel, int n) {
            if ((n & 1) != 0) {
                LinkedModeUI.this.leave(n);
            } else {
                LinkedModeUI.this.connect();
                if ((n & 4) != 0) {
                    LinkedModeUI.this.select();
                }
                LinkedModeUI.this.ensureAnnotationModelInstalled();
                LinkedModeUI.this.redraw();
            }
        }
    }

    public static interface IExitPolicy {
        public ExitFlags doExit(LinkedModeModel var1, VerifyEvent var2, int var3, int var4);
    }

    public static interface ILinkedModeUIFocusListener {
        public void linkingFocusLost(LinkedPosition var1, LinkedModeUITarget var2);

        public void linkingFocusGained(LinkedPosition var1, LinkedModeUITarget var2);
    }

    private class KeyListener
    implements VerifyKeyListener {
        private boolean fIsEnabled = true;

        private KeyListener() {
        }

        public void verifyKey(VerifyEvent verifyEvent) {
            if (!verifyEvent.doit || !this.fIsEnabled) {
                return;
            }
            Point point = LinkedModeUI.this.fCurrentTarget.getViewer().getSelectedRange();
            int n = point.x;
            int n2 = point.y;
            ExitFlags exitFlags = LinkedModeUI.this.fExitPolicy.doExit(LinkedModeUI.this.fModel, verifyEvent, n, n2);
            if (exitFlags != null) {
                LinkedModeUI.this.leave(exitFlags.flags);
                verifyEvent.doit = exitFlags.doit;
                return;
            }
            switch (verifyEvent.character) {
                case '\t': {
                    if (!(LinkedModeUI.this.fExitPosition != null && LinkedModeUI.this.fExitPosition.includes(n) || LinkedModeUI.this.fModel.anyPositionContains(n))) {
                        LinkedModeUI.this.leave(1);
                        break;
                    }
                    if (verifyEvent.stateMask == 131072) {
                        LinkedModeUI.this.previous();
                    } else {
                        LinkedModeUI.this.next();
                    }
                    verifyEvent.doit = false;
                    break;
                }
                case '\n': 
                case '\r': {
                    if (!LinkedModeUI.this.fModel.anyPositionContains(n)) {
                        LinkedModeUI.this.leave(1);
                        break;
                    }
                    LinkedModeUI.this.leave(3);
                    verifyEvent.doit = false;
                    break;
                }
                case '\u001b': {
                    LinkedModeUI.this.leave(1);
                    verifyEvent.doit = false;
                    break;
                }
                default: {
                    if (verifyEvent.character == '\u0000' || this.controlUndoBehavior(n, n2)) break;
                    LinkedModeUI.this.leave(1);
                }
            }
        }

        private boolean controlUndoBehavior(int n, int n2) {
            LinkedPosition linkedPosition = LinkedModeUI.this.fModel.findPosition(new LinkedPosition(LinkedModeUI.this.fCurrentTarget.getViewer().getDocument(), n, n2, -1));
            if (linkedPosition != null) {
                if (!linkedPosition.equals((Object)LinkedModeUI.this.fPreviousPosition)) {
                    LinkedModeUI.this.endCompoundChangeIfNeeded();
                }
                LinkedModeUI.this.beginCompoundChangeIfNeeded();
            }
            LinkedModeUI.this.fPreviousPosition = linkedPosition;
            return LinkedModeUI.this.fPreviousPosition != null;
        }

        public void setEnabled(boolean bl) {
            this.fIsEnabled = bl;
        }
    }

    public static abstract class LinkedModeUITarget
    implements ILinkedModeUIFocusListener {
        StyledText fWidget;
        Shell fShell;
        KeyListener fKeyListener;
        LinkedPositionAnnotations fAnnotationModel;

        public abstract ITextViewer getViewer();
    }

    private class MySelectionListener
    implements ISelectionChangedListener {
        private MySelectionListener() {
        }

        public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
            ISelection iSelection = selectionChangedEvent.getSelection();
            if (iSelection instanceof ITextSelection) {
                IDocument iDocument;
                ITextSelection iTextSelection = (ITextSelection)iSelection;
                if (selectionChangedEvent.getSelectionProvider() instanceof ITextViewer && (iDocument = ((ITextViewer)selectionChangedEvent.getSelectionProvider()).getDocument()) != null) {
                    int n = iTextSelection.getOffset();
                    int n2 = iTextSelection.getLength();
                    if (n >= 0 && n2 >= 0) {
                        LinkedPosition linkedPosition = new LinkedPosition(iDocument, n, n2, -1);
                        LinkedPosition linkedPosition2 = LinkedModeUI.this.fModel.findPosition(linkedPosition);
                        if (linkedPosition2 == null && LinkedModeUI.this.fExitPosition != null && LinkedModeUI.this.fExitPosition.includes(linkedPosition)) {
                            linkedPosition2 = LinkedModeUI.this.fExitPosition;
                        }
                        if (linkedPosition2 != null) {
                            LinkedModeUI.this.switchPosition(linkedPosition2, false, false);
                        }
                    }
                }
            }
        }
    }

    private static class NullExitPolicy
    implements IExitPolicy {
        private NullExitPolicy() {
        }

        @Override
        public ExitFlags doExit(LinkedModeModel linkedModeModel, VerifyEvent verifyEvent, int n, int n2) {
            return null;
        }
    }

    private class ProposalListener
    implements IProposalListener {
        private ProposalListener() {
        }

        @Override
        public void proposalChosen(ICompletionProposal iCompletionProposal) {
            LinkedModeUI.this.next();
        }
    }
}

