/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.information;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.AbstractInformationControlManager;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.IViewportListener;
import org.eclipse.jface.text.IWidgetTokenKeeper;
import org.eclipse.jface.text.IWidgetTokenKeeperExtension;
import org.eclipse.jface.text.IWidgetTokenOwner;
import org.eclipse.jface.text.IWidgetTokenOwnerExtension;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.information.IInformationPresenter;
import org.eclipse.jface.text.information.IInformationPresenterExtension;
import org.eclipse.jface.text.information.IInformationProvider;
import org.eclipse.jface.text.information.IInformationProviderExtension;
import org.eclipse.jface.text.information.IInformationProviderExtension2;
import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class InformationPresenter
extends AbstractInformationControlManager
implements IInformationPresenter,
IInformationPresenterExtension,
IWidgetTokenKeeper,
IWidgetTokenKeeperExtension {
    public static final int WIDGET_PRIORITY = 5;
    private ITextViewer fTextViewer;
    private Map fProviders;
    private int fOffset = -1;
    private String fPartitioning;

    public InformationPresenter(IInformationControlCreator iInformationControlCreator) {
        super(iInformationControlCreator);
        this.setCloser(new Closer());
        this.takesFocusWhenVisible(true);
        this.fPartitioning = "__dftl_partitioning";
    }

    public void setDocumentPartitioning(String string) {
        Assert.isNotNull((Object)string);
        this.fPartitioning = string;
    }

    @Override
    public String getDocumentPartitioning() {
        return this.fPartitioning;
    }

    public void setInformationProvider(IInformationProvider iInformationProvider, String string) {
        Assert.isNotNull((Object)string);
        if (this.fProviders == null) {
            this.fProviders = new HashMap();
        }
        if (iInformationProvider == null) {
            this.fProviders.remove(string);
        } else {
            this.fProviders.put(string, iInformationProvider);
        }
    }

    @Override
    public IInformationProvider getInformationProvider(String string) {
        if (this.fProviders == null) {
            return null;
        }
        return (IInformationProvider)this.fProviders.get(string);
    }

    public void setOffset(int n) {
        this.fOffset = n;
    }

    @Override
    protected void computeInformation() {
        Object object;
        String string;
        int n;
        int n2 = n = this.fOffset < 0 ? this.fTextViewer.getSelectedRange().x : this.fOffset;
        if (n == -1) {
            return;
        }
        this.fOffset = -1;
        IInformationProvider iInformationProvider = null;
        try {
            string = TextUtilities.getContentType((IDocument)this.fTextViewer.getDocument(), (String)this.getDocumentPartitioning(), (int)n, (boolean)true);
            iInformationProvider = this.getInformationProvider(string);
        }
        catch (BadLocationException badLocationException) {}
        if (iInformationProvider == null) {
            return;
        }
        string = iInformationProvider.getSubject(this.fTextViewer, n);
        if (string == null) {
            return;
        }
        if (iInformationProvider instanceof IInformationProviderExtension) {
            IInformationProviderExtension iInformationProviderExtension = (IInformationProviderExtension)((Object)iInformationProvider);
            object = iInformationProviderExtension.getInformation2(this.fTextViewer, (IRegion)string);
        } else {
            object = iInformationProvider.getInformation(this.fTextViewer, (IRegion)string);
        }
        if (iInformationProvider instanceof IInformationProviderExtension2) {
            this.setCustomInformationControlCreator(((IInformationProviderExtension2)((Object)iInformationProvider)).getInformationPresenterControlCreator());
        } else {
            this.setCustomInformationControlCreator(null);
        }
        this.setInformation(object, this.computeArea((IRegion)string));
    }

    private Rectangle computeArea(IRegion iRegion) {
        Point point;
        Rectangle rectangle;
        int n = 0;
        int n2 = 0;
        IRegion iRegion2 = this.modelRange2WidgetRange(iRegion);
        if (iRegion2 != null) {
            n = iRegion2.getOffset();
            n2 = iRegion2.getOffset() + iRegion2.getLength();
        }
        StyledText styledText = this.fTextViewer.getTextWidget();
        if (n2 > 0 && n < n2) {
            rectangle = styledText.getTextBounds(n, n2 - 1);
        } else {
            point = styledText.getLocationAtOffset(n);
            rectangle = new Rectangle(point.x, point.y, 0, styledText.getLineHeight(n));
        }
        point = styledText.getClientArea();
        Geometry.moveInside((Rectangle)rectangle, (Rectangle)point);
        return rectangle;
    }

    private IRegion modelRange2WidgetRange(IRegion iRegion) {
        if (this.fTextViewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 iTextViewerExtension5 = (ITextViewerExtension5)((Object)this.fTextViewer);
            return iTextViewerExtension5.modelRange2WidgetRange(iRegion);
        }
        IRegion iRegion2 = this.fTextViewer.getVisibleRegion();
        int n = iRegion.getOffset() - iRegion2.getOffset();
        int n2 = n + iRegion.getLength();
        if (n2 > iRegion2.getLength()) {
            n2 = iRegion2.getLength();
        }
        return new Region(n, n2 - n);
    }

    @Override
    public void install(ITextViewer iTextViewer) {
        this.fTextViewer = iTextViewer;
        this.install((Control)this.fTextViewer.getTextWidget());
    }

    @Override
    public void uninstall() {
        this.dispose();
    }

    @Override
    protected void showInformationControl(Rectangle rectangle) {
        if (this.fTextViewer instanceof IWidgetTokenOwnerExtension && this.fTextViewer instanceof IWidgetTokenOwner) {
            IWidgetTokenOwnerExtension iWidgetTokenOwnerExtension = (IWidgetTokenOwnerExtension)((Object)this.fTextViewer);
            if (iWidgetTokenOwnerExtension.requestWidgetToken(this, 5)) {
                super.showInformationControl(rectangle);
            }
        } else if (this.fTextViewer instanceof IWidgetTokenOwner) {
            IWidgetTokenOwner iWidgetTokenOwner = (IWidgetTokenOwner)((Object)this.fTextViewer);
            if (iWidgetTokenOwner.requestWidgetToken(this)) {
                super.showInformationControl(rectangle);
            }
        } else {
            super.showInformationControl(rectangle);
        }
    }

    @Override
    protected void hideInformationControl() {
        try {
            super.hideInformationControl();
        }
        finally {
            if (this.fTextViewer instanceof IWidgetTokenOwner) {
                IWidgetTokenOwner iWidgetTokenOwner = (IWidgetTokenOwner)((Object)this.fTextViewer);
                iWidgetTokenOwner.releaseWidgetToken(this);
            }
        }
    }

    @Override
    protected void handleInformationControlDisposed() {
        try {
            super.handleInformationControlDisposed();
        }
        finally {
            if (this.fTextViewer instanceof IWidgetTokenOwner) {
                IWidgetTokenOwner iWidgetTokenOwner = (IWidgetTokenOwner)((Object)this.fTextViewer);
                iWidgetTokenOwner.releaseWidgetToken(this);
            }
        }
    }

    @Override
    public boolean requestWidgetToken(IWidgetTokenOwner iWidgetTokenOwner) {
        return false;
    }

    @Override
    public boolean requestWidgetToken(IWidgetTokenOwner iWidgetTokenOwner, int n) {
        return false;
    }

    @Override
    public boolean setFocus(IWidgetTokenOwner iWidgetTokenOwner) {
        return false;
    }

    class Closer
    implements AbstractInformationControlManager.IInformationControlCloser,
    ControlListener,
    MouseListener,
    FocusListener,
    IViewportListener,
    KeyListener {
        private Control fSubjectControl;
        private IInformationControl fInformationControlToClose;
        private boolean fIsActive = false;

        Closer() {
        }

        @Override
        public void setSubjectControl(Control control) {
            this.fSubjectControl = control;
        }

        @Override
        public void setInformationControl(IInformationControl iInformationControl) {
            this.fInformationControlToClose = iInformationControl;
        }

        @Override
        public void start(Rectangle rectangle) {
            if (this.fIsActive) {
                return;
            }
            this.fIsActive = true;
            if (this.fSubjectControl != null && !this.fSubjectControl.isDisposed()) {
                this.fSubjectControl.addControlListener((ControlListener)this);
                this.fSubjectControl.addMouseListener((MouseListener)this);
                this.fSubjectControl.addFocusListener((FocusListener)this);
                this.fSubjectControl.addKeyListener((KeyListener)this);
            }
            if (this.fInformationControlToClose != null) {
                this.fInformationControlToClose.addFocusListener(this);
            }
            InformationPresenter.this.fTextViewer.addViewportListener(this);
        }

        @Override
        public void stop() {
            if (!this.fIsActive) {
                return;
            }
            this.fIsActive = false;
            InformationPresenter.this.fTextViewer.removeViewportListener(this);
            if (this.fInformationControlToClose != null) {
                this.fInformationControlToClose.removeFocusListener(this);
            }
            if (this.fSubjectControl != null && !this.fSubjectControl.isDisposed()) {
                this.fSubjectControl.removeControlListener((ControlListener)this);
                this.fSubjectControl.removeMouseListener((MouseListener)this);
                this.fSubjectControl.removeFocusListener((FocusListener)this);
                this.fSubjectControl.removeKeyListener((KeyListener)this);
            }
        }

        public void controlResized(ControlEvent controlEvent) {
            InformationPresenter.this.hideInformationControl();
        }

        public void controlMoved(ControlEvent controlEvent) {
            InformationPresenter.this.hideInformationControl();
        }

        public void mouseDown(MouseEvent mouseEvent) {
            InformationPresenter.this.hideInformationControl();
        }

        public void mouseUp(MouseEvent mouseEvent) {
        }

        public void mouseDoubleClick(MouseEvent mouseEvent) {
            InformationPresenter.this.hideInformationControl();
        }

        public void focusGained(FocusEvent focusEvent) {
        }

        public void focusLost(FocusEvent focusEvent) {
            Display display = this.fSubjectControl.getDisplay();
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (Closer.this.fInformationControlToClose == null || !Closer.this.fInformationControlToClose.isFocusControl()) {
                        InformationPresenter.this.hideInformationControl();
                    }
                }
            });
        }

        @Override
        public void viewportChanged(int n) {
            InformationPresenter.this.hideInformationControl();
        }

        public void keyPressed(KeyEvent keyEvent) {
            InformationPresenter.this.hideInformationControl();
        }

        public void keyReleased(KeyEvent keyEvent) {
        }
    }
}

