/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.hyperlink;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.AbstractInformationControl;
import org.eclipse.jface.text.AbstractInformationControlManager;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IInformationControlExtension2;
import org.eclipse.jface.text.IInformationControlExtension3;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextHoverExtension2;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.IWidgetTokenKeeper;
import org.eclipse.jface.text.IWidgetTokenKeeperExtension;
import org.eclipse.jface.text.IWidgetTokenOwner;
import org.eclipse.jface.text.IWidgetTokenOwnerExtension;
import org.eclipse.jface.text.JFaceTextUtil;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.DefaultHyperlinkPresenter;
import org.eclipse.jface.text.hyperlink.HyperlinkMessages;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.IHyperlinkPresenterExtension2;
import org.eclipse.jface.util.Geometry;
import org.eclipse.jface.util.Util;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class MultipleHyperlinkPresenter
extends DefaultHyperlinkPresenter
implements IHyperlinkPresenterExtension2 {
    private static final boolean IS_OLD_WINDOWS;
    private static final boolean IS_MAC;
    private static final boolean IS_GTK;
    private ITextViewer fTextViewer;
    private IHyperlink[] fHyperlinks;
    private Region fSubjectRegion;
    private MultipleHyperlinkHoverManager fManager;
    private int fCursorOffset;

    static {
        int n;
        String string;
        int n2 = Integer.MAX_VALUE;
        if (Util.isWin32() && (string = System.getProperty("os.version")) != null && (n = string.indexOf(46)) != -1) {
            string = string.substring(0, n);
            try {
                n2 = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        IS_OLD_WINDOWS = n2 < 6;
        IS_MAC = Util.isMac();
        IS_GTK = Util.isGtk();
    }

    public MultipleHyperlinkPresenter(IPreferenceStore iPreferenceStore) {
        super(iPreferenceStore);
    }

    public MultipleHyperlinkPresenter(RGB rGB) {
        super(rGB);
    }

    @Override
    public void install(ITextViewer iTextViewer) {
        super.install(iTextViewer);
        this.fTextViewer = iTextViewer;
        this.fManager = new MultipleHyperlinkHoverManager(new MultipleHyperlinkHover(), this.fTextViewer, this);
        this.fManager.install((Control)iTextViewer.getTextWidget());
        this.fManager.setSizeConstraints(100, 12, false, true);
    }

    @Override
    public void uninstall() {
        super.uninstall();
        if (this.fTextViewer != null) {
            this.fManager.dispose();
            this.fTextViewer = null;
        }
    }

    @Override
    public boolean canShowMultipleHyperlinks() {
        return true;
    }

    @Override
    public boolean canHideHyperlinks() {
        return !this.fManager.isInformationControlVisible();
    }

    @Override
    public void hideHyperlinks() {
        super.hideHyperlinks();
        this.fHyperlinks = null;
    }

    @Override
    public void showHyperlinks(IHyperlink[] iHyperlinkArray) {
        this.showHyperlinks(iHyperlinkArray, false);
    }

    @Override
    public void showHyperlinks(IHyperlink[] iHyperlinkArray, boolean bl) {
        this.fManager.takesFocusWhenVisible(bl);
        super.showHyperlinks(new IHyperlink[]{iHyperlinkArray[0]});
        this.fSubjectRegion = null;
        this.fHyperlinks = iHyperlinkArray;
        if (iHyperlinkArray.length == 1) {
            return;
        }
        int n = iHyperlinkArray[0].getHyperlinkRegion().getOffset();
        int n2 = n + iHyperlinkArray[0].getHyperlinkRegion().getLength();
        int n3 = 1;
        while (n3 < iHyperlinkArray.length) {
            int n4 = iHyperlinkArray[n3].getHyperlinkRegion().getOffset();
            int n5 = n4 + iHyperlinkArray[n3].getHyperlinkRegion().getLength();
            n = Math.min(n, n4);
            n2 = Math.max(n2, n5);
            ++n3;
        }
        this.fSubjectRegion = new Region(n, n2 - n);
        this.fCursorOffset = JFaceTextUtil.getOffsetForCursorLocation(this.fTextViewer);
        this.fManager.showInformation();
    }

    private void setCaret() {
        Point point = this.fTextViewer.getSelectedRange();
        if (this.fCursorOffset != -1 && (this.fSubjectRegion.getOffset() > point.x || point.x + point.y > this.fSubjectRegion.getOffset() + this.fSubjectRegion.getLength())) {
            this.fTextViewer.setSelectedRange(this.fCursorOffset, 0);
        }
    }

    private static class LinkListInformationControl
    extends AbstractInformationControl
    implements IInformationControlExtension2 {
        private final MultipleHyperlinkHoverManager fManager;
        private IHyperlink[] fInput;
        private Composite fParent;
        private Table fTable;
        private final Color fForegroundColor;
        private final Color fBackgroundColor;

        public LinkListInformationControl(Shell shell, MultipleHyperlinkHoverManager multipleHyperlinkHoverManager, Color color, Color color2) {
            super(shell, false);
            this.fManager = multipleHyperlinkHoverManager;
            this.fForegroundColor = color;
            this.fBackgroundColor = color2;
            this.create();
        }

        @Override
        public void setInformation(String string) {
        }

        @Override
        public void setInput(Object object) {
            this.fInput = (IHyperlink[])object;
            this.deferredCreateContent(this.fParent);
        }

        @Override
        protected void createContent(Composite composite) {
            this.fParent = composite;
            GridLayout gridLayout = new GridLayout();
            if (IS_OLD_WINDOWS) {
                gridLayout.marginWidth = 0;
                gridLayout.marginHeight = 4;
                gridLayout.marginRight = 4;
            } else if (IS_MAC) {
                gridLayout.marginWidth = 4;
                gridLayout.marginHeight = 0;
                gridLayout.marginTop = 4;
                gridLayout.marginBottom = 3;
            } else if (IS_GTK) {
                gridLayout.marginWidth = 4;
                gridLayout.marginHeight = 0;
                gridLayout.marginTop = 4;
                gridLayout.marginBottom = 2;
            } else {
                gridLayout.marginWidth = 4;
                gridLayout.marginHeight = 4;
            }
            this.fParent.setLayout((Layout)gridLayout);
            this.fParent.setForeground(this.fForegroundColor);
            this.fParent.setBackground(this.fBackgroundColor);
        }

        @Override
        public Point computeSizeHint() {
            int n;
            int n2;
            Point point = this.getShell().computeSize(-1, -1, true);
            Point point2 = this.getSizeConstraints();
            if (point2 == null) {
                return point;
            }
            if (this.fTable.getVerticalBar() == null || this.fTable.getHorizontalBar() == null) {
                return Geometry.min((Point)point2, (Point)point);
            }
            int n3 = this.fTable.getVerticalBar().getSize().x;
            int n4 = this.fTable.getHorizontalBar().getSize().y;
            if (IS_MAC && this.fTable.getScrollbarsMode() == 2) {
                --n3;
                --n4;
            }
            if (point.y - n4 <= point2.y) {
                n2 = point.x - n3;
                this.fTable.getVerticalBar().setVisible(false);
            } else {
                n2 = Math.min(point.x, point2.x);
            }
            if (point.x - n3 <= point2.x) {
                n = point.y - n4;
                this.fTable.getHorizontalBar().setVisible(false);
            } else {
                n = Math.min(point.y, point2.y);
            }
            return new Point(n2, n);
        }

        private void deferredCreateContent(Composite composite) {
            this.fTable = new Table(composite, 65540);
            this.fTable.setLinesVisible(false);
            this.fTable.setHeaderVisible(false);
            this.fTable.setForeground(this.fForegroundColor);
            this.fTable.setBackground(this.fBackgroundColor);
            this.fTable.setFont(JFaceResources.getDialogFont());
            GridData gridData = new GridData(1, 1, true, true);
            this.fTable.setLayoutData((Object)gridData);
            final TableViewer tableViewer = new TableViewer(this.fTable);
            tableViewer.setContentProvider((IContentProvider)new LinkContentProvider());
            tableViewer.setLabelProvider((IBaseLabelProvider)new LinkLabelProvider());
            tableViewer.setInput((Object)this.fInput);
            this.fTable.setSelection(0);
            this.registerTableListeners();
            this.getShell().addShellListener((ShellListener)new ShellAdapter(){

                public void shellActivated(ShellEvent shellEvent) {
                    if (tableViewer.getTable().getSelectionCount() == 0) {
                        tableViewer.getTable().setSelection(0);
                    }
                    tableViewer.getTable().setFocus();
                }
            });
        }

        private void registerTableListeners() {
            this.fTable.addMouseMoveListener(new MouseMoveListener(){
                TableItem fLastItem = null;

                public void mouseMove(MouseEvent mouseEvent) {
                    if (LinkListInformationControl.this.fTable.equals(mouseEvent.getSource())) {
                        TableItem tableItem;
                        if (this.fLastItem == null ^ (tableItem = LinkListInformationControl.this.fTable.getItem(new Point(mouseEvent.x, mouseEvent.y))) == null) {
                            LinkListInformationControl.this.fTable.setCursor(tableItem == null ? null : LinkListInformationControl.this.fTable.getDisplay().getSystemCursor(21));
                        }
                        if (tableItem instanceof TableItem) {
                            int n;
                            TableItem tableItem2 = tableItem;
                            if (!tableItem.equals(this.fLastItem)) {
                                this.fLastItem = tableItem;
                                LinkListInformationControl.this.fTable.setSelection(new TableItem[]{this.fLastItem});
                            } else if (mouseEvent.y < LinkListInformationControl.this.fTable.getItemHeight() / 4) {
                                int n2 = LinkListInformationControl.this.fTable.indexOf(tableItem2);
                                if (n2 > 0) {
                                    this.fLastItem = LinkListInformationControl.this.fTable.getItem(n2 - 1);
                                    LinkListInformationControl.this.fTable.setSelection(new TableItem[]{this.fLastItem});
                                }
                            } else if (mouseEvent.y > ((LinkListInformationControl)LinkListInformationControl.this).fTable.getBounds().height - LinkListInformationControl.this.fTable.getItemHeight() / 4 && (n = LinkListInformationControl.this.fTable.indexOf(tableItem2)) < LinkListInformationControl.this.fTable.getItemCount() - 1) {
                                this.fLastItem = LinkListInformationControl.this.fTable.getItem(n + 1);
                                LinkListInformationControl.this.fTable.setSelection(new TableItem[]{this.fLastItem});
                            }
                        } else if (tableItem == null) {
                            this.fLastItem = null;
                        }
                    }
                }
            });
            this.fTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                    LinkListInformationControl.this.openSelectedLink();
                }
            });
            this.fTable.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseUp(MouseEvent mouseEvent) {
                    if (LinkListInformationControl.this.fTable.getSelectionCount() < 1) {
                        return;
                    }
                    if (mouseEvent.button != 1) {
                        return;
                    }
                    if (LinkListInformationControl.this.fTable.equals(mouseEvent.getSource())) {
                        TableItem tableItem = LinkListInformationControl.this.fTable.getItem(new Point(mouseEvent.x, mouseEvent.y));
                        TableItem tableItem2 = LinkListInformationControl.this.fTable.getSelection()[0];
                        if (tableItem2.equals(tableItem)) {
                            LinkListInformationControl.this.openSelectedLink();
                        }
                    }
                }
            });
            this.fTable.addTraverseListener(new TraverseListener(){

                public void keyTraversed(TraverseEvent traverseEvent) {
                    if (traverseEvent.keyCode == 27) {
                        LinkListInformationControl.this.fManager.hideInformationControl();
                    }
                }
            });
        }

        @Override
        public boolean hasContents() {
            return true;
        }

        private void openSelectedLink() {
            if (this.fTable.getSelectionCount() < 1) {
                return;
            }
            TableItem tableItem = this.fTable.getSelection()[0];
            IHyperlink iHyperlink = (IHyperlink)tableItem.getData();
            this.fManager.hideInformationControl();
            this.fManager.setCaret();
            iHyperlink.open();
        }

        private static final class LinkContentProvider
        implements IStructuredContentProvider {
            private LinkContentProvider() {
            }

            public Object[] getElements(Object object) {
                return (Object[])object;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object object, Object object2) {
            }
        }

        private static final class LinkLabelProvider
        extends ColumnLabelProvider {
            private LinkLabelProvider() {
            }

            public String getText(Object object) {
                IHyperlink iHyperlink = (IHyperlink)object;
                String string = iHyperlink.getHyperlinkText();
                if (string != null) {
                    return string;
                }
                return HyperlinkMessages.getString("LinkListInformationControl.unknownLink");
            }
        }
    }

    private class MultipleHyperlinkHover
    implements ITextHover,
    ITextHoverExtension,
    ITextHoverExtension2 {
        private MultipleHyperlinkHover() {
        }

        @Override
        public String getHoverInfo(ITextViewer iTextViewer, IRegion iRegion) {
            return null;
        }

        @Override
        public IRegion getHoverRegion(ITextViewer iTextViewer, int n) {
            return MultipleHyperlinkPresenter.this.fSubjectRegion;
        }

        @Override
        public Object getHoverInfo2(ITextViewer iTextViewer, IRegion iRegion) {
            return MultipleHyperlinkPresenter.this.fHyperlinks;
        }

        @Override
        public IInformationControlCreator getHoverControlCreator() {
            return new IInformationControlCreator(){

                @Override
                public IInformationControl createInformationControl(Shell shell) {
                    Color color = MultipleHyperlinkPresenter.this.fTextViewer.getTextWidget().getForeground();
                    Color color2 = MultipleHyperlinkPresenter.this.fTextViewer.getTextWidget().getBackground();
                    return new LinkListInformationControl(shell, MultipleHyperlinkPresenter.this.fManager, color, color2);
                }
            };
        }
    }

    private static class MultipleHyperlinkHoverManager
    extends AbstractInformationControlManager
    implements IWidgetTokenKeeper,
    IWidgetTokenKeeperExtension {
        private static final int WIDGET_TOKEN_PRIORITY = 1;
        private final MultipleHyperlinkHover fHover;
        private final ITextViewer fTextViewer;
        private final MultipleHyperlinkPresenter fHyperlinkPresenter;
        private final Closer fCloser;
        private boolean fIsControlVisible;

        public MultipleHyperlinkHoverManager(MultipleHyperlinkHover multipleHyperlinkHover, ITextViewer iTextViewer, MultipleHyperlinkPresenter multipleHyperlinkPresenter) {
            super(multipleHyperlinkHover.getHoverControlCreator());
            this.fHover = multipleHyperlinkHover;
            this.fTextViewer = iTextViewer;
            this.fHyperlinkPresenter = multipleHyperlinkPresenter;
            this.fCloser = new Closer();
            this.setCloser(this.fCloser);
            this.fIsControlVisible = false;
        }

        @Override
        protected void computeInformation() {
            IRegion iRegion = this.fHover.getHoverRegion(this.fTextViewer, -1);
            if (iRegion == null) {
                this.setInformation(null, null);
                return;
            }
            Rectangle rectangle = JFaceTextUtil.computeArea(iRegion, this.fTextViewer);
            if (rectangle == null || rectangle.isEmpty()) {
                this.setInformation(null, null);
                return;
            }
            Object object = this.fHover.getHoverInfo2(this.fTextViewer, iRegion);
            this.setCustomInformationControlCreator(this.fHover.getHoverControlCreator());
            this.setInformation(object, rectangle);
        }

        @Override
        protected Point computeInformationControlLocation(Rectangle rectangle, Point point) {
            Point point2 = super.computeInformationControlLocation(rectangle, point);
            Point point3 = this.fTextViewer.getTextWidget().getDisplay().getCursorLocation();
            if (this.isTakingFocusWhenVisible() || point3.x <= point2.x + point.x) {
                return point2;
            }
            point2.x = point3.x + 20 - point.x;
            return point2;
        }

        @Override
        protected void showInformationControl(Rectangle rectangle) {
            if (this.fTextViewer instanceof IWidgetTokenOwnerExtension) {
                if (((IWidgetTokenOwnerExtension)((Object)this.fTextViewer)).requestWidgetToken(this, 1)) {
                    super.showInformationControl(rectangle);
                    this.fIsControlVisible = true;
                }
            } else if (this.fTextViewer instanceof IWidgetTokenOwner) {
                if (((IWidgetTokenOwner)((Object)this.fTextViewer)).requestWidgetToken(this)) {
                    super.showInformationControl(rectangle);
                    this.fIsControlVisible = true;
                }
            } else {
                super.showInformationControl(rectangle);
                this.fIsControlVisible = true;
            }
        }

        private void setCaret() {
            this.fHyperlinkPresenter.setCaret();
        }

        @Override
        protected void hideInformationControl() {
            super.hideInformationControl();
            if (this.fTextViewer instanceof IWidgetTokenOwner) {
                ((IWidgetTokenOwner)((Object)this.fTextViewer)).releaseWidgetToken(this);
            }
            this.fIsControlVisible = false;
            this.fHyperlinkPresenter.hideHyperlinks();
        }

        @Override
        public void disposeInformationControl() {
            super.disposeInformationControl();
            if (this.fTextViewer instanceof IWidgetTokenOwner) {
                ((IWidgetTokenOwner)((Object)this.fTextViewer)).releaseWidgetToken(this);
            }
            this.fIsControlVisible = false;
            this.fHyperlinkPresenter.hideHyperlinks();
        }

        @Override
        public boolean requestWidgetToken(IWidgetTokenOwner iWidgetTokenOwner) {
            this.hideInformationControl();
            return true;
        }

        @Override
        public boolean requestWidgetToken(IWidgetTokenOwner iWidgetTokenOwner, int n) {
            if (n < 1) {
                return false;
            }
            this.hideInformationControl();
            return true;
        }

        @Override
        public boolean setFocus(IWidgetTokenOwner iWidgetTokenOwner) {
            return this.isTakingFocusWhenVisible();
        }

        public boolean isInformationControlVisible() {
            return this.fIsControlVisible;
        }

        private class Closer
        implements AbstractInformationControlManager.IInformationControlCloser,
        Listener,
        KeyListener,
        MouseListener {
            private Control fSubjectControl;
            private Display fDisplay;
            private IInformationControl fControl;
            private Rectangle fSubjectArea;

            private Closer() {
            }

            @Override
            public void setInformationControl(IInformationControl iInformationControl) {
                this.fControl = iInformationControl;
            }

            @Override
            public void setSubjectControl(Control control) {
                this.fSubjectControl = control;
            }

            @Override
            public void start(Rectangle rectangle) {
                this.fSubjectArea = rectangle;
                this.fDisplay = this.fSubjectControl.getDisplay();
                if (!this.fDisplay.isDisposed()) {
                    this.fDisplay.addFilter(16, (Listener)this);
                    this.fDisplay.addFilter(5, (Listener)this);
                    MultipleHyperlinkHoverManager.this.fTextViewer.getTextWidget().addKeyListener((KeyListener)this);
                    MultipleHyperlinkHoverManager.this.fTextViewer.getTextWidget().addMouseListener((MouseListener)this);
                }
            }

            @Override
            public void stop() {
                if (this.fDisplay != null && !this.fDisplay.isDisposed()) {
                    this.fDisplay.removeFilter(16, (Listener)this);
                    this.fDisplay.removeFilter(5, (Listener)this);
                    MultipleHyperlinkHoverManager.this.fTextViewer.getTextWidget().removeKeyListener((KeyListener)this);
                    MultipleHyperlinkHoverManager.this.fTextViewer.getTextWidget().removeMouseListener((MouseListener)this);
                }
                this.fSubjectArea = null;
            }

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 16: {
                        if (this.fControl.isFocusControl()) break;
                        MultipleHyperlinkHoverManager.this.disposeInformationControl();
                        break;
                    }
                    case 5: {
                        this.handleMouseMove(event);
                    }
                }
            }

            private void handleMouseMove(Event event) {
                if (!(event.widget instanceof Control)) {
                    return;
                }
                if (this.fControl.isFocusControl()) {
                    return;
                }
                Control control = (Control)event.widget;
                Point point = event.display.map(control, this.fSubjectControl, event.x, event.y);
                if (this.fSubjectArea.contains(point)) {
                    return;
                }
                if (this.inKeepUpZone(point.x, point.y, ((IInformationControlExtension3)((Object)this.fControl)).getBounds())) {
                    return;
                }
                if (!MultipleHyperlinkHoverManager.this.isTakingFocusWhenVisible()) {
                    MultipleHyperlinkHoverManager.this.hideInformationControl();
                }
            }

            private boolean inKeepUpZone(int n, int n2, Rectangle rectangle) {
                if (this.fSubjectArea.contains(n, n2)) {
                    return true;
                }
                Rectangle rectangle2 = this.fSubjectControl.getDisplay().map(null, this.fSubjectControl, rectangle);
                Rectangle rectangle3 = Geometry.copy((Rectangle)rectangle2);
                if (rectangle3.contains(n, n2)) {
                    return true;
                }
                int n3 = this.fSubjectArea.y + this.fSubjectArea.height;
                Rectangle rectangle4 = new Rectangle(this.fSubjectArea.x, n3, this.fSubjectArea.width, rectangle3.y - n3);
                return rectangle4.contains(n, n2);
            }

            public void keyPressed(KeyEvent keyEvent) {
                MultipleHyperlinkHoverManager.this.hideInformationControl();
            }

            public void keyReleased(KeyEvent keyEvent) {
                if (!MultipleHyperlinkHoverManager.this.isTakingFocusWhenVisible()) {
                    MultipleHyperlinkHoverManager.this.hideInformationControl();
                }
            }

            public void mouseDoubleClick(MouseEvent mouseEvent) {
            }

            public void mouseDown(MouseEvent mouseEvent) {
            }

            public void mouseUp(MouseEvent mouseEvent) {
                MultipleHyperlinkHoverManager.this.hideInformationControl();
            }
        }
    }
}

