/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.hyperlink;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.JFaceTextUtil;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetectorExtension2;
import org.eclipse.jface.text.hyperlink.IHyperlinkPresenter;
import org.eclipse.jface.text.hyperlink.IHyperlinkPresenterExtension;
import org.eclipse.jface.text.hyperlink.IHyperlinkPresenterExtension2;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class HyperlinkManager
implements ITextListener,
Listener,
KeyListener,
MouseListener,
MouseMoveListener,
FocusListener,
MouseTrackListener {
    public static final int OPEN_HYPERLINK = 23;
    public static final DETECTION_STRATEGY FIRST = new DETECTION_STRATEGY("first");
    public static final DETECTION_STRATEGY ALL = new DETECTION_STRATEGY("all");
    public static final DETECTION_STRATEGY LONGEST_REGION_ALL = new DETECTION_STRATEGY("all with same longest region");
    public static final DETECTION_STRATEGY LONGEST_REGION_FIRST = new DETECTION_STRATEGY("first with longest region");
    private ITextViewer fTextViewer;
    private boolean fActive;
    private int fHyperlinkStateMask;
    private int fActiveHyperlinkStateMask;
    private IHyperlink[] fActiveHyperlinks;
    private IHyperlinkDetector[] fHyperlinkDetectors;
    private IHyperlinkPresenter fHyperlinkPresenter;
    private final DETECTION_STRATEGY fDetectionStrategy;

    public HyperlinkManager(DETECTION_STRATEGY dETECTION_STRATEGY) {
        Assert.isNotNull((Object)dETECTION_STRATEGY);
        this.fDetectionStrategy = dETECTION_STRATEGY;
    }

    public void install(ITextViewer iTextViewer, IHyperlinkPresenter iHyperlinkPresenter, IHyperlinkDetector[] iHyperlinkDetectorArray, int n) {
        Assert.isNotNull((Object)iTextViewer);
        Assert.isNotNull((Object)iHyperlinkPresenter);
        this.fTextViewer = iTextViewer;
        this.fHyperlinkPresenter = iHyperlinkPresenter;
        Assert.isLegal((this.fHyperlinkPresenter.canShowMultipleHyperlinks() || this.fDetectionStrategy == FIRST || this.fDetectionStrategy == LONGEST_REGION_FIRST ? 1 : 0) != 0);
        this.setHyperlinkDetectors(iHyperlinkDetectorArray);
        this.setHyperlinkStateMask(n);
        StyledText styledText = this.fTextViewer.getTextWidget();
        if (styledText == null || styledText.isDisposed()) {
            return;
        }
        styledText.getDisplay().addFilter(2, (Listener)this);
        styledText.addKeyListener((KeyListener)this);
        styledText.addMouseListener((MouseListener)this);
        styledText.addMouseMoveListener((MouseMoveListener)this);
        styledText.addFocusListener((FocusListener)this);
        styledText.addMouseTrackListener((MouseTrackListener)this);
        this.fTextViewer.addTextListener(this);
        this.fHyperlinkPresenter.install(this.fTextViewer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setHyperlinkDetectors(IHyperlinkDetector[] iHyperlinkDetectorArray) {
        Assert.isTrue((iHyperlinkDetectorArray != null && iHyperlinkDetectorArray.length > 0 ? 1 : 0) != 0);
        if (this.fHyperlinkDetectors == null) {
            this.fHyperlinkDetectors = iHyperlinkDetectorArray;
            return;
        }
        IHyperlinkDetector[] iHyperlinkDetectorArray2 = this.fHyperlinkDetectors;
        synchronized (this.fHyperlinkDetectors) {
            this.fHyperlinkDetectors = iHyperlinkDetectorArray;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void setHyperlinkStateMask(int n) {
        this.fHyperlinkStateMask = n;
    }

    public void uninstall() {
        this.deactivate();
        StyledText styledText = this.fTextViewer.getTextWidget();
        if (styledText != null && !styledText.isDisposed()) {
            styledText.removeKeyListener((KeyListener)this);
            styledText.getDisplay().removeFilter(2, (Listener)this);
            styledText.removeMouseListener((MouseListener)this);
            styledText.removeMouseMoveListener((MouseMoveListener)this);
            styledText.removeFocusListener((FocusListener)this);
            styledText.removeMouseTrackListener((MouseTrackListener)this);
        }
        this.fTextViewer.removeTextListener(this);
        this.fHyperlinkPresenter.uninstall();
        this.fHyperlinkPresenter = null;
        this.fTextViewer = null;
        this.fHyperlinkDetectors = null;
    }

    protected void deactivate() {
        this.fHyperlinkPresenter.hideHyperlinks();
        this.fActive = false;
    }

    protected IHyperlink[] findHyperlinks() {
        int n = this.getCurrentTextOffset();
        if (n == -1) {
            return null;
        }
        Region region = new Region(n, 0);
        return this.findHyperlinks((IRegion)region);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IHyperlink[] findHyperlinks(IRegion iRegion) {
        ArrayList<IHyperlink> arrayList = new ArrayList<IHyperlink>(this.fHyperlinkDetectors.length * 2);
        IHyperlinkDetector[] iHyperlinkDetectorArray = this.fHyperlinkDetectors;
        synchronized (this.fHyperlinkDetectors) {
            int n = 0;
            int n2 = this.fHyperlinkDetectors.length;
            while (n < n2) {
                int n3;
                IHyperlinkDetector iHyperlinkDetector = this.fHyperlinkDetectors[n];
                if (iHyperlinkDetector != null && !(!(iHyperlinkDetector instanceof IHyperlinkDetectorExtension2) ? this.fActiveHyperlinkStateMask != this.fHyperlinkStateMask : (n3 = ((IHyperlinkDetectorExtension2)((Object)iHyperlinkDetector)).getStateMask()) != -1 && n3 != this.fActiveHyperlinkStateMask || n3 == -1 && this.fActiveHyperlinkStateMask != this.fHyperlinkStateMask)) {
                    n3 = this.fHyperlinkPresenter.canShowMultipleHyperlinks() ? 1 : 0;
                    IHyperlink[] iHyperlinkArray = iHyperlinkDetector.detectHyperlinks(this.fTextViewer, iRegion, n3 != 0);
                    if (iHyperlinkArray != null) {
                        Assert.isLegal((iHyperlinkArray.length > 0 ? 1 : 0) != 0);
                        if (this.fDetectionStrategy == FIRST) {
                            if (iHyperlinkArray.length == 1) {
                                // ** MonitorExit[var3_3] (shouldn't be in output)
                                return iHyperlinkArray;
                            }
                            // ** MonitorExit[var3_3] (shouldn't be in output)
                            return new IHyperlink[]{iHyperlinkArray[0]};
                        }
                        arrayList.addAll(Arrays.asList(iHyperlinkArray));
                    }
                }
                ++n;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            if (arrayList.isEmpty()) {
                return null;
            }
            if (this.fDetectionStrategy != ALL) {
                int n4 = this.computeLongestHyperlinkLength(arrayList);
                for (IHyperlink iHyperlink : new ArrayList(arrayList)) {
                    if (iHyperlink.getHyperlinkRegion().getLength() >= n4) continue;
                    arrayList.remove(iHyperlink);
                }
            }
            if (this.fDetectionStrategy == LONGEST_REGION_FIRST) {
                return new IHyperlink[]{(IHyperlink)arrayList.get(0)};
            }
            return arrayList.toArray(new IHyperlink[arrayList.size()]);
        }
    }

    protected int computeLongestHyperlinkLength(List list) {
        Assert.isLegal((list != null && !list.isEmpty() ? 1 : 0) != 0);
        Iterator iterator = list.iterator();
        int n = Integer.MIN_VALUE;
        while (iterator.hasNext()) {
            IRegion iRegion = ((IHyperlink)iterator.next()).getHyperlinkRegion();
            if (iRegion.getLength() < n) continue;
            n = iRegion.getLength();
        }
        return n;
    }

    protected int getCurrentTextOffset() {
        return JFaceTextUtil.getOffsetForCursorLocation(this.fTextViewer);
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (this.fActive) {
            this.deactivate();
            return;
        }
        if (!this.isRegisteredStateMask(keyEvent.keyCode)) {
            this.deactivate();
            return;
        }
        this.fActive = true;
        this.fActiveHyperlinkStateMask = keyEvent.keyCode;
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void mouseDoubleClick(MouseEvent mouseEvent) {
    }

    public void mouseDown(MouseEvent mouseEvent) {
        if (!this.fActive) {
            return;
        }
        if (mouseEvent.stateMask != this.fActiveHyperlinkStateMask) {
            this.deactivate();
            return;
        }
        if (mouseEvent.button != 1) {
            this.deactivate();
            return;
        }
    }

    public void mouseUp(MouseEvent mouseEvent) {
        if (!this.fActive) {
            this.fActiveHyperlinks = null;
            return;
        }
        if (mouseEvent.button != 1) {
            this.fActiveHyperlinks = null;
        }
        this.deactivate();
        if (this.fActiveHyperlinks != null) {
            this.fActiveHyperlinks[0].open();
        }
    }

    public void mouseMove(MouseEvent mouseEvent) {
        if (this.fHyperlinkPresenter instanceof IHyperlinkPresenterExtension && !((IHyperlinkPresenterExtension)((Object)this.fHyperlinkPresenter)).canHideHyperlinks()) {
            return;
        }
        if (!this.isRegisteredStateMask(mouseEvent.stateMask)) {
            if (this.fActive) {
                this.deactivate();
            }
            return;
        }
        this.fActive = true;
        this.fActiveHyperlinkStateMask = mouseEvent.stateMask;
        StyledText styledText = this.fTextViewer.getTextWidget();
        if (styledText == null || styledText.isDisposed()) {
            this.deactivate();
            return;
        }
        if ((mouseEvent.stateMask & 0x80000) != 0 && styledText.getSelectionCount() != 0) {
            this.deactivate();
            return;
        }
        this.fActiveHyperlinks = this.findHyperlinks();
        this.showHyperlinks(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isRegisteredStateMask(int n) {
        if (n == this.fHyperlinkStateMask) {
            return true;
        }
        IHyperlinkDetector[] iHyperlinkDetectorArray = this.fHyperlinkDetectors;
        synchronized (this.fHyperlinkDetectors) {
            int n2 = 0;
            while (true) {
                if (n2 >= this.fHyperlinkDetectors.length) {
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return false;
                }
                if (this.fHyperlinkDetectors[n2] instanceof IHyperlinkDetectorExtension2 && n == ((IHyperlinkDetectorExtension2)((Object)this.fHyperlinkDetectors[n2])).getStateMask()) {
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return true;
                }
                ++n2;
            }
        }
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        this.deactivate();
    }

    public void handleEvent(Event event) {
        this.deactivate();
    }

    @Override
    public void textChanged(TextEvent textEvent) {
        if (textEvent.getDocumentEvent() != null) {
            this.deactivate();
        }
    }

    public void mouseExit(MouseEvent mouseEvent) {
        if (this.fHyperlinkPresenter instanceof IHyperlinkPresenterExtension && !((IHyperlinkPresenterExtension)((Object)this.fHyperlinkPresenter)).canHideHyperlinks()) {
            return;
        }
        this.deactivate();
    }

    public void mouseEnter(MouseEvent mouseEvent) {
    }

    public void mouseHover(MouseEvent mouseEvent) {
    }

    private boolean showHyperlinks(boolean bl) {
        if (this.fActiveHyperlinks == null || this.fActiveHyperlinks.length == 0) {
            this.fHyperlinkPresenter.hideHyperlinks();
            return false;
        }
        if (this.fActiveHyperlinks.length == 1 && bl) {
            this.fActiveHyperlinks[0].open();
        } else if (this.fHyperlinkPresenter instanceof IHyperlinkPresenterExtension2) {
            ((IHyperlinkPresenterExtension2)((Object)this.fHyperlinkPresenter)).showHyperlinks(this.fActiveHyperlinks, bl);
        } else {
            this.fHyperlinkPresenter.showHyperlinks(this.fActiveHyperlinks);
        }
        return true;
    }

    public boolean openHyperlink() {
        this.fActiveHyperlinkStateMask = this.fHyperlinkStateMask;
        if (this.fHyperlinkPresenter instanceof IHyperlinkPresenterExtension && !((IHyperlinkPresenterExtension)((Object)this.fHyperlinkPresenter)).canHideHyperlinks()) {
            return false;
        }
        ITextSelection iTextSelection = (ITextSelection)((TextViewer)this.fTextViewer).getSelection();
        int n = iTextSelection.getOffset();
        if (n == -1) {
            return false;
        }
        Region region = new Region(n, 0);
        this.fActiveHyperlinks = this.findHyperlinks((IRegion)region);
        return this.showHyperlinks(true);
    }

    public static final class DETECTION_STRATEGY {
        String fName;

        private DETECTION_STRATEGY(String string) {
            this.fName = string;
        }

        public String toString() {
            return this.fName;
        }
    }
}

