/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.hyperlink;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.ITextPresentationListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension2;
import org.eclipse.jface.text.ITextViewerExtension4;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.IHyperlinkPresenter;
import org.eclipse.jface.text.hyperlink.IHyperlinkPresenterExtension;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;

public class DefaultHyperlinkPresenter
implements IHyperlinkPresenter,
IHyperlinkPresenterExtension,
ITextPresentationListener,
ITextInputListener,
IDocumentListener,
IPropertyChangeListener {
    public static final String HYPERLINK_COLOR = "hyperlinkColor";
    public static final String HYPERLINK_COLOR_SYSTEM_DEFAULT = "hyperlinkColor.SystemDefault";
    private ITextViewer fTextViewer;
    private Color fColor;
    private boolean fIsUsingNativeLinkColor;
    private RGB fRGB;
    private boolean fDisposeColor;
    private IRegion fActiveRegion;
    private Position fRememberedPosition;
    private IPreferenceStore fPreferenceStore;

    public DefaultHyperlinkPresenter(IPreferenceStore iPreferenceStore) {
        this.fPreferenceStore = iPreferenceStore;
        this.fDisposeColor = true;
    }

    public DefaultHyperlinkPresenter(Color color) {
        this.fColor = color;
    }

    public DefaultHyperlinkPresenter(RGB rGB) {
        this.fRGB = rGB;
        this.fDisposeColor = true;
    }

    @Override
    public boolean canShowMultipleHyperlinks() {
        return false;
    }

    @Override
    public void showHyperlinks(IHyperlink[] iHyperlinkArray) {
        Assert.isLegal((iHyperlinkArray != null && iHyperlinkArray.length == 1 ? 1 : 0) != 0);
        this.highlightRegion(iHyperlinkArray[0].getHyperlinkRegion());
    }

    @Override
    public boolean canHideHyperlinks() {
        return true;
    }

    @Override
    public void hideHyperlinks() {
        this.repairRepresentation();
        this.fRememberedPosition = null;
    }

    @Override
    public void install(ITextViewer iTextViewer) {
        StyledText styledText;
        Assert.isNotNull((Object)iTextViewer);
        this.fTextViewer = iTextViewer;
        this.fTextViewer.addTextInputListener(this);
        if (this.fTextViewer instanceof ITextViewerExtension4) {
            ((ITextViewerExtension4)((Object)this.fTextViewer)).addTextPresentationListener(this);
        }
        if (this.fPreferenceStore != null) {
            this.fIsUsingNativeLinkColor = this.fPreferenceStore.getBoolean(HYPERLINK_COLOR_SYSTEM_DEFAULT);
            if (!this.fIsUsingNativeLinkColor) {
                this.fColor = this.createColorFromPreferenceStore();
            }
            this.fPreferenceStore.addPropertyChangeListener((IPropertyChangeListener)this);
        } else if (this.fRGB != null && (styledText = this.fTextViewer.getTextWidget()) != null && !styledText.isDisposed()) {
            this.fColor = new Color((Device)styledText.getDisplay(), this.fRGB);
        }
    }

    @Override
    public void uninstall() {
        this.fTextViewer.removeTextInputListener(this);
        IDocument iDocument = this.fTextViewer.getDocument();
        if (iDocument != null) {
            iDocument.removeDocumentListener((IDocumentListener)this);
        }
        if (this.fColor != null) {
            if (this.fDisposeColor) {
                this.fColor.dispose();
            }
            this.fColor = null;
        }
        if (this.fTextViewer instanceof ITextViewerExtension4) {
            ((ITextViewerExtension4)((Object)this.fTextViewer)).removeTextPresentationListener(this);
        }
        this.fTextViewer = null;
        if (this.fPreferenceStore != null) {
            this.fPreferenceStore.removePropertyChangeListener((IPropertyChangeListener)this);
            this.fPreferenceStore = null;
        }
    }

    public void setColor(Color color) {
        Assert.isNotNull((Object)this.fTextViewer);
        Assert.isTrue((this.fPreferenceStore == null ? 1 : 0) != 0, (String)"Cannot set color if preference store is set");
        if (this.fColor != null && this.fDisposeColor) {
            this.fColor.dispose();
        }
        this.fColor = color;
    }

    @Override
    public void applyTextPresentation(TextPresentation textPresentation) {
        if (this.fActiveRegion == null) {
            return;
        }
        IRegion iRegion = textPresentation.getExtent();
        if (this.fActiveRegion.getOffset() + this.fActiveRegion.getLength() >= iRegion.getOffset() && iRegion.getOffset() + iRegion.getLength() > this.fActiveRegion.getOffset()) {
            Color color = null;
            if (!this.fIsUsingNativeLinkColor) {
                color = this.fColor;
            }
            StyleRange styleRange = new StyleRange(this.fActiveRegion.getOffset(), this.fActiveRegion.getLength(), color, null);
            styleRange.underlineStyle = 4;
            styleRange.underline = true;
            textPresentation.mergeStyleRange(styleRange);
        }
    }

    private void highlightRegion(IRegion iRegion) {
        if (iRegion.equals(this.fActiveRegion)) {
            return;
        }
        this.repairRepresentation();
        StyledText styledText = this.fTextViewer.getTextWidget();
        if (styledText == null || styledText.isDisposed()) {
            return;
        }
        this.fActiveRegion = iRegion;
        if (this.fTextViewer instanceof ITextViewerExtension2) {
            ((ITextViewerExtension2)((Object)this.fTextViewer)).invalidateTextPresentation(iRegion.getOffset(), iRegion.getLength());
        } else {
            this.fTextViewer.invalidateTextPresentation();
        }
    }

    private void repairRepresentation() {
        if (this.fActiveRegion == null) {
            return;
        }
        int n = this.fActiveRegion.getOffset();
        int n2 = this.fActiveRegion.getLength();
        this.fActiveRegion = null;
        if (this.fTextViewer instanceof ITextViewerExtension2) {
            ((ITextViewerExtension2)((Object)this.fTextViewer)).invalidateTextPresentation(n, n2);
        } else {
            this.fTextViewer.invalidateTextPresentation();
        }
    }

    public void documentAboutToBeChanged(DocumentEvent documentEvent) {
        if (this.fActiveRegion != null) {
            this.fRememberedPosition = new Position(this.fActiveRegion.getOffset(), this.fActiveRegion.getLength());
            try {
                documentEvent.getDocument().addPosition(this.fRememberedPosition);
            }
            catch (BadLocationException badLocationException) {
                this.fRememberedPosition = null;
            }
        }
    }

    public void documentChanged(DocumentEvent documentEvent) {
        if (this.fRememberedPosition != null) {
            if (!this.fRememberedPosition.isDeleted()) {
                documentEvent.getDocument().removePosition(this.fRememberedPosition);
                this.fActiveRegion = new Region(this.fRememberedPosition.getOffset(), this.fRememberedPosition.getLength());
            } else {
                this.fActiveRegion = new Region(documentEvent.getOffset(), documentEvent.getLength());
            }
            this.fRememberedPosition = null;
            StyledText styledText = this.fTextViewer.getTextWidget();
            if (styledText != null && !styledText.isDisposed()) {
                styledText.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        DefaultHyperlinkPresenter.this.hideHyperlinks();
                    }
                });
            }
        }
    }

    @Override
    public void inputDocumentAboutToBeChanged(IDocument iDocument, IDocument iDocument2) {
        if (iDocument == null) {
            return;
        }
        this.hideHyperlinks();
        iDocument.removeDocumentListener((IDocumentListener)this);
    }

    @Override
    public void inputDocumentChanged(IDocument iDocument, IDocument iDocument2) {
        if (iDocument2 == null) {
            return;
        }
        iDocument2.addDocumentListener((IDocumentListener)this);
    }

    private Color createColorFromPreferenceStore() {
        StyledText styledText = this.fTextViewer.getTextWidget();
        if (styledText == null || styledText.isDisposed()) {
            return null;
        }
        RGB rGB = null;
        if (this.fPreferenceStore.contains(HYPERLINK_COLOR) && (rGB = this.fPreferenceStore.isDefault(HYPERLINK_COLOR) ? PreferenceConverter.getDefaultColor((IPreferenceStore)this.fPreferenceStore, (String)HYPERLINK_COLOR) : PreferenceConverter.getColor((IPreferenceStore)this.fPreferenceStore, (String)HYPERLINK_COLOR)) != null) {
            return new Color((Device)styledText.getDisplay(), rGB);
        }
        return null;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (HYPERLINK_COLOR.equals(propertyChangeEvent.getProperty())) {
            if (this.fColor != null && this.fDisposeColor) {
                this.fColor.dispose();
            }
            this.fColor = this.createColorFromPreferenceStore();
            return;
        }
        if (HYPERLINK_COLOR_SYSTEM_DEFAULT.equals(propertyChangeEvent.getProperty())) {
            this.fIsUsingNativeLinkColor = this.fPreferenceStore.getBoolean(HYPERLINK_COLOR_SYSTEM_DEFAULT);
            if (!this.fIsUsingNativeLinkColor && this.fColor == null) {
                this.fColor = this.createColorFromPreferenceStore();
            }
            return;
        }
    }
}

