/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.formatter;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultPositionUpdater;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.TypedPosition;
import org.eclipse.jface.text.formatter.FormattingContext;
import org.eclipse.jface.text.formatter.IContentFormatter;
import org.eclipse.jface.text.formatter.IContentFormatterExtension;
import org.eclipse.jface.text.formatter.IFormattingContext;
import org.eclipse.jface.text.formatter.IFormattingStrategy;
import org.eclipse.jface.text.formatter.IFormattingStrategyExtension;

public class MultiPassContentFormatter
implements IContentFormatter,
IContentFormatterExtension {
    private IFormattingStrategyExtension fMaster = null;
    private final String fPartitioning;
    private final Map fSlaves = new HashMap();
    private final String fType;

    public MultiPassContentFormatter(String string, String string2) {
        this.fPartitioning = string;
        this.fType = string2;
    }

    @Override
    public final void format(IDocument iDocument, IFormattingContext iFormattingContext) {
        iFormattingContext.setProperty("formatting.context.medium", iDocument);
        Boolean bl = (Boolean)iFormattingContext.getProperty("formatting.context.document");
        if (bl == null || !bl.booleanValue()) {
            IRegion iRegion = (IRegion)iFormattingContext.getProperty("formatting.context.region");
            if (iRegion != null) {
                try {
                    this.formatMaster(iFormattingContext, iDocument, iRegion.getOffset(), iRegion.getLength());
                }
                finally {
                    this.formatSlaves(iFormattingContext, iDocument, iRegion.getOffset(), iRegion.getLength());
                }
            }
        } else {
            try {
                this.formatMaster(iFormattingContext, iDocument, 0, iDocument.getLength());
            }
            finally {
                this.formatSlaves(iFormattingContext, iDocument, 0, iDocument.getLength());
            }
        }
    }

    @Override
    public final void format(IDocument iDocument, IRegion iRegion) {
        FormattingContext formattingContext = new FormattingContext();
        formattingContext.setProperty("formatting.context.document", Boolean.FALSE);
        formattingContext.setProperty("formatting.context.region", iRegion);
        this.format(iDocument, formattingContext);
    }

    protected void formatMaster(IFormattingContext iFormattingContext, IDocument iDocument, int n, int n2) {
        try {
            int n3 = n - iDocument.getLineInformationOfOffset(n).getOffset();
            n -= n3;
            n2 += n3;
        }
        catch (BadLocationException badLocationException) {}
        if (this.fMaster != null) {
            iFormattingContext.setProperty("formatting.context.partition", new TypedPosition(n, n2, this.fType));
            this.fMaster.formatterStarts(iFormattingContext);
            this.fMaster.format();
            this.fMaster.formatterStops();
        }
    }

    protected void formatSlave(IFormattingContext iFormattingContext, IDocument iDocument, int n, int n2, String string) {
        IFormattingStrategyExtension iFormattingStrategyExtension = (IFormattingStrategyExtension)this.fSlaves.get(string);
        if (iFormattingStrategyExtension != null) {
            iFormattingContext.setProperty("formatting.context.partition", new TypedPosition(n, n2, string));
            iFormattingStrategyExtension.formatterStarts(iFormattingContext);
            iFormattingStrategyExtension.format();
            iFormattingStrategyExtension.formatterStops();
        }
    }

    protected void formatSlaves(IFormattingContext iFormattingContext, IDocument iDocument, int n, int n2) {
        Map map = new HashMap(0);
        try {
            try {
                ITypedRegion[] iTypedRegionArray = TextUtilities.computePartitioning((IDocument)iDocument, (String)this.fPartitioning, (int)n, (int)n2, (boolean)false);
                if (!this.fType.equals(iTypedRegionArray[0].getType())) {
                    iTypedRegionArray[0] = TextUtilities.getPartition((IDocument)iDocument, (String)this.fPartitioning, (int)iTypedRegionArray[0].getOffset(), (boolean)false);
                }
                if (iTypedRegionArray.length > 1 && !this.fType.equals(iTypedRegionArray[iTypedRegionArray.length - 1].getType())) {
                    iTypedRegionArray[iTypedRegionArray.length - 1] = TextUtilities.getPartition((IDocument)iDocument, (String)this.fPartitioning, (int)iTypedRegionArray[iTypedRegionArray.length - 1].getOffset(), (boolean)false);
                }
                String string = null;
                ITypedRegion iTypedRegion = null;
                map = TextUtilities.removeDocumentPartitioners((IDocument)iDocument);
                int n3 = iTypedRegionArray.length - 1;
                while (n3 >= 0) {
                    iTypedRegion = iTypedRegionArray[n3];
                    string = iTypedRegion.getType();
                    if (!this.fType.equals(string)) {
                        this.formatSlave(iFormattingContext, iDocument, iTypedRegion.getOffset(), iTypedRegion.getLength(), string);
                    }
                    --n3;
                }
            }
            catch (BadLocationException badLocationException) {
                TextUtilities.addDocumentPartitioners((IDocument)iDocument, map);
            }
        }
        finally {
            TextUtilities.addDocumentPartitioners((IDocument)iDocument, map);
        }
    }

    @Override
    public final IFormattingStrategy getFormattingStrategy(String string) {
        return null;
    }

    public final void setMasterStrategy(IFormattingStrategy iFormattingStrategy) {
        Assert.isTrue((boolean)(iFormattingStrategy instanceof IFormattingStrategyExtension));
        this.fMaster = (IFormattingStrategyExtension)((Object)iFormattingStrategy);
    }

    public final void setSlaveStrategy(IFormattingStrategy iFormattingStrategy, String string) {
        Assert.isTrue((boolean)(iFormattingStrategy instanceof IFormattingStrategyExtension));
        if (!this.fType.equals(string)) {
            this.fSlaves.put(string, iFormattingStrategy);
        }
    }

    protected class NonDeletingPositionUpdater
    extends DefaultPositionUpdater {
        public NonDeletingPositionUpdater(String string) {
            super(string);
        }

        protected final boolean notDeleted() {
            int n;
            if (this.fOffset < this.fPosition.offset && this.fPosition.offset + this.fPosition.length < this.fOffset + this.fLength && (n = this.fOffset + this.fLength) < this.fDocument.getLength()) {
                try {
                    boolean bl = false;
                    char c = this.fDocument.getChar(n);
                    while (n < this.fDocument.getLength() && Character.isWhitespace(c)) {
                        bl = true;
                        c = this.fDocument.getChar(n++);
                    }
                    if (bl) {
                        --n;
                    }
                }
                catch (BadLocationException badLocationException) {}
                this.fPosition.offset = n;
                this.fPosition.length = 0;
            }
            return true;
        }
    }
}

