/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.formatter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DefaultPositionUpdater;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.TypedPosition;
import org.eclipse.jface.text.formatter.IContentFormatter;
import org.eclipse.jface.text.formatter.IFormattingStrategy;

public class ContentFormatter
implements IContentFormatter {
    private static final String PARTITIONING = "__formatter_partitioning";
    private Map fStrategies;
    private boolean fIsPartitionAware = true;
    private String[] fPartitionManagingCategories;
    private List fOverlappingPositionReferences;
    private IPositionUpdater fPartitioningUpdater;
    private String fPartitioning = "__dftl_partitioning";
    private IDocument fDocument;
    private String[] fExternalPartitonManagingCategories;
    private boolean fNeedsComputation = true;

    public void setFormattingStrategy(IFormattingStrategy iFormattingStrategy, String string) {
        Assert.isNotNull((Object)string);
        if (this.fStrategies == null) {
            this.fStrategies = new HashMap();
        }
        if (iFormattingStrategy == null) {
            this.fStrategies.remove(string);
        } else {
            this.fStrategies.put(string, iFormattingStrategy);
        }
    }

    public void setPartitionManagingPositionCategories(String[] stringArray) {
        this.fExternalPartitonManagingCategories = TextUtilities.copy((String[])stringArray);
    }

    public void setDocumentPartitioning(String string) {
        this.fPartitioning = string;
    }

    public void enablePartitionAwareFormatting(boolean bl) {
        this.fIsPartitionAware = bl;
    }

    @Override
    public IFormattingStrategy getFormattingStrategy(String string) {
        Assert.isNotNull((Object)string);
        if (this.fStrategies == null) {
            return null;
        }
        return (IFormattingStrategy)this.fStrategies.get(string);
    }

    @Override
    public void format(IDocument iDocument, IRegion iRegion) {
        this.fNeedsComputation = true;
        this.fDocument = iDocument;
        try {
            if (this.fIsPartitionAware) {
                this.formatPartitions(iRegion);
            } else {
                this.formatRegion(iRegion);
            }
        }
        finally {
            this.fNeedsComputation = true;
            this.fDocument = null;
        }
    }

    private void formatPartitions(IRegion iRegion) {
        this.addPartitioningUpdater();
        try {
            TypedPosition[] typedPositionArray = this.getPartitioning(iRegion);
            if (typedPositionArray != null) {
                this.start(typedPositionArray, this.getIndentation(iRegion.getOffset()));
                this.format(typedPositionArray);
                this.stop(typedPositionArray);
            }
        }
        catch (BadLocationException badLocationException) {}
        this.removePartitioningUpdater();
    }

    private void formatRegion(IRegion iRegion) {
        IFormattingStrategy iFormattingStrategy = this.getFormattingStrategy("__dftl_partition_content_type");
        if (iFormattingStrategy != null) {
            iFormattingStrategy.formatterStarts(this.getIndentation(iRegion.getOffset()));
            this.format(iFormattingStrategy, new TypedPosition(iRegion.getOffset(), iRegion.getLength(), "__dftl_partition_content_type"));
            iFormattingStrategy.formatterStops();
        }
    }

    private TypedPosition[] getPartitioning(IRegion iRegion) throws BadLocationException {
        ITypedRegion[] iTypedRegionArray = TextUtilities.computePartitioning((IDocument)this.fDocument, (String)this.fPartitioning, (int)iRegion.getOffset(), (int)iRegion.getLength(), (boolean)false);
        TypedPosition[] typedPositionArray = new TypedPosition[iTypedRegionArray.length];
        int n = 0;
        while (n < iTypedRegionArray.length) {
            typedPositionArray[n] = new TypedPosition(iTypedRegionArray[n]);
            try {
                this.fDocument.addPosition(PARTITIONING, (Position)typedPositionArray[n]);
            }
            catch (BadPositionCategoryException badPositionCategoryException) {}
            ++n;
        }
        return typedPositionArray;
    }

    private void start(TypedPosition[] typedPositionArray, String string) {
        int n = 0;
        while (n < typedPositionArray.length) {
            IFormattingStrategy iFormattingStrategy = this.getFormattingStrategy(typedPositionArray[n].getType());
            if (iFormattingStrategy != null) {
                iFormattingStrategy.formatterStarts(string);
            }
            ++n;
        }
    }

    private void format(TypedPosition[] typedPositionArray) {
        int n = 0;
        while (n < typedPositionArray.length) {
            IFormattingStrategy iFormattingStrategy = this.getFormattingStrategy(typedPositionArray[n].getType());
            if (iFormattingStrategy != null) {
                this.format(iFormattingStrategy, typedPositionArray[n]);
            }
            ++n;
        }
    }

    private void format(IFormattingStrategy iFormattingStrategy, TypedPosition typedPosition) {
        try {
            int n = typedPosition.getOffset();
            int n2 = typedPosition.getLength();
            String string = this.fDocument.get(n, n2);
            int[] nArray = this.getAffectedPositions(n, n2);
            String string2 = iFormattingStrategy.format(string, this.isLineStart(n), this.getIndentation(n), nArray);
            if (string2 != null && !string2.equals(string)) {
                RemoveAffectedPositions removeAffectedPositions = new RemoveAffectedPositions();
                this.fDocument.insertPositionUpdater((IPositionUpdater)removeAffectedPositions, 0);
                UpdateAffectedPositions updateAffectedPositions = new UpdateAffectedPositions(nArray, n);
                this.fDocument.addPositionUpdater((IPositionUpdater)updateAffectedPositions);
                this.fDocument.replace(n, n2, string2);
                this.fDocument.removePositionUpdater((IPositionUpdater)removeAffectedPositions);
                this.fDocument.removePositionUpdater((IPositionUpdater)updateAffectedPositions);
            }
        }
        catch (BadLocationException badLocationException) {}
    }

    private void stop(TypedPosition[] typedPositionArray) {
        int n = 0;
        while (n < typedPositionArray.length) {
            IFormattingStrategy iFormattingStrategy = this.getFormattingStrategy(typedPositionArray[n].getType());
            if (iFormattingStrategy != null) {
                iFormattingStrategy.formatterStops();
            }
            ++n;
        }
    }

    private void addPartitioningUpdater() {
        this.fPartitioningUpdater = new NonDeletingPositionUpdater(PARTITIONING);
        this.fDocument.addPositionCategory(PARTITIONING);
        this.fDocument.addPositionUpdater(this.fPartitioningUpdater);
    }

    private void removePartitioningUpdater() {
        try {
            this.fDocument.removePositionUpdater(this.fPartitioningUpdater);
            this.fDocument.removePositionCategory(PARTITIONING);
            this.fPartitioningUpdater = null;
        }
        catch (BadPositionCategoryException badPositionCategoryException) {}
    }

    private String[] getPartitionManagingCategories() {
        if (this.fNeedsComputation) {
            this.fNeedsComputation = false;
            this.fPartitionManagingCategories = TextUtilities.computePartitionManagingCategories((IDocument)this.fDocument);
            if (this.fPartitionManagingCategories == null) {
                this.fPartitionManagingCategories = this.fExternalPartitonManagingCategories;
            }
        }
        return this.fPartitionManagingCategories;
    }

    private boolean ignoreCategory(String string) {
        if (PARTITIONING.equals(string)) {
            return true;
        }
        String[] stringArray = this.getPartitionManagingCategories();
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n].equals(string)) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    private void determinePositionsToUpdate(int n, int n2) {
        String[] stringArray = this.fDocument.getPositionCategories();
        if (stringArray != null) {
            int n3 = 0;
            while (n3 < stringArray.length) {
                if (!this.ignoreCategory(stringArray[n3])) {
                    try {
                        Position[] positionArray = this.fDocument.getPositions(stringArray[n3]);
                        int n4 = 0;
                        while (n4 < positionArray.length) {
                            Position position = positionArray[n4];
                            if (position.overlapsWith(n, n2)) {
                                if (n < position.getOffset()) {
                                    this.fOverlappingPositionReferences.add(new PositionReference(position, true, stringArray[n3]));
                                }
                                if (position.getOffset() + position.getLength() < n + n2) {
                                    this.fOverlappingPositionReferences.add(new PositionReference(position, false, stringArray[n3]));
                                }
                            }
                            ++n4;
                        }
                    }
                    catch (BadPositionCategoryException badPositionCategoryException) {}
                }
                ++n3;
            }
        }
    }

    private int[] getAffectedPositions(int n, int n2) {
        this.fOverlappingPositionReferences = new ArrayList();
        this.determinePositionsToUpdate(n, n2);
        Collections.sort(this.fOverlappingPositionReferences);
        int[] nArray = new int[this.fOverlappingPositionReferences.size()];
        int n3 = 0;
        while (n3 < nArray.length) {
            PositionReference positionReference = (PositionReference)this.fOverlappingPositionReferences.get(n3);
            nArray[n3] = positionReference.getCharacterPosition() - n;
            ++n3;
        }
        return nArray;
    }

    private void removeAffectedPositions(IDocument iDocument) {
        int n = this.fOverlappingPositionReferences.size();
        int n2 = 0;
        while (n2 < n) {
            PositionReference positionReference = (PositionReference)this.fOverlappingPositionReferences.get(n2);
            try {
                iDocument.removePosition(positionReference.getCategory(), positionReference.getPosition());
            }
            catch (BadPositionCategoryException badPositionCategoryException) {}
            ++n2;
        }
    }

    protected void updateAffectedPositions(IDocument iDocument, int[] nArray, int n) {
        if (iDocument != this.fDocument) {
            return;
        }
        if (nArray.length == 0) {
            return;
        }
        int n2 = 0;
        while (n2 < nArray.length) {
            PositionReference positionReference = (PositionReference)this.fOverlappingPositionReferences.get(n2);
            if (positionReference.refersToOffset()) {
                positionReference.setOffset(n + nArray[n2]);
            } else {
                positionReference.setLength(n + nArray[n2] - positionReference.getOffset());
            }
            Position position = positionReference.getPosition();
            String string = positionReference.getCategory();
            if (!iDocument.containsPosition(string, position.offset, position.length)) {
                try {
                    if (this.positionAboutToBeAdded(iDocument, string, position)) {
                        iDocument.addPosition(positionReference.getCategory(), position);
                    }
                }
                catch (BadPositionCategoryException badPositionCategoryException) {
                }
                catch (BadLocationException badLocationException) {}
            }
            ++n2;
        }
        this.fOverlappingPositionReferences = null;
    }

    protected boolean positionAboutToBeAdded(IDocument iDocument, String string, Position position) {
        return true;
    }

    private String getIndentation(int n) {
        try {
            int n2 = this.fDocument.getLineOfOffset(n);
            int n3 = n2 = this.fDocument.getLineOffset(n2);
            char c = this.fDocument.getChar(n3);
            while ('\t' == c || ' ' == c) {
                c = this.fDocument.getChar(++n3);
            }
            return this.fDocument.get(n2, n3 - n2);
        }
        catch (BadLocationException badLocationException) {
            return "";
        }
    }

    private boolean isLineStart(int n) throws BadLocationException {
        int n2 = this.fDocument.getLineOfOffset(n);
        return (n2 = this.fDocument.getLineOffset(n2)) == n;
    }

    class NonDeletingPositionUpdater
    extends DefaultPositionUpdater {
        protected NonDeletingPositionUpdater(String string) {
            super(string);
        }

        protected boolean notDeleted() {
            return true;
        }
    }

    static class PositionReference
    implements Comparable {
        protected Position fPosition;
        protected boolean fRefersToOffset;
        protected String fCategory;

        protected PositionReference(Position position, boolean bl, String string) {
            this.fPosition = position;
            this.fRefersToOffset = bl;
            this.fCategory = string;
        }

        protected int getOffset() {
            return this.fPosition.getOffset();
        }

        protected void setOffset(int n) {
            this.fPosition.setOffset(n);
        }

        protected int getLength() {
            return this.fPosition.getLength();
        }

        protected void setLength(int n) {
            this.fPosition.setLength(n);
        }

        protected boolean refersToOffset() {
            return this.fRefersToOffset;
        }

        protected String getCategory() {
            return this.fCategory;
        }

        protected Position getPosition() {
            return this.fPosition;
        }

        protected int getCharacterPosition() {
            if (this.fRefersToOffset) {
                return this.getOffset();
            }
            return this.getOffset() + this.getLength();
        }

        public int compareTo(Object object) {
            if (object instanceof PositionReference) {
                PositionReference positionReference = (PositionReference)object;
                return this.getCharacterPosition() - positionReference.getCharacterPosition();
            }
            throw new ClassCastException();
        }
    }

    class RemoveAffectedPositions
    implements IPositionUpdater {
        RemoveAffectedPositions() {
        }

        public void update(DocumentEvent documentEvent) {
            ContentFormatter.this.removeAffectedPositions(documentEvent.getDocument());
        }
    }

    class UpdateAffectedPositions
    implements IPositionUpdater {
        private int[] fPositions;
        private int fOffset;

        public UpdateAffectedPositions(int[] nArray, int n) {
            this.fPositions = nArray;
            this.fOffset = n;
        }

        public void update(DocumentEvent documentEvent) {
            ContentFormatter.this.updateAffectedPositions(documentEvent.getDocument(), this.fPositions, this.fOffset);
        }
    }
}

