/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.contentassist;

import org.eclipse.jface.internal.text.DelayedInputChangeListener;
import org.eclipse.jface.internal.text.InformationControlReplacer;
import org.eclipse.jface.text.IDelayedInputChangeProvider;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlExtension5;
import org.eclipse.jface.text.contentassist.AdditionalInfoController;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.Helper;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Widget;

class PopupCloser
extends ShellAdapter
implements FocusListener,
SelectionListener,
Listener {
    private ContentAssistant fContentAssistant;
    private Table fTable;
    private ScrollBar fScrollbar;
    private boolean fScrollbarClicked = false;
    private Shell fShell;
    private Display fDisplay;
    private AdditionalInfoController fAdditionalInfoController;

    PopupCloser() {
    }

    public void install(ContentAssistant contentAssistant, Table table) {
        this.install(contentAssistant, table, null);
    }

    public void install(ContentAssistant contentAssistant, Table table, AdditionalInfoController additionalInfoController) {
        this.fContentAssistant = contentAssistant;
        this.fTable = table;
        this.fAdditionalInfoController = additionalInfoController;
        if (Helper.okToUse((Widget)this.fTable)) {
            this.fShell = this.fTable.getShell();
            this.fDisplay = this.fShell.getDisplay();
            this.fShell.addShellListener((ShellListener)this);
            this.fTable.addFocusListener((FocusListener)this);
            this.fScrollbar = this.fTable.getVerticalBar();
            if (this.fScrollbar != null) {
                this.fScrollbar.addSelectionListener((SelectionListener)this);
            }
            this.fDisplay.addFilter(26, (Listener)this);
            this.fDisplay.addFilter(37, (Listener)this);
            this.fDisplay.addFilter(27, (Listener)this);
            this.fDisplay.addFilter(4, (Listener)this);
        }
    }

    public void uninstall() {
        this.fContentAssistant = null;
        if (Helper.okToUse((Widget)this.fShell)) {
            this.fShell.removeShellListener((ShellListener)this);
        }
        this.fShell = null;
        if (Helper.okToUse((Widget)this.fScrollbar)) {
            this.fScrollbar.removeSelectionListener((SelectionListener)this);
        }
        if (Helper.okToUse((Widget)this.fTable)) {
            this.fTable.removeFocusListener((FocusListener)this);
        }
        if (this.fDisplay != null && !this.fDisplay.isDisposed()) {
            this.fDisplay.removeFilter(26, (Listener)this);
            this.fDisplay.removeFilter(37, (Listener)this);
            this.fDisplay.removeFilter(27, (Listener)this);
            this.fDisplay.removeFilter(4, (Listener)this);
        }
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        this.fScrollbarClicked = true;
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        this.fScrollbarClicked = true;
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(final FocusEvent focusEvent) {
        this.fScrollbarClicked = false;
        Display display = this.fTable.getDisplay();
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                if (Helper.okToUse((Widget)PopupCloser.this.fTable) && !PopupCloser.this.fTable.isFocusControl() && !PopupCloser.this.fScrollbarClicked && PopupCloser.this.fContentAssistant != null) {
                    PopupCloser.this.fContentAssistant.popupFocusLost(focusEvent);
                }
            }
        });
    }

    public void shellDeactivated(ShellEvent shellEvent) {
        if (this.fContentAssistant != null && this.fDisplay != null) {
            this.fDisplay.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (PopupCloser.this.fContentAssistant != null && !PopupCloser.this.fContentAssistant.hasProposalPopupFocus()) {
                        PopupCloser.this.fContentAssistant.hide();
                    }
                }
            });
        }
    }

    public void shellClosed(ShellEvent shellEvent) {
        if (this.fContentAssistant != null) {
            this.fContentAssistant.hide();
        }
    }

    public void handleEvent(Event event) {
        switch (event.type) {
            case 26: 
            case 37: {
                if (this.fAdditionalInfoController == null) {
                    return;
                }
                if (event.widget == this.fShell || event.widget == this.fTable || event.widget == this.fScrollbar) {
                    return;
                }
                if (this.fAdditionalInfoController.getInternalAccessor().getInformationControlReplacer() == null) {
                    this.fAdditionalInfoController.hideInformationControl();
                    break;
                }
                if (this.fAdditionalInfoController.getInternalAccessor().isReplaceInProgress()) break;
                IInformationControl iInformationControl = this.fAdditionalInfoController.getCurrentInformationControl2();
                if (event.widget instanceof Control && iInformationControl instanceof IInformationControlExtension5) {
                    IInformationControlExtension5 iInformationControlExtension5 = (IInformationControlExtension5)((Object)iInformationControl);
                    Control control = (Control)event.widget;
                    if (!iInformationControlExtension5.containsControl(control)) {
                        this.fAdditionalInfoController.hideInformationControl();
                        break;
                    }
                    if (event.type != 37) break;
                    this.fAdditionalInfoController.getInternalAccessor().replaceInformationControl(false);
                    break;
                }
                if (iInformationControl == null || !iInformationControl.isFocusControl()) break;
                this.fAdditionalInfoController.getInternalAccessor().replaceInformationControl(true);
                break;
            }
            case 4: {
                IInformationControlExtension5 iInformationControlExtension5;
                if (this.fAdditionalInfoController == null || this.fAdditionalInfoController.getInternalAccessor().isReplaceInProgress() || !(event.widget instanceof Control)) break;
                Control control = (Control)event.widget;
                IInformationControl iInformationControl = this.fAdditionalInfoController.getCurrentInformationControl2();
                if (!(iInformationControl instanceof IInformationControlExtension5) || !(iInformationControlExtension5 = (IInformationControlExtension5)((Object)iInformationControl)).containsControl(control)) break;
                if (iInformationControl instanceof IDelayedInputChangeProvider) {
                    final IDelayedInputChangeProvider iDelayedInputChangeProvider = (IDelayedInputChangeProvider)((Object)iInformationControl);
                    DelayedInputChangeListener delayedInputChangeListener = new DelayedInputChangeListener(iDelayedInputChangeProvider, this.fAdditionalInfoController.getInternalAccessor().getInformationControlReplacer());
                    iDelayedInputChangeProvider.setDelayedInputChangeListener(delayedInputChangeListener);
                    control.getShell().getDisplay().timerExec(1000, new Runnable(){

                        @Override
                        public void run() {
                            iDelayedInputChangeProvider.setDelayedInputChangeListener(null);
                        }
                    });
                }
                control.getShell().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        PopupCloser.this.fAdditionalInfoController.getInternalAccessor().replaceInformationControl(true);
                    }
                });
                break;
            }
            case 27: {
                Control control;
                IInformationControlExtension5 iInformationControlExtension5;
                InformationControlReplacer informationControlReplacer;
                if (this.fAdditionalInfoController == null || (informationControlReplacer = this.fAdditionalInfoController.getInternalAccessor().getInformationControlReplacer()) == null || this.fContentAssistant == null) break;
                IInformationControl iInformationControl = informationControlReplacer.getCurrentInformationControl2();
                if (!(event.widget instanceof Control) || !(iInformationControl instanceof IInformationControlExtension5) || !(iInformationControlExtension5 = (IInformationControlExtension5)((Object)iInformationControl)).containsControl(control = (Control)event.widget)) break;
                control.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (PopupCloser.this.fContentAssistant != null && !PopupCloser.this.fContentAssistant.hasProposalPopupFocus()) {
                            PopupCloser.this.fContentAssistant.hide();
                        }
                    }
                });
            }
        }
    }
}

