/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.contentassist;

import java.util.Stack;
import org.eclipse.jface.contentassist.IContentAssistSubjectControl;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.contentassist.ContentAssistSubjectControlAdapter;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.Helper;
import org.eclipse.jface.text.contentassist.IContentAssistListener;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationExtension;
import org.eclipse.jface.text.contentassist.IContextInformationPresenter;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jface.text.contentassist.PopupCloser;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

class ContextInformationPopup
implements IContentAssistListener {
    private ITextViewer fViewer;
    private ContentAssistant fContentAssistant;
    private PopupCloser fPopupCloser = new PopupCloser();
    private Shell fContextSelectorShell;
    private Table fContextSelectorTable;
    private IContextInformation[] fContextSelectorInput;
    private String fLineDelimiter = null;
    private Shell fContextInfoPopup;
    private StyledText fContextInfoText;
    private TextPresentation fTextPresentation;
    private Stack fContextFrameStack = new Stack();
    private IContentAssistSubjectControl fContentAssistSubjectControl;
    private ContentAssistSubjectControlAdapter fContentAssistSubjectControlAdapter;
    private SelectionListener fTextWidgetSelectionListener;
    private ContextFrame fLastContext = null;

    public ContextInformationPopup(ContentAssistant contentAssistant, ITextViewer iTextViewer) {
        this.fContentAssistant = contentAssistant;
        this.fViewer = iTextViewer;
        this.fContentAssistSubjectControlAdapter = new ContentAssistSubjectControlAdapter(this.fViewer);
    }

    public ContextInformationPopup(ContentAssistant contentAssistant, IContentAssistSubjectControl iContentAssistSubjectControl) {
        this.fContentAssistant = contentAssistant;
        this.fContentAssistSubjectControl = iContentAssistSubjectControl;
        this.fContentAssistSubjectControlAdapter = new ContentAssistSubjectControlAdapter(this.fContentAssistSubjectControl);
    }

    public String showContextProposals(boolean bl) {
        Control control = this.fContentAssistSubjectControlAdapter.getControl();
        BusyIndicator.showWhile((Display)control.getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                int n;
                int n2 = ((ContextInformationPopup)ContextInformationPopup.this).fContentAssistSubjectControlAdapter.getSelectedRange().x;
                IContextInformation[] iContextInformationArray = ContextInformationPopup.this.computeContextInformation(n2);
                int n3 = n = iContextInformationArray == null ? 0 : iContextInformationArray.length;
                if (n == 1) {
                    ContextFrame contextFrame = ContextInformationPopup.this.createContextFrame(iContextInformationArray[0], n2);
                    if (ContextInformationPopup.this.isDuplicate(contextFrame)) {
                        ContextInformationPopup.this.validateContextInformation();
                    } else {
                        ContextInformationPopup.this.internalShowContextInfo(contextFrame);
                    }
                } else if (n > 0) {
                    int n4 = 0;
                    int n5 = 0;
                    while (n5 < iContextInformationArray.length) {
                        IContextInformation iContextInformation = iContextInformationArray[n5];
                        ContextFrame contextFrame = ContextInformationPopup.this.createContextFrame(iContextInformation, n2);
                        if (ContextInformationPopup.this.isDuplicate(contextFrame)) {
                            ContextInformationPopup.this.validateContextInformation();
                            return;
                        }
                        if (ContextInformationPopup.this.isLastFrame(contextFrame)) {
                            n4 = n5;
                        }
                        for (ContextFrame contextFrame2 : ContextInformationPopup.this.fContextFrameStack) {
                            if (!contextFrame2.equals(contextFrame)) continue;
                            ContextInformationPopup.this.validateContextInformation();
                            return;
                        }
                        ++n5;
                    }
                    if (ContextInformationPopup.this.fLineDelimiter == null) {
                        ContextInformationPopup.this.fLineDelimiter = ContextInformationPopup.this.fContentAssistSubjectControlAdapter.getLineDelimiter();
                    }
                    ContextInformationPopup.this.createContextSelector();
                    ContextInformationPopup.this.setContexts(iContextInformationArray, n4);
                    ContextInformationPopup.this.displayContextSelector();
                }
            }
        });
        return this.getErrorMessage();
    }

    public void showContextInformation(final IContextInformation iContextInformation, final int n) {
        Control control = this.fContentAssistSubjectControlAdapter.getControl();
        BusyIndicator.showWhile((Display)control.getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                if (iContextInformation == null) {
                    ContextInformationPopup.this.validateContextInformation();
                } else {
                    ContextFrame contextFrame = ContextInformationPopup.this.createContextFrame(iContextInformation, n);
                    if (ContextInformationPopup.this.isDuplicate(contextFrame)) {
                        ContextInformationPopup.this.validateContextInformation();
                    } else {
                        ContextInformationPopup.this.internalShowContextInfo(contextFrame);
                    }
                    ContextInformationPopup.this.hideContextSelector();
                }
            }
        });
    }

    private void internalShowContextInfo(ContextFrame contextFrame) {
        if (contextFrame != null) {
            this.fContextFrameStack.push(contextFrame);
            if (this.fContextFrameStack.size() == 1) {
                this.fLastContext = null;
            }
            this.internalShowContextFrame(contextFrame, this.fContextFrameStack.size() == 1);
            this.validateContextInformation();
        }
    }

    private ContextFrame createContextFrame(IContextInformation iContextInformation, int n) {
        IContextInformationValidator iContextInformationValidator = this.fContentAssistSubjectControlAdapter.getContextInformationValidator(this.fContentAssistant, n);
        if (iContextInformationValidator != null) {
            int n2;
            int n3 = n2 = iContextInformation instanceof IContextInformationExtension ? ((IContextInformationExtension)((Object)iContextInformation)).getContextInformationPosition() : n;
            if (n2 == -1) {
                n2 = n;
            }
            int n4 = this.fContentAssistSubjectControlAdapter.getWidgetSelectionRange().x - (n - n2);
            IContextInformationPresenter iContextInformationPresenter = this.fContentAssistSubjectControlAdapter.getContextInformationPresenter(this.fContentAssistant, n);
            return new ContextFrame(iContextInformation, n2, n, n4, iContextInformationValidator, iContextInformationPresenter);
        }
        return null;
    }

    private boolean isDuplicate(ContextFrame contextFrame) {
        if (contextFrame == null) {
            return false;
        }
        if (this.fContextFrameStack.isEmpty()) {
            return false;
        }
        ContextFrame contextFrame2 = (ContextFrame)this.fContextFrameStack.peek();
        return contextFrame.equals(contextFrame2);
    }

    private boolean isLastFrame(ContextFrame contextFrame) {
        return contextFrame != null && contextFrame.equals(this.fLastContext);
    }

    private void internalShowContextFrame(ContextFrame contextFrame, boolean bl) {
        this.fContentAssistSubjectControlAdapter.installValidator(contextFrame);
        if (contextFrame.fPresenter != null) {
            if (this.fTextPresentation == null) {
                this.fTextPresentation = new TextPresentation();
            }
            this.fContentAssistSubjectControlAdapter.installContextInformationPresenter(contextFrame);
            contextFrame.fPresenter.updatePresentation(contextFrame.fOffset, this.fTextPresentation);
        }
        this.createContextInfoPopup();
        this.fContextInfoText.setText(contextFrame.fInformation.getInformationDisplayString());
        if (this.fTextPresentation != null) {
            TextPresentation.applyTextPresentation(this.fTextPresentation, this.fContextInfoText);
        }
        this.resize(contextFrame.fVisibleOffset);
        if (bl) {
            if (this.fContentAssistant.addContentAssistListener(this, 2)) {
                if (this.fContentAssistSubjectControlAdapter.getControl() != null) {
                    this.fTextWidgetSelectionListener = new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent selectionEvent) {
                            ContextInformationPopup.this.validateContextInformation();
                        }
                    };
                    this.fContentAssistSubjectControlAdapter.addSelectionListener(this.fTextWidgetSelectionListener);
                }
                this.fContentAssistant.addToLayout(this, this.fContextInfoPopup, 2, contextFrame.fVisibleOffset);
                this.fContextInfoPopup.setVisible(true);
            }
        } else {
            this.fContentAssistant.layout(2, contextFrame.fVisibleOffset);
        }
    }

    private IContextInformation[] computeContextInformation(int n) {
        return this.fContentAssistSubjectControlAdapter.computeContextInformation(this.fContentAssistant, n);
    }

    private String getErrorMessage() {
        return this.fContentAssistant.getErrorMessage();
    }

    private void createContextInfoPopup() {
        if (Helper.okToUse((Widget)this.fContextInfoPopup)) {
            return;
        }
        Control control = this.fContentAssistSubjectControlAdapter.getControl();
        Display display = control.getDisplay();
        this.fContextInfoPopup = new Shell(control.getShell(), 16392);
        this.fContextInfoPopup.setBackground(display.getSystemColor(2));
        this.fContextInfoText = new StyledText((Composite)this.fContextInfoPopup, 74);
        Color color = this.fContentAssistant.getContextInformationPopupBackground();
        if (color == null) {
            color = display.getSystemColor(29);
        }
        this.fContextInfoText.setBackground(color);
        color = this.fContentAssistant.getContextInformationPopupForeground();
        if (color == null) {
            color = display.getSystemColor(28);
        }
        this.fContextInfoText.setForeground(color);
    }

    private void resize(int n) {
        Point point = this.fContextInfoText.computeSize(-1, -1, true);
        point.x += 2;
        Rectangle rectangle = this.fContentAssistant.getLayoutManager().computeBoundsAboveBelow(this.fContextInfoPopup, point, n);
        if (rectangle.width < point.x) {
            point = this.fContextInfoText.computeSize(rectangle.width - 2, -1, true);
        }
        point.x += 0;
        this.fContextInfoText.setSize(point);
        this.fContextInfoText.setLocation(1, 1);
        point.x += 2;
        point.y += 2;
        this.fContextInfoPopup.setSize(point);
    }

    private void hideContextInfoPopup() {
        if (Helper.okToUse((Widget)this.fContextInfoPopup)) {
            int n = this.fContextFrameStack.size();
            if (n > 0) {
                this.fLastContext = (ContextFrame)this.fContextFrameStack.pop();
                --n;
            }
            if (n > 0) {
                ContextFrame contextFrame = (ContextFrame)this.fContextFrameStack.peek();
                this.internalShowContextFrame(contextFrame, false);
            } else {
                this.fContentAssistant.removeContentAssistListener(this, 2);
                if (this.fContentAssistSubjectControlAdapter.getControl() != null) {
                    this.fContentAssistSubjectControlAdapter.removeSelectionListener(this.fTextWidgetSelectionListener);
                }
                this.fTextWidgetSelectionListener = null;
                this.fContextInfoPopup.setVisible(false);
                this.fContextInfoPopup.dispose();
                this.fContextInfoPopup = null;
                if (this.fTextPresentation != null) {
                    this.fTextPresentation.clear();
                    this.fTextPresentation = null;
                }
            }
        }
        if (this.fContextInfoPopup == null) {
            this.fContentAssistant.contextInformationClosed();
        }
    }

    private void createContextSelector() {
        StyledText styledText;
        ITextViewerExtension iTextViewerExtension;
        if (Helper.okToUse((Widget)this.fContextSelectorShell)) {
            return;
        }
        Control control = this.fContentAssistSubjectControlAdapter.getControl();
        this.fContextSelectorShell = new Shell(control.getShell(), 16400);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.fContextSelectorShell.setLayout((Layout)gridLayout);
        this.fContextSelectorShell.setBackground(control.getDisplay().getSystemColor(2));
        if (this.fViewer instanceof ITextViewerExtension) {
            iTextViewerExtension = (ITextViewerExtension)((Object)this.fViewer);
            styledText = this.fViewer.getTextWidget();
            final VerifyKeyListener verifyKeyListener = new VerifyKeyListener(){

                public void verifyKey(VerifyEvent verifyEvent) {
                    if (ContextInformationPopup.this.isActive() && verifyEvent.keyCode == 13 && verifyEvent.character == '\r' && verifyEvent.widget == styledText) {
                        verifyEvent.doit = false;
                        ContextInformationPopup.this.insertSelectedContext();
                        ContextInformationPopup.this.hideContextSelector();
                    }
                }
            };
            iTextViewerExtension.prependVerifyKeyListener(verifyKeyListener);
            this.fContextSelectorShell.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent disposeEvent) {
                    iTextViewerExtension.removeVerifyKeyListener(verifyKeyListener);
                }
            });
        }
        this.fContextSelectorTable = new Table((Composite)this.fContextSelectorShell, 768);
        this.fContextSelectorTable.setLocation(1, 1);
        iTextViewerExtension = new GridData(1808);
        ((GridData)iTextViewerExtension).heightHint = this.fContextSelectorTable.getItemHeight() * 10;
        ((GridData)iTextViewerExtension).widthHint = 300;
        this.fContextSelectorTable.setLayoutData((Object)iTextViewerExtension);
        this.fContextSelectorShell.pack(true);
        styledText = this.fContentAssistant.getContextSelectorBackground();
        if (styledText == null) {
            styledText = control.getDisplay().getSystemColor(29);
        }
        this.fContextSelectorTable.setBackground((Color)styledText);
        styledText = this.fContentAssistant.getContextSelectorForeground();
        if (styledText == null) {
            styledText = control.getDisplay().getSystemColor(28);
        }
        this.fContextSelectorTable.setForeground((Color)styledText);
        this.fContextSelectorTable.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                ContextInformationPopup.this.insertSelectedContext();
                ContextInformationPopup.this.hideContextSelector();
            }
        });
        this.fPopupCloser.install(this.fContentAssistant, this.fContextSelectorTable);
        this.fContextSelectorTable.setHeaderVisible(false);
        this.fContentAssistant.addToLayout(this, this.fContextSelectorShell, 1, this.fContentAssistant.getSelectionOffset());
    }

    int getMinimalHeight() {
        int n = 0;
        if (Helper.okToUse((Widget)this.fContextSelectorTable)) {
            int n2 = this.fContextSelectorTable.getItemHeight() * 10;
            Rectangle rectangle = this.fContextSelectorTable.computeTrim(0, 0, -1, n2);
            n = rectangle.height;
        }
        return n;
    }

    private void insertSelectedContext() {
        int n = this.fContextSelectorTable.getSelectionIndex();
        if (n < 0 || n >= this.fContextSelectorInput.length) {
            return;
        }
        int n2 = this.fContentAssistSubjectControlAdapter.getSelectedRange().x;
        this.internalShowContextInfo(this.createContextFrame(this.fContextSelectorInput[n], n2));
    }

    private void setContexts(IContextInformation[] iContextInformationArray, int n) {
        if (Helper.okToUse((Widget)this.fContextSelectorTable)) {
            this.fContextSelectorInput = iContextInformationArray;
            this.fContextSelectorTable.setRedraw(false);
            this.fContextSelectorTable.removeAll();
            int n2 = 0;
            while (n2 < iContextInformationArray.length) {
                IContextInformation iContextInformation = iContextInformationArray[n2];
                TableItem tableItem = new TableItem(this.fContextSelectorTable, 0);
                if (iContextInformation.getImage() != null) {
                    tableItem.setImage(iContextInformation.getImage());
                }
                tableItem.setText(iContextInformation.getContextDisplayString());
                ++n2;
            }
            this.fContextSelectorTable.select(n);
            this.fContextSelectorTable.setRedraw(true);
        }
    }

    private void displayContextSelector() {
        if (this.fContentAssistant.addContentAssistListener(this, 0)) {
            this.fContextSelectorShell.setVisible(true);
        }
    }

    private void hideContextSelector() {
        if (Helper.okToUse((Widget)this.fContextSelectorShell)) {
            this.fContentAssistant.removeContentAssistListener(this, 0);
            this.fPopupCloser.uninstall();
            this.fContextSelectorShell.setVisible(false);
            this.fContextSelectorShell.dispose();
            this.fContextSelectorShell = null;
        }
        if (!Helper.okToUse((Widget)this.fContextInfoPopup)) {
            this.fContentAssistant.contextInformationClosed();
        }
    }

    public boolean hasFocus() {
        if (Helper.okToUse((Widget)this.fContextSelectorShell)) {
            return this.fContextSelectorShell.isFocusControl() || this.fContextSelectorTable.isFocusControl();
        }
        return false;
    }

    public void hide() {
        this.hideContextSelector();
        this.hideContextInfoPopup();
    }

    public boolean isActive() {
        return Helper.okToUse((Widget)this.fContextInfoPopup) || Helper.okToUse((Widget)this.fContextSelectorShell);
    }

    @Override
    public boolean verifyKey(VerifyEvent verifyEvent) {
        if (Helper.okToUse((Widget)this.fContextSelectorShell)) {
            return this.contextSelectorKeyPressed(verifyEvent);
        }
        if (Helper.okToUse((Widget)this.fContextInfoPopup)) {
            return this.contextInfoPopupKeyPressed((KeyEvent)verifyEvent);
        }
        return true;
    }

    private boolean contextSelectorKeyPressed(VerifyEvent verifyEvent) {
        char c = verifyEvent.character;
        if (c == '\u0000') {
            int n = this.fContextSelectorTable.getSelectionIndex();
            int n2 = this.fContextSelectorTable.getSize().y / this.fContextSelectorTable.getItemHeight() - 1;
            int n3 = this.fContextSelectorTable.getItemCount();
            switch (verifyEvent.keyCode) {
                case 0x1000001: {
                    if (--n >= 0) break;
                    n = n3 - 1;
                    break;
                }
                case 0x1000002: {
                    if (++n <= n3 - 1) break;
                    n = 0;
                    break;
                }
                case 0x1000006: {
                    if ((n += n2) < n3) break;
                    n = n3 - 1;
                    break;
                }
                case 0x1000005: {
                    if ((n -= n2) >= 0) break;
                    n = 0;
                    break;
                }
                case 0x1000007: {
                    n = 0;
                    break;
                }
                case 0x1000008: {
                    n = n3 - 1;
                    break;
                }
                default: {
                    if (verifyEvent.keyCode != 16777298 && verifyEvent.keyCode != SWT.MOD1 && verifyEvent.keyCode != SWT.MOD2 && verifyEvent.keyCode != SWT.MOD3 && verifyEvent.keyCode != SWT.MOD4) {
                        this.hideContextSelector();
                    }
                    return true;
                }
            }
            this.fContextSelectorTable.setSelection(n);
            this.fContextSelectorTable.showSelection();
            verifyEvent.doit = false;
            return false;
        }
        if ('\t' == c) {
            verifyEvent.doit = false;
            this.fContextSelectorShell.setFocus();
            return false;
        }
        if (c == '\u001b') {
            verifyEvent.doit = false;
            this.hideContextSelector();
        }
        return true;
    }

    private boolean contextInfoPopupKeyPressed(KeyEvent keyEvent) {
        char c = keyEvent.character;
        if (c == '\u0000') {
            switch (keyEvent.keyCode) {
                case 0x1000001: 
                case 0x1000002: 
                case 0x1000003: 
                case 0x1000004: {
                    this.validateContextInformation();
                    break;
                }
                default: {
                    if (keyEvent.keyCode != 16777298 && keyEvent.keyCode != SWT.MOD1 && keyEvent.keyCode != SWT.MOD2 && keyEvent.keyCode != SWT.MOD3 && keyEvent.keyCode != SWT.MOD4) {
                        this.hideContextInfoPopup();
                        break;
                    } else {
                        break;
                    }
                }
            }
        } else if (c == '\u001b') {
            keyEvent.doit = false;
            this.hideContextInfoPopup();
        } else {
            this.validateContextInformation();
        }
        return true;
    }

    @Override
    public void processEvent(VerifyEvent verifyEvent) {
        if (Helper.okToUse((Widget)this.fContextSelectorShell)) {
            this.contextSelectorProcessEvent(verifyEvent);
        }
        if (Helper.okToUse((Widget)this.fContextInfoPopup)) {
            this.contextInfoPopupProcessEvent(verifyEvent);
        }
    }

    private void contextSelectorProcessEvent(VerifyEvent verifyEvent) {
        if (verifyEvent.start == verifyEvent.end && verifyEvent.text != null && verifyEvent.text.equals(this.fLineDelimiter)) {
            verifyEvent.doit = false;
            this.insertSelectedContext();
        }
        this.hideContextSelector();
    }

    private void contextInfoPopupProcessEvent(VerifyEvent verifyEvent) {
        if (verifyEvent.start != verifyEvent.end && (verifyEvent.text == null || verifyEvent.text.length() == 0)) {
            this.validateContextInformation();
        }
    }

    private void validateContextInformation() {
        if (!Helper.okToUse((Widget)this.fContextInfoPopup)) {
            return;
        }
        this.fContextInfoPopup.getDisplay().asyncExec(new Runnable(){
            private ContextFrame fFrame;
            {
                this.fFrame = (ContextFrame)ContextInformationPopup.this.fContextFrameStack.peek();
            }

            @Override
            public void run() {
                if (!ContextInformationPopup.this.fContextFrameStack.isEmpty() && this.fFrame == ContextInformationPopup.this.fContextFrameStack.peek()) {
                    int n = ((ContextInformationPopup)ContextInformationPopup.this).fContentAssistSubjectControlAdapter.getSelectedRange().x;
                    while (Helper.okToUse((Widget)ContextInformationPopup.this.fContextInfoPopup) && !ContextInformationPopup.this.fContextFrameStack.isEmpty()) {
                        ContextFrame contextFrame = (ContextFrame)ContextInformationPopup.this.fContextFrameStack.peek();
                        if (contextFrame.fValidator == null || !contextFrame.fValidator.isContextInformationValid(n)) {
                            ContextInformationPopup.this.hideContextInfoPopup();
                            continue;
                        }
                        if (contextFrame.fPresenter == null || !contextFrame.fPresenter.updatePresentation(n, ContextInformationPopup.this.fTextPresentation)) break;
                        int n2 = ((ContextInformationPopup)ContextInformationPopup.this).fContentAssistSubjectControlAdapter.getWidgetSelectionRange().x;
                        TextPresentation.applyTextPresentation(ContextInformationPopup.this.fTextPresentation, ContextInformationPopup.this.fContextInfoText);
                        ContextInformationPopup.this.resize(n2);
                        break;
                    }
                }
            }
        });
    }

    static class ContextFrame {
        final int fBeginOffset;
        final int fOffset;
        final int fVisibleOffset;
        final IContextInformation fInformation;
        final IContextInformationValidator fValidator;
        final IContextInformationPresenter fPresenter;

        public ContextFrame(IContextInformation iContextInformation, int n, int n2, int n3, IContextInformationValidator iContextInformationValidator, IContextInformationPresenter iContextInformationPresenter) {
            this.fInformation = iContextInformation;
            this.fBeginOffset = n;
            this.fOffset = n2;
            this.fVisibleOffset = n3;
            this.fValidator = iContextInformationValidator;
            this.fPresenter = iContextInformationPresenter;
        }

        public boolean equals(Object object) {
            if (object instanceof ContextFrame) {
                ContextFrame contextFrame = (ContextFrame)object;
                return this.fInformation.equals(contextFrame.fInformation) && this.fBeginOffset == contextFrame.fBeginOffset;
            }
            return super.equals(object);
        }

        public int hashCode() {
            return this.fInformation.hashCode() << 16 | this.fBeginOffset;
        }
    }
}

