/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.contentassist;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.bindings.keys.KeySequence;
import org.eclipse.jface.contentassist.IContentAssistSubjectControl;
import org.eclipse.jface.contentassist.ISubjectControlContentAssistProcessor;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IEventConsumer;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.IViewportListener;
import org.eclipse.jface.text.IWidgetTokenKeeper;
import org.eclipse.jface.text.IWidgetTokenKeeperExtension;
import org.eclipse.jface.text.IWidgetTokenOwner;
import org.eclipse.jface.text.IWidgetTokenOwnerExtension;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.contentassist.AdditionalInfoController;
import org.eclipse.jface.text.contentassist.CompletionProposalPopup;
import org.eclipse.jface.text.contentassist.ContentAssistEvent;
import org.eclipse.jface.text.contentassist.ContentAssistSubjectControlAdapter;
import org.eclipse.jface.text.contentassist.ContextInformationPopup;
import org.eclipse.jface.text.contentassist.Helper;
import org.eclipse.jface.text.contentassist.ICompletionListener;
import org.eclipse.jface.text.contentassist.ICompletionListenerExtension;
import org.eclipse.jface.text.contentassist.ICompletionListenerExtension2;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalSorter;
import org.eclipse.jface.text.contentassist.IContentAssistListener;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistantExtension;
import org.eclipse.jface.text.contentassist.IContentAssistantExtension2;
import org.eclipse.jface.text.contentassist.IContentAssistantExtension3;
import org.eclipse.jface.text.contentassist.IContentAssistantExtension4;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationPresenter;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jface.text.contentassist.JFaceTextMessages;
import org.eclipse.jface.util.Geometry;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class ContentAssistant
implements IContentAssistant,
IContentAssistantExtension,
IContentAssistantExtension2,
IContentAssistantExtension3,
IContentAssistantExtension4,
IWidgetTokenKeeper,
IWidgetTokenKeeperExtension {
    public static final String SELECT_NEXT_PROPOSAL_COMMAND_ID = "org.eclipse.ui.edit.text.contentAssist.selectNextProposal";
    public static final String SELECT_PREVIOUS_PROPOSAL_COMMAND_ID = "org.eclipse.ui.edit.text.contentAssist.selectPreviousProposal";
    public static final String STORE_SIZE_X = "size.x";
    public static final String STORE_SIZE_Y = "size.y";
    static final int CONTEXT_SELECTOR = 0;
    static final int PROPOSAL_SELECTOR = 1;
    static final int CONTEXT_INFO_POPUP = 2;
    public static final int WIDGET_PRIORITY = 20;
    private static final int DEFAULT_AUTO_ACTIVATION_DELAY = 500;
    private IInformationControlCreator fInformationControlCreator;
    private int fAutoActivationDelay = 500;
    private boolean fIsAutoActivated = false;
    private boolean fIsAutoInserting = false;
    private int fProposalPopupOrientation = 10;
    private int fContextInfoPopupOrientation = 20;
    private Map fProcessors;
    private String fPartitioning = "__dftl_partitioning";
    private Color fContextInfoPopupBackground;
    private Color fContextInfoPopupForeground;
    private Color fContextSelectorBackground;
    private Color fContextSelectorForeground;
    private Color fProposalSelectorBackground;
    private Color fProposalSelectorForeground;
    private ITextViewer fViewer;
    private String fLastErrorMessage;
    private Closer fCloser;
    LayoutManager fLayoutManager;
    private AutoAssistListener fAutoAssistListener;
    private InternalListener fInternalListener;
    private CompletionProposalPopup fProposalPopup;
    private ContextInformationPopup fContextInfoPopup;
    private boolean fVerifyKeyListenerHooked = false;
    private IContentAssistListener[] fListeners = new IContentAssistListener[4];
    private IContentAssistSubjectControl fContentAssistSubjectControl;
    private Shell fContentAssistSubjectControlShell;
    private TraverseListener fCASCSTraverseListener;
    private ContentAssistSubjectControlAdapter fContentAssistSubjectControlAdapter;
    private IDialogSettings fDialogSettings;
    private boolean fIsPrefixCompletionEnabled = false;
    private ListenerList fCompletionListeners = new ListenerList(1);
    private String fMessage = "";
    private boolean fIsRepetitionMode = false;
    private boolean fShowEmptyList = false;
    private boolean fIsStatusLineVisible;
    private long fLastAutoActivation = Long.MIN_VALUE;
    private KeySequence fRepeatedInvocationKeySequence;
    private Map fHandlers;
    private boolean fIsColoredLabelsSupportEnabled = false;
    private ICompletionProposalSorter fSorter;

    public void setDocumentPartitioning(String string) {
        Assert.isNotNull((Object)string);
        this.fPartitioning = string;
    }

    @Override
    public String getDocumentPartitioning() {
        return this.fPartitioning;
    }

    public void setContentAssistProcessor(IContentAssistProcessor iContentAssistProcessor, String string) {
        Assert.isNotNull((Object)string);
        if (this.fProcessors == null) {
            this.fProcessors = new HashMap();
        }
        if (iContentAssistProcessor == null) {
            this.fProcessors.remove(string);
        } else {
            this.fProcessors.put(string, iContentAssistProcessor);
        }
    }

    @Override
    public IContentAssistProcessor getContentAssistProcessor(String string) {
        if (this.fProcessors == null) {
            return null;
        }
        return (IContentAssistProcessor)this.fProcessors.get(string);
    }

    private String computeAllAutoActivationTriggers() {
        if (this.fProcessors == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(5);
        for (Map.Entry entry : this.fProcessors.entrySet()) {
            IContentAssistProcessor iContentAssistProcessor = (IContentAssistProcessor)entry.getValue();
            char[] cArray = iContentAssistProcessor.getCompletionProposalAutoActivationCharacters();
            if (cArray != null) {
                stringBuffer.append(cArray);
            }
            if ((cArray = iContentAssistProcessor.getContextInformationAutoActivationCharacters()) == null) continue;
            stringBuffer.append(cArray);
        }
        return stringBuffer.toString();
    }

    public void enableAutoActivation(boolean bl) {
        this.fIsAutoActivated = bl;
        this.manageAutoActivation(this.fIsAutoActivated);
    }

    public void enableAutoInsert(boolean bl) {
        this.fIsAutoInserting = bl;
    }

    boolean isAutoInserting() {
        return this.fIsAutoInserting;
    }

    private void manageAutoActivation(boolean bl) {
        if (bl) {
            if (this.fContentAssistSubjectControlAdapter != null && this.fAutoAssistListener == null) {
                this.fAutoAssistListener = this.createAutoAssistListener();
                if (this.fContentAssistSubjectControlAdapter.supportsVerifyKeyListener()) {
                    this.fContentAssistSubjectControlAdapter.appendVerifyKeyListener(this.fAutoAssistListener);
                } else {
                    this.fContentAssistSubjectControlAdapter.addKeyListener((KeyListener)this.fAutoAssistListener);
                }
            }
        } else if (this.fAutoAssistListener != null) {
            if (this.fContentAssistSubjectControlAdapter.supportsVerifyKeyListener()) {
                this.fContentAssistSubjectControlAdapter.removeVerifyKeyListener(this.fAutoAssistListener);
            } else {
                this.fContentAssistSubjectControlAdapter.removeKeyListener((KeyListener)this.fAutoAssistListener);
            }
            this.fAutoAssistListener = null;
        }
    }

    protected AutoAssistListener createAutoAssistListener() {
        return new AutoAssistListener();
    }

    public void setAutoActivationDelay(int n) {
        this.fAutoActivationDelay = Math.max(0, n);
    }

    public int getAutoActivationDelay() {
        return this.fAutoActivationDelay;
    }

    public void setProposalPopupOrientation(int n) {
        this.fProposalPopupOrientation = n;
    }

    public void setContextInformationPopupOrientation(int n) {
        this.fContextInfoPopupOrientation = n;
    }

    public void setContextInformationPopupBackground(Color color) {
        this.fContextInfoPopupBackground = color;
    }

    Color getContextInformationPopupBackground() {
        return this.fContextInfoPopupBackground;
    }

    public void setContextInformationPopupForeground(Color color) {
        this.fContextInfoPopupForeground = color;
    }

    Color getContextInformationPopupForeground() {
        return this.fContextInfoPopupForeground;
    }

    public void setProposalSelectorBackground(Color color) {
        this.fProposalSelectorBackground = color;
    }

    Color getProposalSelectorBackground() {
        return this.fProposalSelectorBackground;
    }

    public void setProposalSelectorForeground(Color color) {
        this.fProposalSelectorForeground = color;
    }

    Color getProposalSelectorForeground() {
        return this.fProposalSelectorForeground;
    }

    public void setContextSelectorBackground(Color color) {
        this.fContextSelectorBackground = color;
    }

    Color getContextSelectorBackground() {
        return this.fContextSelectorBackground;
    }

    public void setContextSelectorForeground(Color color) {
        this.fContextSelectorForeground = color;
    }

    Color getContextSelectorForeground() {
        return this.fContextSelectorForeground;
    }

    public void setInformationControlCreator(IInformationControlCreator iInformationControlCreator) {
        this.fInformationControlCreator = iInformationControlCreator;
    }

    protected void install(IContentAssistSubjectControl iContentAssistSubjectControl) {
        this.fContentAssistSubjectControl = iContentAssistSubjectControl;
        this.fContentAssistSubjectControlAdapter = new ContentAssistSubjectControlAdapter(this.fContentAssistSubjectControl);
        this.install();
    }

    @Override
    public void install(ITextViewer iTextViewer) {
        this.fViewer = iTextViewer;
        this.fContentAssistSubjectControlAdapter = new ContentAssistSubjectControlAdapter(this.fViewer);
        this.install();
    }

    protected void install() {
        this.fLayoutManager = new LayoutManager();
        this.fInternalListener = new InternalListener();
        AdditionalInfoController additionalInfoController = null;
        if (this.fInformationControlCreator != null) {
            additionalInfoController = new AdditionalInfoController(this.fInformationControlCreator, OpenStrategy.getPostSelectionDelay());
        }
        this.fContextInfoPopup = this.fContentAssistSubjectControlAdapter.createContextInfoPopup(this);
        this.fProposalPopup = this.fContentAssistSubjectControlAdapter.createCompletionProposalPopup(this, additionalInfoController);
        this.fProposalPopup.setSorter(this.fSorter);
        this.registerHandler(SELECT_NEXT_PROPOSAL_COMMAND_ID, this.fProposalPopup.createProposalSelectionHandler(1));
        this.registerHandler(SELECT_PREVIOUS_PROPOSAL_COMMAND_ID, this.fProposalPopup.createProposalSelectionHandler(2));
        if (Helper.okToUse((Widget)this.fContentAssistSubjectControlAdapter.getControl())) {
            this.fContentAssistSubjectControlShell = this.fContentAssistSubjectControlAdapter.getControl().getShell();
            this.fCASCSTraverseListener = new TraverseListener(){

                public void keyTraversed(TraverseEvent traverseEvent) {
                    if (traverseEvent.detail == 2 && ContentAssistant.this.isProposalPopupActive()) {
                        traverseEvent.doit = false;
                    }
                }
            };
            this.fContentAssistSubjectControlShell.addTraverseListener(this.fCASCSTraverseListener);
        }
        this.manageAutoActivation(this.fIsAutoActivated);
    }

    @Override
    public void uninstall() {
        this.hide();
        this.manageAutoActivation(false);
        if (this.fHandlers != null) {
            this.fHandlers.clear();
            this.fHandlers = null;
        }
        if (this.fCloser != null) {
            this.fCloser.uninstall();
            this.fCloser = null;
        }
        if (Helper.okToUse((Widget)this.fContentAssistSubjectControlShell)) {
            this.fContentAssistSubjectControlShell.removeTraverseListener(this.fCASCSTraverseListener);
        }
        this.fCASCSTraverseListener = null;
        this.fContentAssistSubjectControlShell = null;
        this.fViewer = null;
        this.fContentAssistSubjectControl = null;
        this.fContentAssistSubjectControlAdapter = null;
    }

    void addToLayout(Object object, Shell shell, int n, int n2) {
        this.fLayoutManager.add(object, shell, n, n2);
    }

    void layout(int n, int n2) {
        this.fLayoutManager.layout(n, n2);
    }

    LayoutManager getLayoutManager() {
        return this.fLayoutManager;
    }

    void popupFocusLost(FocusEvent focusEvent) {
        this.fCloser.focusLost(focusEvent);
    }

    int getSelectionOffset() {
        return this.fContentAssistSubjectControlAdapter.getWidgetSelectionRange().x;
    }

    private boolean acquireWidgetToken(int n) {
        switch (n) {
            case 0: 
            case 1: {
                if (this.fContentAssistSubjectControl instanceof IWidgetTokenOwnerExtension) {
                    IWidgetTokenOwnerExtension iWidgetTokenOwnerExtension = (IWidgetTokenOwnerExtension)((Object)this.fContentAssistSubjectControl);
                    return iWidgetTokenOwnerExtension.requestWidgetToken(this, 20);
                }
                if (this.fContentAssistSubjectControl instanceof IWidgetTokenOwner) {
                    IWidgetTokenOwner iWidgetTokenOwner = (IWidgetTokenOwner)((Object)this.fContentAssistSubjectControl);
                    return iWidgetTokenOwner.requestWidgetToken(this);
                }
                if (this.fViewer instanceof IWidgetTokenOwnerExtension) {
                    IWidgetTokenOwnerExtension iWidgetTokenOwnerExtension = (IWidgetTokenOwnerExtension)((Object)this.fViewer);
                    return iWidgetTokenOwnerExtension.requestWidgetToken(this, 20);
                }
                if (!(this.fViewer instanceof IWidgetTokenOwner)) break;
                IWidgetTokenOwner iWidgetTokenOwner = (IWidgetTokenOwner)((Object)this.fViewer);
                return iWidgetTokenOwner.requestWidgetToken(this);
            }
        }
        return true;
    }

    boolean addContentAssistListener(IContentAssistListener iContentAssistListener, int n) {
        if (this.acquireWidgetToken(n)) {
            this.fListeners[n] = iContentAssistListener;
            if (this.fCloser == null && this.getNumberOfListeners() == 1) {
                this.fCloser = new Closer();
                this.fCloser.install();
                this.fContentAssistSubjectControlAdapter.setEventConsumer(this.fInternalListener);
                this.installKeyListener();
            } else {
                this.promoteKeyListener();
            }
            return true;
        }
        return false;
    }

    private void promoteKeyListener() {
        this.uninstallVerifyKeyListener();
        this.installKeyListener();
    }

    private void installKeyListener() {
        if (!this.fVerifyKeyListenerHooked && Helper.okToUse((Widget)this.fContentAssistSubjectControlAdapter.getControl())) {
            this.fVerifyKeyListenerHooked = this.fContentAssistSubjectControlAdapter.prependVerifyKeyListener(this.fInternalListener);
        }
    }

    private void releaseWidgetToken(int n) {
        if (this.fListeners[0] == null && this.fListeners[1] == null) {
            IWidgetTokenOwner iWidgetTokenOwner = null;
            if (this.fContentAssistSubjectControl instanceof IWidgetTokenOwner) {
                iWidgetTokenOwner = (IWidgetTokenOwner)((Object)this.fContentAssistSubjectControl);
            } else if (this.fViewer instanceof IWidgetTokenOwner) {
                iWidgetTokenOwner = (IWidgetTokenOwner)((Object)this.fViewer);
            }
            if (iWidgetTokenOwner != null) {
                iWidgetTokenOwner.releaseWidgetToken(this);
            }
        }
    }

    void removeContentAssistListener(IContentAssistListener iContentAssistListener, int n) {
        this.fListeners[n] = null;
        if (this.getNumberOfListeners() == 0) {
            if (this.fCloser != null) {
                this.fCloser.uninstall();
                this.fCloser = null;
            }
            this.uninstallVerifyKeyListener();
            this.fContentAssistSubjectControlAdapter.setEventConsumer(null);
        }
        this.releaseWidgetToken(n);
    }

    private void uninstallVerifyKeyListener() {
        if (this.fVerifyKeyListenerHooked) {
            if (Helper.okToUse((Widget)this.fContentAssistSubjectControlAdapter.getControl())) {
                this.fContentAssistSubjectControlAdapter.removeVerifyKeyListener(this.fInternalListener);
            }
            this.fVerifyKeyListenerHooked = false;
        }
    }

    private int getNumberOfListeners() {
        int n = 0;
        int n2 = 0;
        while (n2 <= 2) {
            if (this.fListeners[n2] != null) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    @Override
    public String showPossibleCompletions() {
        if (!this.prepareToShowCompletions(false)) {
            return null;
        }
        if (this.fIsPrefixCompletionEnabled) {
            return this.fProposalPopup.incrementalComplete();
        }
        return this.fProposalPopup.showProposals(false);
    }

    @Override
    public String completePrefix() {
        if (!this.prepareToShowCompletions(false)) {
            return null;
        }
        return this.fProposalPopup.incrementalComplete();
    }

    private boolean prepareToShowCompletions(boolean bl) {
        if (!bl) {
            int n = Math.max(this.fAutoActivationDelay, 200);
            if (System.currentTimeMillis() < this.fLastAutoActivation + (long)n) {
                return false;
            }
        }
        this.promoteKeyListener();
        this.fireSessionBeginEvent(bl);
        return true;
    }

    protected void possibleCompletionsClosed() {
        this.fLastAutoActivation = Long.MIN_VALUE;
        this.storeCompletionProposalPopupSize();
    }

    @Override
    public String showContextInformation() {
        this.promoteKeyListener();
        if (this.fContextInfoPopup != null) {
            return this.fContextInfoPopup.showContextProposals(false);
        }
        return null;
    }

    protected void contextInformationClosed() {
    }

    void showContextInformation(IContextInformation iContextInformation, int n) {
        if (this.fContextInfoPopup != null) {
            this.fContextInfoPopup.showContextInformation(iContextInformation, n);
        }
    }

    String getErrorMessage() {
        return this.fLastErrorMessage;
    }

    private IContentAssistProcessor getProcessor(ITextViewer iTextViewer, int n) {
        try {
            IDocument iDocument = iTextViewer.getDocument();
            String string = TextUtilities.getContentType((IDocument)iDocument, (String)this.getDocumentPartitioning(), (int)n, (boolean)true);
            return this.getContentAssistProcessor(string);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    private IContentAssistProcessor getProcessor(IContentAssistSubjectControl iContentAssistSubjectControl, int n) {
        try {
            IDocument iDocument = iContentAssistSubjectControl.getDocument();
            String string = iDocument != null ? TextUtilities.getContentType((IDocument)iDocument, (String)this.getDocumentPartitioning(), (int)n, (boolean)true) : "__dftl_partition_content_type";
            return this.getContentAssistProcessor(string);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    ICompletionProposal[] computeCompletionProposals(IContentAssistSubjectControl iContentAssistSubjectControl, int n) {
        this.fLastErrorMessage = null;
        ICompletionProposal[] iCompletionProposalArray = null;
        IContentAssistProcessor iContentAssistProcessor = this.getProcessor(iContentAssistSubjectControl, n);
        if (iContentAssistProcessor instanceof ISubjectControlContentAssistProcessor) {
            iCompletionProposalArray = ((ISubjectControlContentAssistProcessor)iContentAssistProcessor).computeCompletionProposals(iContentAssistSubjectControl, n);
            this.fLastErrorMessage = iContentAssistProcessor.getErrorMessage();
        }
        return iCompletionProposalArray;
    }

    ICompletionProposal[] computeCompletionProposals(ITextViewer iTextViewer, int n) {
        this.fLastErrorMessage = null;
        ICompletionProposal[] iCompletionProposalArray = null;
        IContentAssistProcessor iContentAssistProcessor = this.getProcessor(iTextViewer, n);
        if (iContentAssistProcessor != null) {
            iCompletionProposalArray = iContentAssistProcessor.computeCompletionProposals(iTextViewer, n);
            this.fLastErrorMessage = iContentAssistProcessor.getErrorMessage();
        }
        return iCompletionProposalArray;
    }

    IContextInformation[] computeContextInformation(ITextViewer iTextViewer, int n) {
        this.fLastErrorMessage = null;
        IContextInformation[] iContextInformationArray = null;
        IContentAssistProcessor iContentAssistProcessor = this.getProcessor(iTextViewer, n);
        if (iContentAssistProcessor != null) {
            iContextInformationArray = iContentAssistProcessor.computeContextInformation(iTextViewer, n);
            this.fLastErrorMessage = iContentAssistProcessor.getErrorMessage();
        }
        return iContextInformationArray;
    }

    IContextInformation[] computeContextInformation(IContentAssistSubjectControl iContentAssistSubjectControl, int n) {
        this.fLastErrorMessage = null;
        IContextInformation[] iContextInformationArray = null;
        IContentAssistProcessor iContentAssistProcessor = this.getProcessor(iContentAssistSubjectControl, n);
        if (iContentAssistProcessor instanceof ISubjectControlContentAssistProcessor) {
            iContextInformationArray = ((ISubjectControlContentAssistProcessor)iContentAssistProcessor).computeContextInformation(iContentAssistSubjectControl, n);
            this.fLastErrorMessage = iContentAssistProcessor.getErrorMessage();
        }
        return iContextInformationArray;
    }

    IContextInformationValidator getContextInformationValidator(ITextViewer iTextViewer, int n) {
        IContentAssistProcessor iContentAssistProcessor = this.getProcessor(iTextViewer, n);
        return iContentAssistProcessor != null ? iContentAssistProcessor.getContextInformationValidator() : null;
    }

    IContextInformationValidator getContextInformationValidator(IContentAssistSubjectControl iContentAssistSubjectControl, int n) {
        IContentAssistProcessor iContentAssistProcessor = this.getProcessor(iContentAssistSubjectControl, n);
        return iContentAssistProcessor != null ? iContentAssistProcessor.getContextInformationValidator() : null;
    }

    IContextInformationPresenter getContextInformationPresenter(ITextViewer iTextViewer, int n) {
        IContextInformationValidator iContextInformationValidator = this.getContextInformationValidator(iTextViewer, n);
        if (iContextInformationValidator instanceof IContextInformationPresenter) {
            return (IContextInformationPresenter)((Object)iContextInformationValidator);
        }
        return null;
    }

    IContextInformationPresenter getContextInformationPresenter(IContentAssistSubjectControl iContentAssistSubjectControl, int n) {
        IContextInformationValidator iContextInformationValidator = this.getContextInformationValidator(iContentAssistSubjectControl, n);
        if (iContextInformationValidator instanceof IContextInformationPresenter) {
            return (IContextInformationPresenter)((Object)iContextInformationValidator);
        }
        return null;
    }

    char[] getCompletionProposalAutoActivationCharacters(IContentAssistSubjectControl iContentAssistSubjectControl, int n) {
        IContentAssistProcessor iContentAssistProcessor = this.getProcessor(iContentAssistSubjectControl, n);
        return iContentAssistProcessor != null ? iContentAssistProcessor.getCompletionProposalAutoActivationCharacters() : null;
    }

    char[] getCompletionProposalAutoActivationCharacters(ITextViewer iTextViewer, int n) {
        IContentAssistProcessor iContentAssistProcessor = this.getProcessor(iTextViewer, n);
        return iContentAssistProcessor != null ? iContentAssistProcessor.getCompletionProposalAutoActivationCharacters() : null;
    }

    char[] getContextInformationAutoActivationCharacters(ITextViewer iTextViewer, int n) {
        IContentAssistProcessor iContentAssistProcessor = this.getProcessor(iTextViewer, n);
        return iContentAssistProcessor != null ? iContentAssistProcessor.getContextInformationAutoActivationCharacters() : null;
    }

    char[] getContextInformationAutoActivationCharacters(IContentAssistSubjectControl iContentAssistSubjectControl, int n) {
        IContentAssistProcessor iContentAssistProcessor = this.getProcessor(iContentAssistSubjectControl, n);
        return iContentAssistProcessor != null ? iContentAssistProcessor.getContextInformationAutoActivationCharacters() : null;
    }

    @Override
    public boolean requestWidgetToken(IWidgetTokenOwner iWidgetTokenOwner) {
        return false;
    }

    @Override
    public boolean requestWidgetToken(IWidgetTokenOwner iWidgetTokenOwner, int n) {
        if (n > 20) {
            this.hide();
            return true;
        }
        return false;
    }

    @Override
    public boolean setFocus(IWidgetTokenOwner iWidgetTokenOwner) {
        if (this.fProposalPopup != null) {
            this.fProposalPopup.setFocus();
            return this.fProposalPopup.hasFocus();
        }
        return false;
    }

    protected void hide() {
        if (this.fProposalPopup != null) {
            this.fProposalPopup.hide();
        }
        if (this.fContextInfoPopup != null) {
            this.fContextInfoPopup.hide();
        }
    }

    public void setRestoreCompletionProposalSize(IDialogSettings iDialogSettings) {
        Assert.isTrue((iDialogSettings != null ? 1 : 0) != 0);
        this.fDialogSettings = iDialogSettings;
    }

    protected void storeCompletionProposalPopupSize() {
        if (this.fDialogSettings == null || this.fProposalPopup == null) {
            return;
        }
        Point point = this.fProposalPopup.getSize();
        if (point == null) {
            return;
        }
        this.fDialogSettings.put(STORE_SIZE_X, point.x);
        this.fDialogSettings.put(STORE_SIZE_Y, point.y);
    }

    protected Point restoreCompletionProposalPopupSize() {
        if (this.fDialogSettings == null) {
            return null;
        }
        Point point = new Point(-1, -1);
        try {
            point.x = this.fDialogSettings.getInt(STORE_SIZE_X);
            point.y = this.fDialogSettings.getInt(STORE_SIZE_Y);
        }
        catch (NumberFormatException numberFormatException) {
            point.x = -1;
            point.y = -1;
        }
        if (point.x == -1 && point.y == -1) {
            return null;
        }
        Rectangle rectangle = null;
        if (this.fContentAssistSubjectControl != null && Helper.okToUse((Widget)this.fContentAssistSubjectControl.getControl())) {
            rectangle = this.fContentAssistSubjectControl.getControl().getDisplay().getBounds();
        } else {
            Display display = Display.getCurrent();
            if (display == null) {
                display = Display.getDefault();
            }
            if (display != null && !display.isDisposed()) {
                rectangle = display.getBounds();
            }
        }
        if (point.x > -1 && point.y > -1) {
            if (rectangle != null) {
                point.x = Math.min(point.x, rectangle.width);
                point.y = Math.min(point.y, rectangle.height);
            }
            point.x = Math.max(point.x, 30);
            point.y = Math.max(point.y, 30);
        }
        return point;
    }

    public void enablePrefixCompletion(boolean bl) {
        this.fIsPrefixCompletionEnabled = bl;
    }

    boolean isPrefixCompletionEnabled() {
        return this.fIsPrefixCompletionEnabled;
    }

    public boolean hasProposalPopupFocus() {
        return this.fProposalPopup.hasFocus();
    }

    @Override
    public void addCompletionListener(ICompletionListener iCompletionListener) {
        Assert.isLegal((iCompletionListener != null ? 1 : 0) != 0);
        this.fCompletionListeners.add((Object)iCompletionListener);
    }

    @Override
    public void removeCompletionListener(ICompletionListener iCompletionListener) {
        this.fCompletionListeners.remove((Object)iCompletionListener);
    }

    void fireSessionBeginEvent(boolean bl) {
        if (this.fContentAssistSubjectControlAdapter != null && !this.isProposalPopupActive()) {
            IContentAssistProcessor iContentAssistProcessor = this.getProcessor(this.fContentAssistSubjectControlAdapter, this.fContentAssistSubjectControlAdapter.getSelectedRange().x);
            ContentAssistEvent contentAssistEvent = new ContentAssistEvent(this, iContentAssistProcessor, bl);
            Object[] objectArray = this.fCompletionListeners.getListeners();
            int n = 0;
            while (n < objectArray.length) {
                ICompletionListener iCompletionListener = (ICompletionListener)objectArray[n];
                iCompletionListener.assistSessionStarted(contentAssistEvent);
                ++n;
            }
        }
    }

    void fireSessionRestartEvent() {
        if (this.fContentAssistSubjectControlAdapter != null) {
            IContentAssistProcessor iContentAssistProcessor = this.getProcessor(this.fContentAssistSubjectControlAdapter, this.fContentAssistSubjectControlAdapter.getSelectedRange().x);
            ContentAssistEvent contentAssistEvent = new ContentAssistEvent(this, iContentAssistProcessor);
            Object[] objectArray = this.fCompletionListeners.getListeners();
            int n = 0;
            while (n < objectArray.length) {
                ICompletionListener iCompletionListener = (ICompletionListener)objectArray[n];
                if (iCompletionListener instanceof ICompletionListenerExtension) {
                    ((ICompletionListenerExtension)((Object)iCompletionListener)).assistSessionRestarted(contentAssistEvent);
                }
                ++n;
            }
        }
    }

    void fireSessionEndEvent() {
        if (this.fContentAssistSubjectControlAdapter != null) {
            IContentAssistProcessor iContentAssistProcessor = this.getProcessor(this.fContentAssistSubjectControlAdapter, this.fContentAssistSubjectControlAdapter.getSelectedRange().x);
            ContentAssistEvent contentAssistEvent = new ContentAssistEvent(this, iContentAssistProcessor);
            Object[] objectArray = this.fCompletionListeners.getListeners();
            int n = 0;
            while (n < objectArray.length) {
                ICompletionListener iCompletionListener = (ICompletionListener)objectArray[n];
                iCompletionListener.assistSessionEnded(contentAssistEvent);
                ++n;
            }
        }
    }

    @Override
    public void setRepeatedInvocationMode(boolean bl) {
        this.fIsRepetitionMode = bl;
    }

    boolean isRepeatedInvocationMode() {
        return this.fIsRepetitionMode;
    }

    @Override
    public void setShowEmptyList(boolean bl) {
        this.fShowEmptyList = bl;
    }

    boolean isShowEmptyList() {
        return this.fShowEmptyList;
    }

    @Override
    public void setStatusLineVisible(boolean bl) {
        this.fIsStatusLineVisible = bl;
        if (this.fProposalPopup != null) {
            this.fProposalPopup.setStatusLineVisible(bl);
        }
    }

    boolean isStatusLineVisible() {
        return this.fIsStatusLineVisible;
    }

    @Override
    public void setStatusMessage(String string) {
        Assert.isLegal((string != null ? 1 : 0) != 0);
        this.fMessage = string;
        if (this.fProposalPopup != null) {
            this.fProposalPopup.setMessage(string);
        }
    }

    String getStatusMessage() {
        return this.fMessage;
    }

    @Override
    public void setEmptyMessage(String string) {
        Assert.isLegal((string != null ? 1 : 0) != 0);
        if (this.fProposalPopup != null) {
            this.fProposalPopup.setEmptyMessage(string);
        }
    }

    void fireSelectionEvent(ICompletionProposal iCompletionProposal, boolean bl) {
        Object[] objectArray = this.fCompletionListeners.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            ICompletionListener iCompletionListener = (ICompletionListener)objectArray[n];
            iCompletionListener.selectionChanged(iCompletionProposal, bl);
            ++n;
        }
    }

    void fireAppliedEvent(ICompletionProposal iCompletionProposal) {
        Object[] objectArray = this.fCompletionListeners.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            ICompletionListener iCompletionListener = (ICompletionListener)objectArray[n];
            if (iCompletionListener instanceof ICompletionListenerExtension2) {
                ((ICompletionListenerExtension2)((Object)iCompletionListener)).applied(iCompletionProposal);
            }
            ++n;
        }
    }

    @Override
    public void setRepeatedInvocationTrigger(KeySequence keySequence) {
        this.fRepeatedInvocationKeySequence = keySequence;
    }

    KeySequence getRepeatedInvocationKeySequence() {
        return this.fRepeatedInvocationKeySequence;
    }

    protected boolean isProposalPopupActive() {
        return this.fProposalPopup != null && this.fProposalPopup.isActive();
    }

    protected boolean isContextInfoPopupActive() {
        return this.fContextInfoPopup != null && this.fContextInfoPopup.isActive();
    }

    @Override
    public final IHandler getHandler(String string) {
        if (this.fHandlers == null) {
            throw new IllegalStateException();
        }
        IHandler iHandler = (IHandler)this.fHandlers.get(string);
        if (iHandler != null) {
            return iHandler;
        }
        Assert.isLegal((boolean)false);
        return null;
    }

    protected final void registerHandler(String string, IHandler iHandler) {
        if (this.fHandlers == null) {
            this.fHandlers = new HashMap(2);
        }
        this.fHandlers.put(string, iHandler);
    }

    boolean isColoredLabelsSupportEnabled() {
        return this.fIsColoredLabelsSupportEnabled;
    }

    public void enableColoredLabels(boolean bl) {
        this.fIsColoredLabelsSupportEnabled = bl;
    }

    public void setSorter(ICompletionProposalSorter iCompletionProposalSorter) {
        this.fSorter = iCompletionProposalSorter;
        if (this.fProposalPopup != null) {
            this.fProposalPopup.setSorter(this.fSorter);
        }
    }

    static /* synthetic */ int access$4(ContentAssistant contentAssistant) {
        return contentAssistant.fAutoActivationDelay;
    }

    protected class AutoAssistListener
    extends KeyAdapter
    implements Runnable,
    VerifyKeyListener {
        private Thread fThread;
        private boolean fIsReset = false;
        private Object fMutex = new Object();
        private int fShowStyle;
        private static final int SHOW_PROPOSALS = 1;
        private static final int SHOW_CONTEXT_INFO = 2;

        protected AutoAssistListener() {
        }

        protected void start(int n) {
            this.fShowStyle = n;
            this.fThread = new Thread((Runnable)this, JFaceTextMessages.getString("ContentAssistant.assist_delay_timer_name"));
            this.fThread.start();
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[UNCONDITIONALDOLOOP]], but top level block is 1[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void reset(int n) {
            Object object = this.fMutex;
            synchronized (object) {
                this.fShowStyle = n;
                this.fIsReset = true;
                this.fMutex.notifyAll();
            }
        }

        protected void stop() {
            Thread thread = this.fThread;
            if (thread != null && thread.isAlive()) {
                thread.interrupt();
            }
        }

        private boolean contains(char[] cArray, char c) {
            if (cArray != null) {
                int n = 0;
                while (n < cArray.length) {
                    if (c == cArray[n]) {
                        return true;
                    }
                    ++n;
                }
            }
            return false;
        }

        public void keyPressed(KeyEvent keyEvent) {
            int n;
            if (keyEvent.character == '\u0000' && (keyEvent.keyCode & 0x1000000) == 0) {
                return;
            }
            if (keyEvent.character != '\u0000' && keyEvent.stateMask == 65536) {
                return;
            }
            if (ContentAssistant.this.computeAllAutoActivationTriggers().indexOf(keyEvent.character) < 0) {
                this.stop();
                return;
            }
            int n2 = ((ContentAssistant)ContentAssistant.this).fContentAssistSubjectControlAdapter.getSelectedRange().x;
            char[] cArray = ContentAssistant.this.fContentAssistSubjectControlAdapter.getCompletionProposalAutoActivationCharacters(ContentAssistant.this, n2);
            if (this.contains(cArray, keyEvent.character) && !ContentAssistant.this.isProposalPopupActive()) {
                n = 1;
            } else {
                cArray = ContentAssistant.this.fContentAssistSubjectControlAdapter.getContextInformationAutoActivationCharacters(ContentAssistant.this, n2);
                if (this.contains(cArray, keyEvent.character) && !ContentAssistant.this.isContextInfoPopupActive()) {
                    n = 2;
                } else {
                    this.stop();
                    return;
                }
            }
            if (this.fThread != null && this.fThread.isAlive()) {
                this.reset(n);
            } else {
                this.start(n);
            }
        }

        public void verifyKey(VerifyEvent verifyEvent) {
            this.keyPressed((KeyEvent)verifyEvent);
        }

        protected void showAssist(final int n) {
            final Control control = ContentAssistant.this.fContentAssistSubjectControlAdapter.getControl();
            if (control == null) {
                return;
            }
            Display display = control.getDisplay();
            if (display == null) {
                return;
            }
            try {
                display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (ContentAssistant.this.isProposalPopupActive()) {
                            return;
                        }
                        if (control.isDisposed() || !control.isFocusControl()) {
                            return;
                        }
                        if (n == 1) {
                            if (!ContentAssistant.this.prepareToShowCompletions(true)) {
                                return;
                            }
                            ContentAssistant.this.fProposalPopup.showProposals(true);
                            ContentAssistant.this.fLastAutoActivation = System.currentTimeMillis();
                        } else if (n == 2 && ContentAssistant.this.fContextInfoPopup != null) {
                            ContentAssistant.this.promoteKeyListener();
                            ContentAssistant.this.fContextInfoPopup.showContextProposals(true);
                        }
                    }
                });
            }
            catch (SWTError sWTError) {}
        }
    }

    class Closer
    implements ControlListener,
    MouseListener,
    FocusListener,
    DisposeListener,
    IViewportListener {
        private Shell fShell;
        private Control fControl;

        Closer() {
        }

        protected void install() {
            Control control;
            this.fControl = control = ContentAssistant.this.fContentAssistSubjectControlAdapter.getControl();
            if (Helper.okToUse((Widget)control)) {
                Shell shell;
                this.fShell = shell = control.getShell();
                shell.addControlListener((ControlListener)this);
                control.addMouseListener((MouseListener)this);
                control.addFocusListener((FocusListener)this);
                control.addDisposeListener((DisposeListener)this);
            }
            if (ContentAssistant.this.fViewer != null) {
                ContentAssistant.this.fViewer.addViewportListener(this);
            }
        }

        protected void uninstall() {
            Shell shell = this.fShell;
            this.fShell = null;
            if (Helper.okToUse((Widget)shell)) {
                shell.removeControlListener((ControlListener)this);
            }
            Control control = this.fControl;
            this.fControl = null;
            if (Helper.okToUse((Widget)control)) {
                control.removeMouseListener((MouseListener)this);
                control.removeFocusListener((FocusListener)this);
                control.removeDisposeListener((DisposeListener)this);
            }
            if (ContentAssistant.this.fViewer != null) {
                ContentAssistant.this.fViewer.removeViewportListener(this);
            }
        }

        public void controlResized(ControlEvent controlEvent) {
            ContentAssistant.this.hide();
        }

        public void controlMoved(ControlEvent controlEvent) {
            ContentAssistant.this.hide();
        }

        public void mouseDown(MouseEvent mouseEvent) {
            ContentAssistant.this.hide();
        }

        public void mouseUp(MouseEvent mouseEvent) {
        }

        public void mouseDoubleClick(MouseEvent mouseEvent) {
            ContentAssistant.this.hide();
        }

        public void focusGained(FocusEvent focusEvent) {
        }

        public void focusLost(FocusEvent focusEvent) {
            Display display;
            Control control = this.fControl;
            if (Helper.okToUse((Widget)control) && (display = control.getDisplay()) != null) {
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!(ContentAssistant.this.fProposalPopup.hasFocus() || ContentAssistant.this.fContextInfoPopup != null && ContentAssistant.this.fContextInfoPopup.hasFocus())) {
                            ContentAssistant.this.hide();
                        }
                    }
                });
            }
        }

        public void widgetDisposed(DisposeEvent disposeEvent) {
            ContentAssistant.this.hide();
        }

        @Override
        public void viewportChanged(int n) {
            ContentAssistant.this.hide();
        }
    }

    class InternalListener
    implements VerifyKeyListener,
    IEventConsumer {
        InternalListener() {
        }

        public void verifyKey(VerifyEvent verifyEvent) {
            IContentAssistListener[] iContentAssistListenerArray = (IContentAssistListener[])ContentAssistant.this.fListeners.clone();
            int n = 0;
            while (n < iContentAssistListenerArray.length) {
                if (iContentAssistListenerArray[n] != null && (!iContentAssistListenerArray[n].verifyKey(verifyEvent) || !verifyEvent.doit)) break;
                ++n;
            }
            if (ContentAssistant.this.fAutoAssistListener != null) {
                ContentAssistant.this.fAutoAssistListener.keyPressed((KeyEvent)verifyEvent);
            }
        }

        @Override
        public void processEvent(VerifyEvent verifyEvent) {
            ContentAssistant.this.installKeyListener();
            IContentAssistListener[] iContentAssistListenerArray = (IContentAssistListener[])ContentAssistant.this.fListeners.clone();
            int n = 0;
            while (n < iContentAssistListenerArray.length) {
                if (iContentAssistListenerArray[n] != null) {
                    iContentAssistListenerArray[n].processEvent(verifyEvent);
                    if (!verifyEvent.doit) {
                        return;
                    }
                }
                ++n;
            }
        }
    }

    class LayoutManager
    implements Listener {
        public static final int LAYOUT_PROPOSAL_SELECTOR = 0;
        public static final int LAYOUT_CONTEXT_SELECTOR = 1;
        public static final int LAYOUT_CONTEXT_INFO_POPUP = 2;
        int fContextType = 1;
        Shell[] fShells = new Shell[3];
        Object[] fPopups = new Object[3];

        LayoutManager() {
        }

        protected void add(Object object, Shell shell, int n, int n2) {
            Assert.isNotNull((Object)object);
            Assert.isTrue((shell != null && !shell.isDisposed() ? 1 : 0) != 0);
            this.checkType(n);
            if (this.fShells[n] != shell) {
                if (this.fShells[n] != null) {
                    this.fShells[n].removeListener(12, (Listener)this);
                }
                shell.addListener(12, (Listener)this);
                this.fShells[n] = shell;
            }
            this.fPopups[n] = object;
            if (n == 1 || n == 2) {
                this.fContextType = n;
            }
            this.layout(n, n2);
            this.adjustListeners(n);
        }

        protected void checkType(int n) {
            Assert.isTrue((n == 0 || n == 1 || n == 2 ? 1 : 0) != 0);
        }

        public void handleEvent(Event event) {
            Widget widget = event.widget;
            widget.removeListener(12, (Listener)this);
            int n = this.getShellType(widget);
            this.checkType(n);
            this.fShells[n] = null;
            switch (n) {
                case 0: {
                    if (this.fContextType != 1 || !Helper.okToUse((Widget)this.fShells[1])) break;
                    ContentAssistant.this.addContentAssistListener((IContentAssistListener)this.fPopups[1], 0);
                    break;
                }
                case 1: {
                    if (Helper.okToUse((Widget)this.fShells[0])) {
                        if (ContentAssistant.this.fProposalPopupOrientation == 12) {
                            this.layout(0, ContentAssistant.this.getSelectionOffset());
                        }
                        ContentAssistant.this.addContentAssistListener((IContentAssistListener)this.fPopups[0], 1);
                    }
                    this.fContextType = 2;
                    break;
                }
                case 2: {
                    if (Helper.okToUse((Widget)this.fShells[0]) && ContentAssistant.this.fContextInfoPopupOrientation == 21) {
                        this.layout(0, ContentAssistant.this.getSelectionOffset());
                    }
                    this.fContextType = 1;
                }
            }
        }

        protected int getShellType(Widget widget) {
            int n = 0;
            while (n < this.fShells.length) {
                if (this.fShells[n] == widget) {
                    return n;
                }
                ++n;
            }
            return -1;
        }

        protected void layout(int n, int n2) {
            switch (n) {
                case 0: {
                    this.layoutProposalSelector(n2);
                    break;
                }
                case 1: {
                    this.layoutContextSelector(n2);
                    break;
                }
                case 2: {
                    this.layoutContextInfoPopup(n2);
                }
            }
        }

        protected void layoutProposalSelector(int n) {
            if (this.fContextType == 2 && ContentAssistant.this.fContextInfoPopupOrientation == 21 && Helper.okToUse((Widget)this.fShells[2])) {
                Shell shell = this.fShells[0];
                Shell shell2 = this.fShells[2];
                shell.setLocation(this.getStackedLocation(shell, shell2));
            } else if (this.fContextType != 1 || !Helper.okToUse((Widget)this.fShells[1])) {
                Shell shell = this.fShells[0];
                CompletionProposalPopup completionProposalPopup = (CompletionProposalPopup)this.fPopups[0];
                shell.setBounds(this.computeBoundsBelowAbove(shell, shell.getSize(), n, completionProposalPopup));
            } else {
                CompletionProposalPopup completionProposalPopup = (CompletionProposalPopup)this.fPopups[0];
                switch (ContentAssistant.this.fProposalPopupOrientation) {
                    case 11: {
                        this.fShells[1].dispose();
                        Shell shell = this.fShells[0];
                        shell.setBounds(this.computeBoundsBelowAbove(shell, shell.getSize(), n, completionProposalPopup));
                        break;
                    }
                    case 10: {
                        Shell shell = this.fShells[0];
                        shell.setBounds(this.computeBoundsBelowAbove(shell, shell.getSize(), n, completionProposalPopup));
                        break;
                    }
                    case 12: {
                        Shell shell = this.fShells[0];
                        Shell shell3 = this.fShells[1];
                        shell.setLocation(this.getStackedLocation(shell, shell3));
                    }
                }
            }
        }

        protected void layoutContextSelector(int n) {
            Shell shell = this.fShells[1];
            shell.setBounds(this.computeBoundsBelowAbove(shell, shell.getSize(), n, null));
            if (Helper.okToUse((Widget)this.fShells[0])) {
                switch (ContentAssistant.this.fProposalPopupOrientation) {
                    case 11: {
                        this.fShells[0].dispose();
                        break;
                    }
                    case 10: {
                        break;
                    }
                    case 12: {
                        shell = this.fShells[0];
                        Shell shell2 = this.fShells[1];
                        shell.setLocation(this.getStackedLocation(shell, shell2));
                    }
                }
            }
        }

        protected void layoutContextInfoPopup(int n) {
            switch (ContentAssistant.this.fContextInfoPopupOrientation) {
                case 20: {
                    Shell shell = this.fShells[2];
                    shell.setBounds(this.computeBoundsAboveBelow(shell, shell.getSize(), n));
                    break;
                }
                case 21: {
                    Shell shell = this.fShells[2];
                    shell.setBounds(this.computeBoundsBelowAbove(shell, shell.getSize(), n, null));
                    if (!Helper.okToUse((Widget)this.fShells[0])) break;
                    Shell shell2 = this.fShells[0];
                    shell2.setLocation(this.getStackedLocation(shell2, shell));
                }
            }
        }

        protected void constrainLocation(Point point, Point point2, Rectangle rectangle) {
            if (point.x + point2.x > rectangle.x + rectangle.width) {
                point.x = rectangle.x + rectangle.width - point2.x;
            }
            if (point.x < rectangle.x) {
                point.x = rectangle.x;
            }
            if (point.y + point2.y > rectangle.y + rectangle.height) {
                point.y = rectangle.y + rectangle.height - point2.y;
            }
            if (point.y < rectangle.y) {
                point.y = rectangle.y;
            }
        }

        protected Rectangle constrainHorizontally(Rectangle rectangle, Rectangle rectangle2) {
            if (rectangle.width > rectangle2.width) {
                rectangle.width = rectangle2.width;
            }
            if (rectangle.x + rectangle.width > rectangle2.x + rectangle2.width) {
                rectangle.x = rectangle2.x + rectangle2.width - rectangle.width;
            }
            if (rectangle.x < rectangle2.x) {
                rectangle.x = rectangle2.x;
            }
            return rectangle;
        }

        protected Rectangle computeBoundsAboveBelow(Shell shell, Point point, int n) {
            Control control = ContentAssistant.this.fContentAssistSubjectControlAdapter.getControl();
            Display display = control.getDisplay();
            Rectangle rectangle = this.getCaretRectangle(n);
            Monitor monitor = this.getClosestMonitor(display, rectangle);
            Rectangle rectangle2 = monitor.getClientArea();
            Geometry.moveInside((Rectangle)rectangle, (Rectangle)rectangle2);
            int n2 = rectangle.y - rectangle2.y;
            int n3 = rectangle.y + rectangle.height;
            int n4 = rectangle2.y + rectangle2.height - n3;
            Rectangle rectangle3 = n2 >= point.y ? new Rectangle(rectangle.x, rectangle.y - point.y, point.x, point.y) : (n4 >= point.y ? new Rectangle(rectangle.x, n3, point.x, point.y) : (n4 <= n2 ? new Rectangle(rectangle.x, rectangle2.y, point.x, n2) : new Rectangle(rectangle.x, n3, point.x, n4)));
            return this.constrainHorizontally(rectangle3, rectangle2);
        }

        protected Rectangle computeBoundsBelowAbove(Shell shell, Point point, int n, CompletionProposalPopup completionProposalPopup) {
            Rectangle rectangle;
            Control control = ContentAssistant.this.fContentAssistSubjectControlAdapter.getControl();
            Display display = control.getDisplay();
            Rectangle rectangle2 = this.getCaretRectangle(n);
            Monitor monitor = this.getClosestMonitor(display, rectangle2);
            Rectangle rectangle3 = monitor.getClientArea();
            Geometry.moveInside((Rectangle)rectangle2, (Rectangle)rectangle3);
            int n2 = completionProposalPopup == null ? Integer.MAX_VALUE : completionProposalPopup.getMinimalHeight();
            int n3 = rectangle2.y - rectangle3.y;
            int n4 = rectangle3.y + rectangle3.height - (rectangle2.y + rectangle2.height);
            boolean bl = false;
            if (n4 >= point.y) {
                rectangle = new Rectangle(rectangle2.x, rectangle2.y + rectangle2.height, point.x, point.y);
            } else if (n4 >= n2) {
                rectangle = new Rectangle(rectangle2.x, rectangle2.y + rectangle2.height, point.x, n4);
            } else if (n3 >= point.y) {
                rectangle = new Rectangle(rectangle2.x, rectangle2.y - point.y, point.x, point.y);
                bl = true;
            } else if (n4 >= n3) {
                rectangle = new Rectangle(rectangle2.x, rectangle2.y + rectangle2.height, point.x, n4);
            } else {
                rectangle = new Rectangle(rectangle2.x, rectangle3.y, point.x, n3);
                bl = true;
            }
            if (completionProposalPopup != null) {
                completionProposalPopup.switchedPositionToAbove(bl);
            }
            return this.constrainHorizontally(rectangle, rectangle3);
        }

        private Rectangle getCaretRectangle(int n) {
            Point point = ContentAssistant.this.fContentAssistSubjectControlAdapter.getLocationAtOffset(n);
            Control control = ContentAssistant.this.fContentAssistSubjectControlAdapter.getControl();
            Point point2 = control.getSize();
            this.constrainLocation(point, new Point(0, 0), new Rectangle(0, 0, point2.x, point2.y));
            point = control.toDisplay(point);
            Rectangle rectangle = new Rectangle(point.x, point.y, 1, ContentAssistant.this.fContentAssistSubjectControlAdapter.getLineHeight());
            return rectangle;
        }

        protected Point getStackedLocation(Shell shell, Shell shell2) {
            Point point = shell2.getLocation();
            Point point2 = shell2.getSize();
            point.x += point2.x / 4;
            point.y += point2.y;
            point = shell2.toDisplay(point);
            Point point3 = shell.getSize();
            Monitor monitor = this.getClosestMonitor(shell2.getDisplay(), new Rectangle(point.x, point.y, 0, 0));
            Rectangle rectangle = monitor.getClientArea();
            this.constrainLocation(point, point3, rectangle);
            return point;
        }

        protected void adjustListeners(int n) {
            switch (n) {
                case 0: {
                    if (this.fContextType != 1 || !Helper.okToUse((Widget)this.fShells[1])) break;
                    ContentAssistant.this.removeContentAssistListener((IContentAssistListener)this.fPopups[1], 0);
                    break;
                }
                case 1: {
                    if (!Helper.okToUse((Widget)this.fShells[0])) break;
                    ContentAssistant.this.removeContentAssistListener((IContentAssistListener)this.fPopups[0], 1);
                    break;
                }
            }
        }

        private Monitor getClosestMonitor(Display display, Rectangle rectangle) {
            int n = Integer.MAX_VALUE;
            Point point = Geometry.centerPoint((Rectangle)rectangle);
            Monitor[] monitorArray = display.getMonitors();
            Monitor monitor = monitorArray[0];
            int n2 = 0;
            while (n2 < monitorArray.length) {
                Monitor monitor2 = monitorArray[n2];
                Rectangle rectangle2 = monitor2.getClientArea();
                if (rectangle2.contains(point)) {
                    return monitor2;
                }
                int n3 = Geometry.distanceSquared((Point)Geometry.centerPoint((Rectangle)rectangle2), (Point)point);
                if (n3 < n) {
                    n = n3;
                    monitor = monitor2;
                }
                ++n2;
            }
            return monitor;
        }
    }
}

