/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.contentassist;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.contentassist.IContentAssistSubjectControl;
import org.eclipse.jface.contentassist.ISubjectControlContextInformationPresenter;
import org.eclipse.jface.contentassist.ISubjectControlContextInformationValidator;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IEventConsumer;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.jface.text.contentassist.AdditionalInfoController;
import org.eclipse.jface.text.contentassist.CompletionProposalPopup;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.ContextInformationPopup;
import org.eclipse.jface.text.contentassist.Helper;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationPresenter;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;

final class ContentAssistSubjectControlAdapter
implements IContentAssistSubjectControl {
    private ITextViewer fViewer;
    private IContentAssistSubjectControl fContentAssistSubjectControl;

    ContentAssistSubjectControlAdapter(IContentAssistSubjectControl iContentAssistSubjectControl) {
        Assert.isNotNull((Object)iContentAssistSubjectControl);
        this.fContentAssistSubjectControl = iContentAssistSubjectControl;
    }

    public ContentAssistSubjectControlAdapter(ITextViewer iTextViewer) {
        Assert.isNotNull((Object)iTextViewer);
        this.fViewer = iTextViewer;
    }

    @Override
    public int getLineHeight() {
        if (this.fContentAssistSubjectControl != null) {
            return this.fContentAssistSubjectControl.getLineHeight();
        }
        return this.fViewer.getTextWidget().getLineHeight(this.getCaretOffset());
    }

    @Override
    public Control getControl() {
        if (this.fContentAssistSubjectControl != null) {
            return this.fContentAssistSubjectControl.getControl();
        }
        return this.fViewer.getTextWidget();
    }

    @Override
    public Point getLocationAtOffset(int n) {
        if (this.fContentAssistSubjectControl != null) {
            return this.fContentAssistSubjectControl.getLocationAtOffset(n);
        }
        return this.fViewer.getTextWidget().getLocationAtOffset(n);
    }

    @Override
    public Point getWidgetSelectionRange() {
        if (this.fContentAssistSubjectControl != null) {
            return this.fContentAssistSubjectControl.getWidgetSelectionRange();
        }
        return this.fViewer.getTextWidget().getSelectionRange();
    }

    @Override
    public Point getSelectedRange() {
        if (this.fContentAssistSubjectControl != null) {
            return this.fContentAssistSubjectControl.getSelectedRange();
        }
        return this.fViewer.getSelectedRange();
    }

    @Override
    public int getCaretOffset() {
        if (this.fContentAssistSubjectControl != null) {
            return this.fContentAssistSubjectControl.getCaretOffset();
        }
        return this.fViewer.getTextWidget().getCaretOffset();
    }

    @Override
    public String getLineDelimiter() {
        if (this.fContentAssistSubjectControl != null) {
            return this.fContentAssistSubjectControl.getLineDelimiter();
        }
        return this.fViewer.getTextWidget().getLineDelimiter();
    }

    @Override
    public void addKeyListener(KeyListener keyListener) {
        if (this.fContentAssistSubjectControl != null) {
            this.fContentAssistSubjectControl.addKeyListener(keyListener);
        } else {
            this.fViewer.getTextWidget().addKeyListener(keyListener);
        }
    }

    @Override
    public void removeKeyListener(KeyListener keyListener) {
        if (this.fContentAssistSubjectControl != null) {
            this.fContentAssistSubjectControl.removeKeyListener(keyListener);
        } else {
            this.fViewer.getTextWidget().removeKeyListener(keyListener);
        }
    }

    @Override
    public IDocument getDocument() {
        if (this.fContentAssistSubjectControl != null) {
            return this.fContentAssistSubjectControl.getDocument();
        }
        return this.fViewer.getDocument();
    }

    @Override
    public boolean prependVerifyKeyListener(VerifyKeyListener verifyKeyListener) {
        if (this.fContentAssistSubjectControl != null) {
            return this.fContentAssistSubjectControl.prependVerifyKeyListener(verifyKeyListener);
        }
        if (this.fViewer instanceof ITextViewerExtension) {
            ITextViewerExtension iTextViewerExtension = (ITextViewerExtension)((Object)this.fViewer);
            iTextViewerExtension.prependVerifyKeyListener(verifyKeyListener);
            return true;
        }
        StyledText styledText = this.fViewer.getTextWidget();
        if (Helper.okToUse((Widget)styledText)) {
            styledText.addVerifyKeyListener(verifyKeyListener);
            return true;
        }
        return false;
    }

    @Override
    public boolean appendVerifyKeyListener(VerifyKeyListener verifyKeyListener) {
        if (this.fContentAssistSubjectControl != null) {
            return this.fContentAssistSubjectControl.appendVerifyKeyListener(verifyKeyListener);
        }
        if (this.fViewer instanceof ITextViewerExtension) {
            ITextViewerExtension iTextViewerExtension = (ITextViewerExtension)((Object)this.fViewer);
            iTextViewerExtension.appendVerifyKeyListener(verifyKeyListener);
            return true;
        }
        StyledText styledText = this.fViewer.getTextWidget();
        if (Helper.okToUse((Widget)styledText)) {
            styledText.addVerifyKeyListener(verifyKeyListener);
            return true;
        }
        return false;
    }

    @Override
    public void removeVerifyKeyListener(VerifyKeyListener verifyKeyListener) {
        if (this.fContentAssistSubjectControl != null) {
            this.fContentAssistSubjectControl.removeVerifyKeyListener(verifyKeyListener);
        } else if (this.fViewer instanceof ITextViewerExtension) {
            ITextViewerExtension iTextViewerExtension = (ITextViewerExtension)((Object)this.fViewer);
            iTextViewerExtension.removeVerifyKeyListener(verifyKeyListener);
        } else {
            StyledText styledText = this.fViewer.getTextWidget();
            if (Helper.okToUse((Widget)styledText)) {
                styledText.removeVerifyKeyListener(verifyKeyListener);
            }
        }
    }

    @Override
    public void setEventConsumer(IEventConsumer iEventConsumer) {
        if (this.fContentAssistSubjectControl != null) {
            this.fContentAssistSubjectControl.setEventConsumer(iEventConsumer);
        } else {
            this.fViewer.setEventConsumer(iEventConsumer);
        }
    }

    @Override
    public void setSelectedRange(int n, int n2) {
        if (this.fContentAssistSubjectControl != null) {
            this.fContentAssistSubjectControl.setSelectedRange(n, n2);
        } else {
            this.fViewer.setSelectedRange(n, n2);
        }
    }

    @Override
    public void revealRange(int n, int n2) {
        if (this.fContentAssistSubjectControl != null) {
            this.fContentAssistSubjectControl.revealRange(n, n2);
        } else {
            this.fViewer.revealRange(n, n2);
        }
    }

    @Override
    public boolean supportsVerifyKeyListener() {
        if (this.fContentAssistSubjectControl != null) {
            return this.fContentAssistSubjectControl.supportsVerifyKeyListener();
        }
        return true;
    }

    public char[] getCompletionProposalAutoActivationCharacters(ContentAssistant contentAssistant, int n) {
        if (this.fContentAssistSubjectControl != null) {
            return contentAssistant.getCompletionProposalAutoActivationCharacters(this.fContentAssistSubjectControl, n);
        }
        return contentAssistant.getCompletionProposalAutoActivationCharacters(this.fViewer, n);
    }

    char[] getContextInformationAutoActivationCharacters(ContentAssistant contentAssistant, int n) {
        if (this.fContentAssistSubjectControl != null) {
            return contentAssistant.getContextInformationAutoActivationCharacters(this.fContentAssistSubjectControl, n);
        }
        return contentAssistant.getContextInformationAutoActivationCharacters(this.fViewer, n);
    }

    CompletionProposalPopup createCompletionProposalPopup(ContentAssistant contentAssistant, AdditionalInfoController additionalInfoController) {
        if (this.fContentAssistSubjectControl != null) {
            return new CompletionProposalPopup(contentAssistant, this.fContentAssistSubjectControl, additionalInfoController);
        }
        return new CompletionProposalPopup(contentAssistant, this.fViewer, additionalInfoController);
    }

    ContextInformationPopup createContextInfoPopup(ContentAssistant contentAssistant) {
        if (this.fContentAssistSubjectControl != null) {
            return new ContextInformationPopup(contentAssistant, this.fContentAssistSubjectControl);
        }
        return new ContextInformationPopup(contentAssistant, this.fViewer);
    }

    public IContextInformationValidator getContextInformationValidator(ContentAssistant contentAssistant, int n) {
        if (this.fContentAssistSubjectControl != null) {
            return contentAssistant.getContextInformationValidator(this.fContentAssistSubjectControl, n);
        }
        return contentAssistant.getContextInformationValidator(this.fViewer, n);
    }

    public IContextInformationPresenter getContextInformationPresenter(ContentAssistant contentAssistant, int n) {
        if (this.fContentAssistSubjectControl != null) {
            return contentAssistant.getContextInformationPresenter(this.fContentAssistSubjectControl, n);
        }
        return contentAssistant.getContextInformationPresenter(this.fViewer, n);
    }

    public void installValidator(ContextInformationPopup.ContextFrame contextFrame) {
        if (this.fContentAssistSubjectControl != null) {
            if (contextFrame.fValidator instanceof ISubjectControlContextInformationValidator) {
                ((ISubjectControlContextInformationValidator)contextFrame.fValidator).install(contextFrame.fInformation, this.fContentAssistSubjectControl, contextFrame.fOffset);
            }
        } else {
            contextFrame.fValidator.install(contextFrame.fInformation, this.fViewer, contextFrame.fOffset);
        }
    }

    public void installContextInformationPresenter(ContextInformationPopup.ContextFrame contextFrame) {
        if (this.fContentAssistSubjectControl != null) {
            if (contextFrame.fPresenter instanceof ISubjectControlContextInformationPresenter) {
                ((ISubjectControlContextInformationPresenter)((Object)contextFrame.fValidator)).install(contextFrame.fInformation, this.fContentAssistSubjectControl, contextFrame.fBeginOffset);
            }
        } else {
            contextFrame.fPresenter.install(contextFrame.fInformation, this.fViewer, contextFrame.fBeginOffset);
        }
    }

    public IContextInformation[] computeContextInformation(ContentAssistant contentAssistant, int n) {
        if (this.fContentAssistSubjectControl != null) {
            return contentAssistant.computeContextInformation(this.fContentAssistSubjectControl, n);
        }
        return contentAssistant.computeContextInformation(this.fViewer, n);
    }

    @Override
    public boolean addSelectionListener(SelectionListener selectionListener) {
        if (this.fContentAssistSubjectControl != null) {
            return this.fContentAssistSubjectControl.addSelectionListener(selectionListener);
        }
        this.fViewer.getTextWidget().addSelectionListener(selectionListener);
        return true;
    }

    @Override
    public void removeSelectionListener(SelectionListener selectionListener) {
        if (this.fContentAssistSubjectControl != null) {
            this.fContentAssistSubjectControl.removeSelectionListener(selectionListener);
        } else {
            this.fViewer.getTextWidget().removeSelectionListener(selectionListener);
        }
    }
}

