/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.contentassist;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.bindings.keys.KeySequence;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.SWTKeySupport;
import org.eclipse.jface.contentassist.IContentAssistSubjectControl;
import org.eclipse.jface.internal.text.InformationControlReplacer;
import org.eclipse.jface.internal.text.TableOwnerDrawSupport;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.AbstractInformationControlManager;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IEditingSupport;
import org.eclipse.jface.text.IEditingSupportRegistry;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.IRewriteTarget;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.contentassist.AdditionalInfoController;
import org.eclipse.jface.text.contentassist.ContentAssistSubjectControlAdapter;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.Helper;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension2;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension3;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension4;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension6;
import org.eclipse.jface.text.contentassist.ICompletionProposalSorter;
import org.eclipse.jface.text.contentassist.IContentAssistListener;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.JFaceTextMessages;
import org.eclipse.jface.text.contentassist.PopupCloser;
import org.eclipse.jface.util.Geometry;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

class CompletionProposalPopup
implements IContentAssistListener {
    private static final boolean USE_VIRTUAL = !"motif".equals(SWT.getPlatform());
    private ITextViewer fViewer;
    private final ContentAssistant fContentAssistant;
    private final AdditionalInfoController fAdditionalInfoController;
    private final PopupCloser fPopupCloser = new PopupCloser();
    private Shell fProposalShell;
    private Table fProposalTable;
    private boolean fInserting = false;
    private ProposalSelectionListener fKeyListener;
    private final List fDocumentEvents = new ArrayList();
    private IDocumentListener fDocumentListener;
    private ICompletionProposal[] fFilteredProposals;
    private ICompletionProposal[] fComputedProposals;
    private int fInvocationOffset;
    private int fFilterOffset;
    private ICompletionProposal fLastProposal;
    private IContentAssistSubjectControl fContentAssistSubjectControl;
    private final ContentAssistSubjectControlAdapter fContentAssistSubjectControlAdapter;
    private Point fSize;
    private IEditingSupport fFocusHelper;
    private boolean fIsFilteredSubset;
    private final Runnable fFilterRunnable = new Runnable(){

        @Override
        public void run() {
            ICompletionProposal[] iCompletionProposalArray;
            int n;
            block10: {
                if (!CompletionProposalPopup.this.fIsFilterPending) {
                    return;
                }
                CompletionProposalPopup.this.fIsFilterPending = false;
                if (!Helper.okToUse((Widget)CompletionProposalPopup.this.fContentAssistSubjectControlAdapter.getControl())) {
                    return;
                }
                n = ((CompletionProposalPopup)CompletionProposalPopup.this).fContentAssistSubjectControlAdapter.getSelectedRange().x;
                iCompletionProposalArray = null;
                try {
                    try {
                        if (n > -1) {
                            DocumentEvent documentEvent = TextUtilities.mergeProcessedDocumentEvents((List)CompletionProposalPopup.this.fDocumentEvents);
                            iCompletionProposalArray = CompletionProposalPopup.this.computeFilteredProposals(n, documentEvent);
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        CompletionProposalPopup.this.fDocumentEvents.clear();
                        break block10;
                    }
                }
                catch (Throwable throwable) {
                    CompletionProposalPopup.this.fDocumentEvents.clear();
                    throw throwable;
                }
                CompletionProposalPopup.this.fDocumentEvents.clear();
            }
            CompletionProposalPopup.this.fFilterOffset = n;
            if (iCompletionProposalArray != null && iCompletionProposalArray.length > 0) {
                CompletionProposalPopup.this.setProposals(iCompletionProposalArray, CompletionProposalPopup.this.fIsFilteredSubset);
            } else {
                CompletionProposalPopup.this.hide();
            }
        }
    };
    private boolean fIsFilterPending = false;
    private Label fMessageText;
    private Font fMessageTextFont;
    private int fLastCompletionOffset;
    private final EmptyProposal fEmptyProposal = new EmptyProposal();
    private String fEmptyMessage = null;
    private boolean fIsColoredLabelsSupportEnabled = false;
    private ICompletionProposalSorter fSorter;

    public CompletionProposalPopup(ContentAssistant contentAssistant, ITextViewer iTextViewer, AdditionalInfoController additionalInfoController) {
        this.fContentAssistant = contentAssistant;
        this.fViewer = iTextViewer;
        this.fAdditionalInfoController = additionalInfoController;
        this.fContentAssistSubjectControlAdapter = new ContentAssistSubjectControlAdapter(this.fViewer);
    }

    public CompletionProposalPopup(ContentAssistant contentAssistant, IContentAssistSubjectControl iContentAssistSubjectControl, AdditionalInfoController additionalInfoController) {
        this.fContentAssistant = contentAssistant;
        this.fContentAssistSubjectControl = iContentAssistSubjectControl;
        this.fAdditionalInfoController = additionalInfoController;
        this.fContentAssistSubjectControlAdapter = new ContentAssistSubjectControlAdapter(this.fContentAssistSubjectControl);
    }

    public String showProposals(final boolean bl) {
        if (this.fKeyListener == null) {
            this.fKeyListener = new ProposalSelectionListener();
        }
        Control control = this.fContentAssistSubjectControlAdapter.getControl();
        if (!Helper.okToUse((Widget)this.fProposalShell) && control != null && !control.isDisposed()) {
            this.fContentAssistSubjectControlAdapter.addKeyListener(this.fKeyListener);
            BusyIndicator.showWhile((Display)control.getDisplay(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    int n;
                    CompletionProposalPopup.this.fInvocationOffset = ((CompletionProposalPopup)CompletionProposalPopup.this).fContentAssistSubjectControlAdapter.getSelectedRange().x;
                    CompletionProposalPopup.this.fFilterOffset = CompletionProposalPopup.this.fInvocationOffset;
                    CompletionProposalPopup.this.fLastCompletionOffset = CompletionProposalPopup.this.fFilterOffset;
                    CompletionProposalPopup.this.fComputedProposals = CompletionProposalPopup.this.computeProposals(CompletionProposalPopup.this.fInvocationOffset);
                    int n2 = n = CompletionProposalPopup.this.fComputedProposals == null ? 0 : CompletionProposalPopup.this.fComputedProposals.length;
                    if (n == 0 && CompletionProposalPopup.this.hideWhenNoProposals(bl)) {
                        return;
                    }
                    if (n == 1 && !bl && CompletionProposalPopup.this.canAutoInsert(CompletionProposalPopup.this.fComputedProposals[0])) {
                        CompletionProposalPopup.this.insertProposal(CompletionProposalPopup.this.fComputedProposals[0], '\u0000', 0, CompletionProposalPopup.this.fInvocationOffset);
                        CompletionProposalPopup.this.hide();
                    } else {
                        CompletionProposalPopup.this.createProposalSelector();
                        CompletionProposalPopup.this.setProposals(CompletionProposalPopup.this.fComputedProposals, false);
                        CompletionProposalPopup.this.displayProposals();
                    }
                }
            });
        } else {
            this.fLastCompletionOffset = this.fFilterOffset;
            this.handleRepeatedInvocation();
        }
        return this.getErrorMessage();
    }

    private boolean hideWhenNoProposals(boolean bl) {
        if (bl || !this.fContentAssistant.isShowEmptyList()) {
            Control control;
            if (!bl && (control = this.fContentAssistSubjectControlAdapter.getControl()) != null && !control.isDisposed()) {
                control.getDisplay().beep();
            }
            this.hide();
            return true;
        }
        return false;
    }

    private void handleRepeatedInvocation() {
        if (this.fContentAssistant.isRepeatedInvocationMode()) {
            this.fComputedProposals = this.computeProposals(this.fFilterOffset);
            this.setProposals(this.fComputedProposals, false);
        }
    }

    private ICompletionProposal[] computeProposals(int n) {
        if (this.fContentAssistSubjectControl != null) {
            return this.fContentAssistant.computeCompletionProposals(this.fContentAssistSubjectControl, n);
        }
        return this.fContentAssistant.computeCompletionProposals(this.fViewer, n);
    }

    private String getErrorMessage() {
        return this.fContentAssistant.getErrorMessage();
    }

    private void createProposalSelector() {
        Listener listener;
        if (Helper.okToUse((Widget)this.fProposalShell)) {
            return;
        }
        Control control = this.fContentAssistSubjectControlAdapter.getControl();
        this.fProposalShell = new Shell(control.getShell(), 16400);
        this.fProposalShell.setFont(JFaceResources.getDefaultFont());
        if (USE_VIRTUAL) {
            this.fProposalTable = new Table((Composite)this.fProposalShell, 0x10000300);
            listener = new Listener(){

                public void handleEvent(Event event) {
                    CompletionProposalPopup.this.handleSetData(event);
                }
            };
            this.fProposalTable.addListener(36, listener);
        } else {
            this.fProposalTable = new Table((Composite)this.fProposalShell, 768);
        }
        this.fIsColoredLabelsSupportEnabled = this.fContentAssistant.isColoredLabelsSupportEnabled();
        if (this.fIsColoredLabelsSupportEnabled) {
            TableOwnerDrawSupport.install(this.fProposalTable);
        }
        this.fProposalTable.setLocation(0, 0);
        if (this.fAdditionalInfoController != null) {
            this.fAdditionalInfoController.setSizeConstraints(50, 10, true, true);
        }
        listener = new GridLayout();
        listener.marginWidth = 0;
        listener.marginHeight = 0;
        listener.verticalSpacing = 1;
        this.fProposalShell.setLayout((Layout)listener);
        if (this.fContentAssistant.isStatusLineVisible()) {
            this.createMessageText();
        }
        GridData gridData = new GridData(1808);
        Point point = this.fContentAssistant.restoreCompletionProposalPopupSize();
        if (point != null) {
            this.fProposalTable.setLayoutData((Object)gridData);
            this.fProposalShell.setSize(point);
        } else {
            int n = this.fProposalTable.getItemHeight() * 10;
            double d = (1.0 + Math.sqrt(5.0)) / 2.0;
            int n2 = (int)((double)n * d);
            Rectangle rectangle = this.fProposalTable.computeTrim(0, 0, n2, n);
            gridData.heightHint = rectangle.height;
            gridData.widthHint = rectangle.width;
            this.fProposalTable.setLayoutData((Object)gridData);
            this.fProposalShell.pack();
        }
        this.fContentAssistant.addToLayout(this, this.fProposalShell, 0, this.fContentAssistant.getSelectionOffset());
        this.fProposalShell.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent controlEvent) {
            }

            public void controlResized(ControlEvent controlEvent) {
                if (CompletionProposalPopup.this.fAdditionalInfoController != null) {
                    CompletionProposalPopup.this.fAdditionalInfoController.setSizeConstraints(50, 10, true, false);
                    CompletionProposalPopup.this.fAdditionalInfoController.hideInformationControl();
                    CompletionProposalPopup.this.fAdditionalInfoController.handleTableSelectionChanged();
                }
                CompletionProposalPopup.this.fSize = CompletionProposalPopup.this.fProposalShell.getSize();
            }
        });
        this.fProposalShell.setBackground(control.getDisplay().getSystemColor(15));
        Color color = this.getBackgroundColor(control);
        this.fProposalTable.setBackground(color);
        color = this.getForegroundColor(control);
        this.fProposalTable.setForeground(color);
        this.fProposalTable.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                CompletionProposalPopup.this.insertSelectedProposalWithMask(selectionEvent.stateMask);
            }
        });
        this.fPopupCloser.install(this.fContentAssistant, this.fProposalTable, this.fAdditionalInfoController);
        this.fProposalShell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                CompletionProposalPopup.this.unregister();
            }
        });
        this.fProposalTable.setHeaderVisible(false);
        this.addCommandSupport((Control)this.fProposalTable);
    }

    int getMinimalHeight() {
        int n = 0;
        if (Helper.okToUse((Widget)this.fProposalTable)) {
            int n2 = this.fProposalTable.getItemHeight() * 10;
            Rectangle rectangle = this.fProposalTable.computeTrim(0, 0, -1, n2);
            n = rectangle.height;
        }
        if (Helper.okToUse((Widget)this.fMessageText)) {
            n += this.fMessageText.getSize().y + 1;
        }
        return n;
    }

    private void addCommandSupport(final Control control) {
        final KeySequence keySequence = this.fContentAssistant.getRepeatedInvocationKeySequence();
        if (keySequence != null && !keySequence.isEmpty() && this.fContentAssistant.isRepeatedInvocationMode()) {
            control.addFocusListener(new FocusListener(){
                private CommandKeyListener fCommandKeyListener;

                public void focusGained(FocusEvent focusEvent) {
                    if (Helper.okToUse((Widget)control) && this.fCommandKeyListener == null) {
                        this.fCommandKeyListener = new CommandKeyListener(keySequence);
                        CompletionProposalPopup.this.fProposalTable.addKeyListener((KeyListener)this.fCommandKeyListener);
                    }
                }

                public void focusLost(FocusEvent focusEvent) {
                    if (this.fCommandKeyListener != null) {
                        control.removeKeyListener((KeyListener)this.fCommandKeyListener);
                        this.fCommandKeyListener = null;
                    }
                }
            });
        }
        if (this.fAdditionalInfoController != null) {
            control.addFocusListener(new FocusListener(){
                private TraverseListener fTraverseListener;

                public void focusGained(FocusEvent focusEvent) {
                    if (Helper.okToUse((Widget)control) && this.fTraverseListener == null) {
                        this.fTraverseListener = new TraverseListener(){

                            public void keyTraversed(TraverseEvent traverseEvent) {
                                if (traverseEvent.detail == 16) {
                                    IInformationControl iInformationControl = CompletionProposalPopup.this.fAdditionalInfoController.getCurrentInformationControl2();
                                    if (CompletionProposalPopup.this.fAdditionalInfoController.getInternalAccessor().canReplace(iInformationControl)) {
                                        CompletionProposalPopup.this.fAdditionalInfoController.getInternalAccessor().replaceInformationControl(true);
                                        traverseEvent.doit = false;
                                    }
                                }
                            }
                        };
                        CompletionProposalPopup.this.fProposalTable.addTraverseListener(this.fTraverseListener);
                    }
                }

                public void focusLost(FocusEvent focusEvent) {
                    if (this.fTraverseListener != null) {
                        control.removeTraverseListener(this.fTraverseListener);
                        this.fTraverseListener = null;
                    }
                }
            });
        }
    }

    private Color getBackgroundColor(Control control) {
        Color color = this.fContentAssistant.getProposalSelectorBackground();
        if (color == null) {
            color = JFaceResources.getColorRegistry().get("CONTENT_ASSIST_BACKGROUND_COLOR");
        }
        return color;
    }

    private Color getForegroundColor(Control control) {
        Color color = this.fContentAssistant.getProposalSelectorForeground();
        if (color == null) {
            color = JFaceResources.getColorRegistry().get("CONTENT_ASSIST_FOREGROUND_COLOR");
        }
        return color;
    }

    private void createMessageText() {
        if (this.fMessageText == null) {
            this.fMessageText = new Label((Composite)this.fProposalShell, 131072);
            GridData gridData = new GridData(4, 1024, true, false);
            this.fMessageText.setLayoutData((Object)gridData);
            this.fMessageText.setText(String.valueOf(this.fContentAssistant.getStatusMessage()) + " ");
            if (this.fMessageTextFont == null) {
                Font font = this.fMessageText.getFont();
                Display display = this.fProposalShell.getDisplay();
                FontData[] fontDataArray = font.getFontData();
                int n = 0;
                while (n < fontDataArray.length) {
                    fontDataArray[n].setHeight(fontDataArray[n].getHeight() * 9 / 10);
                    ++n;
                }
                this.fMessageTextFont = new Font((Device)display, fontDataArray);
            }
            this.fMessageText.setFont(this.fMessageTextFont);
            this.fMessageText.setBackground(this.getBackgroundColor((Control)this.fProposalShell));
            this.fMessageText.setForeground(this.getForegroundColor((Control)this.fProposalShell));
            if (this.fContentAssistant.isRepeatedInvocationMode()) {
                this.fMessageText.setCursor(this.fProposalShell.getDisplay().getSystemCursor(21));
                this.fMessageText.addMouseListener((MouseListener)new MouseAdapter(){

                    public void mouseUp(MouseEvent mouseEvent) {
                        CompletionProposalPopup.this.fLastCompletionOffset = CompletionProposalPopup.this.fFilterOffset;
                        CompletionProposalPopup.this.fProposalTable.setFocus();
                        CompletionProposalPopup.this.handleRepeatedInvocation();
                    }

                    public void mouseDown(MouseEvent mouseEvent) {
                    }
                });
            }
        }
    }

    private void handleSetData(Event event) {
        TableItem tableItem = (TableItem)event.item;
        int n = this.fProposalTable.indexOf(tableItem);
        if (n >= 0 && n < this.fFilteredProposals.length) {
            String string;
            ICompletionProposal iCompletionProposal = this.fFilteredProposals[n];
            StyleRange[] styleRangeArray = null;
            if (this.fIsColoredLabelsSupportEnabled && iCompletionProposal instanceof ICompletionProposalExtension6) {
                StyledString styledString = ((ICompletionProposalExtension6)((Object)iCompletionProposal)).getStyledDisplayString();
                string = styledString.getString();
                styleRangeArray = styledString.getStyleRanges();
            } else {
                string = iCompletionProposal.getDisplayString();
            }
            tableItem.setText(string);
            if (this.fIsColoredLabelsSupportEnabled) {
                TableOwnerDrawSupport.storeStyleRanges(tableItem, 0, styleRangeArray);
            }
            tableItem.setImage(iCompletionProposal.getImage());
            tableItem.setData((Object)iCompletionProposal);
        }
    }

    private ICompletionProposal getSelectedProposal() {
        if (this.fIsFilterPending) {
            this.fFilterRunnable.run();
        }
        if (!Helper.okToUse((Widget)this.fProposalTable)) {
            return null;
        }
        int n = this.fProposalTable.getSelectionIndex();
        if (this.fFilteredProposals == null || n < 0 || n >= this.fFilteredProposals.length) {
            return null;
        }
        return this.fFilteredProposals[n];
    }

    private void insertSelectedProposalWithMask(int n) {
        ICompletionProposal iCompletionProposal = this.getSelectedProposal();
        this.hide();
        if (iCompletionProposal != null) {
            this.insertProposal(iCompletionProposal, '\u0000', n, this.fContentAssistSubjectControlAdapter.getSelectedRange().x);
        }
    }

    private void insertProposal(ICompletionProposal iCompletionProposal, char c, int n, final int n2) {
        this.fInserting = true;
        IRewriteTarget iRewriteTarget = null;
        IEditingSupport iEditingSupport = new IEditingSupport(){

            @Override
            public boolean isOriginator(DocumentEvent documentEvent, IRegion iRegion) {
                return iRegion.getOffset() <= n2 && iRegion.getOffset() + iRegion.getLength() >= n2;
            }

            @Override
            public boolean ownsFocusShell() {
                return false;
            }
        };
        try {
            IContextInformation iContextInformation;
            Object object;
            IDocument iDocument = this.fContentAssistSubjectControlAdapter.getDocument();
            if (this.fViewer instanceof ITextViewerExtension) {
                object = (ITextViewerExtension)((Object)this.fViewer);
                iRewriteTarget = object.getRewriteTarget();
            }
            if (iRewriteTarget != null) {
                iRewriteTarget.beginCompoundChange();
            }
            if (this.fViewer instanceof IEditingSupportRegistry) {
                object = (IEditingSupportRegistry)((Object)this.fViewer);
                object.register(iEditingSupport);
            }
            if (iCompletionProposal instanceof ICompletionProposalExtension2 && this.fViewer != null) {
                object = (ICompletionProposalExtension2)((Object)iCompletionProposal);
                object.apply(this.fViewer, c, n, n2);
            } else if (iCompletionProposal instanceof ICompletionProposalExtension) {
                object = (ICompletionProposalExtension)((Object)iCompletionProposal);
                object.apply(iDocument, c, n2);
            } else {
                iCompletionProposal.apply(iDocument);
            }
            this.fireAppliedEvent(iCompletionProposal);
            object = iCompletionProposal.getSelection(iDocument);
            if (object != null) {
                this.fContentAssistSubjectControlAdapter.setSelectedRange(((Point)object).x, ((Point)object).y);
                this.fContentAssistSubjectControlAdapter.revealRange(((Point)object).x, ((Point)object).y);
            }
            if ((iContextInformation = iCompletionProposal.getContextInformation()) != null) {
                int n3;
                if (iCompletionProposal instanceof ICompletionProposalExtension) {
                    ICompletionProposalExtension iCompletionProposalExtension = (ICompletionProposalExtension)((Object)iCompletionProposal);
                    n3 = iCompletionProposalExtension.getContextInformationPosition();
                } else {
                    if (object == null) {
                        object = this.fContentAssistSubjectControlAdapter.getSelectedRange();
                    }
                    n3 = ((Point)object).x + ((Point)object).y;
                }
                this.fContentAssistant.showContextInformation(iContextInformation, n3);
            } else {
                this.fContentAssistant.showContextInformation(null, -1);
            }
        }
        finally {
            if (iRewriteTarget != null) {
                iRewriteTarget.endCompoundChange();
            }
            if (this.fViewer instanceof IEditingSupportRegistry) {
                IEditingSupportRegistry iEditingSupportRegistry = (IEditingSupportRegistry)((Object)this.fViewer);
                iEditingSupportRegistry.unregister(iEditingSupport);
            }
            this.fInserting = false;
        }
    }

    public boolean hasFocus() {
        if (Helper.okToUse((Widget)this.fProposalShell)) {
            if (this.fProposalShell.getDisplay().getActiveShell() == this.fProposalShell) {
                return true;
            }
            if (this.fAdditionalInfoController != null) {
                IInformationControl iInformationControl = this.fAdditionalInfoController.getCurrentInformationControl2();
                if (iInformationControl != null && iInformationControl.isFocusControl()) {
                    return true;
                }
                InformationControlReplacer informationControlReplacer = this.fAdditionalInfoController.getInternalAccessor().getInformationControlReplacer();
                if (informationControlReplacer != null && (iInformationControl = informationControlReplacer.getCurrentInformationControl2()) != null && iInformationControl.isFocusControl()) {
                    return true;
                }
            }
        }
        return false;
    }

    public void hide() {
        this.unregister();
        if (this.fViewer instanceof IEditingSupportRegistry) {
            IEditingSupportRegistry iEditingSupportRegistry = (IEditingSupportRegistry)((Object)this.fViewer);
            iEditingSupportRegistry.unregister(this.fFocusHelper);
        }
        if (Helper.okToUse((Widget)this.fProposalShell)) {
            this.fContentAssistant.removeContentAssistListener(this, 1);
            this.fPopupCloser.uninstall();
            this.fProposalShell.setVisible(false);
            this.fProposalShell.dispose();
            this.fProposalShell = null;
        }
        if (this.fMessageTextFont != null) {
            this.fMessageTextFont.dispose();
            this.fMessageTextFont = null;
        }
        if (this.fMessageText != null) {
            this.fMessageText = null;
        }
        this.fEmptyMessage = null;
        this.fLastCompletionOffset = -1;
        this.fContentAssistant.fireSessionEndEvent();
    }

    private void unregister() {
        Object object;
        if (this.fDocumentListener != null) {
            object = this.fContentAssistSubjectControlAdapter.getDocument();
            if (object != null) {
                object.removeDocumentListener(this.fDocumentListener);
            }
            this.fDocumentListener = null;
        }
        this.fDocumentEvents.clear();
        if (this.fKeyListener != null && this.fContentAssistSubjectControlAdapter.getControl() != null && !this.fContentAssistSubjectControlAdapter.getControl().isDisposed()) {
            this.fContentAssistSubjectControlAdapter.removeKeyListener(this.fKeyListener);
            this.fKeyListener = null;
        }
        if (this.fLastProposal != null) {
            if (this.fLastProposal instanceof ICompletionProposalExtension2 && this.fViewer != null) {
                object = (ICompletionProposalExtension2)((Object)this.fLastProposal);
                object.unselected(this.fViewer);
            }
            this.fLastProposal = null;
        }
        this.fFilteredProposals = null;
        this.fComputedProposals = null;
        this.fContentAssistant.possibleCompletionsClosed();
    }

    public boolean isActive() {
        return this.fProposalShell != null && !this.fProposalShell.isDisposed();
    }

    private void setProposals(ICompletionProposal[] iCompletionProposalArray, boolean bl) {
        ICompletionProposal[] iCompletionProposalArray2 = this.fFilteredProposals;
        ICompletionProposal iCompletionProposal = this.getSelectedProposal();
        if (iCompletionProposalArray2 != this.fFilteredProposals) {
            return;
        }
        if (Helper.okToUse((Widget)this.fProposalTable)) {
            TableItem[] tableItemArray;
            if (iCompletionProposal instanceof ICompletionProposalExtension2 && this.fViewer != null) {
                ((ICompletionProposalExtension2)((Object)iCompletionProposal)).unselected(this.fViewer);
            }
            if (iCompletionProposalArray == null || iCompletionProposalArray.length == 0) {
                this.fEmptyProposal.fOffset = this.fFilterOffset;
                this.fEmptyProposal.fDisplayString = this.fEmptyMessage != null ? this.fEmptyMessage : JFaceTextMessages.getString("CompletionProposalPopup.no_proposals");
                iCompletionProposalArray = new ICompletionProposal[]{this.fEmptyProposal};
            }
            if (this.fSorter != null) {
                this.sortProposals(iCompletionProposalArray);
            }
            this.fFilteredProposals = iCompletionProposalArray;
            int n = iCompletionProposalArray.length;
            if (USE_VIRTUAL) {
                this.fProposalTable.setItemCount(n);
                this.fProposalTable.clearAll();
            } else {
                this.fProposalTable.setRedraw(false);
                this.fProposalTable.setItemCount(n);
                tableItemArray = this.fProposalTable.getItems();
                int n2 = 0;
                while (n2 < tableItemArray.length) {
                    TableItem tableItem = tableItemArray[n2];
                    ICompletionProposal iCompletionProposal2 = iCompletionProposalArray[n2];
                    tableItem.setText(iCompletionProposal2.getDisplayString());
                    tableItem.setImage(iCompletionProposal2.getImage());
                    tableItem.setData((Object)iCompletionProposal2);
                    ++n2;
                }
                this.fProposalTable.setRedraw(true);
            }
            tableItemArray = this.fProposalShell.getLocation();
            Point point = this.getLocation();
            if (point.x < tableItemArray.x && point.y == tableItemArray.y || point.y < tableItemArray.y) {
                this.fProposalShell.setLocation(point);
            }
            this.selectProposal(0, false);
        }
    }

    private Point getLocation() {
        int n = this.fContentAssistSubjectControlAdapter.getCaretOffset();
        Rectangle rectangle = this.fContentAssistant.getLayoutManager().computeBoundsBelowAbove(this.fProposalShell, this.fSize == null ? this.fProposalShell.getSize() : this.fSize, n, this);
        return Geometry.getLocation((Rectangle)rectangle);
    }

    Point getSize() {
        return this.fSize;
    }

    private void displayProposals() {
        if (!Helper.okToUse((Widget)this.fProposalShell) || !Helper.okToUse((Widget)this.fProposalTable)) {
            return;
        }
        if (this.fContentAssistant.addContentAssistListener(this, 1)) {
            this.ensureDocumentListenerInstalled();
            if (this.fFocusHelper == null) {
                this.fFocusHelper = new IEditingSupport(){

                    @Override
                    public boolean isOriginator(DocumentEvent documentEvent, IRegion iRegion) {
                        return false;
                    }

                    @Override
                    public boolean ownsFocusShell() {
                        return true;
                    }
                };
            }
            if (this.fViewer instanceof IEditingSupportRegistry) {
                IEditingSupportRegistry iEditingSupportRegistry = (IEditingSupportRegistry)((Object)this.fViewer);
                iEditingSupportRegistry.register(this.fFocusHelper);
            }
            this.fProposalShell.setVisible(true);
            if (!this.fContentAssistSubjectControlAdapter.supportsVerifyKeyListener() && Helper.okToUse((Widget)this.fProposalShell)) {
                this.fProposalShell.setFocus();
            }
            if (this.fAdditionalInfoController != null && Helper.okToUse((Widget)this.fProposalTable)) {
                this.fAdditionalInfoController.install((Control)this.fProposalTable);
                this.fAdditionalInfoController.handleTableSelectionChanged();
            }
        } else {
            this.hide();
        }
    }

    private void ensureDocumentListenerInstalled() {
        if (this.fDocumentListener == null) {
            this.fDocumentListener = new IDocumentListener(){

                public void documentAboutToBeChanged(DocumentEvent documentEvent) {
                    if (!CompletionProposalPopup.this.fInserting) {
                        CompletionProposalPopup.this.fDocumentEvents.add(documentEvent);
                    }
                }

                public void documentChanged(DocumentEvent documentEvent) {
                    if (!CompletionProposalPopup.this.fInserting) {
                        CompletionProposalPopup.this.filterProposals();
                    }
                }
            };
            IDocument iDocument = this.fContentAssistSubjectControlAdapter.getDocument();
            if (iDocument != null) {
                iDocument.addDocumentListener(this.fDocumentListener);
            }
        }
    }

    @Override
    public boolean verifyKey(VerifyEvent verifyEvent) {
        if (!Helper.okToUse((Widget)this.fProposalShell)) {
            return true;
        }
        char c = verifyEvent.character;
        if (c == '\u0000') {
            int n = this.fProposalTable.getSelectionIndex();
            int n2 = this.fProposalTable.getSize().y / this.fProposalTable.getItemHeight() - 1;
            int n3 = this.fProposalTable.getItemCount();
            switch (verifyEvent.keyCode) {
                case 0x1000003: 
                case 0x1000004: {
                    this.filterProposals();
                    return true;
                }
                case 0x1000001: {
                    if (--n >= 0) break;
                    n = n3 - 1;
                    break;
                }
                case 0x1000002: {
                    if (++n <= n3 - 1) break;
                    n = 0;
                    break;
                }
                case 0x1000006: {
                    if ((n += n2) < n3) break;
                    n = n3 - 1;
                    break;
                }
                case 0x1000005: {
                    if ((n -= n2) >= 0) break;
                    n = 0;
                    break;
                }
                case 0x1000007: {
                    n = 0;
                    break;
                }
                case 0x1000008: {
                    n = n3 - 1;
                    break;
                }
                default: {
                    if (verifyEvent.keyCode != 16777298 && verifyEvent.keyCode != SWT.MOD1 && verifyEvent.keyCode != SWT.MOD2 && verifyEvent.keyCode != SWT.MOD3 && verifyEvent.keyCode != SWT.MOD4) {
                        this.hide();
                    }
                    return true;
                }
            }
            this.selectProposal(n, (verifyEvent.stateMask & 0x40000) != 0);
            verifyEvent.doit = false;
            return false;
        }
        switch (c) {
            case '\u001b': {
                verifyEvent.doit = false;
                this.hide();
                break;
            }
            case '\n': 
            case '\r': {
                verifyEvent.doit = false;
                this.insertSelectedProposalWithMask(verifyEvent.stateMask);
                break;
            }
            case '\t': {
                verifyEvent.doit = false;
                this.fProposalShell.setFocus();
                return false;
            }
            default: {
                ICompletionProposalExtension iCompletionProposalExtension;
                char[] cArray;
                ICompletionProposal iCompletionProposal = this.getSelectedProposal();
                if (!(iCompletionProposal instanceof ICompletionProposalExtension) || !this.contains(cArray = (iCompletionProposalExtension = (ICompletionProposalExtension)((Object)iCompletionProposal)).getTriggerCharacters(), c)) break;
                verifyEvent.doit = false;
                this.hide();
                this.insertProposal(iCompletionProposal, c, verifyEvent.stateMask, this.fContentAssistSubjectControlAdapter.getSelectedRange().x);
            }
        }
        return true;
    }

    private void selectProposal(int n, boolean bl) {
        ICompletionProposal iCompletionProposal = this.getSelectedProposal();
        if (iCompletionProposal instanceof ICompletionProposalExtension2 && this.fViewer != null) {
            ((ICompletionProposalExtension2)((Object)iCompletionProposal)).unselected(this.fViewer);
        }
        if (this.fFilteredProposals == null) {
            this.fireSelectionEvent(null, bl);
            return;
        }
        ICompletionProposal iCompletionProposal2 = this.fFilteredProposals[n];
        if (iCompletionProposal2 instanceof ICompletionProposalExtension2 && this.fViewer != null) {
            ((ICompletionProposalExtension2)((Object)iCompletionProposal2)).selected(this.fViewer, bl);
        }
        this.fireSelectionEvent(iCompletionProposal2, bl);
        this.fLastProposal = iCompletionProposal2;
        this.fProposalTable.setSelection(n);
        this.fProposalTable.showSelection();
        if (this.fAdditionalInfoController != null) {
            this.fAdditionalInfoController.handleTableSelectionChanged();
        }
    }

    private void fireSelectionEvent(ICompletionProposal iCompletionProposal, boolean bl) {
        this.fContentAssistant.fireSelectionEvent(iCompletionProposal, bl);
    }

    private void fireAppliedEvent(ICompletionProposal iCompletionProposal) {
        this.fContentAssistant.fireAppliedEvent(iCompletionProposal);
    }

    private boolean contains(char[] cArray, char c) {
        if (cArray == null) {
            return false;
        }
        int n = 0;
        while (n < cArray.length) {
            if (c == cArray[n]) {
                return true;
            }
            ++n;
        }
        return false;
    }

    @Override
    public void processEvent(VerifyEvent verifyEvent) {
    }

    private void filterProposals() {
        if (!this.fIsFilterPending) {
            this.fIsFilterPending = true;
            Control control = this.fContentAssistSubjectControlAdapter.getControl();
            control.getDisplay().asyncExec(this.fFilterRunnable);
        }
    }

    private ICompletionProposal[] computeFilteredProposals(int n, DocumentEvent documentEvent) {
        ICompletionProposal[] iCompletionProposalArray;
        if (n == this.fInvocationOffset && documentEvent == null) {
            this.fIsFilteredSubset = false;
            return this.fComputedProposals;
        }
        if (n < this.fInvocationOffset) {
            this.fIsFilteredSubset = false;
            this.fInvocationOffset = n;
            this.fContentAssistant.fireSessionRestartEvent();
            this.fComputedProposals = this.computeProposals(this.fInvocationOffset);
            return this.fComputedProposals;
        }
        if (n < this.fFilterOffset) {
            iCompletionProposalArray = this.fComputedProposals;
            this.fIsFilteredSubset = false;
        } else {
            iCompletionProposalArray = this.fFilteredProposals;
            this.fIsFilteredSubset = true;
        }
        if (iCompletionProposalArray == null) {
            this.fIsFilteredSubset = false;
            return null;
        }
        IDocument iDocument = this.fContentAssistSubjectControlAdapter.getDocument();
        int n2 = iCompletionProposalArray.length;
        ArrayList<Object> arrayList = new ArrayList<Object>(n2);
        int n3 = 0;
        while (n3 < n2) {
            Object object;
            if (iCompletionProposalArray[n3] instanceof ICompletionProposalExtension2) {
                object = (ICompletionProposalExtension2)((Object)iCompletionProposalArray[n3]);
                if (object.validate(iDocument, n, documentEvent)) {
                    arrayList.add(object);
                }
            } else if (iCompletionProposalArray[n3] instanceof ICompletionProposalExtension) {
                object = (ICompletionProposalExtension)((Object)iCompletionProposalArray[n3]);
                if (object.isValidFor(iDocument, n)) {
                    arrayList.add(object);
                }
            } else {
                this.fIsFilteredSubset = false;
                this.fInvocationOffset = n;
                this.fContentAssistant.fireSessionRestartEvent();
                this.fComputedProposals = this.computeProposals(this.fInvocationOffset);
                return this.fComputedProposals;
            }
            ++n3;
        }
        return arrayList.toArray(new ICompletionProposal[arrayList.size()]);
    }

    public void setFocus() {
        if (Helper.okToUse((Widget)this.fProposalShell)) {
            this.fProposalShell.setFocus();
        }
    }

    private boolean canAutoInsert(ICompletionProposal iCompletionProposal) {
        if (this.fContentAssistant.isAutoInserting()) {
            if (iCompletionProposal instanceof ICompletionProposalExtension4) {
                ICompletionProposalExtension4 iCompletionProposalExtension4 = (ICompletionProposalExtension4)((Object)iCompletionProposal);
                return iCompletionProposalExtension4.isAutoInsertable();
            }
            return true;
        }
        return false;
    }

    public String incrementalComplete() {
        if (Helper.okToUse((Widget)this.fProposalShell) && this.fFilteredProposals != null) {
            if (this.fLastCompletionOffset == this.fFilterOffset) {
                this.handleRepeatedInvocation();
            } else {
                this.fLastCompletionOffset = this.fFilterOffset;
                this.completeCommonPrefix();
            }
        } else {
            Control control = this.fContentAssistSubjectControlAdapter.getControl();
            if (this.fKeyListener == null) {
                this.fKeyListener = new ProposalSelectionListener();
            }
            if (!Helper.okToUse((Widget)this.fProposalShell) && !control.isDisposed()) {
                this.fContentAssistSubjectControlAdapter.addKeyListener(this.fKeyListener);
            }
            BusyIndicator.showWhile((Display)control.getDisplay(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    int n;
                    CompletionProposalPopup.this.fInvocationOffset = ((CompletionProposalPopup)CompletionProposalPopup.this).fContentAssistSubjectControlAdapter.getSelectedRange().x;
                    CompletionProposalPopup.this.fFilterOffset = CompletionProposalPopup.this.fInvocationOffset;
                    CompletionProposalPopup.this.fLastCompletionOffset = CompletionProposalPopup.this.fFilterOffset;
                    CompletionProposalPopup.this.fFilteredProposals = CompletionProposalPopup.this.computeProposals(CompletionProposalPopup.this.fInvocationOffset);
                    int n2 = n = CompletionProposalPopup.this.fFilteredProposals == null ? 0 : CompletionProposalPopup.this.fFilteredProposals.length;
                    if (n == 0 && CompletionProposalPopup.this.hideWhenNoProposals(false)) {
                        return;
                    }
                    if (n == 1 && CompletionProposalPopup.this.canAutoInsert(CompletionProposalPopup.this.fFilteredProposals[0])) {
                        CompletionProposalPopup.this.insertProposal(CompletionProposalPopup.this.fFilteredProposals[0], '\u0000', 0, CompletionProposalPopup.this.fInvocationOffset);
                        CompletionProposalPopup.this.hide();
                    } else {
                        CompletionProposalPopup.this.ensureDocumentListenerInstalled();
                        if (n > 0 && CompletionProposalPopup.this.completeCommonPrefix()) {
                            CompletionProposalPopup.this.hide();
                        } else {
                            CompletionProposalPopup.this.fComputedProposals = CompletionProposalPopup.this.fFilteredProposals;
                            CompletionProposalPopup.this.createProposalSelector();
                            CompletionProposalPopup.this.setProposals(CompletionProposalPopup.this.fComputedProposals, false);
                            CompletionProposalPopup.this.displayProposals();
                        }
                    }
                }
            });
        }
        return this.getErrorMessage();
    }

    private boolean completeCommonPrefix() {
        CharSequence charSequence;
        int n;
        Object object;
        if (this.fFilteredProposals.length == 1) {
            if (this.canAutoInsert(this.fFilteredProposals[0])) {
                this.insertProposal(this.fFilteredProposals[0], '\u0000', 0, this.fFilterOffset);
                this.hide();
                return true;
            }
            return false;
        }
        IDocument iDocument = this.fContentAssistSubjectControlAdapter.getDocument();
        StringBuffer stringBuffer = null;
        ArrayList<ICompletionProposal> arrayList = new ArrayList<ICompletionProposal>();
        boolean bl = false;
        CharSequence charSequence2 = null;
        int n2 = 0;
        StringBuffer stringBuffer2 = null;
        ArrayList<ICompletionProposal> arrayList2 = new ArrayList<ICompletionProposal>();
        int n3 = 0;
        while (n3 < this.fFilteredProposals.length) {
            block22: {
                object = this.fFilteredProposals[n3];
                if (!(object instanceof ICompletionProposalExtension3)) {
                    return false;
                }
                n = ((ICompletionProposalExtension3)object).getPrefixCompletionStart(this.fContentAssistSubjectControlAdapter.getDocument(), this.fFilterOffset);
                charSequence = ((ICompletionProposalExtension3)object).getPrefixCompletionText(this.fContentAssistSubjectControlAdapter.getDocument(), this.fFilterOffset);
                if (charSequence == null) {
                    charSequence = TextProcessor.deprocess((String)object.getDisplayString());
                }
                try {
                    CharSequence charSequence3;
                    int n4 = this.fFilterOffset - n;
                    int n5 = Math.min(charSequence.length(), n4);
                    String string = iDocument.get(n, n4);
                    if (!bl && charSequence.toString().startsWith(string)) {
                        bl = false;
                        arrayList.add((ICompletionProposal)object);
                        charSequence3 = charSequence.subSequence(n5, charSequence.length());
                        if (stringBuffer == null) {
                            stringBuffer = new StringBuffer(charSequence3.toString());
                        } else {
                            this.truncatePostfix(stringBuffer, charSequence3);
                        }
                        break block22;
                    }
                    if (n3 == 0 || bl) {
                        charSequence3 = charSequence.subSequence(0, n5);
                        if (this.isPrefixCompatible(charSequence2, n2, charSequence3, n, iDocument)) {
                            bl = true;
                            charSequence2 = charSequence3;
                            n2 = n;
                            CharSequence charSequence4 = charSequence.subSequence(n5, charSequence.length());
                            if (stringBuffer2 == null) {
                                stringBuffer2 = new StringBuffer(charSequence4.toString());
                            } else {
                                this.truncatePostfix(stringBuffer2, charSequence4);
                            }
                            arrayList2.add((ICompletionProposal)object);
                            break block22;
                        }
                        return false;
                    }
                    return false;
                }
                catch (BadLocationException badLocationException) {
                    return false;
                }
            }
            if (stringBuffer != null && stringBuffer.length() == 0 && arrayList.size() > 1) {
                return false;
            }
            ++n3;
        }
        if (arrayList.size() == 1) {
            ICompletionProposal iCompletionProposal = (ICompletionProposal)arrayList.get(0);
            if (this.canAutoInsert(iCompletionProposal) && stringBuffer.length() > 0) {
                this.insertProposal(iCompletionProposal, '\u0000', 0, this.fInvocationOffset);
                this.hide();
                return true;
            }
            return false;
        }
        if (bl && arrayList2.size() == 1) {
            ICompletionProposal iCompletionProposal = (ICompletionProposal)arrayList2.get(0);
            if (this.canAutoInsert(iCompletionProposal)) {
                this.insertProposal(iCompletionProposal, '\u0000', 0, this.fInvocationOffset);
                this.hide();
                return true;
            }
            return false;
        }
        CharSequence charSequence5 = bl ? charSequence2 : "";
        object = bl ? stringBuffer2 : stringBuffer;
        if (charSequence5 == null || object == null) {
            return false;
        }
        try {
            n = Math.min(iDocument.getLength(), this.fFilterOffset + object.length());
            charSequence = new StringBuffer(iDocument.get(this.fFilterOffset, n - this.fFilterOffset));
            this.truncatePostfix((StringBuffer)charSequence, (CharSequence)object);
            iDocument.replace(this.fFilterOffset - charSequence5.length(), charSequence5.length() + ((StringBuffer)charSequence).length(), String.valueOf(charSequence5.toString()) + object.toString());
            this.fContentAssistSubjectControlAdapter.setSelectedRange(this.fFilterOffset + object.length(), 0);
            this.fContentAssistSubjectControlAdapter.revealRange(this.fFilterOffset + object.length(), 0);
            this.fFilterOffset += object.length();
            this.fLastCompletionOffset = this.fFilterOffset;
            return false;
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    private boolean isPrefixCompatible(CharSequence charSequence, int n, CharSequence charSequence2, int n2, IDocument iDocument) throws BadLocationException {
        if (charSequence == null || charSequence2 == null) {
            return true;
        }
        int n3 = Math.min(n, n2);
        int n4 = n + charSequence.length();
        int n5 = n2 + charSequence2.length();
        String string = String.valueOf(iDocument.get(n, n3 - n)) + charSequence + iDocument.get(n4, Math.min(this.fFilterOffset, this.fFilterOffset - n4));
        String string2 = String.valueOf(iDocument.get(n2, n3 - n2)) + charSequence2 + iDocument.get(n5, Math.min(this.fFilterOffset, this.fFilterOffset - n5));
        return string.equals(string2);
    }

    private void truncatePostfix(StringBuffer stringBuffer, CharSequence charSequence) {
        int n = Math.min(stringBuffer.length(), charSequence.length());
        int n2 = 0;
        while (n2 < n) {
            if (charSequence.charAt(n2) != stringBuffer.charAt(n2)) {
                stringBuffer.delete(n2, stringBuffer.length());
                return;
            }
            ++n2;
        }
        stringBuffer.delete(n, stringBuffer.length());
    }

    void setMessage(String string) {
        Assert.isNotNull((Object)string);
        if (this.isActive() && this.fMessageText != null) {
            this.fMessageText.setText(String.valueOf(string) + " ");
        }
    }

    void setEmptyMessage(String string) {
        Assert.isNotNull((Object)string);
        this.fEmptyMessage = string;
    }

    public void setStatusLineVisible(boolean bl) {
        if (!this.isActive() || bl == (this.fMessageText != null)) {
            return;
        }
        if (bl) {
            this.createMessageText();
        } else {
            this.fMessageText.dispose();
            this.fMessageText = null;
        }
        this.fProposalShell.layout();
    }

    void switchedPositionToAbove(boolean bl) {
        if (this.fAdditionalInfoController != null) {
            this.fAdditionalInfoController.setFallbackAnchors(new AbstractInformationControlManager.Anchor[]{AbstractInformationControlManager.ANCHOR_RIGHT, AbstractInformationControlManager.ANCHOR_LEFT, bl ? AbstractInformationControlManager.ANCHOR_TOP : AbstractInformationControlManager.ANCHOR_BOTTOM});
        }
    }

    IHandler createProposalSelectionHandler(int n) {
        return new ProposalSelectionHandler(n);
    }

    public void setSorter(ICompletionProposalSorter iCompletionProposalSorter) {
        this.fSorter = iCompletionProposalSorter;
    }

    private void sortProposals(ICompletionProposal[] iCompletionProposalArray) {
        Arrays.sort(iCompletionProposalArray, new Comparator(){

            public int compare(Object object, Object object2) {
                return CompletionProposalPopup.this.fSorter.compare((ICompletionProposal)object, (ICompletionProposal)object2);
            }
        });
    }

    private final class CommandKeyListener
    extends KeyAdapter {
        private final KeySequence fCommandSequence;

        private CommandKeyListener(KeySequence keySequence) {
            this.fCommandSequence = keySequence;
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (!Helper.okToUse((Widget)CompletionProposalPopup.this.fProposalShell)) {
                return;
            }
            int n = SWTKeySupport.convertEventToUnmodifiedAccelerator((KeyEvent)keyEvent);
            KeySequence keySequence = KeySequence.getInstance((KeyStroke)SWTKeySupport.convertAcceleratorToKeyStroke((int)n));
            if (keySequence.equals((Object)this.fCommandSequence)) {
                if (CompletionProposalPopup.this.fContentAssistant.isPrefixCompletionEnabled()) {
                    CompletionProposalPopup.this.incrementalComplete();
                } else {
                    CompletionProposalPopup.this.showProposals(false);
                }
            }
        }
    }

    private static final class EmptyProposal
    implements ICompletionProposal,
    ICompletionProposalExtension {
        String fDisplayString;
        int fOffset;

        private EmptyProposal() {
        }

        @Override
        public void apply(IDocument iDocument) {
        }

        @Override
        public Point getSelection(IDocument iDocument) {
            return new Point(this.fOffset, 0);
        }

        @Override
        public IContextInformation getContextInformation() {
            return null;
        }

        @Override
        public Image getImage() {
            return null;
        }

        @Override
        public String getDisplayString() {
            return this.fDisplayString;
        }

        @Override
        public String getAdditionalProposalInfo() {
            return null;
        }

        @Override
        public void apply(IDocument iDocument, char c, int n) {
        }

        @Override
        public boolean isValidFor(IDocument iDocument, int n) {
            return false;
        }

        @Override
        public char[] getTriggerCharacters() {
            return null;
        }

        @Override
        public int getContextInformationPosition() {
            return -1;
        }
    }

    final class ProposalSelectionHandler
    extends AbstractHandler {
        static final int SELECT_NEXT = 1;
        static final int SELECT_PREVIOUS = 2;
        private final int fOperationCode;

        public ProposalSelectionHandler(int n) {
            Assert.isLegal((n == 1 || n == 2 ? 1 : 0) != 0);
            this.fOperationCode = n;
        }

        public Object execute(ExecutionEvent executionEvent) throws ExecutionException {
            int n = CompletionProposalPopup.this.fProposalTable.getItemCount();
            int n2 = CompletionProposalPopup.this.fProposalTable.getSelectionIndex();
            switch (this.fOperationCode) {
                case 1: {
                    if (++n2 <= n - 1) break;
                    n2 = 0;
                    break;
                }
                case 2: {
                    if (--n2 >= 0) break;
                    n2 = n - 1;
                }
            }
            CompletionProposalPopup.this.selectProposal(n2, false);
            return null;
        }
    }

    private final class ProposalSelectionListener
    implements KeyListener {
        private ProposalSelectionListener() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            int n;
            if (!Helper.okToUse((Widget)CompletionProposalPopup.this.fProposalShell)) {
                return;
            }
            if (keyEvent.character == '\u0000' && keyEvent.keyCode == 262144 && (n = CompletionProposalPopup.this.fProposalTable.getSelectionIndex()) >= 0) {
                CompletionProposalPopup.this.selectProposal(n, true);
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
            int n;
            if (!Helper.okToUse((Widget)CompletionProposalPopup.this.fProposalShell)) {
                return;
            }
            if (keyEvent.character == '\u0000' && keyEvent.keyCode == 262144 && (n = CompletionProposalPopup.this.fProposalTable.getSelectionIndex()) >= 0) {
                CompletionProposalPopup.this.selectProposal(n, false);
            }
        }
    }
}

