/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.contentassist;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public final class CompletionProposal
implements ICompletionProposal {
    private String fDisplayString;
    private String fReplacementString;
    private int fReplacementOffset;
    private int fReplacementLength;
    private int fCursorPosition;
    private Image fImage;
    private IContextInformation fContextInformation;
    private String fAdditionalProposalInfo;

    public CompletionProposal(String string, int n, int n2, int n3) {
        this(string, n, n2, n3, null, null, null, null);
    }

    public CompletionProposal(String string, int n, int n2, int n3, Image image, String string2, IContextInformation iContextInformation, String string3) {
        Assert.isNotNull((Object)string);
        Assert.isTrue((n >= 0 ? 1 : 0) != 0);
        Assert.isTrue((n2 >= 0 ? 1 : 0) != 0);
        Assert.isTrue((n3 >= 0 ? 1 : 0) != 0);
        this.fReplacementString = string;
        this.fReplacementOffset = n;
        this.fReplacementLength = n2;
        this.fCursorPosition = n3;
        this.fImage = image;
        this.fDisplayString = string2;
        this.fContextInformation = iContextInformation;
        this.fAdditionalProposalInfo = string3;
    }

    @Override
    public void apply(IDocument iDocument) {
        try {
            iDocument.replace(this.fReplacementOffset, this.fReplacementLength, this.fReplacementString);
        }
        catch (BadLocationException badLocationException) {}
    }

    @Override
    public Point getSelection(IDocument iDocument) {
        return new Point(this.fReplacementOffset + this.fCursorPosition, 0);
    }

    @Override
    public IContextInformation getContextInformation() {
        return this.fContextInformation;
    }

    @Override
    public Image getImage() {
        return this.fImage;
    }

    @Override
    public String getDisplayString() {
        if (this.fDisplayString != null) {
            return this.fDisplayString;
        }
        return this.fReplacementString;
    }

    @Override
    public String getAdditionalProposalInfo() {
        return this.fAdditionalProposalInfo;
    }
}

