/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.contentassist;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.internal.text.InformationControlReplacer;
import org.eclipse.jface.text.AbstractInformationControlManager;
import org.eclipse.jface.text.AbstractReusableInformationControlCreator;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IInformationControlExtension3;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension3;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension5;
import org.eclipse.jface.text.contentassist.JFaceTextMessages;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

class AdditionalInfoController
extends AbstractInformationControlManager {
    private Table fProposalTable;
    private SelectionListener fSelectionListener = new TableSelectionListener();
    private final int fDelay;
    private Timer fTimer;
    private ICompletionProposal fProposal;
    private Object fInformation;

    AdditionalInfoController(IInformationControlCreator iInformationControlCreator, int n) {
        super(iInformationControlCreator);
        this.fDelay = n;
        this.setAnchor(ANCHOR_RIGHT);
        this.setFallbackAnchors(new AbstractInformationControlManager.Anchor[]{ANCHOR_RIGHT, ANCHOR_LEFT, ANCHOR_BOTTOM});
        int n2 = -1;
        this.setMargins(n2, n2);
        InformationControlReplacer informationControlReplacer = new InformationControlReplacer(new DefaultPresenterControlCreator());
        this.getInternalAccessor().setInformationControlReplacer(informationControlReplacer);
    }

    @Override
    public void install(Control control) {
        if (this.fProposalTable == control) {
            return;
        }
        super.install((Control)control.getShell());
        Assert.isTrue((boolean)(control instanceof Table));
        this.fProposalTable = (Table)control;
        this.fProposalTable.addSelectionListener(this.fSelectionListener);
        this.getInternalAccessor().getInformationControlReplacer().install((Control)this.fProposalTable);
        this.fTimer = new Timer(this.fProposalTable.getDisplay(), this.fDelay){

            @Override
            protected void showInformation(ICompletionProposal iCompletionProposal, Object object) {
                InformationControlReplacer informationControlReplacer = AdditionalInfoController.this.getInternalAccessor().getInformationControlReplacer();
                if (informationControlReplacer != null) {
                    informationControlReplacer.hideInformationControl();
                }
                AdditionalInfoController.this.showInformation(iCompletionProposal, object);
            }
        };
    }

    @Override
    public void disposeInformationControl() {
        if (this.fTimer != null) {
            this.fTimer.terminate();
            this.fTimer = null;
        }
        this.fProposal = null;
        this.fInformation = null;
        if (this.fProposalTable != null && !this.fProposalTable.isDisposed()) {
            this.fProposalTable.removeSelectionListener(this.fSelectionListener);
            this.fProposalTable = null;
        }
        super.disposeInformationControl();
    }

    public void handleTableSelectionChanged() {
        TableItem tableItem;
        Object object;
        TableItem[] tableItemArray;
        if (this.fProposalTable != null && !this.fProposalTable.isDisposed() && this.fProposalTable.isVisible() && (tableItemArray = this.fProposalTable.getSelection()) != null && tableItemArray.length > 0 && (object = (tableItem = tableItemArray[0]).getData()) instanceof ICompletionProposal) {
            ICompletionProposal iCompletionProposal = (ICompletionProposal)object;
            this.fTimer.reset(iCompletionProposal);
        }
    }

    void showInformation(ICompletionProposal iCompletionProposal, Object object) {
        if (this.fProposalTable == null || this.fProposalTable.isDisposed()) {
            return;
        }
        if (this.fProposal == iCompletionProposal && (object == null && this.fInformation == null || object != null && object.equals(this.fInformation))) {
            return;
        }
        this.fInformation = object;
        this.fProposal = iCompletionProposal;
        this.showInformation();
    }

    @Override
    protected void computeInformation() {
        if (this.fProposal instanceof ICompletionProposalExtension3) {
            this.setCustomInformationControlCreator(((ICompletionProposalExtension3)((Object)this.fProposal)).getInformationControlCreator());
        } else {
            this.setCustomInformationControlCreator(null);
        }
        Point point = this.fProposalTable.getShell().getSize();
        this.setInformation(this.fInformation, new Rectangle(0, 0, point.x, point.y));
    }

    @Override
    protected Point computeLocation(Rectangle rectangle, Point point, AbstractInformationControlManager.Anchor anchor) {
        Point point2 = super.computeLocation(rectangle, point, anchor);
        Rectangle rectangle2 = this.fProposalTable.getShell().computeTrim(0, 0, 0, 0);
        point2.x += rectangle2.x;
        point2.y += rectangle2.y;
        return point2;
    }

    @Override
    protected Point computeSizeConstraints(Control control, IInformationControl iInformationControl) {
        Point point = super.computeSizeConstraints(control, iInformationControl);
        Point point2 = control.getShell().getSize();
        if (this.fInformationControl instanceof IInformationControlExtension3) {
            Rectangle rectangle = ((IInformationControlExtension3)((Object)this.fInformationControl)).computeTrim();
            point2.x -= rectangle.width;
            point2.y -= rectangle.height;
        }
        if (point.x < point2.x) {
            point.x = point2.x;
        }
        if (point.y < point2.y) {
            point.y = point2.y;
        }
        return point;
    }

    @Override
    protected void hideInformationControl() {
        super.hideInformationControl();
        if (this.fTimer != null) {
            this.fTimer.reset(null);
        }
    }

    @Override
    protected boolean canClearDataOnHide() {
        return false;
    }

    public IInformationControl getCurrentInformationControl2() {
        return this.getInternalAccessor().getCurrentInformationControl();
    }

    private static class DefaultPresenterControlCreator
    extends AbstractReusableInformationControlCreator {
        private DefaultPresenterControlCreator() {
        }

        @Override
        public IInformationControl doCreateInformationControl(Shell shell) {
            return new DefaultInformationControl(shell, true);
        }
    }

    private class TableSelectionListener
    implements SelectionListener {
        private TableSelectionListener() {
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            AdditionalInfoController.this.handleTableSelectionChanged();
        }

        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        }
    }

    private static abstract class Timer {
        private static final int DELAY_UNTIL_JOB_IS_SCHEDULED = 50;
        private final Task IDLE = new Task(){

            @Override
            public void run() {
                Assert.isTrue((boolean)false);
            }

            @Override
            public Task nextTask() {
                Assert.isTrue((boolean)false);
                return null;
            }

            @Override
            public long delay() {
                return Long.MAX_VALUE;
            }

            public String toString() {
                return "IDLE";
            }
        };
        private final Task FIRST_WAIT = new Task(){

            @Override
            public void run() {
                final ICompletionProposalExtension5 iCompletionProposalExtension5 = Timer.this.getCurrentProposalEx();
                Job job = new Job(JFaceTextMessages.getString("AdditionalInfoController.job_name")){

                    protected IStatus run(IProgressMonitor iProgressMonitor) {
                        Object object;
                        try {
                            object = iCompletionProposalExtension5.getAdditionalProposalInfo(iProgressMonitor);
                        }
                        catch (RuntimeException runtimeException) {
                            return new Status(2, "org.eclipse.jface.text", 0, "", (Throwable)runtimeException);
                        }
                        Timer.this.setInfo((ICompletionProposal)((Object)iCompletionProposalExtension5), object);
                        return Status.OK_STATUS;
                    }
                };
                job.schedule();
            }

            @Override
            public Task nextTask() {
                return Timer.this.SECOND_WAIT;
            }

            @Override
            public long delay() {
                return 50L;
            }

            public String toString() {
                return "FIRST_WAIT";
            }
        };
        private final Task SECOND_WAIT = new Task(){

            @Override
            public void run() {
                Timer.this.allowShowing();
            }

            @Override
            public Task nextTask() {
                return Timer.this.IDLE;
            }

            @Override
            public long delay() {
                return Timer.this.fDelay - 50;
            }

            public String toString() {
                return "SECOND_WAIT";
            }
        };
        private final Task LEGACY_WAIT = new Task(){

            @Override
            public void run() {
                final ICompletionProposal iCompletionProposal = Timer.this.getCurrentProposal();
                if (!Timer.this.fDisplay.isDisposed()) {
                    Timer.this.fDisplay.asyncExec(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            Timer timer = Timer.this;
                            synchronized (timer) {
                                if (iCompletionProposal == Timer.this.getCurrentProposal()) {
                                    String string = iCompletionProposal.getAdditionalProposalInfo();
                                    Timer.this.showInformation(iCompletionProposal, string);
                                }
                            }
                        }
                    });
                }
            }

            @Override
            public Task nextTask() {
                return Timer.this.IDLE;
            }

            @Override
            public long delay() {
                return Timer.this.fDelay;
            }

            public String toString() {
                return "LEGACY_WAIT";
            }
        };
        private final Task EXIT = new Task(){

            @Override
            public long delay() {
                return 1L;
            }

            @Override
            public Task nextTask() {
                Assert.isTrue((boolean)false);
                return Timer.this.EXIT;
            }

            @Override
            public void run() {
                Assert.isTrue((boolean)false);
            }

            public String toString() {
                return "EXIT";
            }
        };
        private final Thread fThread;
        private Task fTask;
        private long fNextWakeup;
        private ICompletionProposal fCurrentProposal = null;
        private Object fCurrentInfo = null;
        private boolean fAllowShowing = false;
        private final Display fDisplay;
        private final int fDelay;

        public Timer(Display display, int n) {
            this.fDisplay = display;
            this.fDelay = n;
            long l = System.currentTimeMillis();
            this.schedule(this.IDLE, l);
            this.fThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Timer.this.loop();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }, JFaceTextMessages.getString("InfoPopup.info_delay_timer_name"));
            this.fThread.start();
        }

        public final synchronized void terminate() {
            this.schedule(this.EXIT, System.currentTimeMillis());
            this.notifyAll();
        }

        public final synchronized void reset(ICompletionProposal iCompletionProposal) {
            if (this.fCurrentProposal != iCompletionProposal) {
                this.fCurrentProposal = iCompletionProposal;
                this.fCurrentInfo = null;
                this.fAllowShowing = false;
                long l = this.fNextWakeup;
                Task task = this.taskOnReset(iCompletionProposal);
                this.schedule(task, System.currentTimeMillis());
                if (this.fNextWakeup < l) {
                    this.notifyAll();
                }
            }
        }

        private Task taskOnReset(ICompletionProposal iCompletionProposal) {
            if (iCompletionProposal == null) {
                return this.IDLE;
            }
            if (this.isExt5(iCompletionProposal)) {
                return this.FIRST_WAIT;
            }
            return this.LEGACY_WAIT;
        }

        private synchronized void loop() throws InterruptedException {
            long l = System.currentTimeMillis();
            Task task = this.currentTask();
            while (task != this.EXIT) {
                long l2 = this.fNextWakeup - l;
                if (l2 <= 0L) {
                    task.run();
                    task = task.nextTask();
                    this.schedule(task, l);
                    continue;
                }
                this.wait(l2);
                l = System.currentTimeMillis();
                task = this.currentTask();
            }
        }

        private Task currentTask() {
            return this.fTask;
        }

        private void schedule(Task task, long l) {
            this.fTask = task;
            long l2 = l + task.delay();
            this.fNextWakeup = l2 <= l ? Long.MAX_VALUE : l2;
        }

        private boolean isExt5(ICompletionProposal iCompletionProposal) {
            return iCompletionProposal instanceof ICompletionProposalExtension5;
        }

        ICompletionProposal getCurrentProposal() {
            return this.fCurrentProposal;
        }

        ICompletionProposalExtension5 getCurrentProposalEx() {
            Assert.isTrue((boolean)(this.fCurrentProposal instanceof ICompletionProposalExtension5));
            return (ICompletionProposalExtension5)((Object)this.fCurrentProposal);
        }

        synchronized void setInfo(ICompletionProposal iCompletionProposal, Object object) {
            if (iCompletionProposal == this.fCurrentProposal) {
                this.fCurrentInfo = object;
                if (this.fAllowShowing) {
                    this.triggerShowing();
                }
            }
        }

        private void triggerShowing() {
            final Object object = this.fCurrentInfo;
            if (!this.fDisplay.isDisposed()) {
                this.fDisplay.asyncExec(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Timer timer = Timer.this;
                        synchronized (timer) {
                            if (object == Timer.this.fCurrentInfo) {
                                Timer.this.showInformation(Timer.this.fCurrentProposal, object);
                            }
                        }
                    }
                });
            }
        }

        protected abstract void showInformation(ICompletionProposal var1, Object var2);

        void allowShowing() {
            this.fAllowShowing = true;
            this.triggerShowing();
        }

        private abstract class Task
        implements Runnable {
            private Task() {
            }

            public abstract long delay();

            @Override
            public abstract void run();

            public abstract Task nextTask();
        }
    }
}

