/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text;

import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPaintPositionManager;
import org.eclipse.jface.text.IPainter;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.StyledTextContent;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class WhitespaceCharacterPainter
implements IPainter,
PaintListener {
    private static final char SPACE_SIGN = '\u00b7';
    private static final char IDEOGRAPHIC_SPACE_SIGN = '\u00b0';
    private static final char TAB_SIGN = '\u00bb';
    private static final char CARRIAGE_RETURN_SIGN = '\u00a4';
    private static final char LINE_FEED_SIGN = '\u00b6';
    private boolean fIsActive = false;
    private ITextViewer fTextViewer;
    private StyledText fTextWidget;
    private final boolean fIsAdvancedGraphicsPresent;
    private final boolean fIsFullSelectionStyle;
    private boolean fShowLeadingSpaces = true;
    private boolean fShowEnclosedSpace = true;
    private boolean fShowTrailingSpaces = true;
    private boolean fShowLeadingIdeographicSpaces = true;
    private boolean fShowEnclosedIdeographicSpaces = true;
    private boolean fShowTrailingIdeographicSpaces = true;
    private boolean fShowLeadingTabs = true;
    private boolean fShowEnclosedTabs = true;
    private boolean fShowTrailingTabs = true;
    private boolean fShowCarriageReturn = true;
    private boolean fShowLineFeed = true;
    private int fAlpha = 80;

    public WhitespaceCharacterPainter(ITextViewer iTextViewer) {
        this.fTextViewer = iTextViewer;
        this.fTextWidget = iTextViewer.getTextWidget();
        GC gC = new GC((Drawable)this.fTextWidget);
        gC.setAdvanced(true);
        this.fIsAdvancedGraphicsPresent = gC.getAdvanced();
        gC.dispose();
        this.fIsFullSelectionStyle = (this.fTextWidget.getStyle() & 0x10000) != 0;
    }

    public WhitespaceCharacterPainter(ITextViewer iTextViewer, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, boolean bl9, boolean bl10, boolean bl11, int n) {
        this(iTextViewer);
        this.fShowLeadingSpaces = bl;
        this.fShowEnclosedSpace = bl2;
        this.fShowTrailingSpaces = bl3;
        this.fShowLeadingIdeographicSpaces = bl4;
        this.fShowEnclosedIdeographicSpaces = bl5;
        this.fShowTrailingIdeographicSpaces = bl6;
        this.fShowLeadingTabs = bl7;
        this.fShowEnclosedTabs = bl8;
        this.fShowTrailingTabs = bl9;
        this.fShowCarriageReturn = bl10;
        this.fShowLineFeed = bl11;
        this.fAlpha = n;
    }

    @Override
    public void dispose() {
        this.fTextViewer = null;
        this.fTextWidget = null;
    }

    @Override
    public void paint(int n) {
        IDocument iDocument = this.fTextViewer.getDocument();
        if (iDocument == null) {
            this.deactivate(false);
            return;
        }
        if (!this.fIsActive) {
            this.fIsActive = true;
            this.fTextWidget.addPaintListener((PaintListener)this);
            this.redrawAll();
        } else if (n == 16 || n == 8) {
            this.redrawAll();
        }
    }

    @Override
    public void deactivate(boolean bl) {
        if (this.fIsActive) {
            this.fIsActive = false;
            this.fTextWidget.removePaintListener((PaintListener)this);
            if (bl) {
                this.redrawAll();
            }
        }
    }

    @Override
    public void setPositionManager(IPaintPositionManager iPaintPositionManager) {
    }

    public void paintControl(PaintEvent paintEvent) {
        if (this.fTextWidget != null) {
            this.handleDrawRequest(paintEvent.gc, paintEvent.x, paintEvent.y, paintEvent.width, paintEvent.height);
        }
    }

    private void handleDrawRequest(GC gC, int n, int n2, int n3, int n4) {
        int n5;
        int n6 = this.fTextWidget.getLineIndex(n2);
        if (n6 <= (n5 = this.fTextWidget.getLineIndex(n2 + n4 - 1)) && n6 < this.fTextWidget.getLineCount()) {
            Rectangle rectangle = gC.getClipping();
            Rectangle rectangle2 = this.fTextWidget.getClientArea();
            int n7 = this.fTextWidget.getLeftMargin();
            int n8 = this.fTextWidget.getRightMargin();
            rectangle2.x += n7;
            rectangle2.width -= n7 + n8;
            rectangle.intersect(rectangle2);
            gC.setClipping(rectangle2);
            if (this.fIsAdvancedGraphicsPresent) {
                int n9 = gC.getAlpha();
                gC.setAlpha(this.fAlpha);
                this.drawLineRange(gC, n6, n5, n, n3);
                gC.setAlpha(n9);
            } else {
                this.drawLineRange(gC, n6, n5, n, n3);
            }
            gC.setClipping(rectangle);
        }
    }

    private void drawLineRange(GC gC, int n, int n2, int n3, int n4) {
        int n5 = this.fTextWidget.getClientArea().width;
        int n6 = n;
        while (n6 <= n2) {
            int n7 = this.fTextWidget.getOffsetAtLine(n6);
            int n8 = n6 < this.fTextWidget.getLineCount() - 1 ? this.fTextWidget.getOffsetAtLine(n6 + 1) : this.fTextWidget.getCharCount();
            int n9 = n8 - n7;
            while (n9 > 0) {
                char c = this.fTextWidget.getTextRange(n7 + n9 - 1, 1).charAt(0);
                if (c != '\r' && c != '\n') break;
                --n9;
            }
            Point point = this.fTextWidget.getLocationAtOffset(n7 + n9);
            if (n3 - point.x <= n5) {
                int n10;
                int n11;
                int n12 = this.fTextWidget.getLinePixel(n6);
                try {
                    n11 = this.fTextWidget.getOffsetAtLocation(new Point(n3, n12)) - 1;
                    if (n11 - 2 <= n7) {
                        n11 = n7;
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    n11 = n7;
                }
                if (n3 + n4 >= point.x) {
                    n10 = n8;
                } else {
                    try {
                        n10 = this.fTextWidget.getOffsetAtLocation(new Point(n3 + n4 - 1, n12)) + 1;
                        if (n10 + 2 >= n8) {
                            n10 = n8;
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        n10 = n8;
                    }
                }
                if (n10 > n11) {
                    this.drawCharRange(gC, n11, n10, n7, n8);
                }
            }
            ++n6;
        }
    }

    private boolean isWhitespaceCharacter(char c) {
        return c == ' ' || c == '\u3000' || c == '\t' || c == '\r' || c == '\n';
    }

    private void drawCharRange(GC gC, int n, int n2, int n3, int n4) {
        StyledTextContent styledTextContent = this.fTextWidget.getContent();
        String string = styledTextContent.getTextRange(n3, n4 - n3);
        int n5 = n - n3;
        int n6 = n2 - n3;
        int n7 = -1;
        int n8 = 0;
        while (n8 < string.length()) {
            if (!this.isWhitespaceCharacter(string.charAt(n8))) {
                n7 = n8;
                break;
            }
            ++n8;
        }
        n8 = n7 == -1 ? 1 : 0;
        int n9 = string.length() - 1;
        if (n8 == 0) {
            int n10 = string.length() - 1;
            while (n10 >= 0) {
                if (!this.isWhitespaceCharacter(string.charAt(n10))) {
                    n9 = n10;
                    break;
                }
                --n10;
            }
        }
        StyleRange styleRange = null;
        Color color = null;
        StringBuffer stringBuffer = new StringBuffer(10);
        int n11 = n5;
        while (n11 <= n6) {
            block31: {
                int n12;
                boolean bl;
                int n13;
                block30: {
                    n13 = 0;
                    bl = false;
                    if (n11 >= n6) break block30;
                    n13 = 1;
                    n12 = string.charAt(n11);
                    switch (n12) {
                        case 32: {
                            if (n8 != 0) {
                                if (!this.fShowLeadingSpaces && !this.fShowEnclosedSpace && !this.fShowTrailingSpaces) break;
                                stringBuffer.append('\u00b7');
                                break;
                            }
                            if (n11 < n7) {
                                if (!this.fShowLeadingSpaces) break;
                                stringBuffer.append('\u00b7');
                                break;
                            }
                            if (n11 < n9) {
                                if (!this.fShowEnclosedSpace) break;
                                stringBuffer.append('\u00b7');
                                break;
                            }
                            if (!this.fShowTrailingSpaces) break;
                            stringBuffer.append('\u00b7');
                            break;
                        }
                        case 12288: {
                            if (n8 != 0) {
                                if (!this.fShowLeadingIdeographicSpaces && !this.fShowEnclosedIdeographicSpaces && !this.fShowTrailingIdeographicSpaces) break;
                                stringBuffer.append('\u00b0');
                                break;
                            }
                            if (n11 < n7) {
                                if (!this.fShowLeadingIdeographicSpaces) break;
                                stringBuffer.append('\u00b0');
                                break;
                            }
                            if (n11 < n9) {
                                if (!this.fShowEnclosedIdeographicSpaces) break;
                                stringBuffer.append('\u00b0');
                                break;
                            }
                            if (!this.fShowTrailingIdeographicSpaces) break;
                            stringBuffer.append('\u00b0');
                            break;
                        }
                        case 9: {
                            if (n8 != 0) {
                                if (!this.fShowLeadingTabs && !this.fShowEnclosedTabs && !this.fShowTrailingTabs) break;
                                stringBuffer.append('\u00bb');
                                break;
                            }
                            if (n11 < n7) {
                                if (!this.fShowLeadingTabs) break;
                                stringBuffer.append('\u00bb');
                                break;
                            }
                            if (n11 < n9) {
                                if (!this.fShowEnclosedTabs) break;
                                stringBuffer.append('\u00bb');
                                break;
                            }
                            if (!this.fShowTrailingTabs) break;
                            stringBuffer.append('\u00bb');
                            break;
                        }
                        case 13: {
                            if (this.fShowCarriageReturn) {
                                stringBuffer.append('\u00a4');
                            }
                            if (n11 >= n6 - 1 || string.charAt(n11 + 1) != '\n') {
                                bl = true;
                                break;
                            }
                            break block31;
                        }
                        case 10: {
                            if (this.fShowLineFeed) {
                                stringBuffer.append('\u00b6');
                            }
                            bl = true;
                            break;
                        }
                        default: {
                            n13 = 0;
                        }
                    }
                }
                if (stringBuffer.length() > 0) {
                    n12 = n + n11 - n5 - stringBuffer.length() + n13;
                    if (!bl || !this.isFoldedLine(styledTextContent.getLineAtOffset(n12))) {
                        if (!this.fTextWidget.getBlockSelection() && this.fIsFullSelectionStyle && WhitespaceCharacterPainter.isOffsetSelected(this.fTextWidget, n12)) {
                            color = this.fTextWidget.getSelectionForeground();
                        } else if (styleRange == null || styleRange.start + styleRange.length <= n12) {
                            styleRange = this.fTextWidget.getStyleRangeAtOffset(n12);
                            color = styleRange == null || styleRange.foreground == null ? this.fTextWidget.getForeground() : styleRange.foreground;
                        }
                        this.draw(gC, n12, stringBuffer.toString(), color);
                    }
                    stringBuffer.delete(0, stringBuffer.length());
                }
            }
            ++n11;
        }
    }

    private static final boolean isOffsetSelected(StyledText styledText, int n) {
        Point point = styledText.getSelection();
        return n >= point.x && n < point.y;
    }

    private boolean isFoldedLine(int n) {
        if (this.fTextViewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 iTextViewerExtension5 = (ITextViewerExtension5)((Object)this.fTextViewer);
            int n2 = iTextViewerExtension5.widgetLine2ModelLine(n);
            int n3 = iTextViewerExtension5.modelLine2WidgetLine(n2 + 1);
            return n3 == -1;
        }
        return false;
    }

    private void redrawAll() {
        this.fTextWidget.redraw();
    }

    private void draw(GC gC, int n, String string, Color color) {
        int n2 = this.fTextWidget.getBaseline(n);
        FontMetrics fontMetrics = gC.getFontMetrics();
        int n3 = fontMetrics.getAscent() + fontMetrics.getLeading();
        int n4 = n2 - n3;
        Point point = this.fTextWidget.getLocationAtOffset(n);
        gC.setForeground(color);
        gC.drawString(string, point.x, point.y + n4, true);
    }
}

