/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.text.IUndoManagerExtension;
import org.eclipse.jface.text.JFaceTextMessages;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.text.undo.DocumentUndoEvent;
import org.eclipse.text.undo.DocumentUndoManagerRegistry;
import org.eclipse.text.undo.IDocumentUndoListener;
import org.eclipse.text.undo.IDocumentUndoManager;

public class TextViewerUndoManager
implements IUndoManager,
IUndoManagerExtension {
    private KeyAndMouseListener fKeyAndMouseListener;
    private TextInputListener fTextInputListener;
    private ITextViewer fTextViewer;
    private int fUndoLevel;
    private IDocumentUndoManager fDocumentUndoManager;
    private IDocument fDocument;
    private IDocumentUndoListener fDocumentUndoListener;

    public TextViewerUndoManager(int n) {
        this.fUndoLevel = n;
    }

    private boolean isConnected() {
        return this.fTextViewer != null && this.fDocumentUndoManager != null;
    }

    @Override
    public void beginCompoundChange() {
        if (this.isConnected()) {
            this.fDocumentUndoManager.beginCompoundChange();
        }
    }

    @Override
    public void endCompoundChange() {
        if (this.isConnected()) {
            this.fDocumentUndoManager.endCompoundChange();
        }
    }

    private void addListeners() {
        StyledText styledText = this.fTextViewer.getTextWidget();
        if (styledText != null) {
            this.fKeyAndMouseListener = new KeyAndMouseListener();
            styledText.addMouseListener((MouseListener)this.fKeyAndMouseListener);
            styledText.addKeyListener((KeyListener)this.fKeyAndMouseListener);
            this.fTextInputListener = new TextInputListener();
            this.fTextViewer.addTextInputListener(this.fTextInputListener);
        }
    }

    private void removeListeners() {
        StyledText styledText = this.fTextViewer.getTextWidget();
        if (styledText != null) {
            if (this.fKeyAndMouseListener != null) {
                styledText.removeMouseListener((MouseListener)this.fKeyAndMouseListener);
                styledText.removeKeyListener((KeyListener)this.fKeyAndMouseListener);
                this.fKeyAndMouseListener = null;
            }
            if (this.fTextInputListener != null) {
                this.fTextViewer.removeTextInputListener(this.fTextInputListener);
                this.fTextInputListener = null;
            }
        }
    }

    private void openErrorDialog(final String string, final Exception exception) {
        StyledText styledText;
        Shell shell = null;
        if (this.isConnected() && (styledText = this.fTextViewer.getTextWidget()) != null && !styledText.isDisposed()) {
            shell = styledText.getShell();
        }
        if (Display.getCurrent() != null) {
            MessageDialog.openError(shell, (String)string, (String)exception.getLocalizedMessage());
        } else {
            final Shell shell2 = shell;
            styledText = shell2 != null ? shell2.getDisplay() : Display.getDefault();
            styledText.syncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openError((Shell)shell2, (String)string, (String)exception.getLocalizedMessage());
                }
            });
        }
    }

    @Override
    public void setMaximalUndoLevel(int n) {
        this.fUndoLevel = Math.max(0, n);
        if (this.isConnected()) {
            this.fDocumentUndoManager.setMaximalUndoLevel(this.fUndoLevel);
        }
    }

    @Override
    public void connect(ITextViewer iTextViewer) {
        if (this.fTextViewer == null && iTextViewer != null) {
            this.fTextViewer = iTextViewer;
            this.addListeners();
        }
        IDocument iDocument = this.fTextViewer.getDocument();
        this.connectDocumentUndoManager(iDocument);
    }

    @Override
    public void disconnect() {
        if (this.fTextViewer != null) {
            this.removeListeners();
            this.fTextViewer = null;
        }
        this.disconnectDocumentUndoManager();
    }

    @Override
    public void reset() {
        if (this.isConnected()) {
            this.fDocumentUndoManager.reset();
        }
    }

    @Override
    public boolean redoable() {
        if (this.isConnected()) {
            return this.fDocumentUndoManager.redoable();
        }
        return false;
    }

    @Override
    public boolean undoable() {
        if (this.isConnected()) {
            return this.fDocumentUndoManager.undoable();
        }
        return false;
    }

    @Override
    public void redo() {
        if (this.isConnected()) {
            try {
                this.fDocumentUndoManager.redo();
            }
            catch (ExecutionException executionException) {
                this.openErrorDialog(JFaceTextMessages.getString("DefaultUndoManager.error.redoFailed.title"), (Exception)((Object)executionException));
            }
        }
    }

    @Override
    public void undo() {
        if (this.isConnected()) {
            try {
                this.fDocumentUndoManager.undo();
            }
            catch (ExecutionException executionException) {
                this.openErrorDialog(JFaceTextMessages.getString("DefaultUndoManager.error.undoFailed.title"), (Exception)((Object)executionException));
            }
        }
    }

    private void selectAndReveal(int n, int n2) {
        if (this.fTextViewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 iTextViewerExtension5 = (ITextViewerExtension5)((Object)this.fTextViewer);
            iTextViewerExtension5.exposeModelRange((IRegion)new Region(n, n2));
        } else if (!this.fTextViewer.overlapsWithVisibleRegion(n, n2)) {
            this.fTextViewer.resetVisibleRegion();
        }
        this.fTextViewer.setSelectedRange(n, n2);
        this.fTextViewer.revealRange(n, n2);
    }

    @Override
    public IUndoContext getUndoContext() {
        if (this.isConnected()) {
            return this.fDocumentUndoManager.getUndoContext();
        }
        return null;
    }

    private void connectDocumentUndoManager(IDocument iDocument) {
        this.disconnectDocumentUndoManager();
        if (iDocument != null) {
            this.fDocument = iDocument;
            DocumentUndoManagerRegistry.connect((IDocument)this.fDocument);
            this.fDocumentUndoManager = DocumentUndoManagerRegistry.getDocumentUndoManager((IDocument)this.fDocument);
            this.fDocumentUndoManager.connect((Object)this);
            this.setMaximalUndoLevel(this.fUndoLevel);
            this.fDocumentUndoListener = new DocumentUndoListener();
            this.fDocumentUndoManager.addDocumentUndoListener(this.fDocumentUndoListener);
        }
    }

    private void disconnectDocumentUndoManager() {
        if (this.fDocumentUndoManager != null) {
            this.fDocumentUndoManager.disconnect((Object)this);
            DocumentUndoManagerRegistry.disconnect((IDocument)this.fDocument);
            this.fDocumentUndoManager.removeDocumentUndoListener(this.fDocumentUndoListener);
            this.fDocumentUndoListener = null;
            this.fDocumentUndoManager = null;
        }
    }

    private class DocumentUndoListener
    implements IDocumentUndoListener {
        private DocumentUndoListener() {
        }

        public void documentUndoNotification(DocumentUndoEvent documentUndoEvent) {
            if (!TextViewerUndoManager.this.isConnected()) {
                return;
            }
            int n = documentUndoEvent.getEventType();
            if ((n & 1) != 0 || (n & 2) != 0) {
                if (documentUndoEvent.isCompound()) {
                    ITextViewerExtension iTextViewerExtension = null;
                    if (TextViewerUndoManager.this.fTextViewer instanceof ITextViewerExtension) {
                        iTextViewerExtension = (ITextViewerExtension)((Object)TextViewerUndoManager.this.fTextViewer);
                    }
                    if (iTextViewerExtension != null) {
                        iTextViewerExtension.setRedraw(false);
                    }
                }
                TextViewerUndoManager.this.fTextViewer.getTextWidget().getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (TextViewerUndoManager.this.fTextViewer instanceof TextViewer) {
                            ((TextViewer)TextViewerUndoManager.this.fTextViewer).ignoreAutoEditStrategies(true);
                        }
                    }
                });
            } else if ((n & 4) != 0 || (n & 8) != 0) {
                Object object;
                TextViewerUndoManager.this.fTextViewer.getTextWidget().getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (TextViewerUndoManager.this.fTextViewer instanceof TextViewer) {
                            ((TextViewer)TextViewerUndoManager.this.fTextViewer).ignoreAutoEditStrategies(false);
                        }
                    }
                });
                if (documentUndoEvent.isCompound()) {
                    object = null;
                    if (TextViewerUndoManager.this.fTextViewer instanceof ITextViewerExtension) {
                        object = (ITextViewerExtension)((Object)TextViewerUndoManager.this.fTextViewer);
                    }
                    if (object != null) {
                        object.setRedraw(true);
                    }
                }
                if (TextViewerUndoManager.this.fTextViewer != null && (object = TextViewerUndoManager.this.fTextViewer.getTextWidget()) != null && !object.isDisposed() && object.isFocusControl()) {
                    TextViewerUndoManager.this.selectAndReveal(documentUndoEvent.getOffset(), documentUndoEvent.getText() == null ? 0 : documentUndoEvent.getText().length());
                }
            }
        }
    }

    private class KeyAndMouseListener
    implements MouseListener,
    KeyListener {
        private KeyAndMouseListener() {
        }

        public void mouseDoubleClick(MouseEvent mouseEvent) {
        }

        public void mouseDown(MouseEvent mouseEvent) {
            if (mouseEvent.button == 1 && TextViewerUndoManager.this.isConnected()) {
                TextViewerUndoManager.this.fDocumentUndoManager.commit();
            }
        }

        public void mouseUp(MouseEvent mouseEvent) {
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void keyPressed(KeyEvent keyEvent) {
            switch (keyEvent.keyCode) {
                case 0x1000001: 
                case 0x1000002: 
                case 0x1000003: 
                case 0x1000004: {
                    if (!TextViewerUndoManager.this.isConnected()) break;
                    TextViewerUndoManager.this.fDocumentUndoManager.commit();
                }
            }
        }
    }

    private class TextInputListener
    implements ITextInputListener {
        private TextInputListener() {
        }

        @Override
        public void inputDocumentAboutToBeChanged(IDocument iDocument, IDocument iDocument2) {
            TextViewerUndoManager.this.disconnectDocumentUndoManager();
        }

        @Override
        public void inputDocumentChanged(IDocument iDocument, IDocument iDocument2) {
            TextViewerUndoManager.this.connectDocumentUndoManager(iDocument2);
        }
    }
}

