/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text;

import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.AbstractHoverInformationControlManager;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IInformationControlExtension5;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextHoverExtension2;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.IViewportListener;
import org.eclipse.jface.text.IWidgetTokenKeeper;
import org.eclipse.jface.text.IWidgetTokenKeeperExtension;
import org.eclipse.jface.text.IWidgetTokenOwner;
import org.eclipse.jface.text.JFaceTextUtil;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.osgi.framework.Bundle;

class TextViewerHoverManager
extends AbstractHoverInformationControlManager
implements IWidgetTokenKeeper,
IWidgetTokenKeeperExtension {
    public static final int WIDGET_PRIORITY = 0;
    private TextViewer fTextViewer;
    private Thread fThread;
    private ITextListener fStopper;
    private Object fMutex = new Object();
    private volatile ITextHover fTextHover;
    private boolean fProcessMouseHoverEvent = true;
    private MouseMoveListener fMouseMoveListener;
    private IViewportListener fViewportListener;

    public TextViewerHoverManager(TextViewer textViewer, IInformationControlCreator iInformationControlCreator) {
        super(iInformationControlCreator);
        this.fTextViewer = textViewer;
        this.fStopper = new ITextListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void textChanged(TextEvent textEvent) {
                Object object = TextViewerHoverManager.this.fMutex;
                synchronized (object) {
                    if (TextViewerHoverManager.this.fThread != null) {
                        TextViewerHoverManager.this.fThread.interrupt();
                        TextViewerHoverManager.this.fThread = null;
                    }
                }
            }
        };
        this.fViewportListener = new IViewportListener(){

            @Override
            public void viewportChanged(int n) {
                TextViewerHoverManager.this.fProcessMouseHoverEvent = false;
            }
        };
        this.fTextViewer.addViewportListener(this.fViewportListener);
        this.fMouseMoveListener = new MouseMoveListener(){

            public void mouseMove(MouseEvent mouseEvent) {
                TextViewerHoverManager.this.fProcessMouseHoverEvent = true;
            }
        };
        this.fTextViewer.getTextWidget().addMouseMoveListener(this.fMouseMoveListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void computeInformation() {
        if (!this.fProcessMouseHoverEvent) {
            this.setInformation(null, null);
            return;
        }
        Point point = this.getHoverEventLocation();
        int n = this.computeOffsetAtLocation(point.x, point.y);
        if (n == -1) {
            this.setInformation(null, null);
            return;
        }
        final ITextHover iTextHover = this.fTextViewer.getTextHover(n, this.getHoverEventStateMask());
        if (iTextHover == null) {
            this.setInformation(null, null);
            return;
        }
        final IRegion iRegion = iTextHover.getHoverRegion(this.fTextViewer, n);
        if (iRegion == null) {
            this.setInformation(null, null);
            return;
        }
        final Rectangle rectangle = JFaceTextUtil.computeArea(iRegion, this.fTextViewer);
        if (rectangle == null || rectangle.isEmpty()) {
            this.setInformation(null, null);
            return;
        }
        if (this.fThread != null) {
            this.setInformation(null, null);
            return;
        }
        this.fThread = new Thread("Text Viewer Hover Presenter"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block27: {
                    boolean bl = false;
                    try {
                        try {
                            if (TextViewerHoverManager.this.fThread != null) {
                                Object object;
                                try {
                                    object = iTextHover instanceof ITextHoverExtension2 ? ((ITextHoverExtension2)((Object)iTextHover)).getHoverInfo2(TextViewerHoverManager.this.fTextViewer, iRegion) : iTextHover.getHoverInfo(TextViewerHoverManager.this.fTextViewer, iRegion);
                                }
                                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                                    object = null;
                                }
                                if (iTextHover instanceof ITextHoverExtension) {
                                    TextViewerHoverManager.this.setCustomInformationControlCreator(((ITextHoverExtension)((Object)iTextHover)).getHoverControlCreator());
                                } else {
                                    TextViewerHoverManager.this.setCustomInformationControlCreator(null);
                                }
                                TextViewerHoverManager.this.setInformation(object, rectangle);
                                if (object != null) {
                                    TextViewerHoverManager.this.fTextHover = iTextHover;
                                }
                            } else {
                                TextViewerHoverManager.this.setInformation(null, null);
                            }
                            bl = true;
                        }
                        catch (RuntimeException runtimeException) {
                            String string = "org.eclipse.jface.text";
                            ILog iLog = Platform.getLog((Bundle)Platform.getBundle((String)string));
                            iLog.log((IStatus)new Status(4, string, 0, "Unexpected runtime error while computing a text hover", (Throwable)runtimeException));
                            Object object = TextViewerHoverManager.this.fMutex;
                            synchronized (object) {
                                if (TextViewerHoverManager.this.fTextViewer != null) {
                                    TextViewerHoverManager.this.fTextViewer.removeTextListener(TextViewerHoverManager.this.fStopper);
                                }
                                TextViewerHoverManager.this.fThread = null;
                                if (!bl) {
                                    TextViewerHoverManager.this.setInformation(null, null);
                                }
                                break block27;
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        Object object = TextViewerHoverManager.this.fMutex;
                        synchronized (object) {
                            if (TextViewerHoverManager.this.fTextViewer != null) {
                                TextViewerHoverManager.this.fTextViewer.removeTextListener(TextViewerHoverManager.this.fStopper);
                            }
                            TextViewerHoverManager.this.fThread = null;
                            if (!bl) {
                                TextViewerHoverManager.this.setInformation(null, null);
                            }
                        }
                        throw throwable;
                    }
                    Object object = TextViewerHoverManager.this.fMutex;
                    synchronized (object) {
                        if (TextViewerHoverManager.this.fTextViewer != null) {
                            TextViewerHoverManager.this.fTextViewer.removeTextListener(TextViewerHoverManager.this.fStopper);
                        }
                        TextViewerHoverManager.this.fThread = null;
                        if (!bl) {
                            TextViewerHoverManager.this.setInformation(null, null);
                        }
                    }
                }
            }
        };
        this.fThread.setDaemon(true);
        this.fThread.setPriority(1);
        Object object = this.fMutex;
        synchronized (object) {
            this.fTextViewer.addTextListener(this.fStopper);
            this.fThread.start();
        }
    }

    @Override
    protected void presentInformation() {
        if (this.fTextViewer == null) {
            return;
        }
        StyledText styledText = this.fTextViewer.getTextWidget();
        if (styledText != null && !styledText.isDisposed()) {
            Display display = styledText.getDisplay();
            if (display == null) {
                return;
            }
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    TextViewerHoverManager.this.doPresentInformation();
                }
            });
        }
    }

    protected void doPresentInformation() {
        super.presentInformation();
    }

    private int computeOffsetAtLocation(int n, int n2) {
        try {
            StyledText styledText = this.fTextViewer.getTextWidget();
            int n3 = styledText.getOffsetAtLocation(new Point(n, n2));
            Point point = styledText.getLocationAtOffset(n3);
            if (point.x > n) {
                --n3;
            }
            if (this.fTextViewer instanceof ITextViewerExtension5) {
                ITextViewerExtension5 iTextViewerExtension5 = (ITextViewerExtension5)((Object)this.fTextViewer);
                return iTextViewerExtension5.widgetOffset2ModelOffset(n3);
            }
            return n3 + this.fTextViewer._getVisibleRegionOffset();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return -1;
        }
    }

    @Override
    protected void showInformationControl(Rectangle rectangle) {
        if (this.fTextViewer != null && this.fTextViewer.requestWidgetToken(this, 0)) {
            super.showInformationControl(rectangle);
        } else if (DEBUG) {
            System.out.println("TextViewerHoverManager#showInformationControl(..) did not get widget token");
        }
    }

    @Override
    protected void hideInformationControl() {
        try {
            this.fTextHover = null;
            super.hideInformationControl();
        }
        finally {
            if (this.fTextViewer != null) {
                this.fTextViewer.releaseWidgetToken(this);
            }
        }
    }

    @Override
    void replaceInformationControl(boolean bl) {
        if (this.fTextViewer != null) {
            this.fTextViewer.releaseWidgetToken(this);
        }
        super.replaceInformationControl(bl);
    }

    @Override
    protected void handleInformationControlDisposed() {
        try {
            super.handleInformationControlDisposed();
        }
        finally {
            if (this.fTextViewer != null) {
                this.fTextViewer.releaseWidgetToken(this);
            }
        }
    }

    @Override
    public boolean requestWidgetToken(IWidgetTokenOwner iWidgetTokenOwner) {
        this.fTextHover = null;
        super.hideInformationControl();
        return true;
    }

    @Override
    public boolean requestWidgetToken(IWidgetTokenOwner iWidgetTokenOwner, int n) {
        if (n > 0) {
            this.fTextHover = null;
            super.hideInformationControl();
            return true;
        }
        return false;
    }

    @Override
    public boolean setFocus(IWidgetTokenOwner iWidgetTokenOwner) {
        if (!this.hasInformationControlReplacer()) {
            return false;
        }
        IInformationControl iInformationControl = this.getCurrentInformationControl();
        if (this.canReplace(iInformationControl)) {
            if (this.cancelReplacingDelay()) {
                this.replaceInformationControl(true);
            }
            return true;
        }
        return iInformationControl instanceof IInformationControlExtension5;
    }

    protected ITextHover getCurrentTextHover() {
        return this.fTextHover;
    }

    @Override
    public void dispose() {
        if (this.fTextViewer != null) {
            this.fTextViewer.removeViewportListener(this.fViewportListener);
            this.fViewportListener = null;
            StyledText styledText = this.fTextViewer.getTextWidget();
            if (styledText != null && !styledText.isDisposed()) {
                styledText.removeMouseMoveListener(this.fMouseMoveListener);
            }
            this.fMouseMoveListener = null;
        }
        super.dispose();
    }
}

