/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.internal.text.NonDeletingPositionUpdater;
import org.eclipse.jface.internal.text.SelectionProcessor;
import org.eclipse.jface.internal.text.StickyHoverManager;
import org.eclipse.jface.text.AbstractInformationControlManager;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.BlockTextSelection;
import org.eclipse.jface.text.DefaultDocumentAdapter;
import org.eclipse.jface.text.DefaultPositionUpdater;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.DocumentRewriteSession;
import org.eclipse.jface.text.DocumentRewriteSessionEvent;
import org.eclipse.jface.text.DocumentRewriteSessionType;
import org.eclipse.jface.text.FindReplaceDocumentAdapter;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IAutoIndentStrategy;
import org.eclipse.jface.text.IBlockTextSelection;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentAdapter;
import org.eclipse.jface.text.IDocumentAdapterExtension;
import org.eclipse.jface.text.IDocumentExtension;
import org.eclipse.jface.text.IDocumentExtension2;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.IDocumentInformationMapping;
import org.eclipse.jface.text.IDocumentInformationMappingExtension2;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IDocumentRewriteSessionListener;
import org.eclipse.jface.text.IEditingSupport;
import org.eclipse.jface.text.IEditingSupportRegistry;
import org.eclipse.jface.text.IEventConsumer;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.jface.text.IFindReplaceTargetExtension;
import org.eclipse.jface.text.IFindReplaceTargetExtension3;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IPainter;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.IRewriteTarget;
import org.eclipse.jface.text.ISlaveDocumentManager;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.ITextOperationTargetExtension;
import org.eclipse.jface.text.ITextPresentationListener;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.jface.text.ITextViewerExtension2;
import org.eclipse.jface.text.ITextViewerExtension4;
import org.eclipse.jface.text.ITextViewerExtension6;
import org.eclipse.jface.text.ITextViewerExtension7;
import org.eclipse.jface.text.ITextViewerExtension8;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.text.IViewportListener;
import org.eclipse.jface.text.IWidgetTokenKeeper;
import org.eclipse.jface.text.IWidgetTokenKeeperExtension;
import org.eclipse.jface.text.IWidgetTokenOwner;
import org.eclipse.jface.text.IWidgetTokenOwnerExtension;
import org.eclipse.jface.text.JFaceTextMessages;
import org.eclipse.jface.text.JFaceTextUtil;
import org.eclipse.jface.text.MarkSelection;
import org.eclipse.jface.text.PaintManager;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.SlaveDocumentEvent;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.TextViewerHoverManager;
import org.eclipse.jface.text.hyperlink.HyperlinkManager;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetectorExtension;
import org.eclipse.jface.text.hyperlink.IHyperlinkPresenter;
import org.eclipse.jface.text.projection.ChildDocument;
import org.eclipse.jface.text.projection.ChildDocumentManager;
import org.eclipse.jface.util.Geometry;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.LineBackgroundEvent;
import org.eclipse.swt.custom.LineBackgroundListener;
import org.eclipse.swt.custom.MovementEvent;
import org.eclipse.swt.custom.MovementListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.StyledTextContent;
import org.eclipse.swt.custom.StyledTextPrintOptions;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.text.edits.TextEdit;

public class TextViewer
extends Viewer
implements ITextViewer,
ITextViewerExtension,
ITextViewerExtension2,
ITextViewerExtension4,
ITextViewerExtension6,
ITextViewerExtension7,
ITextViewerExtension8,
IEditingSupportRegistry,
ITextOperationTarget,
ITextOperationTargetExtension,
IWidgetTokenOwner,
IWidgetTokenOwnerExtension,
IPostSelectionProvider {
    public static final boolean TRACE_ERRORS = false;
    private static final boolean TRACE_DOUBLE_CLICK = false;
    private static final boolean REDRAW_BUG_158746 = true;
    private static final int TEXT_HOVER_WIDTH_CHARS = 100;
    private static final int TEXT_HOVER_HEIGHT_CHARS = 12;
    protected static final int SCROLLER = 1;
    protected static final int MOUSE = 2;
    protected static final int MOUSE_END = 3;
    protected static final int KEY = 4;
    protected static final int RESIZE = 5;
    protected static final int INTERNAL = 6;
    protected static final String SHIFTING = "__TextViewer_shifting";
    private static final String SELECTION_POSITION_CATEGORY = "_textviewer_selection_category";
    private static PrinterData fgPrinterData = null;
    private StyledText fTextWidget;
    private IDocument fDocument;
    private IDocument fVisibleDocument;
    private IDocumentAdapter fDocumentAdapter;
    private ISlaveDocumentManager fSlaveDocumentManager;
    private TextDoubleClickStrategyConnector fDoubleClickStrategyConnector;
    private ViewportGuard fViewportGuard;
    private int fTopInset = 0;
    private WidgetCommand fWidgetCommand = new WidgetCommand();
    private ScrollBar fScroller;
    private VisibleDocumentListener fVisibleDocumentListener = new VisibleDocumentListener();
    private TextVerifyListener fVerifyListener = new TextVerifyListener();
    private DocumentCommand fDocumentCommand = new DocumentCommand();
    private IFindReplaceTarget fFindReplaceTarget;
    private TextViewerHoverManager fTextHoverManager;
    private IWidgetTokenKeeper fWidgetTokenKeeper;
    private VerifyKeyListenersManager fVerifyKeyListenersManager = new VerifyKeyListenersManager();
    protected Position fMarkPosition;
    private final String MARK_POSITION_CATEGORY = "__mark_category_" + this.hashCode();
    private final IPositionUpdater fMarkPositionUpdater = new DefaultPositionUpdater(this.MARK_POSITION_CATEGORY);
    private int fRedrawCounter = 0;
    private IRewriteTarget fRewriteTarget;
    private CursorListener fCursorListener;
    private IRegion fLastSentSelectionChange;
    private List fPostSelectionChangedListeners;
    private final int[] fNumberOfPostSelectionChangedEvents = new int[1];
    private IRegion fLastSentPostSelectionChange;
    private Set fEditorHelpers = new HashSet();
    private DocumentRewriteSessionListener fDocumentRewriteSessionListener = new DocumentRewriteSessionListener();
    protected boolean fIgnoreAutoIndent = false;
    protected Map fIndentChars;
    protected Map fDefaultPrefixChars;
    protected Map fDoubleClickStrategies;
    protected IUndoManager fUndoManager;
    protected Map fAutoIndentStrategies;
    protected Map fTextHovers;
    protected List fViewportListeners;
    protected int fLastTopPixel;
    protected List fTextListeners;
    protected List fTextInputListeners;
    protected IEventConsumer fEventConsumer;
    protected boolean fReplaceTextPresentation = false;
    protected IInformationControlCreator fHoverControlCreator;
    protected IDocumentInformationMapping fInformationMapping;
    protected PaintManager fPaintManager;
    protected String fPartitioning;
    protected List fTextPresentationListeners;
    protected FindReplaceDocumentAdapter fFindReplaceDocumentAdapter;
    protected IHyperlinkDetector[] fHyperlinkDetectors;
    protected IHyperlinkPresenter fHyperlinkPresenter;
    protected HyperlinkManager fHyperlinkManager;
    protected int fHyperlinkStateMask;
    private ViewerState fViewerState;
    private IAutoEditStrategy fTabsToSpacesConverter;
    private int fLastEventTime;
    private Control fDisposedControl;

    private void print(MovementEvent movementEvent) {
        System.out.println("line offset: " + movementEvent.lineOffset);
        System.out.println("line: " + movementEvent.lineText);
        System.out.println("type: " + movementEvent.movement);
        System.out.println("offset: " + movementEvent.offset);
        System.out.println("newOffset: " + movementEvent.newOffset);
    }

    protected TextViewer() {
    }

    public TextViewer(Composite composite, int n) {
        this.createControl(composite, n);
    }

    protected StyledText createTextWidget(Composite composite, int n) {
        StyledText styledText = new StyledText(composite, n);
        styledText.setLeftMargin(Math.max(styledText.getLeftMargin(), 2));
        return styledText;
    }

    protected IDocumentAdapter createDocumentAdapter() {
        return new DefaultDocumentAdapter();
    }

    protected void createControl(Composite composite, int n) {
        this.fTextWidget = this.createTextWidget(composite, n);
        this.fTextWidget.addListener(37, new Listener(){

            public void handleEvent(Event event) {
                if ((event.stateMask & SWT.MOD1) == 0) {
                    return;
                }
                int n = TextViewer.this.fTextWidget.getTopIndex();
                int n2 = JFaceTextUtil.getBottomIndex(TextViewer.this.fTextWidget);
                if (event.count > 0) {
                    TextViewer.this.fTextWidget.setTopIndex(2 * n - n2);
                } else {
                    TextViewer.this.fTextWidget.setTopIndex(n2);
                }
                TextViewer.this.updateViewportListeners(6);
            }
        });
        this.fTextWidget.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                TextViewer.this.fDisposedControl = TextViewer.this.getControl();
                TextViewer.this.handleDispose();
            }
        });
        this.fTextWidget.setFont(composite.getFont());
        this.fTextWidget.setDoubleClickEnabled(true);
        this.fTextWidget.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent traverseEvent) {
                if (131072 == traverseEvent.stateMask && '\t' == traverseEvent.character) {
                    traverseEvent.doit = !TextViewer.this.fTextWidget.getEditable();
                }
            }
        });
        this.fTopInset = -this.fTextWidget.computeTrim((int)0, (int)0, (int)0, (int)0).y;
        this.fVerifyListener.forward(true);
        this.fTextWidget.addVerifyListener((VerifyListener)this.fVerifyListener);
        this.fTextWidget.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                TextViewer.this.selectionChanged(selectionEvent.x, selectionEvent.y - selectionEvent.x);
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                TextViewer.this.selectionChanged(selectionEvent.x, selectionEvent.y - selectionEvent.x);
            }
        });
        this.fCursorListener = new CursorListener();
        this.fCursorListener.install();
        this.initializeViewportUpdate();
    }

    @Override
    public Control getControl() {
        return this.fTextWidget != null ? this.fTextWidget : this.fDisposedControl;
    }

    @Override
    public void activatePlugins() {
        if (this.fDoubleClickStrategies != null && !this.fDoubleClickStrategies.isEmpty() && this.fDoubleClickStrategyConnector == null) {
            this.fDoubleClickStrategyConnector = new TextDoubleClickStrategyConnector();
            this.fTextWidget.addWordMovementListener((MovementListener)this.fDoubleClickStrategyConnector);
            this.fTextWidget.addMouseListener((MouseListener)this.fDoubleClickStrategyConnector);
        }
        this.ensureHoverControlManagerInstalled();
        this.ensureHyperlinkManagerInstalled();
        if (this.fUndoManager != null) {
            this.fUndoManager.connect(this);
            this.fUndoManager.reset();
        }
    }

    private void ensureHoverControlManagerInstalled() {
        if (this.fTextHovers != null && !this.fTextHovers.isEmpty() && this.fHoverControlCreator != null && this.fTextHoverManager == null) {
            this.fTextHoverManager = new TextViewerHoverManager(this, this.fHoverControlCreator);
            this.fTextHoverManager.install((Control)this.getTextWidget());
            this.fTextHoverManager.setSizeConstraints(100, 12, false, true);
            this.fTextHoverManager.setInformationControlReplacer(new StickyHoverManager(this));
        }
    }

    @Override
    public void resetPlugins() {
        if (this.fUndoManager != null) {
            this.fUndoManager.reset();
        }
    }

    protected void handleDispose() {
        this.setDocument(null);
        if (this.fPaintManager != null) {
            this.fPaintManager.dispose();
            this.fPaintManager = null;
        }
        this.removeViewPortUpdate();
        this.fViewportGuard = null;
        if (this.fViewportListeners != null) {
            this.fViewportListeners.clear();
            this.fViewportListeners = null;
        }
        if (this.fTextListeners != null) {
            this.fTextListeners.clear();
            this.fTextListeners = null;
        }
        if (this.fTextInputListeners != null) {
            this.fTextInputListeners.clear();
            this.fTextInputListeners = null;
        }
        if (this.fPostSelectionChangedListeners != null) {
            this.fPostSelectionChangedListeners.clear();
            this.fPostSelectionChangedListeners = null;
        }
        if (this.fAutoIndentStrategies != null) {
            this.fAutoIndentStrategies.clear();
            this.fAutoIndentStrategies = null;
        }
        if (this.fUndoManager != null) {
            this.fUndoManager.disconnect();
            this.fUndoManager = null;
        }
        if (this.fDoubleClickStrategies != null) {
            this.fDoubleClickStrategies.clear();
            this.fDoubleClickStrategies = null;
        }
        if (this.fTextHovers != null) {
            this.fTextHovers.clear();
            this.fTextHovers = null;
        }
        this.fDoubleClickStrategyConnector = null;
        if (this.fTextHoverManager != null) {
            this.fTextHoverManager.dispose();
            this.fTextHoverManager = null;
        }
        if (this.fVisibleDocumentListener != null) {
            if (this.fVisibleDocument != null) {
                this.fVisibleDocument.removeDocumentListener((IDocumentListener)this.fVisibleDocumentListener);
            }
            this.fVisibleDocumentListener = null;
        }
        if (this.fDocumentAdapter != null) {
            this.fDocumentAdapter.setDocument(null);
            this.fDocumentAdapter = null;
        }
        if (this.fSlaveDocumentManager != null) {
            if (this.fVisibleDocument != null) {
                this.fSlaveDocumentManager.freeSlaveDocument(this.fVisibleDocument);
            }
            this.fSlaveDocumentManager = null;
        }
        if (this.fCursorListener != null) {
            this.fCursorListener.uninstall();
            this.fCursorListener = null;
        }
        if (this.fHyperlinkManager != null) {
            this.fHyperlinkManager.uninstall();
            this.fHyperlinkManager = null;
        }
        this.fHyperlinkDetectors = null;
        this.fVisibleDocument = null;
        this.fDocument = null;
        this.fScroller = null;
        this.fTextWidget = null;
    }

    @Override
    public StyledText getTextWidget() {
        return this.fTextWidget;
    }

    protected int getEmptySelectionChangedEventDelay() {
        return OpenStrategy.getPostSelectionDelay();
    }

    @Override
    public void setAutoIndentStrategy(IAutoIndentStrategy iAutoIndentStrategy, String string) {
        this.setAutoEditStrategies(new IAutoEditStrategy[]{iAutoIndentStrategy}, string);
    }

    protected final void setAutoEditStrategies(IAutoEditStrategy[] iAutoEditStrategyArray, String string) {
        if (this.fAutoIndentStrategies == null) {
            this.fAutoIndentStrategies = new HashMap();
        }
        ArrayList<IAutoEditStrategy> arrayList = (ArrayList<IAutoEditStrategy>)this.fAutoIndentStrategies.get(string);
        if (iAutoEditStrategyArray == null) {
            if (arrayList == null) {
                return;
            }
            this.fAutoIndentStrategies.put(string, null);
        } else {
            if (arrayList == null) {
                arrayList = new ArrayList<IAutoEditStrategy>();
                this.fAutoIndentStrategies.put(string, arrayList);
            }
            arrayList.clear();
            arrayList.addAll(Arrays.asList(iAutoEditStrategyArray));
        }
    }

    @Override
    public void prependAutoEditStrategy(IAutoEditStrategy iAutoEditStrategy, String string) {
        ArrayList<IAutoEditStrategy> arrayList;
        if (iAutoEditStrategy == null || string == null) {
            throw new IllegalArgumentException();
        }
        if (this.fAutoIndentStrategies == null) {
            this.fAutoIndentStrategies = new HashMap();
        }
        if ((arrayList = (ArrayList<IAutoEditStrategy>)this.fAutoIndentStrategies.get(string)) == null) {
            arrayList = new ArrayList<IAutoEditStrategy>();
            this.fAutoIndentStrategies.put(string, arrayList);
        }
        arrayList.add(0, iAutoEditStrategy);
    }

    @Override
    public void removeAutoEditStrategy(IAutoEditStrategy iAutoEditStrategy, String string) {
        if (this.fAutoIndentStrategies == null) {
            return;
        }
        List list = (List)this.fAutoIndentStrategies.get(string);
        if (list == null) {
            return;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().equals(iAutoEditStrategy)) continue;
            iterator.remove();
            break;
        }
        if (list.isEmpty()) {
            this.fAutoIndentStrategies.put(string, null);
        }
    }

    @Override
    public void setEventConsumer(IEventConsumer iEventConsumer) {
        this.fEventConsumer = iEventConsumer;
    }

    @Override
    public void setIndentPrefixes(String[] stringArray, String string) {
        int n = -1;
        boolean bl = stringArray != null;
        while (bl && ++n < stringArray.length) {
            boolean bl2 = bl = stringArray[n] != null;
        }
        if (bl) {
            if (this.fIndentChars == null) {
                this.fIndentChars = new HashMap();
            }
            this.fIndentChars.put(string, stringArray);
        } else if (this.fIndentChars != null) {
            this.fIndentChars.remove(string);
        }
    }

    @Override
    public int getTopInset() {
        return this.fTopInset;
    }

    @Override
    public boolean isEditable() {
        if (this.fTextWidget == null) {
            return false;
        }
        return this.fTextWidget.getEditable();
    }

    @Override
    public void setEditable(boolean bl) {
        if (this.fTextWidget != null) {
            this.fTextWidget.setEditable(bl);
        }
    }

    @Override
    public void setDefaultPrefixes(String[] stringArray, String string) {
        if (stringArray != null && stringArray.length > 0) {
            if (this.fDefaultPrefixChars == null) {
                this.fDefaultPrefixChars = new HashMap();
            }
            this.fDefaultPrefixChars.put(string, stringArray);
        } else if (this.fDefaultPrefixChars != null) {
            this.fDefaultPrefixChars.remove(string);
        }
    }

    @Override
    public void setUndoManager(IUndoManager iUndoManager) {
        this.fUndoManager = iUndoManager;
    }

    @Override
    public IUndoManager getUndoManager() {
        return this.fUndoManager;
    }

    @Override
    public void setTextHover(ITextHover iTextHover, String string) {
        this.setTextHover(iTextHover, string, 255);
    }

    @Override
    public void setTextHover(ITextHover iTextHover, String string, int n) {
        TextHoverKey textHoverKey = new TextHoverKey(string, n);
        if (iTextHover != null) {
            if (this.fTextHovers == null) {
                this.fTextHovers = new HashMap();
            }
            this.fTextHovers.put(textHoverKey, iTextHover);
        } else if (this.fTextHovers != null) {
            this.fTextHovers.remove(textHoverKey);
        }
        this.ensureHoverControlManagerInstalled();
    }

    @Override
    public void removeTextHovers(String string) {
        if (this.fTextHovers == null) {
            return;
        }
        for (TextHoverKey textHoverKey : new HashSet(this.fTextHovers.keySet())) {
            if (!textHoverKey.fContentType.equals(string)) continue;
            this.fTextHovers.remove(textHoverKey);
        }
    }

    protected ITextHover getTextHover(int n) {
        return this.getTextHover(n, 255);
    }

    protected ITextHover getTextHover(int n, int n2) {
        if (this.fTextHovers == null) {
            return null;
        }
        IDocument iDocument = this.getDocument();
        if (iDocument == null) {
            return null;
        }
        try {
            TextHoverKey textHoverKey = new TextHoverKey(TextUtilities.getContentType((IDocument)iDocument, (String)this.getDocumentPartitioning(), (int)n, (boolean)true), n2);
            Object v = this.fTextHovers.get(textHoverKey);
            if (v == null) {
                textHoverKey.setStateMask(255);
                v = this.fTextHovers.get(textHoverKey);
            }
            return (ITextHover)v;
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    protected AbstractInformationControlManager getTextHoveringController() {
        return this.fTextHoverManager;
    }

    public void setHoverControlCreator(IInformationControlCreator iInformationControlCreator) {
        this.fHoverControlCreator = iInformationControlCreator;
    }

    @Override
    public void setHoverEnrichMode(ITextViewerExtension8.EnrichMode enrichMode) {
        if (this.fTextHoverManager == null) {
            return;
        }
        this.fTextHoverManager.setHoverEnrichMode(enrichMode);
    }

    @Override
    public boolean requestWidgetToken(IWidgetTokenKeeper iWidgetTokenKeeper) {
        if (this.fTextWidget != null) {
            if (this.fWidgetTokenKeeper != null) {
                if (this.fWidgetTokenKeeper == iWidgetTokenKeeper) {
                    return true;
                }
                if (this.fWidgetTokenKeeper.requestWidgetToken(this)) {
                    this.fWidgetTokenKeeper = iWidgetTokenKeeper;
                    return true;
                }
            } else {
                this.fWidgetTokenKeeper = iWidgetTokenKeeper;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean requestWidgetToken(IWidgetTokenKeeper iWidgetTokenKeeper, int n) {
        if (this.fTextWidget != null) {
            if (this.fWidgetTokenKeeper != null) {
                if (this.fWidgetTokenKeeper == iWidgetTokenKeeper) {
                    return true;
                }
                boolean bl = false;
                if (this.fWidgetTokenKeeper instanceof IWidgetTokenKeeperExtension) {
                    IWidgetTokenKeeperExtension iWidgetTokenKeeperExtension = (IWidgetTokenKeeperExtension)((Object)this.fWidgetTokenKeeper);
                    bl = iWidgetTokenKeeperExtension.requestWidgetToken(this, n);
                } else {
                    bl = this.fWidgetTokenKeeper.requestWidgetToken(this);
                }
                if (bl) {
                    this.fWidgetTokenKeeper = iWidgetTokenKeeper;
                    return true;
                }
            } else {
                this.fWidgetTokenKeeper = iWidgetTokenKeeper;
                return true;
            }
        }
        return false;
    }

    @Override
    public void releaseWidgetToken(IWidgetTokenKeeper iWidgetTokenKeeper) {
        if (this.fWidgetTokenKeeper == iWidgetTokenKeeper) {
            this.fWidgetTokenKeeper = null;
        }
    }

    @Override
    public Point getSelectedRange() {
        if (!this.redraws() && this.fViewerState != null) {
            return this.fViewerState.getSelection();
        }
        if (this.fTextWidget != null) {
            Point point = this.fTextWidget.getSelectionRange();
            if ((point = this.widgetSelection2ModelSelection(point)) != null) {
                return point;
            }
        }
        return new Point(-1, -1);
    }

    @Override
    public void setSelectedRange(int n, int n2) {
        if (!this.redraws()) {
            if (this.fViewerState != null) {
                this.fViewerState.updateSelection(n, n2);
            }
            return;
        }
        if (this.fTextWidget == null) {
            return;
        }
        IRegion iRegion = this.modelRange2ClosestWidgetRange((IRegion)new Region(n, n2));
        if (iRegion != null) {
            int[] nArray = new int[]{iRegion.getOffset(), iRegion.getLength()};
            this.validateSelectionRange(nArray);
            if (nArray[0] >= 0) {
                this.fTextWidget.setSelectionRange(nArray[0], nArray[1]);
                this.selectionChanged(nArray[0], nArray[1]);
            }
        }
    }

    protected void validateSelectionRange(int[] nArray) {
        int n;
        IDocument iDocument = this.getVisibleDocument();
        if (iDocument == null) {
            nArray[0] = -1;
            nArray[1] = -1;
            return;
        }
        int n2 = iDocument.getLength();
        int n3 = nArray[0];
        int n4 = nArray[1];
        if (n4 < 0) {
            n4 = -n4;
            n3 -= n4;
        }
        if (n3 < 0) {
            n3 = 0;
        }
        if (n3 > n2) {
            n3 = n2;
        }
        if ((n = n3 + n4 - n2) > 0) {
            n4 -= n;
        }
        try {
            int n5;
            int n6 = iDocument.getLineOfOffset(n3);
            IRegion iRegion = iDocument.getLineInformation(n6);
            int n7 = iRegion.getOffset() + iRegion.getLength();
            n = n3 - n7;
            if (n > 0) {
                n3 = n7;
                n4 += n;
                String string = iDocument.getLineDelimiter(n6);
                if (string != null) {
                    int n8 = string.length();
                    n3 += n8;
                    n4 -= n8;
                }
            }
            if ((n = (n5 = n3 + n4) - (n7 = (iRegion = iDocument.getLineInformationOfOffset(n5)).getOffset() + iRegion.getLength())) > 0) {
                n4 -= n;
            }
        }
        catch (BadLocationException badLocationException) {
            nArray[0] = -1;
            nArray[1] = -1;
            return;
        }
        if (nArray[1] < 0) {
            nArray[0] = n3 + n4;
            nArray[1] = -n4;
        } else {
            nArray[0] = n3;
            nArray[1] = n4;
        }
    }

    public void setSelection(ISelection iSelection, boolean bl) {
        if (iSelection instanceof IBlockTextSelection && this.getTextWidget().getBlockSelection()) {
            IBlockTextSelection iBlockTextSelection = (IBlockTextSelection)iSelection;
            try {
                int n = iBlockTextSelection.getStartLine();
                int n2 = iBlockTextSelection.getEndLine();
                IRegion iRegion = this.fDocument.getLineInformation(n);
                int n3 = iRegion.getLength();
                int n4 = Math.max(0, iBlockTextSelection.getStartColumn() - n3);
                IRegion iRegion2 = this.fDocument.getLineInformation(n2);
                int n5 = iRegion2.getLength();
                int n6 = Math.max(0, iBlockTextSelection.getEndColumn() - n5);
                Region region = new Region(iRegion.getOffset() + iBlockTextSelection.getStartColumn() - n4, 0);
                int n7 = this.modelRange2ClosestWidgetRange((IRegion)region).getOffset();
                Region region2 = new Region(iRegion2.getOffset() + iBlockTextSelection.getEndColumn() - n6, 0);
                int n8 = this.modelRange2ClosestWidgetRange((IRegion)region2).getOffset();
                Point point = new Point(this.fTextWidget.getHorizontalPixel(), this.fTextWidget.getTopPixel());
                Point point2 = Geometry.add((Point)point, (Point)this.fTextWidget.getLocationAtOffset(n7));
                int n9 = this.getAverageCharWidth();
                point2.x += n4 * n9;
                Point point3 = Geometry.add((Point)point, (Point)this.fTextWidget.getLocationAtOffset(n8));
                point3.x += n6 * n9;
                point3.y += this.fTextWidget.getLineHeight(n8);
                int n10 = n8 - n7;
                int[] nArray = new int[]{n7, n10};
                this.validateSelectionRange(nArray);
                if (nArray[0] >= 0) {
                    this.fTextWidget.setBlockSelectionBounds(Geometry.createRectangle((Point)point2, (Point)Geometry.subtract((Point)point3, (Point)point2)));
                    this.selectionChanged(n7, n10);
                }
            }
            catch (BadLocationException badLocationException) {
                this.setSelectedRange(iBlockTextSelection.getOffset(), iBlockTextSelection.getLength());
            }
            if (bl) {
                this.revealRange(iBlockTextSelection.getOffset(), iBlockTextSelection.getLength());
            }
        } else if (iSelection instanceof ITextSelection) {
            ITextSelection iTextSelection = (ITextSelection)iSelection;
            this.setSelectedRange(iTextSelection.getOffset(), iTextSelection.getLength());
            if (bl) {
                this.revealRange(iTextSelection.getOffset(), iTextSelection.getLength());
            }
        }
    }

    public ISelection getSelection() {
        if (this.fTextWidget != null && this.fTextWidget.getBlockSelection()) {
            int[] nArray = this.fTextWidget.getSelectionRanges();
            int n = nArray[0];
            int n2 = nArray[nArray.length - 2] + nArray[nArray.length - 1];
            Rectangle rectangle = this.fTextWidget.getBlockSelectionBounds();
            int n3 = this.fTextWidget.getHorizontalPixel();
            int n4 = rectangle.x - n3;
            int n5 = rectangle.x + rectangle.width - n3;
            int n6 = this.getAverageCharWidth();
            int n7 = this.computeVirtualChars(n, n4, n6);
            int n8 = this.computeVirtualChars(n2, n5, n6);
            IDocument iDocument = this.getDocument();
            Point point = this.widgetSelection2ModelSelection(new Point(n, n2 - n));
            if (point == null) {
                return TextSelection.emptySelection();
            }
            n = point.x;
            n2 = point.x + point.y;
            try {
                int n9 = iDocument.getLineOfOffset(n);
                int n10 = iDocument.getLineOfOffset(n2);
                int n11 = n - iDocument.getLineOffset(n9) + n7;
                int n12 = n2 - iDocument.getLineOffset(n10) + n8;
                if (n9 == -1 || n10 == -1) {
                    return TextSelection.emptySelection();
                }
                return new BlockTextSelection(iDocument, n9, n11, n10, n12, this.fTextWidget.getTabs());
            }
            catch (BadLocationException badLocationException) {
                return TextSelection.emptySelection();
            }
        }
        Point point = this.getSelectedRange();
        if (point.x == -1 || point.y == -1) {
            return TextSelection.emptySelection();
        }
        return new TextSelection(this.getDocument(), point.x, point.y);
    }

    private int computeVirtualChars(int n, int n2, int n3) {
        int n4 = n2 - this.fTextWidget.getLocationAtOffset((int)n).x;
        return n4 > 0 ? n4 / n3 : 0;
    }

    @Override
    public ISelectionProvider getSelectionProvider() {
        return this;
    }

    public void addPostSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        Assert.isNotNull((Object)iSelectionChangedListener);
        if (this.fPostSelectionChangedListeners == null) {
            this.fPostSelectionChangedListeners = new ArrayList();
        }
        if (!this.fPostSelectionChangedListeners.contains(iSelectionChangedListener)) {
            this.fPostSelectionChangedListeners.add(iSelectionChangedListener);
        }
    }

    public void removePostSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        Assert.isNotNull((Object)iSelectionChangedListener);
        if (this.fPostSelectionChangedListeners != null) {
            this.fPostSelectionChangedListeners.remove(iSelectionChangedListener);
            if (this.fPostSelectionChangedListeners.size() == 0) {
                this.fPostSelectionChangedListeners = null;
            }
        }
    }

    private Display getDisplay() {
        if (this.fTextWidget == null || this.fTextWidget.isDisposed()) {
            return null;
        }
        Display display = this.fTextWidget.getDisplay();
        if (display != null && display.isDisposed()) {
            return null;
        }
        return display;
    }

    private void queuePostSelectionChanged(final boolean bl) {
        Display display = this.getDisplay();
        if (display == null) {
            return;
        }
        this.fNumberOfPostSelectionChangedEvents[0] = this.fNumberOfPostSelectionChangedEvents[0] + 1;
        display.timerExec(this.getEmptySelectionChangedEventDelay(), new Runnable(){
            final int id;
            {
                this.id = TextViewer.this.fNumberOfPostSelectionChangedEvents[0];
            }

            @Override
            public void run() {
                Point point;
                if (this.id == TextViewer.this.fNumberOfPostSelectionChangedEvents[0] && TextViewer.this.getDisplay() != null && (point = TextViewer.this.fTextWidget.getSelectionRange()) != null) {
                    IRegion iRegion = TextViewer.this.widgetRange2ModelRange((IRegion)new Region(point.x, point.y));
                    if (bl || iRegion != null && !iRegion.equals(TextViewer.this.fLastSentPostSelectionChange) || iRegion == null) {
                        TextViewer.this.fLastSentPostSelectionChange = iRegion;
                        TextViewer.this.firePostSelectionChanged(point.x, point.y);
                    }
                }
            }
        });
    }

    protected void firePostSelectionChanged(int n, int n2) {
        if (this.redraws()) {
            IRegion iRegion = this.widgetRange2ModelRange((IRegion)new Region(n, n2));
            ITextSelection iTextSelection = iRegion != null ? new TextSelection(this.getDocument(), iRegion.getOffset(), iRegion.getLength()) : TextSelection.emptySelection();
            SelectionChangedEvent selectionChangedEvent = new SelectionChangedEvent((ISelectionProvider)this, (ISelection)iTextSelection);
            this.firePostSelectionChanged(selectionChangedEvent);
        }
    }

    protected void selectionChanged(int n, int n2) {
        this.queuePostSelectionChanged(true);
        this.fireSelectionChanged(n, n2);
    }

    protected void fireSelectionChanged(int n, int n2) {
        if (this.redraws()) {
            IRegion iRegion;
            if (n2 < 0) {
                n2 = -n2;
                n += n2;
            }
            if ((iRegion = this.widgetRange2ModelRange((IRegion)new Region(n, n2))) != null && !iRegion.equals(this.fLastSentSelectionChange) || iRegion == null) {
                this.fLastSentSelectionChange = iRegion;
                ITextSelection iTextSelection = iRegion != null ? new TextSelection(this.getDocument(), iRegion.getOffset(), iRegion.getLength()) : TextSelection.emptySelection();
                SelectionChangedEvent selectionChangedEvent = new SelectionChangedEvent((ISelectionProvider)this, (ISelection)iTextSelection);
                this.fireSelectionChanged(selectionChangedEvent);
            }
        }
    }

    private void firePostSelectionChanged(SelectionChangedEvent selectionChangedEvent) {
        ArrayList arrayList = this.fPostSelectionChangedListeners;
        if (arrayList != null) {
            arrayList = new ArrayList(arrayList);
            int n = 0;
            while (n < arrayList.size()) {
                ISelectionChangedListener iSelectionChangedListener = (ISelectionChangedListener)arrayList.get(n);
                iSelectionChangedListener.selectionChanged(selectionChangedEvent);
                ++n;
            }
        }
    }

    protected void markChanged(int n, int n2) {
        if (this.redraws()) {
            Object object;
            if (n != -1) {
                object = this.widgetRange2ModelRange((IRegion)new Region(n, n2));
                n = object.getOffset();
                n2 = object.getLength();
            }
            object = new MarkSelection(this.getDocument(), n, n2);
            SelectionChangedEvent selectionChangedEvent = new SelectionChangedEvent((ISelectionProvider)this, (ISelection)object);
            this.fireSelectionChanged(selectionChangedEvent);
        }
    }

    @Override
    public void addTextListener(ITextListener iTextListener) {
        Assert.isNotNull((Object)iTextListener);
        if (this.fTextListeners == null) {
            this.fTextListeners = new ArrayList();
        }
        if (!this.fTextListeners.contains(iTextListener)) {
            this.fTextListeners.add(iTextListener);
        }
    }

    @Override
    public void removeTextListener(ITextListener iTextListener) {
        Assert.isNotNull((Object)iTextListener);
        if (this.fTextListeners != null) {
            this.fTextListeners.remove(iTextListener);
            if (this.fTextListeners.size() == 0) {
                this.fTextListeners = null;
            }
        }
    }

    protected void updateTextListeners(WidgetCommand widgetCommand) {
        ArrayList arrayList = this.fTextListeners;
        if (arrayList != null) {
            arrayList = new ArrayList(arrayList);
            DocumentEvent documentEvent = widgetCommand.event;
            if (documentEvent instanceof SlaveDocumentEvent) {
                documentEvent = ((SlaveDocumentEvent)documentEvent).getMasterEvent();
            }
            TextEvent textEvent = new TextEvent(widgetCommand.start, widgetCommand.length, widgetCommand.text, widgetCommand.preservedText, documentEvent, this.redraws());
            int n = 0;
            while (n < arrayList.size()) {
                ITextListener iTextListener = (ITextListener)arrayList.get(n);
                iTextListener.textChanged(textEvent);
                ++n;
            }
        }
    }

    @Override
    public void addTextInputListener(ITextInputListener iTextInputListener) {
        Assert.isNotNull((Object)iTextInputListener);
        if (this.fTextInputListeners == null) {
            this.fTextInputListeners = new ArrayList();
        }
        if (!this.fTextInputListeners.contains(iTextInputListener)) {
            this.fTextInputListeners.add(iTextInputListener);
        }
    }

    @Override
    public void removeTextInputListener(ITextInputListener iTextInputListener) {
        Assert.isNotNull((Object)iTextInputListener);
        if (this.fTextInputListeners != null) {
            this.fTextInputListeners.remove(iTextInputListener);
            if (this.fTextInputListeners.size() == 0) {
                this.fTextInputListeners = null;
            }
        }
    }

    protected void fireInputDocumentAboutToBeChanged(IDocument iDocument, IDocument iDocument2) {
        List list = this.fTextInputListeners;
        if (list != null) {
            int n = 0;
            while (n < list.size()) {
                ITextInputListener iTextInputListener = (ITextInputListener)list.get(n);
                iTextInputListener.inputDocumentAboutToBeChanged(iDocument, iDocument2);
                ++n;
            }
        }
    }

    protected void fireInputDocumentChanged(IDocument iDocument, IDocument iDocument2) {
        List list = this.fTextInputListeners;
        if (list != null) {
            int n = 0;
            while (n < list.size()) {
                ITextInputListener iTextInputListener = (ITextInputListener)list.get(n);
                iTextInputListener.inputDocumentChanged(iDocument, iDocument2);
                ++n;
            }
        }
    }

    public Object getInput() {
        return this.getDocument();
    }

    @Override
    public IDocument getDocument() {
        return this.fDocument;
    }

    public void setInput(Object object) {
        IDocument iDocument = null;
        if (object instanceof IDocument) {
            iDocument = (IDocument)object;
        }
        this.setDocument(iDocument);
    }

    @Override
    public void setDocument(IDocument iDocument) {
        this.fReplaceTextPresentation = true;
        this.fireInputDocumentAboutToBeChanged(this.fDocument, iDocument);
        IDocument iDocument2 = this.fDocument;
        this.fDocument = iDocument;
        this.setVisibleDocument(this.fDocument);
        this.resetPlugins();
        this.inputChanged(this.fDocument, iDocument2);
        this.fireInputDocumentChanged(iDocument2, this.fDocument);
        this.fLastSentSelectionChange = null;
        this.fReplaceTextPresentation = false;
    }

    @Override
    public void setDocument(IDocument iDocument, int n, int n2) {
        this.fReplaceTextPresentation = true;
        this.fireInputDocumentAboutToBeChanged(this.fDocument, iDocument);
        IDocument iDocument2 = this.fDocument;
        this.fDocument = iDocument;
        try {
            IDocument iDocument3 = this.createSlaveDocument(iDocument);
            this.updateSlaveDocument(iDocument3, n, n2);
            this.setVisibleDocument(iDocument3);
        }
        catch (BadLocationException badLocationException) {
            throw new IllegalArgumentException(JFaceTextMessages.getString("TextViewer.error.invalid_visible_region_1"));
        }
        this.resetPlugins();
        this.inputChanged(this.fDocument, iDocument2);
        this.fireInputDocumentChanged(iDocument2, this.fDocument);
        this.fLastSentSelectionChange = null;
        this.fReplaceTextPresentation = false;
    }

    protected IDocument createSlaveDocument(IDocument iDocument) {
        ISlaveDocumentManager iSlaveDocumentManager = this.getSlaveDocumentManager();
        if (iSlaveDocumentManager != null) {
            if (iSlaveDocumentManager.isSlaveDocument(iDocument)) {
                return iDocument;
            }
            return iSlaveDocumentManager.createSlaveDocument(iDocument);
        }
        return iDocument;
    }

    protected boolean updateVisibleDocument(IDocument iDocument, int n, int n2) throws BadLocationException {
        if (iDocument instanceof ChildDocument) {
            ChildDocument childDocument = (ChildDocument)iDocument;
            IDocument iDocument2 = childDocument.getParentDocument();
            int n3 = iDocument2.getLineOfOffset(n);
            int n4 = iDocument2.getLineOffset(n3);
            int n5 = n - n4 + n2;
            Position position = childDocument.getParentDocumentRange();
            if (n4 != position.getOffset() || n5 != position.getLength()) {
                childDocument.setParentDocumentRange(n4, n5);
                return true;
            }
        }
        return false;
    }

    protected boolean updateSlaveDocument(IDocument iDocument, int n, int n2) throws BadLocationException {
        return this.updateVisibleDocument(iDocument, n, n2);
    }

    private void initializeViewportUpdate() {
        if (this.fViewportGuard != null) {
            return;
        }
        if (this.fTextWidget != null) {
            this.fViewportGuard = new ViewportGuard();
            this.fLastTopPixel = -1;
            this.fTextWidget.addKeyListener((KeyListener)this.fViewportGuard);
            this.fTextWidget.addMouseListener((MouseListener)this.fViewportGuard);
            this.fScroller = this.fTextWidget.getVerticalBar();
            if (this.fScroller != null) {
                this.fScroller.addSelectionListener((SelectionListener)this.fViewportGuard);
            }
        }
    }

    private void removeViewPortUpdate() {
        if (this.fTextWidget != null) {
            this.fTextWidget.removeKeyListener((KeyListener)this.fViewportGuard);
            this.fTextWidget.removeMouseListener((MouseListener)this.fViewportGuard);
            if (this.fScroller != null && !this.fScroller.isDisposed()) {
                this.fScroller.removeSelectionListener((SelectionListener)this.fViewportGuard);
                this.fScroller = null;
            }
            this.fViewportGuard = null;
        }
    }

    @Override
    public void addViewportListener(IViewportListener iViewportListener) {
        if (this.fViewportListeners == null) {
            this.fViewportListeners = new ArrayList();
            this.initializeViewportUpdate();
        }
        if (!this.fViewportListeners.contains(iViewportListener)) {
            this.fViewportListeners.add(iViewportListener);
        }
    }

    @Override
    public void removeViewportListener(IViewportListener iViewportListener) {
        if (this.fViewportListeners != null) {
            this.fViewportListeners.remove(iViewportListener);
        }
    }

    protected void updateViewportListeners(int n) {
        int n2;
        if (this.redraws() && (n2 = this.fTextWidget.getTopPixel()) >= 0 && n2 != this.fLastTopPixel) {
            if (this.fViewportListeners != null) {
                int n3 = 0;
                while (n3 < this.fViewportListeners.size()) {
                    IViewportListener iViewportListener = (IViewportListener)this.fViewportListeners.get(n3);
                    iViewportListener.viewportChanged(n2);
                    ++n3;
                }
            }
            this.fLastTopPixel = n2;
        }
    }

    @Override
    public int getTopIndex() {
        if (this.fTextWidget != null) {
            int n = this.fTextWidget.getTopIndex();
            return this.widgetLine2ModelLine(n);
        }
        return -1;
    }

    @Override
    public void setTopIndex(int n) {
        if (this.fTextWidget != null) {
            int n2 = this.modelLine2WidgetLine(n);
            if (n2 == -1) {
                n2 = this.getClosestWidgetLineForModelLine(n);
            }
            if (n2 > -1) {
                this.fTextWidget.setTopIndex(n2);
                this.updateViewportListeners(6);
            }
        }
    }

    protected int getVisibleLinesInViewport() {
        Rectangle rectangle;
        if (this.fTextWidget != null && !(rectangle = this.fTextWidget.getClientArea()).isEmpty()) {
            return rectangle.height / this.fTextWidget.getLineHeight();
        }
        return -1;
    }

    @Override
    public int getBottomIndex() {
        if (this.fTextWidget == null) {
            return -1;
        }
        int n = JFaceTextUtil.getBottomIndex(this.fTextWidget);
        return this.widgetLine2ModelLine(n);
    }

    @Override
    public int getTopIndexStartOffset() {
        if (this.fTextWidget != null) {
            int n = this.fTextWidget.getTopIndex();
            try {
                n = this.getVisibleDocument().getLineOffset(n);
                return this.widgetOffset2ModelOffset(n);
            }
            catch (BadLocationException badLocationException) {}
        }
        return -1;
    }

    @Override
    public int getBottomIndexEndOffset() {
        IRegion iRegion;
        int n;
        block3: {
            try {
                IRegion iRegion2 = this.getDocument().getLineInformation(this.getBottomIndex());
                n = iRegion2.getOffset() + iRegion2.getLength() - 1;
                iRegion = this.getModelCoverage();
                if (iRegion != null) break block3;
                return -1;
            }
            catch (BadLocationException badLocationException) {
                return this.getDocument().getLength() - 1;
            }
        }
        int n2 = iRegion.getOffset() + iRegion.getLength() - 1;
        return Math.min(n2, n);
    }

    @Override
    public void revealRange(int n, int n2) {
        if (this.fTextWidget == null || !this.redraws()) {
            return;
        }
        Region region = new Region(n, n2);
        IRegion iRegion = this.modelRange2ClosestWidgetRange((IRegion)region);
        if (iRegion != null) {
            int[] nArray = new int[]{iRegion.getOffset(), iRegion.getLength()};
            this.validateSelectionRange(nArray);
            if (nArray[0] >= 0) {
                this.internalRevealRangeWithWorkaround(nArray[0], nArray[0] + nArray[1]);
            }
        } else {
            IRegion iRegion2 = this.getModelCoverage();
            int n3 = iRegion2 == null || n < iRegion2.getOffset() ? 0 : this.getVisibleDocument().getLength();
            this.internalRevealRangeWithWorkaround(n3, n3);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void internalRevealRangeWithWorkaround(int var1_1, int var2_2) {
        var3_3 = this.fTextWidget.getShell();
        var4_4 = 0;
        while (var3_3.isLayoutDeferred()) {
            var3_3.setLayoutDeferred(false);
            ++var4_4;
        }
        try {
            this.internalRevealRange(var1_1, var2_2);
            if (true) ** GOTO lbl19
        }
        catch (Throwable var5_5) {
            ** while (var4_4 > 0)
        }
lbl-1000:
        // 1 sources

        {
            var3_3.setLayoutDeferred(true);
            --var4_4;
            continue;
        }
lbl15:
        // 1 sources

        throw var5_5;
        do {
            var3_3.setLayoutDeferred(true);
            --var4_4;
lbl19:
            // 2 sources

        } while (var4_4 > 0);
    }

    protected void internalRevealRange(int n, int n2) {
        try {
            IDocument iDocument = this.getVisibleDocument();
            int n3 = iDocument.getLineOfOffset(n);
            int n4 = iDocument.getLineOfOffset(n2);
            int n5 = this.fTextWidget.getTopIndex();
            if (n5 > -1) {
                IRegion iRegion;
                int n6;
                int n7 = JFaceTextUtil.getBottomIndex(this.fTextWidget);
                int n8 = n7 - n5;
                if (n3 < n5 || n3 > n7 || n4 < n5 || n4 > n7) {
                    n6 = Math.max(0, n8 - (n4 - n3));
                    this.fTextWidget.setTopIndex(n3 - n6 / 3);
                    this.updateViewportListeners(6);
                }
                if (n4 < n3) {
                    n4 += n3;
                    n3 = n4 - n3;
                    n4 -= n3;
                }
                n6 = -1;
                int n9 = -1;
                if (n4 > n3) {
                    iRegion = this.getExtent(n, n);
                    n9 = n6 = iRegion.getOffset() + this.fTextWidget.getHorizontalPixel();
                } else {
                    iRegion = this.getExtent(n, n2);
                    n6 = iRegion.getOffset() + this.fTextWidget.getHorizontalPixel();
                    n9 = n6 + iRegion.getLength();
                }
                int n10 = this.fTextWidget.getHorizontalPixel();
                int n11 = n10 + this.fTextWidget.getClientArea().width;
                if (n6 < n10 || n11 < n9) {
                    int n12 = 10;
                    int n13 = n10;
                    int n14 = n11 - n10;
                    int n15 = n9 - n6;
                    n13 = n6 < n10 ? n6 : (n15 + n12 < n14 ? n9 + n12 - n14 : n6);
                    float f = (float)n13 / (float)this.getAverageCharWidth();
                    this.fTextWidget.setHorizontalIndex(Math.round(f));
                }
            }
        }
        catch (BadLocationException badLocationException) {
            throw new IllegalArgumentException(JFaceTextMessages.getString("TextViewer.error.invalid_range"));
        }
    }

    protected final int getWidthInPixels(String string) {
        GC gC = new GC((Drawable)this.fTextWidget);
        gC.setFont(this.fTextWidget.getFont());
        Point point = gC.textExtent(string);
        gC.dispose();
        return point.x;
    }

    protected final IRegion getExtent(int n, int n2) {
        if (n2 > 0 && n < n2) {
            Rectangle rectangle = this.fTextWidget.getTextBounds(n, n2 - 1);
            return new Region(rectangle.x, rectangle.width);
        }
        return new Region(this.fTextWidget.getLocationAtOffset((int)n).x, 0);
    }

    protected final int getWidthInPixels(int n, int n2) {
        return this.getExtent(n, n + n2).getLength();
    }

    protected final int getAverageCharWidth() {
        return JFaceTextUtil.getAverageCharWidth((Control)this.getTextWidget());
    }

    public void refresh() {
        this.setDocument(this.getDocument());
    }

    protected ISlaveDocumentManager getSlaveDocumentManager() {
        if (this.fSlaveDocumentManager == null) {
            this.fSlaveDocumentManager = this.createSlaveDocumentManager();
        }
        return this.fSlaveDocumentManager;
    }

    protected ISlaveDocumentManager createSlaveDocumentManager() {
        return new ChildDocumentManager();
    }

    @Override
    public final void invalidateTextPresentation() {
        if (this.fVisibleDocument != null) {
            this.fWidgetCommand.event = null;
            this.fWidgetCommand.start = 0;
            this.fWidgetCommand.length = this.fVisibleDocument.getLength();
            this.fWidgetCommand.text = this.fVisibleDocument.get();
            this.updateTextListeners(this.fWidgetCommand);
        }
    }

    @Override
    public final void invalidateTextPresentation(int n, int n2) {
        IRegion iRegion;
        if (this.fVisibleDocument != null && (iRegion = this.modelRange2WidgetRange((IRegion)new Region(n, n2))) != null) {
            this.fWidgetCommand.event = null;
            this.fWidgetCommand.start = iRegion.getOffset();
            this.fWidgetCommand.length = iRegion.getLength();
            try {
                this.fWidgetCommand.text = this.fVisibleDocument.get(iRegion.getOffset(), iRegion.getLength());
                this.updateTextListeners(this.fWidgetCommand);
            }
            catch (BadLocationException badLocationException) {}
        }
    }

    private void initializeWidgetContents() {
        if (this.fTextWidget != null && this.fVisibleDocument != null) {
            if (this.fDocumentAdapter == null) {
                this.fDocumentAdapter = this.createDocumentAdapter();
            }
            this.fDocumentAdapter.setDocument(this.fVisibleDocument);
            this.fTextWidget.setContent((StyledTextContent)this.fDocumentAdapter);
            this.invalidateTextPresentation();
        }
    }

    protected void freeSlaveDocument(IDocument iDocument) {
        ISlaveDocumentManager iSlaveDocumentManager = this.getSlaveDocumentManager();
        if (iSlaveDocumentManager != null && iSlaveDocumentManager.isSlaveDocument(iDocument)) {
            iSlaveDocumentManager.freeSlaveDocument(iDocument);
        }
    }

    protected void setVisibleDocument(IDocument iDocument) {
        if (this.fVisibleDocument == iDocument && this.fVisibleDocument instanceof ChildDocument) {
            return;
        }
        if (this.fVisibleDocument != null) {
            if (this.fVisibleDocumentListener != null) {
                this.fVisibleDocument.removeDocumentListener((IDocumentListener)this.fVisibleDocumentListener);
            }
            if (this.fVisibleDocument != iDocument) {
                this.freeSlaveDocument(this.fVisibleDocument);
            }
        }
        this.fVisibleDocument = iDocument;
        this.initializeDocumentInformationMapping(this.fVisibleDocument);
        this.initializeWidgetContents();
        this.fFindReplaceDocumentAdapter = null;
        if (this.fVisibleDocument != null && this.fVisibleDocumentListener != null) {
            this.fVisibleDocument.addDocumentListener((IDocumentListener)this.fVisibleDocumentListener);
        }
    }

    protected void handleVisibleDocumentAboutToBeChanged(DocumentEvent documentEvent) {
    }

    protected void handleVisibleDocumentChanged(DocumentEvent documentEvent) {
    }

    protected void initializeDocumentInformationMapping(IDocument iDocument) {
        ISlaveDocumentManager iSlaveDocumentManager = this.getSlaveDocumentManager();
        this.fInformationMapping = iSlaveDocumentManager == null ? null : iSlaveDocumentManager.createMasterSlaveMapping(iDocument);
    }

    protected IDocument getVisibleDocument() {
        return this.fVisibleDocument;
    }

    protected int _getVisibleRegionOffset() {
        IDocument iDocument = this.getVisibleDocument();
        if (iDocument instanceof ChildDocument) {
            ChildDocument childDocument = (ChildDocument)iDocument;
            return childDocument.getParentDocumentRange().getOffset();
        }
        return 0;
    }

    @Override
    public IRegion getVisibleRegion() {
        IDocument iDocument = this.getVisibleDocument();
        if (iDocument instanceof ChildDocument) {
            Position position = ((ChildDocument)iDocument).getParentDocumentRange();
            return new Region(position.getOffset(), position.getLength());
        }
        return new Region(0, iDocument == null ? 0 : iDocument.getLength());
    }

    @Override
    public boolean overlapsWithVisibleRegion(int n, int n2) {
        IDocument iDocument = this.getVisibleDocument();
        if (iDocument instanceof ChildDocument) {
            ChildDocument childDocument = (ChildDocument)iDocument;
            return childDocument.getParentDocumentRange().overlapsWith(n, n2);
        }
        if (iDocument != null) {
            int n3 = iDocument.getLength();
            return n >= 0 && n2 >= 0 && n + n2 <= n3;
        }
        return false;
    }

    @Override
    public void setVisibleRegion(int n, int n2) {
        IRegion iRegion = this.getVisibleRegion();
        if (n == iRegion.getOffset() && n2 == iRegion.getLength()) {
            return;
        }
        this.setRedraw(false);
        try {
            try {
                IDocument iDocument = this.createSlaveDocument(this.getVisibleDocument());
                if (this.updateSlaveDocument(iDocument, n, n2)) {
                    this.setVisibleDocument(iDocument);
                }
            }
            catch (BadLocationException badLocationException) {
                throw new IllegalArgumentException(JFaceTextMessages.getString("TextViewer.error.invalid_visible_region_2"));
            }
        }
        finally {
            this.setRedraw(true);
        }
    }

    @Override
    public void resetVisibleRegion() {
        IDocument iDocument;
        IDocument iDocument2;
        ISlaveDocumentManager iSlaveDocumentManager = this.getSlaveDocumentManager();
        if (iSlaveDocumentManager != null && (iDocument2 = iSlaveDocumentManager.getMasterDocument(iDocument = this.getVisibleDocument())) != null) {
            this.setVisibleDocument(iDocument2);
            iSlaveDocumentManager.freeSlaveDocument(iDocument);
        }
    }

    @Override
    public void setTextDoubleClickStrategy(ITextDoubleClickStrategy iTextDoubleClickStrategy, String string) {
        if (iTextDoubleClickStrategy != null) {
            if (this.fDoubleClickStrategies == null) {
                this.fDoubleClickStrategies = new HashMap();
            }
            this.fDoubleClickStrategies.put(string, iTextDoubleClickStrategy);
        } else if (this.fDoubleClickStrategies != null) {
            this.fDoubleClickStrategies.remove(string);
        }
    }

    protected Object selectContentTypePlugin(int n, Map map) {
        IDocument iDocument = this.getDocument();
        if (iDocument == null) {
            return null;
        }
        try {
            return this.selectContentTypePlugin(TextUtilities.getContentType((IDocument)iDocument, (String)this.getDocumentPartitioning(), (int)n, (boolean)true), map);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    private Object selectContentTypePlugin(String string, Map map) {
        if (map == null) {
            return null;
        }
        return map.get(string);
    }

    protected void customizeDocumentCommand(DocumentCommand documentCommand) {
        ArrayList arrayList;
        if (this.isIgnoringAutoEditStrategies()) {
            return;
        }
        IDocument iDocument = this.getDocument();
        if (this.fTabsToSpacesConverter != null) {
            this.fTabsToSpacesConverter.customizeDocumentCommand(iDocument, documentCommand);
        }
        if ((arrayList = (ArrayList)this.selectContentTypePlugin(documentCommand.offset, this.fAutoIndentStrategies)) == null) {
            return;
        }
        switch (arrayList.size()) {
            case 0: {
                break;
            }
            case 1: {
                ((IAutoEditStrategy)arrayList.iterator().next()).customizeDocumentCommand(iDocument, documentCommand);
                break;
            }
            default: {
                arrayList = new ArrayList(arrayList);
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    ((IAutoEditStrategy)iterator.next()).customizeDocumentCommand(iDocument, documentCommand);
                }
                break block0;
            }
        }
    }

    protected void handleVerifyEvent(VerifyEvent verifyEvent) {
        IRegion iRegion;
        if (this.fEventConsumer != null) {
            this.fEventConsumer.processEvent(verifyEvent);
            if (!verifyEvent.doit) {
                return;
            }
        }
        if (this.fTextWidget.getBlockSelection() && (verifyEvent.text == null || verifyEvent.text.length() < 2)) {
            iRegion = this.fTextWidget.getSelection();
            if (this.fTextWidget.getLineAtOffset(iRegion.x) != this.fTextWidget.getLineAtOffset(iRegion.y)) {
                this.verifyEventInBlockSelection(verifyEvent);
                return;
            }
        }
        iRegion = this.event2ModelRange(verifyEvent);
        this.fDocumentCommand.setEvent(verifyEvent, iRegion);
        this.customizeDocumentCommand(this.fDocumentCommand);
        if (!this.fDocumentCommand.fillEvent(verifyEvent, iRegion)) {
            boolean bl = this.fDocumentCommand.getCommandCount() > 1;
            try {
                try {
                    this.fVerifyListener.forward(false);
                    if (bl && this.fUndoManager != null) {
                        this.fUndoManager.beginCompoundChange();
                    }
                    this.fDocumentCommand.execute(this.getDocument());
                    if (this.fTextWidget != null) {
                        IRegion iRegion2;
                        int n;
                        int n2 = this.fDocumentCommand.caretOffset;
                        if (n2 == -1) {
                            n2 = this.fDocumentCommand.offset + (this.fDocumentCommand.text == null ? 0 : this.fDocumentCommand.text.length());
                        }
                        if ((n = this.modelOffset2WidgetOffset(n2)) == -1 && (iRegion2 = this.getModelCoverage()) != null) {
                            if (n2 <= iRegion2.getOffset()) {
                                n = 0;
                            } else if (n2 >= iRegion2.getOffset() + iRegion2.getLength()) {
                                n = this.getVisibleRegion().getLength();
                            }
                        }
                        if (n != -1) {
                            this.fTextWidget.setCaretOffset(n);
                        }
                        this.fTextWidget.showSelection();
                    }
                }
                catch (BadLocationException badLocationException) {
                    if (bl && this.fUndoManager != null) {
                        this.fUndoManager.endCompoundChange();
                    }
                    this.fVerifyListener.forward(true);
                }
            }
            finally {
                if (bl && this.fUndoManager != null) {
                    this.fUndoManager.endCompoundChange();
                }
                this.fVerifyListener.forward(true);
            }
        }
    }

    private void verifyEventInBlockSelection(final VerifyEvent verifyEvent) {
        verifyEvent.doit = false;
        boolean bl = verifyEvent.time != this.fLastEventTime;
        this.fLastEventTime = verifyEvent.time;
        if (bl) {
            this.wrapCompoundChange(new Runnable(){

                @Override
                public void run() {
                    SelectionProcessor selectionProcessor = new SelectionProcessor(TextViewer.this);
                    try {
                        ISelection iSelection = TextViewer.this.getSelection();
                        int n = verifyEvent.text.length();
                        if (n == 0 && verifyEvent.character == '\u0000') {
                            TextEdit textEdit = selectionProcessor.backspace(iSelection);
                            textEdit.apply(TextViewer.this.fDocument, 2);
                            ISelection iSelection2 = selectionProcessor.makeEmpty(iSelection, true);
                            TextViewer.this.setSelection(iSelection2);
                        } else {
                            int n2 = selectionProcessor.getCoveredLines(iSelection);
                            String string = TextViewer.this.fDocument.getLegalLineDelimiters()[0];
                            StringBuffer stringBuffer = new StringBuffer(n2 * n + (n2 - 1) * string.length());
                            stringBuffer.append(verifyEvent.text);
                            int n3 = 0;
                            while (n3 < n2 - 1) {
                                stringBuffer.append(string);
                                stringBuffer.append(verifyEvent.text);
                                ++n3;
                            }
                            selectionProcessor.doReplace(iSelection, stringBuffer.toString());
                        }
                    }
                    catch (BadLocationException badLocationException) {}
                }
            });
        }
    }

    private boolean isMarkedRegionEmpty() {
        return this.fTextWidget == null || this.fMarkPosition == null || this.fMarkPosition.isDeleted() || this.modelRange2WidgetRange(this.fMarkPosition) == null;
    }

    @Override
    public boolean canDoOperation(int n) {
        if (this.fTextWidget == null || !this.redraws()) {
            return false;
        }
        switch (n) {
            case 3: {
                return this.isEditable() && (this.fTextWidget.getSelectionCount() > 0 || !this.isMarkedRegionEmpty());
            }
            case 4: {
                return this.fTextWidget.getSelectionCount() > 0 || !this.isMarkedRegionEmpty();
            }
            case 5: 
            case 6: {
                return this.isEditable();
            }
            case 7: {
                return true;
            }
            case 8: 
            case 9: {
                return this.isEditable() && this.fIndentChars != null && this.areMultipleLinesSelected();
            }
            case 11: 
            case 12: {
                return this.isEditable() && this.fDefaultPrefixChars != null;
            }
            case 1: {
                return this.fUndoManager != null && this.fUndoManager.undoable();
            }
            case 2: {
                return this.fUndoManager != null && this.fUndoManager.redoable();
            }
            case 10: {
                return this.isPrintable();
            }
            case 23: {
                return this.fHyperlinkManager != null;
            }
        }
        return false;
    }

    @Override
    public void doOperation(int n) {
        if (this.fTextWidget == null || !this.redraws()) {
            return;
        }
        Point point = null;
        switch (n) {
            case 1: {
                if (this.fUndoManager == null) break;
                this.ignoreAutoEditStrategies(true);
                this.fUndoManager.undo();
                this.ignoreAutoEditStrategies(false);
                break;
            }
            case 2: {
                if (this.fUndoManager == null) break;
                this.ignoreAutoEditStrategies(true);
                this.fUndoManager.redo();
                this.ignoreAutoEditStrategies(false);
                break;
            }
            case 3: {
                if (this.fTextWidget.getSelectionCount() == 0) {
                    this.copyMarkedRegion(true);
                } else {
                    this.wrapCompoundChange(new Runnable(){

                        @Override
                        public void run() {
                            TextViewer.this.fTextWidget.cut();
                        }
                    });
                }
                point = this.fTextWidget.getSelectionRange();
                this.fireSelectionChanged(point.x, point.y);
                break;
            }
            case 4: {
                if (this.fTextWidget.getSelectionCount() == 0) {
                    this.copyMarkedRegion(false);
                    break;
                }
                this.fTextWidget.copy();
                break;
            }
            case 5: {
                this.paste();
                break;
            }
            case 6: {
                this.delete();
                break;
            }
            case 7: {
                IDocument iDocument = this.getDocument();
                if (iDocument == null) break;
                if (this.fTextWidget.getBlockSelection()) {
                    this.setSelection(new BlockTextSelection(iDocument, 0, 0, iDocument.getNumberOfLines() - 1, 1000, this.fTextWidget.getTabs()));
                    break;
                }
                this.setSelectedRange(0, iDocument.getLength());
                break;
            }
            case 8: {
                this.shift(false, true, false);
                break;
            }
            case 9: {
                this.shift(false, false, false);
                break;
            }
            case 11: {
                this.shift(true, true, true);
                break;
            }
            case 12: {
                this.shift(true, false, true);
                break;
            }
            case 10: {
                this.print();
                break;
            }
            case 23: {
                boolean bl = this.fHyperlinkManager.openHyperlink();
                if (!bl) {
                    MessageDialog.openInformation((Shell)this.getControl().getShell(), (String)JFaceTextMessages.getString("TextViewer.open_hyperlink_error_title"), (String)JFaceTextMessages.getString("TextViewer.open_hyperlink_error_message"));
                }
                return;
            }
        }
    }

    private void delete() {
        if (!this.fTextWidget.getBlockSelection()) {
            this.fTextWidget.invokeAction(127);
        } else {
            this.wrapCompoundChange(new Runnable(){

                @Override
                public void run() {
                    try {
                        new SelectionProcessor(TextViewer.this).doDelete(TextViewer.this.getSelection());
                    }
                    catch (BadLocationException badLocationException) {}
                }
            });
        }
        Point point = this.fTextWidget.getSelectionRange();
        this.fireSelectionChanged(point.x, point.y);
    }

    private void paste() {
        if (!this.fTextWidget.getBlockSelection()) {
            this.fTextWidget.paste();
        } else {
            this.wrapCompoundChange(new Runnable(){

                @Override
                public void run() {
                    SelectionProcessor selectionProcessor = new SelectionProcessor(TextViewer.this);
                    Clipboard clipboard = new Clipboard(TextViewer.this.getDisplay());
                    try {
                        try {
                            String string;
                            ISelection iSelection = TextViewer.this.getSelection();
                            TextTransfer textTransfer = TextTransfer.getInstance();
                            String string2 = (String)clipboard.getContents((Transfer)textTransfer, 1);
                            if (TextUtilities.indexOf((String[])TextViewer.this.fDocument.getLegalLineDelimiters(), (String)string2, (int)0)[0] != -1) {
                                string = string2;
                            } else {
                                int n = string2.length();
                                int n2 = selectionProcessor.getCoveredLines(iSelection);
                                String string3 = TextViewer.this.fDocument.getLegalLineDelimiters()[0];
                                StringBuffer stringBuffer = new StringBuffer(n2 * n + (n2 - 1) * string3.length());
                                stringBuffer.append(string2);
                                int n3 = 0;
                                while (n3 < n2 - 1) {
                                    stringBuffer.append(string3);
                                    stringBuffer.append(string2);
                                    ++n3;
                                }
                                string = stringBuffer.toString();
                            }
                            selectionProcessor.doReplace(iSelection, string);
                        }
                        catch (BadLocationException badLocationException) {
                            clipboard.dispose();
                        }
                    }
                    finally {
                        clipboard.dispose();
                    }
                }
            });
        }
        Point point = this.fTextWidget.getSelectionRange();
        this.fireSelectionChanged(point.x, point.y);
    }

    private void wrapCompoundChange(Runnable runnable) {
        if (!this.fTextWidget.getBlockSelection()) {
            runnable.run();
            return;
        }
        IRewriteTarget iRewriteTarget = this.getRewriteTarget();
        iRewriteTarget.beginCompoundChange();
        try {
            runnable.run();
        }
        finally {
            iRewriteTarget.endCompoundChange();
        }
    }

    protected void ignoreAutoEditStrategies(boolean bl) {
        if (this.fIgnoreAutoIndent == bl) {
            return;
        }
        this.fIgnoreAutoIndent = bl;
        IDocument iDocument = this.getDocument();
        if (iDocument instanceof IDocumentExtension2) {
            IDocumentExtension2 iDocumentExtension2 = (IDocumentExtension2)iDocument;
            if (bl) {
                iDocumentExtension2.ignorePostNotificationReplaces();
            } else {
                iDocumentExtension2.acceptPostNotificationReplaces();
            }
        }
    }

    protected boolean isIgnoringAutoEditStrategies() {
        return this.fIgnoreAutoIndent;
    }

    @Override
    public void enableOperation(int n, boolean bl) {
    }

    protected void copyMarkedRegion(boolean bl) {
        if (this.fTextWidget == null) {
            return;
        }
        if (this.fMarkPosition == null || this.fMarkPosition.isDeleted() || this.modelRange2WidgetRange(this.fMarkPosition) == null) {
            return;
        }
        int n = this.modelOffset2WidgetOffset(this.fMarkPosition.offset);
        Point point = this.fTextWidget.getSelection();
        if (point.x <= n) {
            this.fTextWidget.setSelection(point.x, n);
        } else {
            this.fTextWidget.setSelection(n, point.x);
        }
        if (bl) {
            this.wrapCompoundChange(new Runnable(){

                @Override
                public void run() {
                    TextViewer.this.fTextWidget.cut();
                }
            });
        } else {
            this.fTextWidget.copy();
            this.fTextWidget.setSelection(point.x);
        }
    }

    protected void deleteText() {
        this.fTextWidget.invokeAction(127);
    }

    protected boolean isBlockSelected() {
        Point point = this.getSelectedRange();
        if (point.y == 0) {
            return false;
        }
        try {
            IDocument iDocument = this.getDocument();
            int n = iDocument.getLineOfOffset(point.x);
            int n2 = iDocument.getLineOffset(n);
            return point.x == n2;
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    protected boolean areMultipleLinesSelected() {
        Point point = this.getSelectedRange();
        if (point.y == 0) {
            return false;
        }
        try {
            IDocument iDocument = this.getDocument();
            int n = iDocument.getLineOfOffset(point.x);
            int n2 = iDocument.getLineOfOffset(point.x + point.y);
            IRegion iRegion = iDocument.getLineInformation(n);
            return n != n2 || point.x == iRegion.getOffset() && point.y == iRegion.getLength();
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    private int getFirstCompleteLineOfRegion(IRegion iRegion) {
        try {
            IDocument iDocument = this.getDocument();
            int n = iDocument.getLineOfOffset(iRegion.getOffset());
            int n2 = iDocument.getLineOffset(n);
            if (n2 >= iRegion.getOffset()) {
                return n;
            }
            n2 = iDocument.getLineOffset(n + 1);
            return n2 > iRegion.getOffset() + iRegion.getLength() ? -1 : n + 1;
        }
        catch (BadLocationException badLocationException) {
            return -1;
        }
    }

    private IRegion getTextBlockFromSelection(ITextSelection iTextSelection) throws BadLocationException {
        IDocument iDocument = this.getDocument();
        int n = iDocument.getLineOffset(iTextSelection.getStartLine());
        int n2 = iTextSelection.getEndLine();
        int n3 = iDocument.getNumberOfLines() > n2 + 1 ? iDocument.getLineOffset(n2 + 1) : iDocument.getLength();
        return new Region(n, n3 - n);
    }

    protected void shift(boolean bl, boolean bl2) {
        this.shift(bl, bl2, false);
    }

    protected void shift(boolean bl, boolean bl2, boolean bl3) {
        block27: {
            if (this.fUndoManager != null) {
                this.fUndoManager.beginCompoundChange();
            }
            IDocument iDocument = this.getDocument();
            Map map = null;
            DocumentRewriteSession documentRewriteSession = null;
            try {
                try {
                    int n;
                    ITextSelection iTextSelection = (ITextSelection)this.getSelection();
                    IRegion iRegion = this.getTextBlockFromSelection(iTextSelection);
                    ITypedRegion[] iTypedRegionArray = TextUtilities.computePartitioning((IDocument)iDocument, (String)this.getDocumentPartitioning(), (int)iRegion.getOffset(), (int)iRegion.getLength(), (boolean)false);
                    int n2 = 0;
                    int[] nArray = new int[iTypedRegionArray.length * 2];
                    int n3 = 0;
                    int n4 = 0;
                    while (n3 < iTypedRegionArray.length) {
                        nArray[n4] = this.getFirstCompleteLineOfRegion((IRegion)iTypedRegionArray[n3]);
                        n = iTypedRegionArray[n3].getLength();
                        int n5 = iTypedRegionArray[n3].getOffset() + n;
                        if (n > 0) {
                            --n5;
                        }
                        nArray[n4 + 1] = nArray[n4] == -1 ? -1 : iDocument.getLineOfOffset(n5);
                        n2 += nArray[n4 + 1] - nArray[n4] + 1;
                        ++n3;
                        n4 += 2;
                    }
                    if (iDocument instanceof IDocumentExtension4) {
                        IDocumentExtension4 iDocumentExtension4 = (IDocumentExtension4)iDocument;
                        documentRewriteSession = iDocumentExtension4.startRewriteSession(DocumentRewriteSessionType.SEQUENTIAL);
                    } else {
                        this.setRedraw(false);
                        this.startSequentialRewriteMode(true);
                    }
                    if (n2 >= 20) {
                        map = TextUtilities.removeDocumentPartitioners((IDocument)iDocument);
                    }
                    Map map2 = bl ? this.fDefaultPrefixChars : this.fIndentChars;
                    n4 = 0;
                    n = 0;
                    while (n4 < iTypedRegionArray.length) {
                        String[] stringArray = (String[])this.selectContentTypePlugin(iTypedRegionArray[n4].getType(), map2);
                        if (stringArray != null && stringArray.length > 0 && nArray[n] >= 0 && nArray[n + 1] >= 0) {
                            if (bl2) {
                                this.shiftRight(nArray[n], nArray[n + 1], stringArray[0]);
                            } else {
                                this.shiftLeft(nArray[n], nArray[n + 1], stringArray, bl3);
                            }
                        }
                        ++n4;
                        n += 2;
                    }
                }
                catch (BadLocationException badLocationException) {
                    if (map != null) {
                        TextUtilities.addDocumentPartitioners((IDocument)iDocument, map);
                    }
                    if (iDocument instanceof IDocumentExtension4) {
                        IDocumentExtension4 iDocumentExtension4 = (IDocumentExtension4)iDocument;
                        iDocumentExtension4.stopRewriteSession(documentRewriteSession);
                    } else {
                        this.stopSequentialRewriteMode();
                        this.setRedraw(true);
                    }
                    if (this.fUndoManager != null) {
                        this.fUndoManager.endCompoundChange();
                    }
                    break block27;
                }
            }
            catch (Throwable throwable) {
                if (map != null) {
                    TextUtilities.addDocumentPartitioners((IDocument)iDocument, map);
                }
                if (iDocument instanceof IDocumentExtension4) {
                    IDocumentExtension4 iDocumentExtension4 = (IDocumentExtension4)iDocument;
                    iDocumentExtension4.stopRewriteSession(documentRewriteSession);
                } else {
                    this.stopSequentialRewriteMode();
                    this.setRedraw(true);
                }
                if (this.fUndoManager != null) {
                    this.fUndoManager.endCompoundChange();
                }
                throw throwable;
            }
            if (map != null) {
                TextUtilities.addDocumentPartitioners((IDocument)iDocument, (Map)map);
            }
            if (iDocument instanceof IDocumentExtension4) {
                IDocumentExtension4 iDocumentExtension4 = (IDocumentExtension4)iDocument;
                iDocumentExtension4.stopRewriteSession(documentRewriteSession);
            } else {
                this.stopSequentialRewriteMode();
                this.setRedraw(true);
            }
            if (this.fUndoManager != null) {
                this.fUndoManager.endCompoundChange();
            }
        }
    }

    private void shiftRight(int n, int n2, String string) {
        try {
            IDocument iDocument = this.getDocument();
            while (n <= n2) {
                iDocument.replace(iDocument.getLineOffset(n++), 0, string);
            }
        }
        catch (BadLocationException badLocationException) {}
    }

    private void shiftLeft(int n, int n2, String[] stringArray, boolean bl) {
        IDocument iDocument = this.getDocument();
        try {
            Object object;
            IRegion[] iRegionArray = new IRegion[n2 - n + 1];
            int n3 = 0;
            while (n3 < iRegionArray.length) {
                int n4;
                IRegion iRegion = iDocument.getLineInformation(n + n3);
                object = iDocument.get(iRegion.getOffset(), iRegion.getLength());
                int n5 = -1;
                int[] nArray = TextUtilities.indexOf((String[])stringArray, (String)object, (int)0);
                if (nArray[0] != -1) {
                    if (bl) {
                        String string = iDocument.get(iRegion.getOffset(), nArray[0]);
                        if ((string = string.trim()).length() == 0) {
                            n5 = iRegion.getOffset() + nArray[0];
                        }
                    } else if (nArray[0] == 0) {
                        n5 = iRegion.getOffset();
                    }
                }
                if (n5 > -1) {
                    n4 = stringArray[nArray[1]].length();
                    if (n4 == 0 && !bl && iRegion.getLength() > 0) {
                        return;
                    }
                } else {
                    return;
                }
                iRegionArray[n3] = new Region(n5, n4);
                ++n3;
            }
            n3 = 0;
            int n6 = 0;
            while (n6 < iRegionArray.length) {
                object = iRegionArray[n6];
                iDocument.replace(object.getOffset() - n3, object.getLength(), "");
                n3 += object.getLength();
                ++n6;
            }
        }
        catch (BadLocationException badLocationException) {}
    }

    protected boolean isPrintable() {
        return true;
    }

    @Override
    public void print(StyledTextPrintOptions styledTextPrintOptions) {
        Shell shell = this.fTextWidget.getShell();
        if (Printer.getPrinterList().length == 0) {
            String string = JFaceTextMessages.getString("TextViewer.warning.noPrinter.title");
            String string2 = JFaceTextMessages.getString("TextViewer.warning.noPrinter.message");
            MessageDialog.openWarning((Shell)shell, (String)string, (String)string2);
            return;
        }
        PrintDialog printDialog = new PrintDialog(shell, 32768);
        printDialog.setPrinterData(fgPrinterData);
        PrinterData printerData = printDialog.open();
        if (printerData != null) {
            final Printer printer = new Printer(printerData);
            final Runnable runnable = this.fTextWidget.print(printer, styledTextPrintOptions);
            Thread thread = new Thread("Printing"){

                @Override
                public void run() {
                    runnable.run();
                    printer.dispose();
                }
            };
            thread.start();
            fgPrinterData = printerData;
            TextViewer.fgPrinterData.startPage = 1;
            TextViewer.fgPrinterData.endPage = 1;
            TextViewer.fgPrinterData.scope = 0;
            TextViewer.fgPrinterData.copyCount = 1;
        }
    }

    protected void print() {
        StyledTextPrintOptions styledTextPrintOptions = new StyledTextPrintOptions();
        styledTextPrintOptions.printTextFontStyle = true;
        styledTextPrintOptions.printTextForeground = true;
        this.print(styledTextPrintOptions);
    }

    protected boolean canPerformFind() {
        IDocument iDocument = this.getVisibleDocument();
        return this.fTextWidget != null && iDocument != null && iDocument.getLength() > 0;
    }

    protected int findAndSelect(int n, String string, boolean bl, boolean bl2, boolean bl3) {
        try {
            return this.findAndSelect(n, string, bl, bl2, bl3, false);
        }
        catch (IllegalStateException illegalStateException) {
            return -1;
        }
        catch (PatternSyntaxException patternSyntaxException) {
            return -1;
        }
    }

    protected int findAndSelect(int n, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        if (this.fTextWidget == null) {
            return -1;
        }
        try {
            int n2 = n == -1 ? n : this.modelOffset2WidgetOffset(n);
            FindReplaceDocumentAdapter findReplaceDocumentAdapter = this.getFindReplaceDocumentAdapter();
            IRegion iRegion = findReplaceDocumentAdapter.find(n2, string, bl, bl2, bl3, bl4);
            if (iRegion != null) {
                int n3 = iRegion.getOffset();
                int n4 = iRegion.getLength();
                char c = findReplaceDocumentAdapter.charAt(n3);
                char c2 = findReplaceDocumentAdapter.charAt(n3 + n4 - 1);
                boolean bl5 = c == '\n' || c == '\r' || c2 == '\n' || c2 == '\r';
                boolean bl6 = this.redraws();
                if (bl5 && bl6) {
                    this.setRedraw(false);
                }
                if (this.redraws()) {
                    this.fTextWidget.setSelectionRange(n3, n4);
                    this.internalRevealRange(n3, n3 + n4);
                    this.selectionChanged(n3, n4);
                } else {
                    this.setSelectedRange(this.widgetOffset2ModelOffset(n3), n4);
                    if (bl6) {
                        this.setRedraw(true);
                    }
                }
                return this.widgetOffset2ModelOffset(n3);
            }
        }
        catch (BadLocationException badLocationException) {}
        return -1;
    }

    protected int findAndSelectInRange(int n, String string, boolean bl, boolean bl2, boolean bl3, int n2, int n3, boolean bl4) {
        int n4;
        int n5;
        block11: {
            if (this.fTextWidget == null) {
                return -1;
            }
            try {
                int n6 = bl && (n == -1 || n < n2) ? n2 : (!bl && (n == -1 || n > n2 + n3) ? n2 + n3 : n);
                n5 = this.modelOffset2WidgetOffset(n6);
                if (n5 != -1) break block11;
                return -1;
            }
            catch (BadLocationException badLocationException) {}
        }
        FindReplaceDocumentAdapter findReplaceDocumentAdapter = this.getFindReplaceDocumentAdapter();
        IRegion iRegion = findReplaceDocumentAdapter.find(n5, string, bl, bl2, bl3, bl4);
        int n7 = -1;
        int n8 = 0;
        if (iRegion != null) {
            n7 = iRegion.getOffset();
            n8 = iRegion.getLength();
        }
        int n9 = n4 = n7 == -1 ? -1 : this.widgetOffset2ModelOffset(n7);
        if (n7 != -1 && (n4 < n2 || n4 + n8 > n2 + n3)) {
            n7 = -1;
        }
        if (n7 > -1) {
            char c = findReplaceDocumentAdapter.charAt(n7);
            char c2 = findReplaceDocumentAdapter.charAt(n7 + n8 - 1);
            boolean bl5 = c == '\n' || c == '\r' || c2 == '\n' || c2 == '\r';
            boolean bl6 = this.redraws();
            if (bl5 && bl6) {
                this.setRedraw(false);
            }
            if (this.redraws()) {
                this.fTextWidget.setSelectionRange(n7, n8);
                this.internalRevealRange(n7, n7 + n8);
                this.selectionChanged(n7, n8);
            } else {
                this.setSelectedRange(n4, n8);
                if (bl6) {
                    this.setRedraw(true);
                }
            }
            return n4;
        }
        return -1;
    }

    @Override
    public void setTextColor(Color color) {
        if (color != null) {
            this.setTextColor(color, 0, this.getDocument().getLength(), true);
        }
    }

    @Override
    public void setTextColor(Color color, int n, int n2, boolean bl) {
        if (this.fTextWidget != null) {
            StyleRange styleRange = new StyleRange();
            styleRange.foreground = color;
            styleRange.start = n;
            styleRange.length = n2;
            if ((styleRange = this.modelStyleRange2WidgetStyleRange(styleRange)) != null) {
                if (bl) {
                    this.fTextWidget.setRedraw(false);
                }
                try {
                    this.fTextWidget.setStyleRange(styleRange);
                }
                finally {
                    if (bl) {
                        this.fTextWidget.setRedraw(true);
                    }
                }
            }
        }
    }

    private void addPresentation(TextPresentation textPresentation) {
        StyleRange styleRange = textPresentation.getDefaultStyleRange();
        if (styleRange != null) {
            if ((styleRange = this.modelStyleRange2WidgetStyleRange(styleRange)) != null) {
                this.fTextWidget.setStyleRange(styleRange);
            }
            ArrayList<StyleRange> arrayList = new ArrayList<StyleRange>(textPresentation.getDenumerableRanges());
            Iterator iterator = textPresentation.getNonDefaultStyleRangeIterator();
            while (iterator.hasNext()) {
                styleRange = (StyleRange)iterator.next();
                if ((styleRange = this.modelStyleRange2WidgetStyleRange(styleRange)) == null) continue;
                arrayList.add(styleRange);
            }
            if (!arrayList.isEmpty()) {
                this.fTextWidget.replaceStyleRanges(0, 0, arrayList.toArray(new StyleRange[arrayList.size()]));
            }
        } else {
            IRegion iRegion = this.modelRange2WidgetRange(textPresentation.getCoverage());
            if (iRegion == null) {
                return;
            }
            ArrayList<StyleRange> arrayList = new ArrayList<StyleRange>(textPresentation.getDenumerableRanges());
            Iterator iterator = textPresentation.getAllStyleRangeIterator();
            while (iterator.hasNext()) {
                styleRange = (StyleRange)iterator.next();
                if ((styleRange = this.modelStyleRange2WidgetStyleRange(styleRange)) == null) continue;
                arrayList.add(styleRange);
            }
            if (!arrayList.isEmpty()) {
                StyleRange[] styleRangeArray = new StyleRange[arrayList.size()];
                arrayList.toArray(styleRangeArray);
                this.fTextWidget.replaceStyleRanges(iRegion.getOffset(), iRegion.getLength(), styleRangeArray);
            }
        }
    }

    private void applyTextPresentation(TextPresentation textPresentation) {
        StyleRange styleRange;
        ArrayList<StyleRange> arrayList = new ArrayList<StyleRange>(textPresentation.getDenumerableRanges());
        Iterator iterator = textPresentation.getAllStyleRangeIterator();
        while (iterator.hasNext()) {
            styleRange = (StyleRange)iterator.next();
            if ((styleRange = this.modelStyleRange2WidgetStyleRange(styleRange)) == null) continue;
            arrayList.add(styleRange);
        }
        if (!arrayList.isEmpty()) {
            styleRange = new StyleRange[arrayList.size()];
            arrayList.toArray((T[])styleRange);
            this.fTextWidget.setStyleRanges((StyleRange[])styleRange);
        }
    }

    protected IRegion _internalGetVisibleRegion() {
        IDocument iDocument = this.getVisibleDocument();
        if (iDocument instanceof ChildDocument) {
            Position position = ((ChildDocument)iDocument).getParentDocumentRange();
            return new Region(position.getOffset(), position.getLength());
        }
        return null;
    }

    @Override
    public void changeTextPresentation(TextPresentation textPresentation, boolean bl) {
        if (textPresentation == null || !this.redraws()) {
            return;
        }
        if (this.fTextWidget == null) {
            return;
        }
        if (this.fTextPresentationListeners != null) {
            ArrayList arrayList = new ArrayList(this.fTextPresentationListeners);
            int n = 0;
            int n2 = arrayList.size();
            while (n < n2) {
                ITextPresentationListener iTextPresentationListener = (ITextPresentationListener)arrayList.get(n);
                iTextPresentationListener.applyTextPresentation(textPresentation);
                ++n;
            }
        }
        if (textPresentation.isEmpty()) {
            return;
        }
        if (bl) {
            this.fTextWidget.setRedraw(false);
        }
        if (this.fReplaceTextPresentation) {
            this.applyTextPresentation(textPresentation);
        } else {
            this.addPresentation(textPresentation);
        }
        if (bl) {
            this.fTextWidget.setRedraw(true);
        }
    }

    @Override
    public IFindReplaceTarget getFindReplaceTarget() {
        if (this.fFindReplaceTarget == null) {
            this.fFindReplaceTarget = new FindReplaceTarget();
        }
        return this.fFindReplaceTarget;
    }

    protected FindReplaceDocumentAdapter getFindReplaceDocumentAdapter() {
        if (this.fFindReplaceDocumentAdapter == null) {
            this.fFindReplaceDocumentAdapter = new FindReplaceDocumentAdapter(this.getVisibleDocument());
        }
        return this.fFindReplaceDocumentAdapter;
    }

    @Override
    public ITextOperationTarget getTextOperationTarget() {
        return this;
    }

    @Override
    public void appendVerifyKeyListener(VerifyKeyListener verifyKeyListener) {
        int n = this.fVerifyKeyListenersManager.numberOfListeners();
        this.fVerifyKeyListenersManager.insertListener(verifyKeyListener, n);
    }

    @Override
    public void prependVerifyKeyListener(VerifyKeyListener verifyKeyListener) {
        this.fVerifyKeyListenersManager.insertListener(verifyKeyListener, 0);
    }

    @Override
    public void removeVerifyKeyListener(VerifyKeyListener verifyKeyListener) {
        this.fVerifyKeyListenersManager.removeListener(verifyKeyListener);
    }

    @Override
    public int getMark() {
        return this.fMarkPosition == null || this.fMarkPosition.isDeleted() ? -1 : this.fMarkPosition.getOffset();
    }

    @Override
    public void setMark(int n) {
        if (n == -1) {
            IDocument iDocument;
            if (this.fMarkPosition != null && !this.fMarkPosition.isDeleted() && (iDocument = this.getDocument()) != null) {
                iDocument.removePosition(this.fMarkPosition);
            }
            this.fMarkPosition = null;
            this.markChanged(-1, 0);
        } else {
            IDocument iDocument = this.getDocument();
            if (iDocument == null) {
                this.fMarkPosition = null;
                return;
            }
            if (this.fMarkPosition != null) {
                iDocument.removePosition(this.fMarkPosition);
            }
            this.fMarkPosition = null;
            try {
                Position position = new Position(n);
                iDocument.addPosition(this.MARK_POSITION_CATEGORY, position);
                this.fMarkPosition = position;
            }
            catch (BadLocationException badLocationException) {
                return;
            }
            catch (BadPositionCategoryException badPositionCategoryException) {
                return;
            }
            this.markChanged(this.modelOffset2WidgetOffset(this.fMarkPosition.offset), 0);
        }
    }

    protected void inputChanged(Object object, Object object2) {
        IDocumentExtension4 iDocumentExtension4;
        IDocument iDocument = (IDocument)object2;
        if (iDocument != null) {
            if (this.fMarkPosition != null && !this.fMarkPosition.isDeleted()) {
                iDocument.removePosition(this.fMarkPosition);
            }
            try {
                iDocument.removePositionUpdater(this.fMarkPositionUpdater);
                iDocument.removePositionCategory(this.MARK_POSITION_CATEGORY);
            }
            catch (BadPositionCategoryException badPositionCategoryException) {}
        }
        this.fMarkPosition = null;
        if (iDocument instanceof IDocumentExtension4) {
            iDocumentExtension4 = (IDocumentExtension4)iDocument;
            iDocumentExtension4.removeDocumentRewriteSessionListener((IDocumentRewriteSessionListener)this.fDocumentRewriteSessionListener);
        }
        super.inputChanged(object, object2);
        if (object instanceof IDocumentExtension4) {
            iDocumentExtension4 = (IDocumentExtension4)object;
            iDocumentExtension4.addDocumentRewriteSessionListener((IDocumentRewriteSessionListener)this.fDocumentRewriteSessionListener);
        }
        if ((iDocumentExtension4 = (IDocument)object) != null) {
            iDocumentExtension4.addPositionCategory(this.MARK_POSITION_CATEGORY);
            iDocumentExtension4.addPositionUpdater(this.fMarkPositionUpdater);
        }
    }

    private void fireRedrawChanged() {
        this.fWidgetCommand.start = 0;
        this.fWidgetCommand.length = 0;
        this.fWidgetCommand.text = null;
        this.fWidgetCommand.event = null;
        this.updateTextListeners(this.fWidgetCommand);
    }

    protected void enabledRedrawing() {
        this.enabledRedrawing(-1);
    }

    protected void enabledRedrawing(int n) {
        if (this.fDocumentAdapter instanceof IDocumentAdapterExtension) {
            IDocumentAdapterExtension iDocumentAdapterExtension = (IDocumentAdapterExtension)((Object)this.fDocumentAdapter);
            StyledText styledText = this.getTextWidget();
            if (styledText != null && !styledText.isDisposed()) {
                iDocumentAdapterExtension.resumeForwardingDocumentChanges();
                if (n > -1) {
                    try {
                        this.setTopIndex(n);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                }
            }
        }
        if (this.fViewerState != null) {
            this.fViewerState.restore(n == -1);
            this.fViewerState = null;
        }
        if (this.fTextWidget != null && !this.fTextWidget.isDisposed()) {
            this.fTextWidget.setRedraw(true);
        }
        this.fireRedrawChanged();
    }

    protected void disableRedrawing() {
        if (this.fViewerState == null) {
            this.fViewerState = new ViewerState();
        }
        if (this.fDocumentAdapter instanceof IDocumentAdapterExtension) {
            IDocumentAdapterExtension iDocumentAdapterExtension = (IDocumentAdapterExtension)((Object)this.fDocumentAdapter);
            iDocumentAdapterExtension.stopForwardingDocumentChanges();
        }
        if (this.fTextWidget != null && !this.fTextWidget.isDisposed()) {
            this.fTextWidget.setRedraw(false);
        }
        this.fireRedrawChanged();
    }

    @Override
    public final void setRedraw(boolean bl) {
        this.setRedraw(bl, -1);
    }

    protected final void setRedraw(boolean bl, int n) {
        if (!bl) {
            ++this.fRedrawCounter;
            if (this.fRedrawCounter == 1) {
                this.disableRedrawing();
            }
        } else {
            --this.fRedrawCounter;
            if (this.fRedrawCounter == 0) {
                if (n == -1) {
                    this.enabledRedrawing();
                } else {
                    this.enabledRedrawing(n);
                }
            }
        }
    }

    protected final boolean redraws() {
        return this.fRedrawCounter <= 0;
    }

    protected final void startSequentialRewriteMode(boolean bl) {
        IDocument iDocument = this.getDocument();
        if (iDocument instanceof IDocumentExtension) {
            IDocumentExtension iDocumentExtension = (IDocumentExtension)iDocument;
            iDocumentExtension.startSequentialRewrite(bl);
        }
    }

    protected final void stopSequentialRewriteMode() {
        IDocument iDocument = this.getDocument();
        if (iDocument instanceof IDocumentExtension) {
            IDocumentExtension iDocumentExtension = (IDocumentExtension)iDocument;
            iDocumentExtension.stopSequentialRewrite();
        }
    }

    @Override
    public IRewriteTarget getRewriteTarget() {
        if (this.fRewriteTarget == null) {
            this.fRewriteTarget = new RewriteTarget();
        }
        return this.fRewriteTarget;
    }

    @Override
    public ITextHover getCurrentTextHover() {
        if (this.fTextHoverManager == null) {
            return null;
        }
        return this.fTextHoverManager.getCurrentTextHover();
    }

    @Override
    public Point getHoverEventLocation() {
        if (this.fTextHoverManager == null) {
            return null;
        }
        return this.fTextHoverManager.getHoverEventLocation();
    }

    protected PaintManager getPaintManager() {
        if (this.fPaintManager == null) {
            this.fPaintManager = new PaintManager(this);
        }
        return this.fPaintManager;
    }

    @Override
    public void addPainter(IPainter iPainter) {
        this.getPaintManager().addPainter(iPainter);
    }

    @Override
    public void removePainter(IPainter iPainter) {
        this.getPaintManager().removePainter(iPainter);
    }

    public int modelLine2WidgetLine(int n) {
        if (this.fInformationMapping == null) {
            return n;
        }
        try {
            return this.fInformationMapping.toImageLine(n);
        }
        catch (BadLocationException badLocationException) {
            return -1;
        }
    }

    public int modelOffset2WidgetOffset(int n) {
        if (this.fInformationMapping == null) {
            return n;
        }
        try {
            return this.fInformationMapping.toImageOffset(n);
        }
        catch (BadLocationException badLocationException) {
            return -1;
        }
    }

    public IRegion modelRange2WidgetRange(IRegion iRegion) {
        if (this.fInformationMapping == null) {
            return iRegion;
        }
        try {
            Region region;
            IRegion iRegion2;
            if (iRegion.getLength() < 0 && (iRegion2 = this.fInformationMapping.toImageRegion((IRegion)(region = new Region(iRegion.getOffset() + iRegion.getLength(), -iRegion.getLength())))) != null) {
                return new Region(iRegion2.getOffset() + iRegion2.getLength(), -iRegion2.getLength());
            }
            return this.fInformationMapping.toImageRegion(iRegion);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    protected IRegion modelRange2ClosestWidgetRange(IRegion iRegion) {
        if (!(this.fInformationMapping instanceof IDocumentInformationMappingExtension2)) {
            return this.modelRange2WidgetRange(iRegion);
        }
        try {
            Region region;
            IRegion iRegion2;
            if (iRegion.getLength() < 0 && (iRegion2 = ((IDocumentInformationMappingExtension2)this.fInformationMapping).toClosestImageRegion((IRegion)(region = new Region(iRegion.getOffset() + iRegion.getLength(), -iRegion.getLength())))) != null) {
                return new Region(iRegion2.getOffset() + iRegion2.getLength(), -iRegion2.getLength());
            }
            return ((IDocumentInformationMappingExtension2)this.fInformationMapping).toClosestImageRegion(iRegion);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    public int widgetlLine2ModelLine(int n) {
        return this.widgetLine2ModelLine(n);
    }

    public int widgetLine2ModelLine(int n) {
        if (this.fInformationMapping == null) {
            return n;
        }
        try {
            return this.fInformationMapping.toOriginLine(n);
        }
        catch (BadLocationException badLocationException) {
            return -1;
        }
    }

    public int widgetOffset2ModelOffset(int n) {
        if (this.fInformationMapping == null) {
            return n;
        }
        try {
            return this.fInformationMapping.toOriginOffset(n);
        }
        catch (BadLocationException badLocationException) {
            if (n == this.getVisibleDocument().getLength()) {
                IRegion iRegion = this.fInformationMapping.getCoverage();
                return iRegion.getOffset() + iRegion.getLength();
            }
            return -1;
        }
    }

    public IRegion widgetRange2ModelRange(IRegion iRegion) {
        if (this.fInformationMapping == null) {
            return iRegion;
        }
        try {
            if (iRegion.getLength() < 0) {
                Region region = new Region(iRegion.getOffset() + iRegion.getLength(), -iRegion.getLength());
                IRegion iRegion2 = this.fInformationMapping.toOriginRegion((IRegion)region);
                return new Region(iRegion2.getOffset() + iRegion2.getLength(), -iRegion2.getLength());
            }
            return this.fInformationMapping.toOriginRegion(iRegion);
        }
        catch (BadLocationException badLocationException) {
            int n;
            int n2 = this.widgetOffset2ModelOffset(iRegion.getOffset());
            if (n2 > -1 && (n = this.widgetOffset2ModelOffset(iRegion.getOffset() + iRegion.getLength())) > -1) {
                return new Region(n2, n - n2);
            }
            return null;
        }
    }

    public IRegion getModelCoverage() {
        if (this.fInformationMapping == null) {
            IDocument iDocument = this.getDocument();
            if (iDocument == null) {
                return null;
            }
            return new Region(0, iDocument.getLength());
        }
        return this.fInformationMapping.getCoverage();
    }

    protected int getClosestWidgetLineForModelLine(int n) {
        if (this.fInformationMapping == null) {
            return n;
        }
        try {
            return this.fInformationMapping.toClosestImageLine(n);
        }
        catch (BadLocationException badLocationException) {
            return -1;
        }
    }

    protected StyleRange modelStyleRange2WidgetStyleRange(StyleRange styleRange) {
        IRegion iRegion = this.modelRange2WidgetRange((IRegion)new Region(styleRange.start, styleRange.length));
        if (iRegion != null) {
            StyleRange styleRange2 = (StyleRange)styleRange.clone();
            styleRange2.start = iRegion.getOffset();
            styleRange2.length = iRegion.getLength();
            return styleRange2;
        }
        return null;
    }

    protected IRegion modelRange2WidgetRange(Position position) {
        return this.modelRange2WidgetRange((IRegion)new Region(position.getOffset(), position.getLength()));
    }

    protected IRegion event2ModelRange(VerifyEvent verifyEvent) {
        Region region = null;
        region = verifyEvent.start <= verifyEvent.end ? new Region(verifyEvent.start, verifyEvent.end - verifyEvent.start) : new Region(verifyEvent.end, verifyEvent.start - verifyEvent.end);
        return this.widgetRange2ModelRange((IRegion)region);
    }

    protected Point widgetSelection2ModelSelection(Point point) {
        Region region = new Region(point.x, point.y);
        return (region = this.widgetRange2ModelRange((IRegion)region)) == null ? null : new Point(region.getOffset(), region.getLength());
    }

    protected Point modelSelection2WidgetSelection(Point point) {
        if (this.fInformationMapping == null) {
            return point;
        }
        try {
            Region region = new Region(point.x, point.y);
            region = this.fInformationMapping.toImageRegion((IRegion)region);
            if (region != null) {
                return new Point(region.getOffset(), region.getLength());
            }
        }
        catch (BadLocationException badLocationException) {}
        return null;
    }

    public int widgetLineOfWidgetOffset(int n) {
        IDocument iDocument = this.getVisibleDocument();
        if (iDocument != null) {
            try {
                return iDocument.getLineOfOffset(n);
            }
            catch (BadLocationException badLocationException) {}
        }
        return -1;
    }

    @Override
    public boolean moveFocusToWidgetToken() {
        if (this.fWidgetTokenKeeper instanceof IWidgetTokenKeeperExtension) {
            IWidgetTokenKeeperExtension iWidgetTokenKeeperExtension = (IWidgetTokenKeeperExtension)((Object)this.fWidgetTokenKeeper);
            return iWidgetTokenKeeperExtension.setFocus(this);
        }
        return false;
    }

    public void setDocumentPartitioning(String string) {
        this.fPartitioning = string;
    }

    protected String getDocumentPartitioning() {
        return this.fPartitioning;
    }

    @Override
    public void addTextPresentationListener(ITextPresentationListener iTextPresentationListener) {
        Assert.isNotNull((Object)iTextPresentationListener);
        if (this.fTextPresentationListeners == null) {
            this.fTextPresentationListeners = new ArrayList();
        }
        if (!this.fTextPresentationListeners.contains(iTextPresentationListener)) {
            this.fTextPresentationListeners.add(iTextPresentationListener);
        }
    }

    @Override
    public void removeTextPresentationListener(ITextPresentationListener iTextPresentationListener) {
        Assert.isNotNull((Object)iTextPresentationListener);
        if (this.fTextPresentationListeners != null) {
            this.fTextPresentationListeners.remove(iTextPresentationListener);
            if (this.fTextPresentationListeners.size() == 0) {
                this.fTextPresentationListeners = null;
            }
        }
    }

    @Override
    public void register(IEditingSupport iEditingSupport) {
        Assert.isLegal((iEditingSupport != null ? 1 : 0) != 0);
        this.fEditorHelpers.add(iEditingSupport);
    }

    @Override
    public void unregister(IEditingSupport iEditingSupport) {
        this.fEditorHelpers.remove(iEditingSupport);
    }

    @Override
    public IEditingSupport[] getRegisteredSupports() {
        return this.fEditorHelpers.toArray(new IEditingSupport[this.fEditorHelpers.size()]);
    }

    @Override
    public void setHyperlinkDetectors(IHyperlinkDetector[] iHyperlinkDetectorArray, int n) {
        int n2;
        if (this.fHyperlinkDetectors != null) {
            n2 = 0;
            while (n2 < this.fHyperlinkDetectors.length) {
                if (this.fHyperlinkDetectors[n2] instanceof IHyperlinkDetectorExtension) {
                    ((IHyperlinkDetectorExtension)((Object)this.fHyperlinkDetectors[n2])).dispose();
                }
                ++n2;
            }
        }
        n2 = iHyperlinkDetectorArray != null && iHyperlinkDetectorArray.length > 0 ? 1 : 0;
        this.fHyperlinkStateMask = n;
        this.fHyperlinkDetectors = iHyperlinkDetectorArray;
        if (n2 != 0) {
            if (this.fHyperlinkManager != null) {
                this.fHyperlinkManager.setHyperlinkDetectors(this.fHyperlinkDetectors);
                this.fHyperlinkManager.setHyperlinkStateMask(this.fHyperlinkStateMask);
            }
            this.ensureHyperlinkManagerInstalled();
        } else {
            if (this.fHyperlinkManager != null) {
                this.fHyperlinkManager.uninstall();
            }
            this.fHyperlinkManager = null;
        }
    }

    public void setHyperlinkPresenter(IHyperlinkPresenter iHyperlinkPresenter) throws IllegalStateException {
        if (this.fHyperlinkManager != null) {
            throw new IllegalStateException();
        }
        this.fHyperlinkPresenter = iHyperlinkPresenter;
        this.ensureHyperlinkManagerInstalled();
    }

    private void ensureHyperlinkManagerInstalled() {
        if (this.fHyperlinkDetectors != null && this.fHyperlinkDetectors.length > 0 && this.fHyperlinkPresenter != null && this.fHyperlinkManager == null) {
            HyperlinkManager.DETECTION_STRATEGY dETECTION_STRATEGY = this.fHyperlinkPresenter.canShowMultipleHyperlinks() ? HyperlinkManager.ALL : HyperlinkManager.FIRST;
            this.fHyperlinkManager = new HyperlinkManager(dETECTION_STRATEGY);
            this.fHyperlinkManager.install(this, this.fHyperlinkPresenter, this.fHyperlinkDetectors, this.fHyperlinkStateMask);
        }
    }

    @Override
    public void setTabsToSpacesConverter(IAutoEditStrategy iAutoEditStrategy) {
        this.fTabsToSpacesConverter = iAutoEditStrategy;
    }

    private static final class ColumnPosition
    extends Position {
        int fStartColumn;
        int fEndColumn;

        ColumnPosition(int n, int n2, int n3, int n4) {
            super(n, n2);
            this.fStartColumn = n3;
            this.fEndColumn = n4;
        }
    }

    private class CursorListener
    implements KeyListener,
    MouseListener {
        private CursorListener() {
        }

        private void install() {
            if (TextViewer.this.fTextWidget != null && !TextViewer.this.fTextWidget.isDisposed()) {
                TextViewer.this.fTextWidget.addKeyListener((KeyListener)this);
                TextViewer.this.fTextWidget.addMouseListener((MouseListener)this);
            }
        }

        private void uninstall() {
            if (TextViewer.this.fTextWidget != null && !TextViewer.this.fTextWidget.isDisposed()) {
                TextViewer.this.fTextWidget.removeKeyListener((KeyListener)this);
                TextViewer.this.fTextWidget.removeMouseListener((MouseListener)this);
            }
        }

        public void keyPressed(KeyEvent keyEvent) {
        }

        public void keyReleased(KeyEvent keyEvent) {
            if (TextViewer.this.fTextWidget.getSelectionCount() == 0) {
                TextViewer.this.fLastSentSelectionChange = null;
                TextViewer.this.queuePostSelectionChanged(keyEvent.character == '\u007f');
            }
        }

        public void mouseDoubleClick(MouseEvent mouseEvent) {
        }

        public void mouseDown(MouseEvent mouseEvent) {
        }

        public void mouseUp(MouseEvent mouseEvent) {
            if (TextViewer.this.fTextWidget.getSelectionCount() == 0) {
                TextViewer.this.queuePostSelectionChanged(false);
            }
        }
    }

    private class DocumentRewriteSessionListener
    implements IDocumentRewriteSessionListener {
        private DocumentRewriteSessionListener() {
        }

        public void documentRewriteSessionChanged(DocumentRewriteSessionEvent documentRewriteSessionEvent) {
            boolean bl;
            IRewriteTarget iRewriteTarget = TextViewer.this.getRewriteTarget();
            boolean bl2 = true;
            boolean bl3 = bl = !bl2;
            if (DocumentRewriteSessionEvent.SESSION_START == documentRewriteSessionEvent.getChangeType()) {
                if (bl2) {
                    iRewriteTarget.setRedraw(false);
                }
                iRewriteTarget.beginCompoundChange();
                if (bl && TextViewer.this.fViewerState == null) {
                    TextViewer.this.fViewerState = new ViewerState();
                }
            } else if (DocumentRewriteSessionEvent.SESSION_STOP == documentRewriteSessionEvent.getChangeType()) {
                if (bl && TextViewer.this.fViewerState != null) {
                    TextViewer.this.fViewerState.restore(true);
                    TextViewer.this.fViewerState = null;
                }
                iRewriteTarget.endCompoundChange();
                if (bl2) {
                    iRewriteTarget.setRedraw(true);
                }
            }
        }
    }

    class FindReplaceRange
    implements LineBackgroundListener,
    ITextListener,
    IPositionUpdater {
        private static final String RANGE_CATEGORY = "org.eclipse.jface.text.TextViewer.find.range";
        private Color fHighlightColor;
        private Position fPosition;

        public FindReplaceRange(IRegion iRegion) {
            this.setRange(iRegion);
        }

        public void setRange(IRegion iRegion) {
            this.fPosition = new Position(iRegion.getOffset(), iRegion.getLength());
        }

        public IRegion getRange() {
            return new Region(this.fPosition.getOffset(), this.fPosition.getLength());
        }

        public void setHighlightColor(Color color) {
            this.fHighlightColor = color;
            this.paint();
        }

        public void lineGetBackground(LineBackgroundEvent lineBackgroundEvent) {
            int n;
            if (TextViewer.this.fTextWidget != null && this.fPosition.includes(n = TextViewer.this.widgetOffset2ModelOffset(lineBackgroundEvent.lineOffset))) {
                lineBackgroundEvent.lineBackground = this.fHighlightColor;
            }
        }

        public void install() {
            TextViewer.this.addTextListener(this);
            TextViewer.this.fTextWidget.addLineBackgroundListener((LineBackgroundListener)this);
            IDocument iDocument = TextViewer.this.getDocument();
            try {
                iDocument.addPositionCategory(RANGE_CATEGORY);
                iDocument.addPosition(RANGE_CATEGORY, this.fPosition);
                iDocument.addPositionUpdater((IPositionUpdater)this);
            }
            catch (BadPositionCategoryException badPositionCategoryException) {
            }
            catch (BadLocationException badLocationException) {}
            this.paint();
        }

        public void uninstall() {
            IDocument iDocument = TextViewer.this.getDocument();
            if (iDocument != null) {
                iDocument.removePositionUpdater((IPositionUpdater)this);
                iDocument.removePosition(this.fPosition);
            }
            if (TextViewer.this.fTextWidget != null && !TextViewer.this.fTextWidget.isDisposed()) {
                TextViewer.this.fTextWidget.removeLineBackgroundListener((LineBackgroundListener)this);
            }
            TextViewer.this.removeTextListener(this);
            this.clear();
        }

        private void clear() {
            if (TextViewer.this.fTextWidget != null && !TextViewer.this.fTextWidget.isDisposed()) {
                TextViewer.this.fTextWidget.redraw();
            }
        }

        private void paint() {
            int n;
            int n2;
            IRegion iRegion = TextViewer.this.modelRange2WidgetRange(this.fPosition);
            int n3 = iRegion.getOffset();
            if (n3 + (n2 = iRegion.getLength()) >= (n = TextViewer.this.fTextWidget.getCharCount())) {
                n2 = n - n3;
                Point point = TextViewer.this.fTextWidget.getLocationAtOffset(n3);
                Point point2 = TextViewer.this.fTextWidget.getLocationAtOffset(n3 + n2);
                int n4 = ((TextViewer)TextViewer.this).fTextWidget.getClientArea().width;
                int n5 = TextViewer.this.fTextWidget.getLineHeight(n3 + n2) + point2.y - point.y;
                TextViewer.this.fTextWidget.redraw(point.x, point.y, n4, n5, false);
            }
            TextViewer.this.fTextWidget.redrawRange(n3, n2, true);
        }

        @Override
        public void textChanged(TextEvent textEvent) {
            if (textEvent.getViewerRedrawState()) {
                this.paint();
            }
        }

        public void update(DocumentEvent documentEvent) {
            int n = documentEvent.getOffset();
            int n2 = documentEvent.getLength();
            int n3 = documentEvent.getText().length() - n2;
            if (n < this.fPosition.getOffset()) {
                this.fPosition.setOffset(this.fPosition.getOffset() + n3);
            } else if (n < this.fPosition.getOffset() + this.fPosition.getLength()) {
                this.fPosition.setLength(this.fPosition.getLength() + n3);
            }
        }
    }

    class FindReplaceTarget
    implements IFindReplaceTarget,
    IFindReplaceTargetExtension,
    IFindReplaceTargetExtension3 {
        private FindReplaceRange fRange;
        private Color fScopeHighlightColor;
        private Map fRememberedPartitioners;
        private DocumentRewriteSession fRewriteSession;

        FindReplaceTarget() {
        }

        @Override
        public String getSelectionText() {
            Point point = TextViewer.this.getSelectedRange();
            if (point.x > -1 && point.y > -1) {
                try {
                    IDocument iDocument = TextViewer.this.getDocument();
                    return iDocument.get(point.x, point.y);
                }
                catch (BadLocationException badLocationException) {}
            }
            return "";
        }

        @Override
        public void replaceSelection(String string) {
            this.replaceSelection(string, false);
        }

        @Override
        public void replaceSelection(String string, boolean bl) {
            Point point = TextViewer.this.getSelectedRange();
            if (point.x > -1 && point.y > -1) {
                try {
                    IRegion iRegion = TextViewer.this.getFindReplaceDocumentAdapter().replace(string, bl);
                    int n = -1;
                    if (iRegion != null) {
                        n = iRegion.getLength();
                    }
                    if (string != null && n > 0) {
                        TextViewer.this.setSelectedRange(point.x, n);
                    }
                }
                catch (BadLocationException badLocationException) {}
            }
        }

        @Override
        public boolean isEditable() {
            return TextViewer.this.isEditable();
        }

        @Override
        public Point getSelection() {
            Point point = TextViewer.this.getSelectedRange();
            Point point2 = TextViewer.this.modelSelection2WidgetSelection(point);
            return point2 != null ? point2 : new Point(-1, -1);
        }

        @Override
        public int findAndSelect(int n, String string, boolean bl, boolean bl2, boolean bl3) {
            try {
                return this.findAndSelect(n, string, bl, bl2, bl3, false);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                return -1;
            }
        }

        @Override
        public int findAndSelect(int n, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
            int n2;
            int n3 = n2 = n == -1 ? -1 : TextViewer.this.widgetOffset2ModelOffset(n);
            if (this.fRange != null) {
                IRegion iRegion = this.fRange.getRange();
                n2 = TextViewer.this.findAndSelectInRange(n2, string, bl, bl2, bl3, iRegion.getOffset(), iRegion.getLength(), bl4);
            } else {
                n2 = TextViewer.this.findAndSelect(n2, string, bl, bl2, bl3, bl4);
            }
            n = n2 == -1 ? -1 : TextViewer.this.modelOffset2WidgetOffset(n2);
            return n;
        }

        @Override
        public boolean canPerformFind() {
            return TextViewer.this.canPerformFind();
        }

        @Override
        public void beginSession() {
            this.fRange = null;
        }

        @Override
        public void endSession() {
            if (this.fRange != null) {
                this.fRange.uninstall();
                this.fRange = null;
            }
        }

        @Override
        public IRegion getScope() {
            return this.fRange == null ? null : this.fRange.getRange();
        }

        @Override
        public Point getLineSelection() {
            Point point = TextViewer.this.getSelectedRange();
            try {
                IDocument iDocument = TextViewer.this.getDocument();
                int n = iDocument.getLineOfOffset(point.x);
                int n2 = iDocument.getLineOffset(n);
                IRegion iRegion = iDocument.getLineInformationOfOffset(point.x + point.y);
                int n3 = iDocument.getLineOfOffset(point.x + point.y);
                int n4 = iRegion.getOffset() == point.x + point.y && n3 > 0 ? iDocument.getLineOffset(n3 - 1) + iDocument.getLineLength(n3 - 1) - n2 : iRegion.getOffset() + iRegion.getLength() - n2;
                return new Point(n2, n4);
            }
            catch (BadLocationException badLocationException) {
                return new Point(point.x, 0);
            }
        }

        @Override
        public void setSelection(int n, int n2) {
            TextViewer.this.setSelectedRange(n, n2);
        }

        @Override
        public void setScope(IRegion iRegion) {
            if (this.fRange != null) {
                this.fRange.uninstall();
            }
            if (iRegion == null) {
                this.fRange = null;
                return;
            }
            this.fRange = new FindReplaceRange(iRegion);
            this.fRange.setHighlightColor(this.fScopeHighlightColor);
            this.fRange.install();
        }

        @Override
        public void setScopeHighlightColor(Color color) {
            if (this.fRange != null) {
                this.fRange.setHighlightColor(color);
            }
            this.fScopeHighlightColor = color;
        }

        @Override
        public void setReplaceAllMode(boolean bl) {
            IDocument iDocument = TextViewer.this.getDocument();
            if (bl) {
                if (iDocument instanceof IDocumentExtension4) {
                    IDocumentExtension4 iDocumentExtension4 = (IDocumentExtension4)iDocument;
                    this.fRewriteSession = iDocumentExtension4.startRewriteSession(DocumentRewriteSessionType.SEQUENTIAL);
                } else {
                    TextViewer.this.setRedraw(false);
                    TextViewer.this.startSequentialRewriteMode(false);
                    if (TextViewer.this.fUndoManager != null) {
                        TextViewer.this.fUndoManager.beginCompoundChange();
                    }
                    this.fRememberedPartitioners = TextUtilities.removeDocumentPartitioners((IDocument)iDocument);
                }
            } else if (iDocument instanceof IDocumentExtension4) {
                IDocumentExtension4 iDocumentExtension4 = (IDocumentExtension4)iDocument;
                iDocumentExtension4.stopRewriteSession(this.fRewriteSession);
            } else {
                TextViewer.this.setRedraw(true);
                TextViewer.this.stopSequentialRewriteMode();
                if (TextViewer.this.fUndoManager != null) {
                    TextViewer.this.fUndoManager.endCompoundChange();
                }
                if (this.fRememberedPartitioners != null) {
                    TextUtilities.addDocumentPartitioners((IDocument)iDocument, (Map)this.fRememberedPartitioners);
                }
            }
        }
    }

    class RewriteTarget
    implements IRewriteTarget {
        RewriteTarget() {
        }

        @Override
        public void beginCompoundChange() {
            if (TextViewer.this.fUndoManager != null) {
                TextViewer.this.fUndoManager.beginCompoundChange();
            }
        }

        @Override
        public void endCompoundChange() {
            if (TextViewer.this.fUndoManager != null) {
                TextViewer.this.fUndoManager.endCompoundChange();
            }
        }

        @Override
        public IDocument getDocument() {
            return TextViewer.this.getDocument();
        }

        @Override
        public void setRedraw(boolean bl) {
            TextViewer.this.setRedraw(bl);
        }
    }

    static class ShiftPositionUpdater
    extends DefaultPositionUpdater {
        protected ShiftPositionUpdater(String string) {
            super(string);
        }

        protected void adaptToInsert() {
            int n = this.fPosition.offset;
            int n2 = this.fPosition.offset + this.fPosition.length - 1;
            n2 = Math.max(n, n2);
            int n3 = this.fOffset;
            int n4 = this.fOffset + this.fReplaceLength - 1;
            n4 = Math.max(n3, n4);
            if (n2 < n3) {
                return;
            }
            if (n <= n3) {
                this.fPosition.length += this.fReplaceLength;
                return;
            }
            if (n > n3) {
                this.fPosition.offset += this.fReplaceLength;
            }
        }
    }

    class TextDoubleClickStrategyConnector
    extends MouseAdapter
    implements MovementListener {
        private Point fDoubleClickSelection;

        TextDoubleClickStrategyConnector() {
        }

        public void mouseUp(MouseEvent mouseEvent) {
            this.fDoubleClickSelection = null;
        }

        public void getNextOffset(MovementEvent movementEvent) {
            if (movementEvent.movement != 8) {
                return;
            }
            if (this.fDoubleClickSelection != null && this.fDoubleClickSelection.x <= movementEvent.offset && movementEvent.offset <= this.fDoubleClickSelection.y) {
                movementEvent.newOffset = this.fDoubleClickSelection.y;
            }
        }

        public void getPreviousOffset(MovementEvent movementEvent) {
            if (movementEvent.movement != 16) {
                return;
            }
            if (this.fDoubleClickSelection == null) {
                ITextDoubleClickStrategy iTextDoubleClickStrategy = (ITextDoubleClickStrategy)TextViewer.this.selectContentTypePlugin(TextViewer.this.getSelectedRange().x, TextViewer.this.fDoubleClickStrategies);
                if (iTextDoubleClickStrategy != null) {
                    StyledText styledText = TextViewer.this.getTextWidget();
                    iTextDoubleClickStrategy.doubleClicked(TextViewer.this);
                    this.fDoubleClickSelection = styledText.getSelection();
                    movementEvent.newOffset = this.fDoubleClickSelection.x;
                }
            } else if (this.fDoubleClickSelection.x <= movementEvent.offset && movementEvent.offset <= this.fDoubleClickSelection.y) {
                movementEvent.newOffset = this.fDoubleClickSelection.x;
            }
        }
    }

    protected class TextHoverKey {
        private String fContentType;
        private int fStateMask;

        protected TextHoverKey(String string, int n) {
            Assert.isNotNull((Object)string);
            this.fContentType = string;
            this.fStateMask = n;
        }

        public boolean equals(Object object) {
            if (object == null || object.getClass() != this.getClass()) {
                return false;
            }
            TextHoverKey textHoverKey = (TextHoverKey)object;
            return textHoverKey.fContentType.equals(this.fContentType) && textHoverKey.fStateMask == this.fStateMask;
        }

        public int hashCode() {
            return this.fStateMask << 16 | this.fContentType.hashCode();
        }

        private void setStateMask(int n) {
            this.fStateMask = n;
        }
    }

    class TextVerifyListener
    implements VerifyListener {
        private boolean fForward = true;

        TextVerifyListener() {
        }

        public void forward(boolean bl) {
            this.fForward = bl;
        }

        public void verifyText(VerifyEvent verifyEvent) {
            if (this.fForward) {
                TextViewer.this.handleVerifyEvent(verifyEvent);
            }
        }
    }

    class VerifyKeyListenersManager
    implements VerifyKeyListener {
        private List fListeners = new ArrayList();
        private List fBatched = new ArrayList();
        private int fReentranceCount = 0;

        VerifyKeyListenersManager() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void verifyKey(VerifyEvent verifyEvent) {
            if (this.fListeners.isEmpty()) {
                return;
            }
            try {
                ++this.fReentranceCount;
                Iterator iterator = this.fListeners.iterator();
                while (iterator.hasNext() && verifyEvent.doit) {
                    VerifyKeyListener verifyKeyListener = (VerifyKeyListener)iterator.next();
                    verifyKeyListener.verifyKey(verifyEvent);
                }
            }
            finally {
                --this.fReentranceCount;
            }
            if (this.fReentranceCount == 0) {
                this.processBatchedRequests();
            }
        }

        private void processBatchedRequests() {
            if (!this.fBatched.isEmpty()) {
                for (Batch batch : this.fBatched) {
                    this.insertListener(batch.listener, batch.index);
                }
                this.fBatched.clear();
            }
        }

        public int numberOfListeners() {
            return this.fListeners.size();
        }

        public void insertListener(VerifyKeyListener verifyKeyListener, int n) {
            if (n == -1) {
                this.removeListener(verifyKeyListener);
            } else if (verifyKeyListener != null) {
                if (this.fReentranceCount > 0) {
                    this.fBatched.add(new Batch(verifyKeyListener, n));
                } else {
                    int n2 = -1;
                    int n3 = this.fListeners.size();
                    int n4 = 0;
                    while (n4 < n3) {
                        if (verifyKeyListener == this.fListeners.get(n4)) {
                            n2 = n4;
                            break;
                        }
                        ++n4;
                    }
                    if (n2 != n) {
                        if (n2 != -1) {
                            this.fListeners.remove(n2);
                        }
                        if (n > this.fListeners.size()) {
                            this.fListeners.add(verifyKeyListener);
                        } else {
                            this.fListeners.add(n, verifyKeyListener);
                        }
                    }
                    if (n3 == 0) {
                        this.install();
                    }
                }
            }
        }

        public void removeListener(VerifyKeyListener verifyKeyListener) {
            if (verifyKeyListener == null) {
                return;
            }
            if (this.fReentranceCount > 0) {
                this.fBatched.add(new Batch(verifyKeyListener, -1));
            } else {
                int n = this.fListeners.size();
                int n2 = 0;
                while (n2 < n) {
                    if (verifyKeyListener == this.fListeners.get(n2)) {
                        this.fListeners.remove(n2);
                        if (n == 1) {
                            this.uninstall();
                        }
                        return;
                    }
                    ++n2;
                }
            }
        }

        private void install() {
            StyledText styledText = TextViewer.this.getTextWidget();
            if (styledText != null && !styledText.isDisposed()) {
                styledText.addVerifyKeyListener((VerifyKeyListener)this);
            }
        }

        private void uninstall() {
            StyledText styledText = TextViewer.this.getTextWidget();
            if (styledText != null && !styledText.isDisposed()) {
                styledText.removeVerifyKeyListener((VerifyKeyListener)this);
            }
        }

        class Batch {
            int index;
            VerifyKeyListener listener;

            public Batch(VerifyKeyListener verifyKeyListener, int n) {
                this.listener = verifyKeyListener;
                this.index = n;
            }
        }
    }

    private final class ViewerState {
        private Position fSelection;
        private boolean fReverseSelection;
        private boolean fSelectionSet;
        private Position fStableLine;
        private int fStablePixel;
        private IPositionUpdater fUpdater;
        private IDocument fUpdaterDocument;
        private String fUpdaterCategory;

        public ViewerState() {
            IDocument iDocument = TextViewer.this.getDocument();
            if (iDocument != null) {
                this.connect(iDocument);
            }
        }

        public Point getSelection() {
            if (this.fSelection == null) {
                return new Point(-1, -1);
            }
            return new Point(this.fSelection.getOffset(), this.fSelection.getLength());
        }

        public void updateSelection(int n, int n2) {
            this.fSelectionSet = true;
            if (this.fSelection == null) {
                this.fSelection = new Position(n, n2);
            } else {
                this.updatePosition(this.fSelection, n, n2);
            }
        }

        public void restore(boolean bl) {
            if (this.isConnected()) {
                this.disconnect();
            }
            if (this.fSelection != null) {
                if (this.fSelection instanceof ColumnPosition) {
                    ColumnPosition columnPosition = (ColumnPosition)this.fSelection;
                    IDocument iDocument = TextViewer.this.fDocument;
                    try {
                        int n = iDocument.getLineOfOffset(this.fSelection.getOffset());
                        int n2 = iDocument.getLineOffset(n);
                        int n3 = this.fSelection.getOffset() + this.fSelection.getLength();
                        int n4 = iDocument.getLineOfOffset(n3);
                        int n5 = iDocument.getLineOffset(n4);
                        int n6 = TextViewer.this.getTextWidget().getTabs();
                        int n7 = this.fSelection.getOffset() - n2 + columnPosition.fStartColumn;
                        int n8 = n3 - n5 + columnPosition.fEndColumn;
                        TextViewer.this.setSelection(new BlockTextSelection(iDocument, n, n7, n4, n8, n6));
                    }
                    catch (BadLocationException badLocationException) {
                        TextViewer.this.setSelectedRange(columnPosition.getOffset(), columnPosition.getLength());
                    }
                } else {
                    int n = this.fSelection.getOffset();
                    int n9 = this.fSelection.getLength();
                    if (this.fReverseSelection) {
                        n -= n9;
                        n9 = -n9;
                    }
                    TextViewer.this.setSelectedRange(n, n9);
                }
                if (bl) {
                    this.updateViewport();
                }
            }
        }

        private void updateViewport() {
            if (this.fSelectionSet) {
                TextViewer.this.revealRange(this.fSelection.getOffset(), this.fSelection.getLength());
            } else if (this.fStableLine != null) {
                int n;
                try {
                    n = this.fUpdaterDocument.getLineOfOffset(this.fStableLine.getOffset());
                }
                catch (BadLocationException badLocationException) {
                    return;
                }
                int n2 = TextViewer.this.getClosestWidgetLineForModelLine(n);
                if (n2 == -1) {
                    return;
                }
                int n3 = TextViewer.this.getTextWidget().getLinePixel(n2);
                int n4 = this.fStablePixel - n3;
                int n5 = TextViewer.this.getTextWidget().getTopPixel();
                TextViewer.this.getTextWidget().setTopPixel(n5 - n4);
            }
        }

        private void connect(IDocument iDocument) {
            Assert.isLegal((iDocument != null ? 1 : 0) != 0);
            Assert.isLegal((!this.isConnected() ? 1 : 0) != 0);
            this.fUpdaterDocument = iDocument;
            try {
                int n;
                int n2;
                IBlockTextSelection iBlockTextSelection;
                this.fUpdaterCategory = TextViewer.SELECTION_POSITION_CATEGORY + this.hashCode();
                this.fUpdater = new NonDeletingPositionUpdater(this.fUpdaterCategory);
                this.fUpdaterDocument.addPositionCategory(this.fUpdaterCategory);
                this.fUpdaterDocument.addPositionUpdater(this.fUpdater);
                ISelection iSelection = TextViewer.this.getSelection();
                if (iSelection instanceof IBlockTextSelection) {
                    iBlockTextSelection = (IBlockTextSelection)iSelection;
                    n2 = Math.max(0, iBlockTextSelection.getStartColumn() - iDocument.getLineInformationOfOffset(iBlockTextSelection.getOffset()).getLength());
                    n = Math.max(0, iBlockTextSelection.getEndColumn() - iDocument.getLineInformationOfOffset(iBlockTextSelection.getOffset() + iBlockTextSelection.getLength()).getLength());
                    this.fSelection = new ColumnPosition(iBlockTextSelection.getOffset(), iBlockTextSelection.getLength(), n2, n);
                } else {
                    iBlockTextSelection = TextViewer.this.getSelectedRange();
                    boolean bl = this.fReverseSelection = ((Point)iBlockTextSelection).y < 0;
                    if (this.fReverseSelection) {
                        n2 = ((Point)iBlockTextSelection).x + ((Point)iBlockTextSelection).y;
                        n = -((Point)iBlockTextSelection).y;
                    } else {
                        n2 = ((Point)iBlockTextSelection).x;
                        n = ((Point)iBlockTextSelection).y;
                    }
                    this.fSelection = new Position(n2, n);
                }
                this.fSelectionSet = false;
                this.fUpdaterDocument.addPosition(this.fUpdaterCategory, this.fSelection);
                int n3 = this.getStableLine();
                n2 = TextViewer.this.modelLine2WidgetLine(n3);
                this.fStablePixel = TextViewer.this.getTextWidget().getLinePixel(n2);
                IRegion iRegion = this.fUpdaterDocument.getLineInformation(n3);
                this.fStableLine = new Position(iRegion.getOffset(), iRegion.getLength());
                this.fUpdaterDocument.addPosition(this.fUpdaterCategory, this.fStableLine);
            }
            catch (BadPositionCategoryException badPositionCategoryException) {
                Assert.isTrue((boolean)false);
            }
            catch (BadLocationException badLocationException) {
                this.disconnect();
            }
        }

        private void updatePosition(Position position, int n, int n2) {
            position.setOffset(n);
            position.setLength(n2);
            position.isDeleted = false;
        }

        private int getStableLine() {
            int n = TextViewer.this.getTextWidget().getLineAtOffset(TextViewer.this.getTextWidget().getCaretOffset());
            int n2 = n < JFaceTextUtil.getPartialTopIndex(TextViewer.this.getTextWidget()) || n > JFaceTextUtil.getPartialBottomIndex(TextViewer.this.getTextWidget()) ? JFaceTextUtil.getPartialTopIndex(TextViewer.this) : TextViewer.this.widgetLine2ModelLine(n);
            return n2;
        }

        private boolean isConnected() {
            return this.fUpdater != null;
        }

        private void disconnect() {
            Assert.isTrue((boolean)this.isConnected());
            try {
                this.fUpdaterDocument.removePosition(this.fUpdaterCategory, this.fSelection);
                this.fUpdaterDocument.removePosition(this.fUpdaterCategory, this.fStableLine);
                this.fUpdaterDocument.removePositionUpdater(this.fUpdater);
                this.fUpdater = null;
                this.fUpdaterDocument.removePositionCategory(this.fUpdaterCategory);
                this.fUpdaterCategory = null;
            }
            catch (BadPositionCategoryException badPositionCategoryException) {
                Assert.isTrue((boolean)false);
            }
        }
    }

    class ViewportGuard
    extends MouseAdapter
    implements ControlListener,
    KeyListener,
    SelectionListener {
        ViewportGuard() {
        }

        public void controlResized(ControlEvent controlEvent) {
            TextViewer.this.updateViewportListeners(5);
        }

        public void controlMoved(ControlEvent controlEvent) {
        }

        public void keyReleased(KeyEvent keyEvent) {
            TextViewer.this.updateViewportListeners(4);
        }

        public void keyPressed(KeyEvent keyEvent) {
            TextViewer.this.updateViewportListeners(4);
        }

        public void mouseUp(MouseEvent mouseEvent) {
            if (TextViewer.this.fTextWidget != null) {
                TextViewer.this.fTextWidget.removeSelectionListener((SelectionListener)this);
            }
            TextViewer.this.updateViewportListeners(3);
        }

        public void mouseDown(MouseEvent mouseEvent) {
            if (TextViewer.this.fTextWidget != null) {
                TextViewer.this.fTextWidget.addSelectionListener((SelectionListener)this);
            }
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            if (selectionEvent.widget == TextViewer.this.fScroller) {
                TextViewer.this.updateViewportListeners(1);
            } else {
                TextViewer.this.updateViewportListeners(2);
            }
        }

        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        }
    }

    class VisibleDocumentListener
    implements IDocumentListener {
        VisibleDocumentListener() {
        }

        public void documentAboutToBeChanged(DocumentEvent documentEvent) {
            if (documentEvent.getDocument() == TextViewer.this.getVisibleDocument()) {
                TextViewer.this.fWidgetCommand.setEvent(documentEvent);
            }
            TextViewer.this.handleVisibleDocumentAboutToBeChanged(documentEvent);
        }

        public void documentChanged(DocumentEvent documentEvent) {
            if (((TextViewer)TextViewer.this).fWidgetCommand.event == documentEvent) {
                TextViewer.this.updateTextListeners(TextViewer.this.fWidgetCommand);
            }
            TextViewer.this.fLastSentSelectionChange = null;
            TextViewer.this.handleVisibleDocumentChanged(documentEvent);
        }
    }

    protected class WidgetCommand {
        public DocumentEvent event;
        public int start;
        public int length;
        public String text;
        public String preservedText;

        protected WidgetCommand() {
        }

        public void setEvent(DocumentEvent documentEvent) {
            block6: {
                this.event = documentEvent;
                this.start = documentEvent.getOffset();
                this.length = documentEvent.getLength();
                this.text = documentEvent.getText();
                if (this.length != 0) {
                    try {
                        if (documentEvent instanceof SlaveDocumentEvent) {
                            SlaveDocumentEvent slaveDocumentEvent = (SlaveDocumentEvent)documentEvent;
                            DocumentEvent documentEvent2 = slaveDocumentEvent.getMasterEvent();
                            if (documentEvent2 != null) {
                                this.preservedText = documentEvent2.getDocument().get(documentEvent2.getOffset(), documentEvent2.getLength());
                            }
                            break block6;
                        }
                        this.preservedText = documentEvent.getDocument().get(documentEvent.getOffset(), documentEvent.getLength());
                    }
                    catch (BadLocationException badLocationException) {
                        this.preservedText = null;
                    }
                } else {
                    this.preservedText = null;
                }
            }
        }
    }
}

