/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;

public class TextSelection
implements ITextSelection {
    private static final boolean ASSERT_INVLID_SELECTION_NULL = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.jface.text/assert/TextSelection/validConstructorArguments"));
    private static final ITextSelection NULL = new TextSelection();
    private final IDocument fDocument;
    private int fOffset;
    private int fLength;

    public static ITextSelection emptySelection() {
        return NULL;
    }

    private TextSelection() {
        this.fOffset = -1;
        this.fLength = -1;
        this.fDocument = null;
    }

    public TextSelection(int n, int n2) {
        this(null, n, n2);
    }

    public TextSelection(IDocument iDocument, int n, int n2) {
        if (ASSERT_INVLID_SELECTION_NULL) {
            Assert.isLegal((n >= 0 ? 1 : 0) != 0);
            Assert.isLegal((n2 >= 0 ? 1 : 0) != 0);
        }
        this.fDocument = iDocument;
        this.fOffset = n;
        this.fLength = n2;
    }

    public boolean isEmpty() {
        return this == NULL || this.fOffset < 0 || this.fLength < 0;
    }

    @Override
    public int getOffset() {
        return this.fOffset;
    }

    @Override
    public int getLength() {
        return this.fLength;
    }

    @Override
    public int getStartLine() {
        try {
            if (this.fDocument != null) {
                return this.fDocument.getLineOfOffset(this.fOffset);
            }
        }
        catch (BadLocationException badLocationException) {}
        return -1;
    }

    @Override
    public int getEndLine() {
        try {
            if (this.fDocument != null) {
                int n = this.fOffset + this.fLength;
                if (this.fLength != 0) {
                    --n;
                }
                return this.fDocument.getLineOfOffset(n);
            }
        }
        catch (BadLocationException badLocationException) {}
        return -1;
    }

    @Override
    public String getText() {
        try {
            if (this.fDocument != null) {
                return this.fDocument.get(this.fOffset, this.fLength);
            }
        }
        catch (BadLocationException badLocationException) {}
        return null;
    }

    public boolean equals(Object object) {
        boolean bl;
        if (object == this) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        TextSelection textSelection = (TextSelection)object;
        boolean bl2 = bl = textSelection.fOffset == this.fOffset && textSelection.fLength == this.fLength;
        if (bl) {
            if (textSelection.fDocument == null && this.fDocument == null) {
                return true;
            }
            if (textSelection.fDocument == null || this.fDocument == null) {
                return false;
            }
            try {
                String string = textSelection.fDocument.get(this.fOffset, this.fLength);
                String string2 = this.fDocument.get(this.fOffset, this.fLength);
                return string.equals(string2);
            }
            catch (BadLocationException badLocationException) {}
        }
        return false;
    }

    public int hashCode() {
        int n = this.fDocument != null ? this.fDocument.hashCode() : 0;
        return this.fOffset << 24 | this.fLength << 16 | n;
    }

    protected IDocument getDocument() {
        return this.fDocument;
    }
}

