/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;

public class TextPresentation {
    private StyleRange fDefaultRange;
    private ArrayList fRanges;
    private IRegion fResultWindow;
    private IRegion fExtent;

    public static void applyTextPresentation(TextPresentation textPresentation, StyledText styledText) {
        StyleRange[] styleRangeArray = new StyleRange[textPresentation.getDenumerableRanges()];
        int n = 0;
        Iterator iterator = textPresentation.getAllStyleRangeIterator();
        while (iterator.hasNext()) {
            styleRangeArray[n++] = (StyleRange)iterator.next();
        }
        styledText.setStyleRanges(styleRangeArray);
    }

    public TextPresentation() {
        this.fRanges = new ArrayList(50);
    }

    public TextPresentation(int n) {
        Assert.isTrue((n > 0 ? 1 : 0) != 0);
        this.fRanges = new ArrayList(n);
    }

    public TextPresentation(IRegion iRegion, int n) {
        this(n);
        Assert.isNotNull((Object)iRegion);
        this.fExtent = iRegion;
    }

    public void setResultWindow(IRegion iRegion) {
        this.fResultWindow = iRegion;
    }

    public void setDefaultStyleRange(StyleRange styleRange) {
        this.fDefaultRange = styleRange;
    }

    public StyleRange getDefaultStyleRange() {
        StyleRange styleRange = this.createWindowRelativeRange(this.fResultWindow, this.fDefaultRange);
        if (styleRange == null) {
            return null;
        }
        return (StyleRange)styleRange.clone();
    }

    public void addStyleRange(StyleRange styleRange) {
        this.checkConsistency(styleRange);
        this.fRanges.add(styleRange);
    }

    public void replaceStyleRange(StyleRange styleRange) {
        this.applyStyleRange(styleRange, false);
    }

    public void mergeStyleRange(StyleRange styleRange) {
        this.applyStyleRange(styleRange, true);
    }

    private void applyStyleRange(StyleRange styleRange, boolean bl) {
        if (styleRange.length == 0) {
            return;
        }
        this.checkConsistency(styleRange);
        int n = styleRange.start;
        int n2 = styleRange.length;
        int n3 = n + n2;
        if (this.fRanges.size() == 0) {
            StyleRange styleRange2 = this.getDefaultStyleRange();
            if (styleRange2 == null) {
                styleRange2 = styleRange;
            }
            styleRange2.start = n;
            styleRange2.length = n2;
            this.applyStyle(styleRange, styleRange2, bl);
            this.fRanges.add(styleRange2);
        } else {
            Region region = new Region(n, n2);
            int n4 = this.getFirstIndexInWindow((IRegion)region);
            if (n4 == this.fRanges.size()) {
                StyleRange styleRange3 = this.getDefaultStyleRange();
                if (styleRange3 == null) {
                    styleRange3 = styleRange;
                }
                styleRange3.start = n;
                styleRange3.length = n2;
                this.applyStyle(styleRange, styleRange3, bl);
                this.fRanges.add(styleRange3);
                return;
            }
            int n5 = this.getFirstIndexAfterWindow((IRegion)region);
            int n6 = n4;
            while (n6 < n5 && n2 > 0) {
                StyleRange styleRange4 = (StyleRange)this.fRanges.get(n6);
                int n7 = styleRange4.start;
                int n8 = n7 + styleRange4.length;
                if (n3 <= n7) {
                    this.fRanges.add(n6, styleRange);
                    return;
                }
                if (n < n8) {
                    StyleRange styleRange5 = null;
                    if (n3 < n8) {
                        styleRange5 = (StyleRange)styleRange4.clone();
                    }
                    if (n < n7) {
                        StyleRange styleRange6 = this.getDefaultStyleRange();
                        if (styleRange6 == null) {
                            styleRange6 = new StyleRange();
                        }
                        styleRange6.start = n;
                        styleRange6.length = n7 - n;
                        this.applyStyle(styleRange, styleRange6, bl);
                        this.fRanges.add(n6, styleRange6);
                        ++n6;
                        ++n5;
                        styleRange4.length = Math.min(n3, n8) - n7;
                        this.applyStyle(styleRange, styleRange4, bl);
                    }
                    if (n >= n7) {
                        styleRange4.length = n - n7;
                        if (styleRange4.length > 0) {
                            styleRange4 = (StyleRange)styleRange4.clone();
                            ++n5;
                            this.fRanges.add(++n6, styleRange4);
                        }
                        this.applyStyle(styleRange, styleRange4, bl);
                        styleRange4.start = n;
                        styleRange4.length = Math.min(n3, n8) - n;
                    }
                    if (n3 < n8) {
                        styleRange5.start = n3;
                        styleRange5.length = n8 - n3;
                        ++n5;
                        this.fRanges.add(++n6, styleRange5);
                    }
                    styleRange.start = n8;
                    styleRange.length = Math.max(n3 - n8, 0);
                    n = styleRange.start;
                    n2 = styleRange.length;
                }
                ++n6;
            }
            if (n2 > 0) {
                StyleRange styleRange7 = this.getDefaultStyleRange();
                if (styleRange7 == null) {
                    styleRange7 = styleRange;
                }
                styleRange7.start = n;
                styleRange7.length = n3 - n;
                this.applyStyle(styleRange, styleRange7, bl);
                this.fRanges.add(n5, styleRange7);
            }
        }
    }

    public void replaceStyleRanges(StyleRange[] styleRangeArray) {
        this.applyStyleRanges(styleRangeArray, false);
    }

    public void mergeStyleRanges(StyleRange[] styleRangeArray) {
        this.applyStyleRanges(styleRangeArray, true);
    }

    private void applyStyleRanges(StyleRange[] styleRangeArray, boolean bl) {
        int n = 0;
        ArrayList arrayList = this.fRanges;
        ArrayList arrayList2 = new ArrayList(2 * styleRangeArray.length + arrayList.size());
        int n2 = 0;
        int n3 = styleRangeArray.length;
        while (n2 < n3) {
            StyleRange styleRange = styleRangeArray[n2];
            this.fRanges = arrayList;
            int n4 = this.getFirstIndexAfterWindow((IRegion)new Region(styleRange.start, styleRange.length));
            while (n < n4) {
                arrayList2.add(arrayList.get(n));
                ++n;
            }
            this.fRanges = arrayList2;
            this.applyStyleRange(styleRange, bl);
            ++n2;
        }
        n2 = arrayList.size();
        while (n < n2) {
            arrayList2.add(arrayList.get(n));
            ++n;
        }
        this.fRanges = arrayList2;
    }

    private void applyStyle(StyleRange styleRange, StyleRange styleRange2, boolean bl) {
        if (bl) {
            if (styleRange.font != null) {
                styleRange2.font = styleRange.font;
            }
            styleRange2.fontStyle |= styleRange.fontStyle;
            if (styleRange.metrics != null) {
                styleRange2.metrics = styleRange.metrics;
            }
            if (styleRange.foreground != null || styleRange.underlineStyle == 4) {
                styleRange2.foreground = styleRange.foreground;
            }
            if (styleRange.background != null) {
                styleRange2.background = styleRange.background;
            }
            styleRange2.strikeout |= styleRange.strikeout;
            if (styleRange.strikeoutColor != null) {
                styleRange2.strikeoutColor = styleRange.strikeoutColor;
            }
            styleRange2.underline |= styleRange.underline;
            if (styleRange.underlineStyle != 0 && styleRange2.underlineStyle != 4) {
                styleRange2.underlineStyle = styleRange.underlineStyle;
            }
            if (styleRange.underlineColor != null) {
                styleRange2.underlineColor = styleRange.underlineColor;
            }
            if (styleRange.borderStyle != 0) {
                styleRange2.borderStyle = styleRange.borderStyle;
            }
            if (styleRange.borderColor != null) {
                styleRange2.borderColor = styleRange.borderColor;
            }
        } else {
            styleRange2.font = styleRange.font;
            styleRange2.fontStyle = styleRange.fontStyle;
            styleRange2.metrics = styleRange.metrics;
            styleRange2.foreground = styleRange.foreground;
            styleRange2.background = styleRange.background;
            styleRange2.strikeout = styleRange.strikeout;
            styleRange2.strikeoutColor = styleRange.strikeoutColor;
            styleRange2.underline = styleRange.underline;
            styleRange2.underlineStyle = styleRange.underlineStyle;
            styleRange2.underlineColor = styleRange.underlineColor;
            styleRange2.borderStyle = styleRange.borderStyle;
            styleRange2.borderColor = styleRange.borderColor;
        }
    }

    private void checkConsistency(StyleRange styleRange) {
        if (styleRange == null) {
            throw new IllegalArgumentException();
        }
        if (this.fDefaultRange != null) {
            int n;
            int n2;
            if (styleRange.start < this.fDefaultRange.start) {
                styleRange.start = this.fDefaultRange.start;
            }
            if ((n2 = styleRange.start + styleRange.length) > (n = this.fDefaultRange.start + this.fDefaultRange.length)) {
                styleRange.length -= n2 - n;
            }
        }
    }

    private int getFirstIndexInWindow(IRegion iRegion) {
        if (iRegion != null) {
            int n = iRegion.getOffset();
            int n2 = -1;
            int n3 = this.fRanges.size();
            while (n3 - n2 > 1) {
                int n4 = n2 + n3 >> 1;
                StyleRange styleRange = (StyleRange)this.fRanges.get(n4);
                if (styleRange.start + styleRange.length > n) {
                    n3 = n4;
                    continue;
                }
                n2 = n4;
            }
            return n3;
        }
        return 0;
    }

    private int getFirstIndexAfterWindow(IRegion iRegion) {
        if (iRegion != null) {
            int n = iRegion.getOffset() + iRegion.getLength();
            int n2 = -1;
            int n3 = this.fRanges.size();
            while (n3 - n2 > 1) {
                int n4 = n2 + n3 >> 1;
                StyleRange styleRange = (StyleRange)this.fRanges.get(n4);
                if (styleRange.start < n) {
                    n2 = n4;
                    continue;
                }
                n3 = n4;
            }
            return n3;
        }
        return this.fRanges.size();
    }

    private StyleRange createWindowRelativeRange(IRegion iRegion, StyleRange styleRange) {
        int n;
        int n2;
        if (iRegion == null || styleRange == null) {
            return styleRange;
        }
        int n3 = styleRange.start - iRegion.getOffset();
        if (n3 < 0) {
            n3 = 0;
        }
        int n4 = (n2 = styleRange.start + styleRange.length) > (n = iRegion.getOffset() + iRegion.getLength()) ? n : n2;
        StyleRange styleRange2 = (StyleRange)styleRange.clone();
        styleRange2.start = n3;
        styleRange2.length = (n4 -= iRegion.getOffset()) - n3;
        return styleRange2;
    }

    private IRegion createWindowRelativeRegion(IRegion iRegion) {
        int n;
        int n2;
        if (this.fResultWindow == null || iRegion == null) {
            return iRegion;
        }
        int n3 = iRegion.getOffset() - this.fResultWindow.getOffset();
        if (n3 < 0) {
            n3 = 0;
        }
        int n4 = (n2 = iRegion.getOffset() + iRegion.getLength()) > (n = this.fResultWindow.getOffset() + this.fResultWindow.getLength()) ? n : n2;
        return new Region(n3, (n4 -= this.fResultWindow.getOffset()) - n3);
    }

    public Iterator getNonDefaultStyleRangeIterator() {
        return new FilterIterator(this.fDefaultRange != null);
    }

    public Iterator getAllStyleRangeIterator() {
        return new FilterIterator(false);
    }

    public boolean isEmpty() {
        return this.fDefaultRange == null && this.getDenumerableRanges() == 0;
    }

    public int getDenumerableRanges() {
        int n = this.getFirstIndexAfterWindow(this.fResultWindow) - this.getFirstIndexInWindow(this.fResultWindow);
        return n < 0 ? 0 : n;
    }

    public StyleRange getFirstStyleRange() {
        try {
            StyleRange styleRange = (StyleRange)this.fRanges.get(this.getFirstIndexInWindow(this.fResultWindow));
            return this.createWindowRelativeRange(this.fResultWindow, styleRange);
        }
        catch (NoSuchElementException noSuchElementException) {
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
        return null;
    }

    public StyleRange getLastStyleRange() {
        try {
            StyleRange styleRange = (StyleRange)this.fRanges.get(this.getFirstIndexAfterWindow(this.fResultWindow) - 1);
            return this.createWindowRelativeRange(this.fResultWindow, styleRange);
        }
        catch (NoSuchElementException noSuchElementException) {
            return null;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    public IRegion getCoverage() {
        if (this.fDefaultRange != null) {
            StyleRange styleRange = this.getDefaultStyleRange();
            return new Region(styleRange.start, styleRange.length);
        }
        StyleRange styleRange = this.getFirstStyleRange();
        StyleRange styleRange2 = this.getLastStyleRange();
        if (styleRange == null || styleRange2 == null) {
            return null;
        }
        return new Region(styleRange.start, styleRange2.start - styleRange.start + styleRange2.length);
    }

    public IRegion getExtent() {
        if (this.fExtent != null) {
            return this.createWindowRelativeRegion(this.fExtent);
        }
        return this.getCoverage();
    }

    public void clear() {
        this.fDefaultRange = null;
        this.fResultWindow = null;
        this.fRanges.clear();
    }

    class FilterIterator
    implements Iterator {
        protected int fIndex;
        protected int fLength;
        protected boolean fSkipDefaults;
        protected IRegion fWindow;

        protected FilterIterator(boolean bl) {
            this.fSkipDefaults = bl;
            this.fWindow = TextPresentation.this.fResultWindow;
            this.fIndex = TextPresentation.this.getFirstIndexInWindow(this.fWindow);
            this.fLength = TextPresentation.this.getFirstIndexAfterWindow(this.fWindow);
            if (this.fSkipDefaults) {
                this.computeIndex();
            }
        }

        public Object next() {
            try {
                StyleRange styleRange = (StyleRange)TextPresentation.this.fRanges.get(this.fIndex++);
                StyleRange styleRange2 = TextPresentation.this.createWindowRelativeRange(this.fWindow, styleRange);
                return styleRange2;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new NoSuchElementException();
            }
            finally {
                if (this.fSkipDefaults) {
                    this.computeIndex();
                }
            }
        }

        @Override
        public boolean hasNext() {
            return this.fIndex < this.fLength;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        protected boolean skip(Object object) {
            StyleRange styleRange = (StyleRange)object;
            return styleRange.similarTo(TextPresentation.this.fDefaultRange);
        }

        protected void computeIndex() {
            while (this.fIndex < this.fLength && this.skip(TextPresentation.this.fRanges.get(this.fIndex))) {
                ++this.fIndex;
            }
        }
    }
}

