/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ILineTracker;
import org.eclipse.jface.text.IRegion;

public class TabsToSpacesConverter
implements IAutoEditStrategy {
    private int fTabRatio;
    private ILineTracker fLineTracker;

    public void setNumberOfSpacesPerTab(int n) {
        this.fTabRatio = n;
    }

    public void setLineTracker(ILineTracker iLineTracker) {
        this.fLineTracker = iLineTracker;
    }

    private int insertTabString(StringBuffer stringBuffer, int n) {
        if (this.fTabRatio == 0) {
            return 0;
        }
        int n2 = n % this.fTabRatio;
        n2 = this.fTabRatio - n2;
        int n3 = 0;
        while (n3 < n2) {
            stringBuffer.append(' ');
            ++n3;
        }
        return n2;
    }

    @Override
    public void customizeDocumentCommand(IDocument iDocument, DocumentCommand documentCommand) {
        String string = documentCommand.text;
        if (string == null) {
            return;
        }
        int n = string.indexOf(9);
        if (n > -1) {
            StringBuffer stringBuffer = new StringBuffer();
            this.fLineTracker.set(documentCommand.text);
            int n2 = this.fLineTracker.getNumberOfLines();
            try {
                int n3 = 0;
                while (n3 < n2) {
                    int n4 = this.fLineTracker.getLineOffset(n3);
                    int n5 = n4 + this.fLineTracker.getLineLength(n3);
                    String string2 = string.substring(n4, n5);
                    int n6 = 0;
                    if (n3 == 0) {
                        IRegion iRegion = iDocument.getLineInformationOfOffset(documentCommand.offset);
                        n6 = documentCommand.offset - iRegion.getOffset();
                    }
                    int n7 = string2.length();
                    int n8 = 0;
                    while (n8 < n7) {
                        char c = string2.charAt(n8);
                        if (c == '\t') {
                            n6 += this.insertTabString(stringBuffer, n6);
                        } else {
                            stringBuffer.append(c);
                            ++n6;
                        }
                        ++n8;
                    }
                    ++n3;
                }
                documentCommand.text = stringBuffer.toString();
            }
            catch (BadLocationException badLocationException) {}
        }
    }
}

