/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text;

import org.eclipse.jface.preference.FontFieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public class PropagatingFontFieldEditor
extends FontFieldEditor {
    private Composite fParent;
    private String fDefaultFontLabel;

    public PropagatingFontFieldEditor(String string, String string2, Composite composite, String string3) {
        super(string, string2, composite);
        this.fParent = composite;
        this.fDefaultFontLabel = string3 == null ? "" : string3;
    }

    protected void doLoad() {
        if (this.getPreferenceStore().isDefault(this.getPreferenceName())) {
            this.loadDefault();
        }
        super.doLoad();
        this.checkForDefault();
    }

    protected void doLoadDefault() {
        super.doLoadDefault();
        this.checkForDefault();
    }

    private void checkForDefault() {
        Label label;
        if (this.presentsDefaultValue() && (label = this.getValueControl(this.fParent)) instanceof Label) {
            label.setText(this.fDefaultFontLabel);
        }
    }

    private static void propagateFont(IPreferenceStore iPreferenceStore, String string, IPreferenceStore iPreferenceStore2, String string2) {
        FontData fontData = PreferenceConverter.getFontData((IPreferenceStore)iPreferenceStore, (String)string);
        if (fontData != null) {
            boolean bl = iPreferenceStore2.isDefault(string2);
            PreferenceConverter.setDefault((IPreferenceStore)iPreferenceStore2, (String)string2, (FontData)fontData);
            if (bl) {
                iPreferenceStore2.setToDefault(string2);
            }
        }
    }

    public static void startPropagate(final IPreferenceStore iPreferenceStore, final String string, final IPreferenceStore iPreferenceStore2, final String string2) {
        iPreferenceStore.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (string.equals(propertyChangeEvent.getProperty())) {
                    PropagatingFontFieldEditor.propagateFont(iPreferenceStore, string, iPreferenceStore2, string2);
                }
            }
        });
        PropagatingFontFieldEditor.propagateFont(iPreferenceStore, string, iPreferenceStore2, string2);
    }
}

