/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DefaultPositionUpdater;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPaintPositionManager;
import org.eclipse.jface.text.IPainter;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;

public final class PaintManager
implements KeyListener,
MouseListener,
ISelectionChangedListener,
ITextListener,
ITextInputListener {
    private List fPainters = new ArrayList(2);
    private PositionManager fManager;
    private ITextViewer fTextViewer;

    public PaintManager(ITextViewer iTextViewer) {
        this.fTextViewer = iTextViewer;
    }

    public void addPainter(IPainter iPainter) {
        if (!this.fPainters.contains(iPainter)) {
            this.fPainters.add(iPainter);
            if (this.fPainters.size() == 1) {
                this.install();
            }
            iPainter.setPositionManager(this.fManager);
            iPainter.paint(8);
        }
    }

    public void removePainter(IPainter iPainter) {
        if (this.fPainters.remove(iPainter)) {
            iPainter.deactivate(true);
            iPainter.setPositionManager(null);
        }
        if (this.fPainters.size() == 0) {
            this.dispose();
        }
    }

    private void install() {
        this.fManager = new PositionManager();
        if (this.fTextViewer.getDocument() != null) {
            this.fManager.install(this.fTextViewer.getDocument());
            this.addListeners();
        }
        this.fTextViewer.addTextInputListener(this);
    }

    private void addListeners() {
        ISelectionProvider iSelectionProvider = this.fTextViewer.getSelectionProvider();
        iSelectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
        this.fTextViewer.addTextListener(this);
        StyledText styledText = this.fTextViewer.getTextWidget();
        styledText.addKeyListener((KeyListener)this);
        styledText.addMouseListener((MouseListener)this);
    }

    public void dispose() {
        if (this.fManager != null) {
            this.fManager.dispose();
            this.fManager = null;
        }
        Iterator iterator = this.fPainters.iterator();
        while (iterator.hasNext()) {
            ((IPainter)iterator.next()).dispose();
        }
        this.fPainters.clear();
        this.fTextViewer.removeTextInputListener(this);
        this.removeListeners();
    }

    private void removeListeners() {
        ISelectionProvider iSelectionProvider = this.fTextViewer.getSelectionProvider();
        if (iSelectionProvider != null) {
            iSelectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
        }
        this.fTextViewer.removeTextListener(this);
        StyledText styledText = this.fTextViewer.getTextWidget();
        if (styledText != null && !styledText.isDisposed()) {
            styledText.removeKeyListener((KeyListener)this);
            styledText.removeMouseListener((MouseListener)this);
        }
    }

    private void paint(int n) {
        Iterator iterator = this.fPainters.iterator();
        while (iterator.hasNext()) {
            ((IPainter)iterator.next()).paint(n);
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        this.paint(2);
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void mouseDoubleClick(MouseEvent mouseEvent) {
    }

    public void mouseDown(MouseEvent mouseEvent) {
        this.paint(4);
    }

    public void mouseUp(MouseEvent mouseEvent) {
    }

    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
        this.paint(0);
    }

    @Override
    public void textChanged(TextEvent textEvent) {
        if (!textEvent.getViewerRedrawState()) {
            return;
        }
        StyledText styledText = this.fTextViewer.getTextWidget();
        if (styledText != null) {
            styledText.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (PaintManager.this.fTextViewer != null) {
                        PaintManager.this.paint(1);
                    }
                }
            });
        }
    }

    @Override
    public void inputDocumentAboutToBeChanged(IDocument iDocument, IDocument iDocument2) {
        if (iDocument != null) {
            Iterator iterator = this.fPainters.iterator();
            while (iterator.hasNext()) {
                ((IPainter)iterator.next()).deactivate(false);
            }
            this.fManager.uninstall(iDocument);
            this.removeListeners();
        }
    }

    @Override
    public void inputDocumentChanged(IDocument iDocument, IDocument iDocument2) {
        if (iDocument2 != null && iDocument2 != this.fManager.fDocument) {
            this.fManager.install(iDocument2);
            this.paint(1);
            this.addListeners();
        }
    }

    static class PaintPositionUpdater
    extends DefaultPositionUpdater {
        protected PaintPositionUpdater(String string) {
            super(string);
        }

        protected void adaptToInsert() {
            int n = this.fPosition.offset;
            int n2 = this.fPosition.offset + this.fPosition.length;
            n2 = Math.max(n, n2);
            int n3 = this.fOffset;
            int n4 = this.fOffset + this.fReplaceLength;
            n4 = Math.max(n3, n4);
            if (n2 < n3) {
                return;
            }
            if (n <= n3) {
                this.fPosition.length += this.fReplaceLength;
            } else {
                this.fPosition.offset += this.fReplaceLength;
            }
        }
    }

    static class PositionManager
    implements IPaintPositionManager {
        private IDocument fDocument;
        private IPositionUpdater fPositionUpdater;
        private String fCategory = String.valueOf(this.getClass().getName()) + this.hashCode();

        public PositionManager() {
            this.fPositionUpdater = new PaintPositionUpdater(this.fCategory);
        }

        public void install(IDocument iDocument) {
            this.fDocument = iDocument;
            this.fDocument.addPositionCategory(this.fCategory);
            this.fDocument.addPositionUpdater(this.fPositionUpdater);
        }

        public void dispose() {
            this.uninstall(this.fDocument);
        }

        public void uninstall(IDocument iDocument) {
            if (iDocument == this.fDocument && iDocument != null) {
                try {
                    this.fDocument.removePositionUpdater(this.fPositionUpdater);
                    this.fDocument.removePositionCategory(this.fCategory);
                }
                catch (BadPositionCategoryException badPositionCategoryException) {}
                this.fDocument = null;
            }
        }

        @Override
        public void managePosition(Position position) {
            try {
                this.fDocument.addPosition(this.fCategory, position);
            }
            catch (BadPositionCategoryException badPositionCategoryException) {
            }
            catch (BadLocationException badLocationException) {}
        }

        @Override
        public void unmanagePosition(Position position) {
            try {
                this.fDocument.removePosition(this.fCategory, position);
            }
            catch (BadPositionCategoryException badPositionCategoryException) {}
        }
    }
}

