/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text;

import org.eclipse.jface.text.IPaintPositionManager;
import org.eclipse.jface.text.IPainter;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;

public class MarginPainter
implements IPainter,
PaintListener {
    private StyledText fTextWidget;
    private int fMarginWidth = 80;
    private Color fColor;
    private int fLineStyle = 1;
    private int fLineWidth = 0;
    private int fCachedWidgetX = -1;
    private boolean fIsActive = false;

    public MarginPainter(ITextViewer iTextViewer) {
        this.fTextWidget = iTextViewer.getTextWidget();
    }

    public void setMarginRulerColumn(int n) {
        this.fMarginWidth = n;
        this.initialize();
    }

    public void setMarginRulerStyle(int n) {
        this.fLineStyle = n;
    }

    public void setMarginRulerWidth(int n) {
        if (n == 1) {
            n = 0;
        }
        this.fLineWidth = n;
    }

    public void setMarginRulerColor(Color color) {
        this.fColor = color;
    }

    public void initialize() {
        this.computeWidgetX();
        this.fTextWidget.redraw();
    }

    private void computeWidgetX() {
        GC gC = new GC((Drawable)this.fTextWidget);
        int n = gC.getFontMetrics().getAverageCharWidth();
        gC.dispose();
        this.fCachedWidgetX = n * this.fMarginWidth;
    }

    @Override
    public void deactivate(boolean bl) {
        if (this.fIsActive) {
            this.fIsActive = false;
            this.fCachedWidgetX = -1;
            this.fTextWidget.removePaintListener((PaintListener)this);
            if (bl) {
                this.fTextWidget.redraw();
            }
        }
    }

    @Override
    public void dispose() {
        this.fTextWidget = null;
    }

    @Override
    public void paint(int n) {
        if (!this.fIsActive) {
            this.fIsActive = true;
            this.fTextWidget.addPaintListener((PaintListener)this);
            if (this.fCachedWidgetX == -1) {
                this.computeWidgetX();
            }
            this.fTextWidget.redraw();
        } else if (16 == n || 8 == n) {
            this.fTextWidget.redraw();
        }
    }

    public void paintControl(PaintEvent paintEvent) {
        int n;
        if (this.fTextWidget != null && (n = this.fCachedWidgetX - this.fTextWidget.getHorizontalPixel()) >= 0) {
            Rectangle rectangle = this.fTextWidget.getClientArea();
            paintEvent.gc.setForeground(this.fColor);
            paintEvent.gc.setLineStyle(this.fLineStyle);
            paintEvent.gc.setLineWidth(this.fLineWidth);
            paintEvent.gc.drawLine(n, 0, n, rectangle.height);
        }
    }

    @Override
    public void setPositionManager(IPaintPositionManager iPaintPositionManager) {
    }
}

